/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.io.StringWriter;
import java.util.List;
import java.util.logging.Level;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.compiere.model.MBPGroup;
import org.compiere.model.MBPartner;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductPrice;
import org.compiere.model.MStorage;
import org.compiere.model.MTaxCategory;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.idempiere.process.MQClient;

public class Export2Queue
extends SvrProcess {
    private int pProductCategoryID;
    private int pProductLocatorID;
    private int pBPartnerGroupID;
    private int pPriceListVersionID;
    private String p_IsSelfService = "Y";
    private String p_LinkProducts = "/queue/Products";
    private String p_LinkCustomers = "/queue/Customers";
    private String p_LinkURL = "localhost";
    private String p_ACK = "N";
    private String p_DummyQOH = "N";
    private String p_DummyPrice = "N";
    private String errmsg = "";
    private int count = 0;
    private int countLocations = 0;
    private String mainMsg = "";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("LinkProducts")) {
                    this.p_LinkProducts = (String)para[i].getParameter();
                } else if (name.equals("LinkCustomers")) {
                    this.p_LinkCustomers = (String)para[i].getParameter();
                } else if (name.equals("LinkURL")) {
                    this.p_LinkURL = (String)para[i].getParameter();
                } else if (name.equals("IsSelfService")) {
                    this.p_IsSelfService = (String)para[i].getParameter();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.pProductCategoryID = para[i].getParameterAsInt();
                } else if (name.equals("C_BP_Group_ID")) {
                    this.pBPartnerGroupID = para[i].getParameterAsInt();
                } else if (name.equals("M_PriceList_Version_ID")) {
                    this.pPriceListVersionID = para[i].getParameterAsInt();
                } else if (name.equals("ACK")) {
                    this.p_ACK = (String)para[i].getParameter();
                } else if (name.equals("DummyQOH")) {
                    this.p_DummyQOH = (String)para[i].getParameter();
                } else if (name.equals("DummyPrice")) {
                    this.p_DummyPrice = (String)para[i].getParameter();
                } else if (name.equals("M_Locator_ID")) {
                    this.pProductLocatorID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MProductCategory prodcat;
        List<MProduct> query;
        int m_client_ID = Env.getAD_Client_ID(Env.getCtx());
        if (this.pProductCategoryID == 0) {
            query = new Query(Env.getCtx(), "M_Product", "AD_Client_ID=? AND IsSelfService=?", this.get_TrxName()).setParameters(m_client_ID, this.p_IsSelfService).list();
            prodcat = (MProductCategory)new Query(Env.getCtx(), "M_Product_Category", "M_Product_Category_ID=?", this.get_TrxName()).setParameters(this.pProductCategoryID).first();
            MQClient.setParams(this.p_LinkURL, 61613, this.p_LinkProducts);
            this.errmsg = MQClient.sendMessage(this.ProductXML(query, prodcat));
            if (this.errmsg.equals("")) {
                this.mainMsg = "Sent to Queue: " + this.count + " Products .. " + " having " + this.countLocations + " Locations...";
                this.count = 0;
                this.countLocations = 0;
            } else {
                return this.errmsg;
            }
        }
        if (this.pProductCategoryID > 0) {
            query = new Query(Env.getCtx(), "M_Product", "M_Product_Category_ID=? AND IsSelfService=?", this.get_TrxName()).setParameters(this.pProductCategoryID, this.p_IsSelfService).list();
            prodcat = (MProductCategory)new Query(Env.getCtx(), "M_Product_Category", "M_Product_Category_ID=?", this.get_TrxName()).setParameters(this.pProductCategoryID).first();
            MQClient.setParams(this.p_LinkURL, 61613, this.p_LinkProducts);
            this.errmsg = MQClient.sendMessage(this.ProductXML(query, prodcat));
            if (this.errmsg.equals("")) {
                this.mainMsg = "Sent to Queue: " + this.count + " Products .. ";
                this.count = 0;
            } else {
                return this.errmsg;
            }
        }
        if (this.pBPartnerGroupID > 0) {
            query = new Query(Env.getCtx(), "C_BPartner", "C_BP_Group_ID=? AND IsCustomer=?", this.get_TrxName()).setParameters(this.pBPartnerGroupID, "Y").list();
            MBPGroup group = (MBPGroup)new Query(Env.getCtx(), "C_BP_Group", "C_BP_Group_ID=?", null).setParameters(this.pBPartnerGroupID).first();
            MQClient.setParams(this.p_LinkURL, 61613, this.p_LinkCustomers);
            this.errmsg = MQClient.sendMessage(this.CustomerXML(query, group));
            if (this.errmsg.equals("")) {
                this.mainMsg = String.valueOf(this.mainMsg) + this.count + " Customers";
            } else {
                return this.errmsg;
            }
        }
        if (this.pBPartnerGroupID == 0 && this.pProductCategoryID == 0 && this.p_ACK.equals("Y")) {
            String returned = "";
            MQClient.setParams(this.p_LinkURL, 61613, this.p_LinkProducts);
            returned = MQClient.receiveMessage();
            if (returned.equals("NO SERVICE")) {
                return returned;
            }
            MQClient.setParams(this.p_LinkURL, 61613, this.p_LinkCustomers);
            returned = MQClient.receiveMessage();
            if (returned.equals("No queued message")) {
                return returned;
            }
            return "Just great! You deleted any last queued message.";
        }
        if (this.mainMsg.equals("")) {
            return "Select something you idiot.";
        }
        return this.mainMsg;
    }

    private String ProductXML(List<MProduct> query, MProductCategory prodcat) {
        try {
            StringWriter res = new StringWriter();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(res);
            writer.writeStartDocument();
            writer.writeStartElement("entityDetail");
            writer.writeStartElement("type");
            writer.writeCharacters("openbravoPOS");
            writer.writeEndElement();
            for (MProduct product : query) {
                MProductPrice price;
                MProductCategory myProdcat = (MProductCategory)new Query(Env.getCtx(), "M_Product_Category", "M_Product_Category_ID=?", this.get_TrxName()).setParameters(product.getM_Product_Category_ID()).first();
                int anyPrice = new Query(Env.getCtx(), "M_ProductPrice", "M_PriceList_Version_ID=? AND M_Product_ID=?", null).setParameters(this.pPriceListVersionID, product.getM_Product_ID()).count();
                if (anyPrice == 0) {
                    if (!this.p_DummyPrice.equals("Y")) continue;
                    price = new MProductPrice(Env.getCtx(), 0, "");
                } else {
                    price = (MProductPrice)new Query(Env.getCtx(), "M_ProductPrice", "M_PriceList_Version_ID=? AND M_Product_ID=?", this.get_TrxName()).setParameters(this.pPriceListVersionID, product.getM_Product_ID()).first();
                }
                int anyStorage = new Query(Env.getCtx(), "M_Storage", "M_Product_ID=?", this.get_TrxName()).setParameters(product.getM_Product_ID()).count();
                if (anyStorage == 0) {
                    if (!this.p_DummyQOH.equals("Y")) continue;
                    ++this.count;
                    writer.writeStartElement("detail");
                    writer.writeStartElement("DocType");
                    writer.writeCharacters("M_Product");
                    writer.writeEndElement();
                    writer.writeStartElement("POSLocatorName");
                    writer.writeCharacters("not available");
                    writer.writeEndElement();
                    writer.writeStartElement("ProductName");
                    writer.writeCharacters(product.getValue());
                    writer.writeEndElement();
                    writer.writeStartElement("QtyOnHand");
                    writer.writeCharacters("0");
                    writer.writeEndElement();
                    writer.writeStartElement("M_Product_Category_ID");
                    writer.writeCharacters(Integer.toString(product.getM_Product_Category_ID()));
                    writer.writeEndElement();
                    writer.writeStartElement("CategoryName");
                    writer.writeCharacters(myProdcat.getName());
                    writer.writeEndElement();
                    writer.writeStartElement("M_Product_ID");
                    writer.writeCharacters(Integer.toString(product.getM_Product_ID()));
                    writer.writeEndElement();
                    MTaxCategory tax = (MTaxCategory)new Query(Env.getCtx(), "C_TaxCategory", "C_TaxCategory_ID=?", null).setParameters(product.getC_TaxCategory().getC_TaxCategory_ID()).first();
                    writer.writeStartElement("C_TaxCategory_ID");
                    writer.writeCharacters(Integer.toString(tax.getC_TaxCategory_ID()));
                    writer.writeEndElement();
                    writer.writeStartElement("TaxName");
                    writer.writeCharacters(tax.getName());
                    writer.writeEndElement();
                    writer.writeStartElement("UPC");
                    writer.writeCharacters(product.getUPC());
                    writer.writeEndElement();
                    writer.writeStartElement("PriceList");
                    writer.writeCharacters(price.getPriceList().toString());
                    writer.writeEndElement();
                    writer.writeStartElement("PriceLimit");
                    writer.writeCharacters(price.getPriceLimit().toString());
                    writer.writeEndElement();
                    writer.writeEndElement();
                    continue;
                }
                List stores = new Query(Env.getCtx(), "M_Storage", "M_Product_ID=?", null).setParameters(product.getM_Product_ID()).list();
                ++this.count;
                for (MStorage store : stores) {
                    MLocator loc = (MLocator)new Query(Env.getCtx(), "M_Locator", "M_Locator_ID=?", this.get_TrxName()).setParameters(store.getM_Locator_ID()).first();
                    ++this.countLocations;
                    writer.writeStartElement("detail");
                    writer.writeStartElement("DocType");
                    writer.writeCharacters("M_Product");
                    writer.writeEndElement();
                    writer.writeStartElement("POSLocatorName");
                    writer.writeCharacters(loc.getWarehouseName());
                    writer.writeEndElement();
                    writer.writeStartElement("ProductName");
                    writer.writeCharacters(product.getValue());
                    writer.writeEndElement();
                    writer.writeStartElement("QtyOnHand");
                    writer.writeCharacters(store.getQtyOnHand().toString());
                    writer.writeEndElement();
                    writer.writeStartElement("M_Product_Category_ID");
                    writer.writeCharacters(Integer.toString(product.getM_Product_Category_ID()));
                    writer.writeEndElement();
                    writer.writeStartElement("CategoryName");
                    writer.writeCharacters(myProdcat.getName());
                    writer.writeEndElement();
                    writer.writeStartElement("M_Product_ID");
                    writer.writeCharacters(Integer.toString(product.getM_Product_ID()));
                    writer.writeEndElement();
                    MTaxCategory tax = (MTaxCategory)new Query(Env.getCtx(), "C_TaxCategory", "C_TaxCategory_ID=?", null).setParameters(product.getC_TaxCategory().getC_TaxCategory_ID()).first();
                    writer.writeStartElement("C_TaxCategory_ID");
                    writer.writeCharacters(Integer.toString(tax.getC_TaxCategory_ID()));
                    writer.writeEndElement();
                    writer.writeStartElement("TaxName");
                    writer.writeCharacters(tax.getName());
                    writer.writeEndElement();
                    writer.writeStartElement("UPC");
                    writer.writeCharacters(product.getUPC());
                    writer.writeEndElement();
                    writer.writeStartElement("PriceList");
                    writer.writeCharacters(price.getPriceList().toString());
                    writer.writeEndElement();
                    writer.writeStartElement("PriceLimit");
                    writer.writeCharacters(price.getPriceLimit().toString());
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            return res.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "XML creation ERROR";
        }
    }

    private String CustomerXML(List<MBPartner> query, MBPGroup group) {
        try {
            StringWriter res = new StringWriter();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(res);
            writer.writeStartDocument();
            writer.writeStartElement("entityDetail");
            writer.writeStartElement("type");
            writer.writeCharacters("openbravoPOS");
            writer.writeEndElement();
            for (MBPartner partner : query) {
                ++this.count;
                writer.writeStartElement("detail");
                writer.writeStartElement("DocType");
                writer.writeCharacters("C_BPartner");
                writer.writeEndElement();
                writer.writeStartElement("CustomerName");
                writer.writeCharacters(partner.getName());
                writer.writeEndElement();
                writer.writeStartElement("Value");
                writer.writeCharacters(partner.getValue());
                writer.writeEndElement();
                writer.writeStartElement("Description");
                writer.writeCharacters(partner.getDescription());
                writer.writeEndElement();
                writer.writeStartElement("C_BPartner_ID");
                writer.writeCharacters(Integer.toString(partner.getC_BPartner_ID()));
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            return res.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "XML creation ERROR";
        }
    }
}

