/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.event.FullTextIndexEventListener;
import org.hibernate.search.query.EntityInfo;
import org.hibernate.search.query.IteratorImpl;
import org.hibernate.search.query.ScrollableResultsImpl;
import org.hibernate.search.util.ContextHelper;

public class FullTextQueryImpl
extends AbstractQueryImpl {
    private static final Log log = LogFactory.getLog(FullTextQueryImpl.class);
    private org.apache.lucene.search.Query luceneQuery;
    private Class[] classes;
    private Set<Class> classesAndSubclasses;
    private Integer firstResult;
    private Integer maxResults;
    private int resultSize;

    public FullTextQueryImpl(org.apache.lucene.search.Query query, Class[] classes, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(query.toString(), null, session, parameterMetadata);
        this.luceneQuery = query;
        this.classes = classes;
    }

    public Iterator iterate() throws HibernateException {
        FullTextIndexEventListener listener = ContextHelper.getLuceneEventListener(this.session);
        Searcher searcher = this.buildSearcher(listener);
        try {
            org.apache.lucene.search.Query query = this.filterQueryByClasses(this.luceneQuery);
            Hits hits = searcher.search(query);
            this.setResultSize(hits);
            int first = this.first();
            int max = this.max(first, hits);
            ArrayList<EntityInfo> entityInfos = new ArrayList<EntityInfo>(max - first + 1);
            for (int index = first; index <= max; ++index) {
                Document document = hits.doc(index);
                EntityInfo entityInfo = new EntityInfo();
                entityInfo.clazz = DocumentBuilder.getDocumentClass(document);
                entityInfo.id = DocumentBuilder.getDocumentId(listener, entityInfo.clazz, document);
                entityInfos.add(entityInfo);
            }
            IteratorImpl iteratorImpl = new IteratorImpl(entityInfos, (Session)this.session);
            return iteratorImpl;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index", e);
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to properly close searcher during lucene query: " + this.getQueryString()), (Throwable)e);
                }
            }
        }
    }

    public ScrollableResults scroll() throws HibernateException {
        FullTextIndexEventListener listener = ContextHelper.getLuceneEventListener(this.session);
        Searcher searcher = this.buildSearcher(listener);
        try {
            org.apache.lucene.search.Query query = this.filterQueryByClasses(this.luceneQuery);
            Hits hits = searcher.search(query);
            this.setResultSize(hits);
            int first = this.first();
            int max = this.max(first, hits);
            return new ScrollableResultsImpl(searcher, hits, first, max, (Session)this.session, listener);
        }
        catch (IOException e) {
            try {
                if (searcher != null) {
                    searcher.close();
                }
            }
            catch (IOException ee) {
                // empty catch block
            }
            throw new HibernateException("Unable to query Lucene index", e);
        }
    }

    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        return this.scroll();
    }

    public List list() throws HibernateException {
        FullTextIndexEventListener listener = ContextHelper.getLuceneEventListener(this.session);
        Searcher searcher = this.buildSearcher(listener);
        try {
            org.apache.lucene.search.Query query = this.filterQueryByClasses(this.luceneQuery);
            Hits hits = searcher.search(query);
            this.setResultSize(hits);
            int first = this.first();
            int max = this.max(first, hits);
            ArrayList<Object> result = new ArrayList<Object>(max - first + 1);
            Session sess = (Session)this.session;
            for (int index = first; index <= max; ++index) {
                Document document = hits.doc(index);
                Class clazz = DocumentBuilder.getDocumentClass(document);
                Serializable id = DocumentBuilder.getDocumentId(listener, clazz, document);
                result.add(sess.load(clazz, id));
            }
            for (Object e : result) {
                Hibernate.initialize(e);
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index", e);
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to properly close searcher during lucene query: " + this.getQueryString()), (Throwable)e);
                }
            }
        }
    }

    private org.apache.lucene.search.Query filterQueryByClasses(org.apache.lucene.search.Query luceneQuery) {
        if (this.classesAndSubclasses == null) {
            return luceneQuery;
        }
        BooleanQuery classFilter = new BooleanQuery();
        classFilter.setBoost(0.0f);
        for (Class clazz : this.classesAndSubclasses) {
            Term t = new Term("_hibernate_class", clazz.getName());
            TermQuery termQuery = new TermQuery(t);
            classFilter.add(termQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery filteredQuery = new BooleanQuery();
        filteredQuery.add(luceneQuery, BooleanClause.Occur.MUST);
        filteredQuery.add(classFilter, BooleanClause.Occur.MUST);
        return filteredQuery;
    }

    private int max(int first, Hits hits) {
        return this.maxResults == null ? hits.length() - 1 : (this.maxResults + first < hits.length() ? first + this.maxResults - 1 : hits.length() - 1);
    }

    private int first() {
        return this.firstResult != null ? this.firstResult : 0;
    }

    private Searcher buildSearcher(FullTextIndexEventListener listener) {
        Searcher searcher;
        Map<Class, DocumentBuilder<Object>> builders = listener.getDocumentBuilders();
        HashSet directories = new HashSet();
        if (this.classes == null || this.classes.length == 0) {
            for (DocumentBuilder<Object> builder : builders.values()) {
                directories.add(builder.getDirectoryProvider().getDirectory());
            }
            this.classesAndSubclasses = null;
        } else {
            HashSet<Class> involvedClasses = new HashSet<Class>(this.classes.length);
            Collections.addAll(involvedClasses, this.classes);
            for (Class clazz : this.classes) {
                DocumentBuilder<Object> builder = builders.get(clazz);
                if (builder == null) continue;
                involvedClasses.addAll(builder.getMappedSubclasses());
            }
            for (Class clazz : involvedClasses) {
                DocumentBuilder<Object> builder = builders.get(clazz);
                if (builder == null) {
                    throw new HibernateException("Not a mapped entity: " + clazz);
                }
                directories.add(builder.getDirectoryProvider().getDirectory());
            }
            this.classesAndSubclasses = involvedClasses;
        }
        int dirNbr = directories.size();
        if (dirNbr > 1) {
            try {
                Searchable[] searchers = new IndexSearcher[dirNbr];
                Iterator it = directories.iterator();
                for (int index = 0; index < dirNbr; ++index) {
                    searchers[index] = new IndexSearcher((Directory)it.next());
                }
                searcher = new MultiSearcher(searchers);
            }
            catch (IOException e) {
                throw new HibernateException("Unable to read Lucene directory", e);
            }
        }
        try {
            searcher = new IndexSearcher((Directory)directories.iterator().next());
        }
        catch (IOException e) {
            throw new HibernateException("Unable to read Lucene directory", e);
        }
        return searcher;
    }

    private void setResultSize(Hits hits) {
        this.resultSize = hits.length();
    }

    public int resultSize() {
        return this.resultSize;
    }

    public Query setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public Query setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public int executeUpdate() throws HibernateException {
        throw new HibernateException("Not supported operation");
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        return null;
    }

    protected Map getLockModes() {
        return null;
    }
}

