/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.tools.worker;

public abstract class MultiWorker {
    protected boolean isWorking;
    protected WorkerThread workerThread;
    protected int timeout;
    protected Object value;

    public MultiWorker() {
        this.setTimeout(-1);
    }

    public abstract void start();

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public void waitForComplete(int n) {
        this.setTimeout(n);
        this.waitForComplete();
    }

    public void stop() {
        this.workerThread.interrupt();
    }

    public void waitForComplete() {
        boolean bl = this.getTimeout() > -1;
        int n = 0;
        int n2 = 1000;
        while (this.isWorking()) {
            try {
                Thread.sleep(n2);
                n += bl ? (n = n + n2) : -1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl || n < this.getTimeout()) continue;
            this.workerThread.interrupt();
            this.workerThread = null;
            break;
        }
    }

    protected abstract class WorkerThread
    extends Thread {
        protected WorkerThread() {
        }

        public abstract Object doWork();

        @Override
        public void run() {
            MultiWorker.this.isWorking = true;
            MultiWorker.this.value = this.doWork();
            MultiWorker.this.isWorking = false;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            MultiWorker.this.isWorking = false;
        }
    }
}

