/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.tools.swing;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.ItemSelectable;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class SwingTool {
    public static synchronized void setCursorsFromChild(Component component, boolean bl) {
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        SwingTool.setCursorsFromParent((Container)component2, bl);
    }

    protected static boolean isIgnoredComponent(Component component) {
        boolean bl = true;
        if (component instanceof ItemSelectable && component.isEnabled()) {
            bl = false;
        } else if (component instanceof JTextComponent && component.isEnabled()) {
            bl = false;
        } else if (component instanceof JFrame && component.isEnabled()) {
            bl = false;
        } else if (component instanceof JPanel && component.isEnabled()) {
            bl = false;
        } else if (component instanceof JLabel && component.isEnabled()) {
            bl = false;
        } else if (component instanceof Adjustable && component.isEnabled()) {
            bl = false;
        }
        return bl;
    }

    public static void setCursor(Component component, boolean bl) {
        if (SwingTool.isIgnoredComponent(component)) {
            return;
        }
        Cursor cursor = new Cursor(3);
        Cursor cursor2 = SwingTool.getPredefinedCursor(component);
        Component component2 = component;
        if (bl) {
            component2.setCursor(cursor);
        } else {
            component2.setCursor(cursor2);
        }
    }

    public static Cursor getPredefinedCursor(Component component) {
        Cursor cursor = Cursor.getDefaultCursor();
        if (component instanceof JTextComponent) {
            cursor = Cursor.getPredefinedCursor(2);
        } else if (component instanceof ItemSelectable || component instanceof Adjustable) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        return cursor;
    }

    public static void setCursors(Component[] componentArray, boolean bl) {
        for (int i = 0; i < componentArray.length; ++i) {
            SwingTool.setCursor(componentArray[i], bl);
        }
    }

    public static synchronized void setCursorsFromParent(Container container, boolean bl) {
        Container container2 = container;
        for (int i = 0; i < container2.getComponentCount(); ++i) {
            SwingTool.setCursor(container2.getComponent(i), bl);
            if (!(container2.getComponent(i) instanceof Container)) continue;
            SwingTool.setCursorsFromParent((Container)container2.getComponent(i), bl);
        }
    }

    public static Component searchComponent(Container container, Class clazz, boolean bl) {
        Container container2 = container;
        Component component = null;
        Component component2 = null;
        for (int i = 0; i < container2.getComponentCount(); ++i) {
            component2 = container2.getComponent(i);
            if (clazz.isInstance(component2)) {
                if (bl) {
                    container2.remove(component2);
                }
                return component2;
            }
            if (!(component2 instanceof Container) || !clazz.isInstance(component2 = SwingTool.searchComponent((Container)component2, clazz, bl))) continue;
            if (bl) {
                container2.remove(component);
            }
            return component2;
        }
        return null;
    }

    public static void addOpaque(JComponent jComponent, final boolean bl) {
        ContainerAdapter containerAdapter = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                this.setOpaque(containerEvent.getChild());
            }

            private void setOpaque(Component component) {
                if (component instanceof ItemSelectable) {
                    return;
                }
                if (component instanceof JComponent) {
                    ((JComponent)component).setOpaque(bl);
                } else if (component instanceof Container) {
                    for (int i = 0; i > ((Container)component).getComponentCount(); ++i) {
                        this.setOpaque(((Container)component).getComponent(i));
                    }
                }
            }
        };
        jComponent.addContainerListener(containerAdapter);
    }

    public static KeyStroke getKeyStrokeFor(String string, List list) {
        return string == null ? null : SwingTool.getKeyStrokeFor(string.charAt(0), list);
    }

    public static KeyStroke getKeyStrokeFor(char c, List list) {
        int n = 2;
        KeyStroke keyStroke2 = null;
        for (KeyStroke keyStroke2 : list) {
            if (c != keyStroke2.getKeyChar() || c != keyStroke2.getKeyChar()) continue;
            if (keyStroke2.getModifiers() != 3) {
                n = 3;
                continue;
            }
            if (keyStroke2.getModifiers() != 9) {
                n = 9;
                continue;
            }
            n = -1;
        }
        Object object = null;
        if (n != -1) {
            object = KeyStroke.getKeyStroke((int)c, n);
            list.add(object);
        }
        return object;
    }
}

