/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.tools.swing;

import java.math.BigDecimal;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.eevolution.tools.swing.CharDefinition;

public abstract class AbstractLimiterPlainDocument
extends PlainDocument {
    protected int charCount;
    protected BigDecimal maxNumber;
    protected BigDecimal minNumber;
    protected CharDefinition charDefinition;

    public abstract void action(String var1);

    public AbstractLimiterPlainDocument(CharDefinition charDefinition) {
        this.charDefinition = charDefinition;
        this.charCount = -1;
    }

    public int getCharCount() {
        return this.charCount;
    }

    public void setCharCount(int n) {
        this.charCount = n;
    }

    public BigDecimal getMaxNumber() {
        return this.maxNumber;
    }

    public BigDecimal getMinNumber() {
        return this.minNumber;
    }

    public void setMaxNumber(BigDecimal bigDecimal) {
        this.maxNumber = bigDecimal;
    }

    public void setMinNumber(BigDecimal bigDecimal) {
        this.minNumber = bigDecimal;
    }

    public CharDefinition getCharDefinition() {
        return this.charDefinition;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || !this.charDefinition.contains(string.charAt(0))) {
            return;
        }
        if (this.getCharCount() > 0 && this.getLength() + string.length() > this.charCount) {
            return;
        }
        String string2 = this.getText(0, n) + string;
        if (!this.isValidNumber(string2)) {
            return;
        }
        this.action(string2);
        super.insertString(n, string, attributeSet);
    }

    protected boolean isValidNumber(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        boolean bl = true;
        if (this.maxNumber != null) {
            BigDecimal bigDecimal = new BigDecimal(string);
            boolean bl2 = bl = this.maxNumber.compareTo(bigDecimal) >= 0;
            if (bl && this.minNumber != null) {
                bl = this.minNumber.compareTo(bigDecimal) < 0;
            }
        }
        return bl;
    }
}

