/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.model.engines.CostEngine;
import org.adempiere.model.engines.CostEngineFactory;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.X_T_BOMLine;

public class CostBillOfMaterial
extends SvrProcess {
    private static final String LEVELS = "....................";
    private int p_AD_Org_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_M_CostType_ID = 0;
    private String p_ConstingMethod = "S";
    private boolean p_implosion = false;
    private int m_LevelNo = 0;
    private int m_SeqNo = 0;
    private MAcctSchema m_as = null;
    private Collection<MCostElement> m_costElements = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = processInfoParameter.getParameterAsInt();
                this.m_as = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
                continue;
            }
            if (string.equals("M_CostType_ID")) {
                this.p_M_CostType_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("CostingMethod")) {
                this.p_ConstingMethod = (String)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("M_Product_ID")) {
                this.p_M_Product_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_M_Product_ID == 0) {
            throw new FillMandatoryException(new String[]{"M_Product_ID"});
        }
        this.explodeProduct(this.p_M_Product_ID, false);
        return "";
    }

    private void explodeProduct(int n, boolean bl) {
        MProduct mProduct = MProduct.get(this.getCtx(), n);
        List<MPPProductBOM> list = this.getBOMs(mProduct, bl);
        if (!bl && list.size() == 0) {
            throw new AdempiereException("@Error@ Product is not a BOM");
        }
        for (MPPProductBOM mPPProductBOM : list) {
            if (!bl) {
                this.createLines(mPPProductBOM, null);
            }
            ++this.m_LevelNo;
            for (MPPProductBOMLine mPPProductBOMLine : mPPProductBOM.getLines()) {
                if (!mPPProductBOMLine.isActive()) continue;
                this.createLines(mPPProductBOM, mPPProductBOMLine);
                this.explodeProduct(mPPProductBOMLine.getM_Product_ID(), true);
            }
            --this.m_LevelNo;
        }
    }

    private List<MPPProductBOM> getBOMs(MProduct mProduct, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("M_Product_ID").append("=?");
        arrayList.add(mProduct.get_ID());
        if (bl) {
            stringBuffer.append(" AND ").append("Value").append("=?");
            arrayList.add(mProduct.getValue());
        }
        List<MPPProductBOM> list = new Query(this.getCtx(), "PP_Product_BOM", stringBuffer.toString(), null).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("Value").list();
        return list;
    }

    private void createLines(MPPProductBOM mPPProductBOM, MPPProductBOMLine mPPProductBOMLine) {
        BigDecimal bigDecimal;
        MProduct mProduct;
        if (mPPProductBOMLine != null) {
            mProduct = MProduct.get(this.getCtx(), mPPProductBOMLine.getM_Product_ID());
            bigDecimal = mPPProductBOMLine.getQty();
        } else if (mPPProductBOM != null) {
            mProduct = MProduct.get(this.getCtx(), mPPProductBOM.getM_Product_ID());
            bigDecimal = Env.ONE;
        } else {
            throw new AdempiereException("@NotFound@ @PP_Product_BOM_ID@");
        }
        for (MCostElement mCostElement : this.getCostElements()) {
            X_T_BOMLine x_T_BOMLine = new X_T_BOMLine(this.getCtx(), 0, this.get_TrxName());
            x_T_BOMLine.setAD_Org_ID(this.p_AD_Org_ID);
            x_T_BOMLine.setSel_Product_ID(this.p_M_Product_ID);
            x_T_BOMLine.setImplosion(this.p_implosion);
            x_T_BOMLine.setC_AcctSchema_ID(this.p_C_AcctSchema_ID);
            x_T_BOMLine.setM_CostType_ID(this.p_M_CostType_ID);
            x_T_BOMLine.setCostingMethod(this.p_ConstingMethod);
            x_T_BOMLine.setAD_PInstance_ID(this.getAD_PInstance_ID());
            x_T_BOMLine.setM_CostElement_ID(mCostElement.get_ID());
            x_T_BOMLine.setM_Product_ID(mProduct.get_ID());
            x_T_BOMLine.setQtyBOM(bigDecimal);
            x_T_BOMLine.setSeqNo(this.m_SeqNo);
            x_T_BOMLine.setLevelNo(this.m_LevelNo);
            x_T_BOMLine.setLevels(LEVELS.substring(0, this.m_LevelNo) + this.m_LevelNo);
            CostEngine costEngine = CostEngineFactory.getCostEngine(this.getAD_Client_ID());
            Collection<MCost> collection = costEngine.getByElement(mProduct, this.m_as, this.p_M_CostType_ID, this.p_AD_Org_ID, 0, mCostElement.getM_CostElement_ID());
            BigDecimal bigDecimal2 = Env.ZERO;
            BigDecimal bigDecimal3 = Env.ZERO;
            BigDecimal bigDecimal4 = Env.ZERO;
            BigDecimal bigDecimal5 = Env.ZERO;
            boolean bl = false;
            for (MCost mCost : collection) {
                bigDecimal2 = bigDecimal2.add(mCost.getCurrentCostPrice());
                bigDecimal3 = bigDecimal3.add(mCost.getCurrentCostPriceLL());
                bigDecimal4 = bigDecimal4.add(mCost.getFutureCostPrice());
                bigDecimal5 = bigDecimal5.add(mCost.getFutureCostPriceLL());
                bl = mCost.isCostFrozen();
            }
            x_T_BOMLine.setCurrentCostPrice(bigDecimal2);
            x_T_BOMLine.setCurrentCostPriceLL(bigDecimal3);
            x_T_BOMLine.setFutureCostPrice(bigDecimal2);
            x_T_BOMLine.setFutureCostPriceLL(bigDecimal3);
            x_T_BOMLine.setIsCostFrozen(bl);
            if (mPPProductBOMLine != null) {
                x_T_BOMLine.setPP_Product_BOM_ID(mPPProductBOMLine.getPP_Product_BOM_ID());
                x_T_BOMLine.setPP_Product_BOMLine_ID(mPPProductBOMLine.getPP_Product_BOMLine_ID());
            } else if (mPPProductBOM != null) {
                x_T_BOMLine.setPP_Product_BOM_ID(mPPProductBOM.getPP_Product_BOM_ID());
            }
            x_T_BOMLine.saveEx();
            ++this.m_SeqNo;
        }
    }

    public Collection<MCostElement> getCostElements() {
        if (this.m_costElements == null) {
            this.m_costElements = MCostElement.getByCostingMethod(this.getCtx(), this.p_ConstingMethod);
        }
        return this.m_costElements;
    }
}

