/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.model.engines.CostDimension;
import org.adempiere.model.engines.CostEngine;
import org.adempiere.model.engines.CostEngineFactory;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;

public class RollupWorkflow
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private int p_M_CostType_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;
    private String p_ConstingMethod = "S";
    private MAcctSchema m_as = null;
    private RoutingService m_routingService = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = processInfoParameter.getParameterAsInt();
                this.m_as = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
                continue;
            }
            if (string.equals("M_CostType_ID")) {
                this.p_M_CostType_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("CostingMethod")) {
                this.p_ConstingMethod = (String)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("M_Product_ID")) {
                this.p_M_Product_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.m_routingService = RoutingServiceFactory.get().getRoutingService(this.getAD_Client_ID());
        for (MProduct mProduct : this.getProducts()) {
            this.log.info("Product: " + mProduct);
            int n = 0;
            MPPProductPlanning mPPProductPlanning = null;
            if (n <= 0) {
                n = MWorkflow.getWorkflowSearchKey(mProduct);
            }
            if (n <= 0) {
                mPPProductPlanning = MPPProductPlanning.find(this.getCtx(), this.p_AD_Org_ID, 0, 0, mProduct.get_ID(), this.get_TrxName());
                if (mPPProductPlanning != null) {
                    n = mPPProductPlanning.getAD_Workflow_ID();
                } else {
                    this.createNotice(mProduct, "@NotFound@ @PP_Product_Planning_ID@");
                }
            }
            if (n <= 0) {
                this.createNotice(mProduct, "@NotFound@ @AD_Workflow_ID@");
                continue;
            }
            MWorkflow mWorkflow = new MWorkflow(this.getCtx(), n, this.get_TrxName());
            this.rollup(mProduct, mWorkflow);
            if (mPPProductPlanning == null) continue;
            mPPProductPlanning.setYield(mWorkflow.getYield());
            mPPProductPlanning.saveEx();
        }
        return "@OK@";
    }

    private Collection<MProduct> getProducts() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer("AD_Client_ID=?");
        arrayList.add(this.getAD_Client_ID());
        stringBuffer.append(" AND (").append("ProductType").append("=?");
        arrayList.add("I");
        stringBuffer.append(" OR ").append("ProductType").append("=?");
        arrayList.add("R");
        stringBuffer.append(") AND ").append("IsBOM").append("=?");
        arrayList.add(true);
        if (this.p_M_Product_ID > 0) {
            stringBuffer.append(" AND ").append("M_Product_ID").append("=?");
            arrayList.add(this.p_M_Product_ID);
        } else if (this.p_M_Product_Category_ID > 0) {
            stringBuffer.append(" AND ").append("M_Product_Category_ID").append("=?");
            arrayList.add(this.p_M_Product_Category_ID);
        }
        List<MProduct> list = new Query(this.getCtx(), "M_Product", stringBuffer.toString(), this.get_TrxName()).setOrderBy("LowLevel").setParameters(arrayList).list();
        return list;
    }

    public void rollup(MProduct mProduct, MWorkflow mWorkflow) {
        this.log.info("Workflow: " + mWorkflow);
        mWorkflow.setCost(Env.ZERO);
        double d = 1.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        MWFNode[] mWFNodeArray = mWorkflow.getNodes(false, this.getAD_Client_ID());
        for (MWFNode list : mWFNodeArray) {
            list.setCost(Env.ZERO);
            if (list.getYield() != 0) {
                d *= (double)list.getYield() / 100.0;
            }
            long l = list.getDuration();
            n += list.getQueuingTime();
            n2 += list.getSetupTime();
            n3 = (int)((long)n3 + l);
            n4 += list.getWaitingTime();
            n5 += list.getMovingTime();
            n6 += list.getWorkingTime();
        }
        mWorkflow.setCost(Env.ZERO);
        mWorkflow.setYield((int)(d * 100.0));
        mWorkflow.setQueuingTime(n);
        mWorkflow.setSetupTime(n2);
        mWorkflow.setDuration(n3);
        mWorkflow.setWaitingTime(n4);
        mWorkflow.setMovingTime(n5);
        mWorkflow.setWorkingTime(n6);
        for (MCostElement mCostElement : MCostElement.getByCostingMethod(this.getCtx(), this.p_ConstingMethod)) {
            if (!CostEngine.isActivityControlElement(mCostElement)) continue;
            CostDimension costDimension = new CostDimension(mProduct, this.m_as, this.p_M_CostType_ID, this.p_AD_Org_ID, 0, mCostElement.get_ID());
            List list = costDimension.toQuery(MCost.class, this.get_TrxName()).list();
            for (MCost mCost : list) {
                int n7 = MAcctSchema.get(Env.getCtx(), mCost.getC_AcctSchema_ID()).getCostingPrecision();
                BigDecimal bigDecimal = Env.ZERO;
                for (MWFNode mWFNode : mWFNodeArray) {
                    CostEngine costEngine = CostEngineFactory.getCostEngine(mWFNode.getAD_Client_ID());
                    BigDecimal bigDecimal2 = costEngine.getResourceActualCostRate(null, mWFNode.getS_Resource_ID(), costDimension, this.get_TrxName());
                    BigDecimal bigDecimal3 = this.m_routingService.getResourceBaseValue(mWFNode.getS_Resource_ID(), mWFNode);
                    BigDecimal bigDecimal4 = bigDecimal3.multiply(bigDecimal2);
                    if (bigDecimal4.scale() > n7) {
                        bigDecimal4 = bigDecimal4.setScale(n7, RoundingMode.HALF_UP);
                    }
                    bigDecimal = bigDecimal.add(bigDecimal4);
                    this.log.info("Element : " + mCostElement + ", Node=" + mWFNode + ", BaseValue=" + bigDecimal3 + ", rate=" + bigDecimal2 + ", nodeCost=" + bigDecimal4 + " => Cost=" + bigDecimal);
                    mWFNode.setCost(mWFNode.getCost().add(bigDecimal4));
                }
                mCost.setCurrentCostPrice(bigDecimal);
                mCost.saveEx();
                mWorkflow.setCost(mWorkflow.getCost().add(bigDecimal));
            }
        }
        for (MWFNode mWFNode : mWFNodeArray) {
            mWFNode.saveEx();
        }
        mWorkflow.saveEx();
        this.log.info("Product: " + mProduct.getName() + " WFCost: " + mWorkflow.getCost());
    }

    private void createNotice(MProduct mProduct, String string) {
        String string2 = mProduct != null ? mProduct.getValue() : "-";
        this.addLog("WARNING: Product " + string2 + ": " + string);
    }
}

