/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.adempiere.model.engines.CostDimension;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.MPPProductPlanning;

public class RollupBillOfMaterial
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private int p_M_CostType_ID = 0;
    private String p_ConstingMethod = "S";
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;
    private String p_ProductType = null;
    private Collection<MCostElement> m_costElements = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("M_CostType_ID")) {
                this.p_M_CostType_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("CostingMethod")) {
                this.p_ConstingMethod = (String)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("M_Product_ID")) {
                this.p_M_Product_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("ProductType")) {
                this.p_ProductType = processInfoParameter.getParameter() == null ? null : processInfoParameter.getParameter().toString();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        int n;
        this.resetCostsLLForLLC0();
        for (int i = n = MPPMRP.getMaxLowLevel(this.getCtx(), this.get_TrxName()); i >= 0; --i) {
            for (MProduct mProduct : this.getProducts(i)) {
                MPPProductBOM mPPProductBOM;
                MPPProductPlanning mPPProductPlanning = MPPProductPlanning.find(this.getCtx(), this.p_AD_Org_ID, 0, 0, mProduct.getM_Product_ID(), this.get_TrxName());
                int n2 = 0;
                if (mPPProductPlanning != null) {
                    n2 = mPPProductPlanning.getPP_Product_BOM_ID();
                } else {
                    this.createNotice(mProduct, "@NotFound@ @PP_Product_Planning_ID@");
                }
                if (n2 <= 0) {
                    n2 = MPPProductBOM.getBOMSearchKey(mProduct);
                }
                if ((mPPProductBOM = MPPProductBOM.get(this.getCtx(), n2)) == null) {
                    this.createNotice(mProduct, "@NotFound@ @PP_Product_BOM_ID@");
                }
                this.rollup(mProduct, mPPProductBOM);
            }
        }
        return "@OK@";
    }

    protected void rollup(MProduct mProduct, MPPProductBOM mPPProductBOM) {
        for (MCostElement mCostElement : this.getCostElements()) {
            for (MCost mCost : this.getCosts(mProduct, mCostElement.get_ID())) {
                this.log.info("Calculate Lower Cost for: " + mPPProductBOM);
                BigDecimal bigDecimal = this.getCurrentCostPriceLL(mPPProductBOM, mCostElement);
                this.log.info(mCostElement.getName() + " Cost Low Level:" + bigDecimal);
                mCost.setCurrentCostPriceLL(bigDecimal);
                this.updateCoProductCosts(mPPProductBOM, mCost);
                mCost.saveEx();
            }
        }
    }

    private void updateCoProductCosts(MPPProductBOM mPPProductBOM, MCost mCost) {
        if (mPPProductBOM == null) {
            return;
        }
        BigDecimal bigDecimal = Env.ZERO;
        for (MPPProductBOMLine mPPProductBOMLine : mPPProductBOM.getLines()) {
            if (!mPPProductBOMLine.isCoProduct()) continue;
            BigDecimal bigDecimal2 = mCost.getCurrentCostPriceLL().multiply(mPPProductBOMLine.getCostAllocationPerc(true));
            MCost mCost2 = MCost.get(mCost.getCtx(), mCost.getAD_Client_ID(), mCost.getAD_Org_ID(), mPPProductBOMLine.getM_Product_ID(), mCost.getM_CostType_ID(), mCost.getC_AcctSchema_ID(), mCost.getM_CostElement_ID(), 0, mCost.get_TrxName());
            if (mCost2 == null) {
                mCost2 = new MCost(mCost.getCtx(), 0, mCost.get_TrxName());
                mCost2.setAD_Org_ID(mCost.getAD_Org_ID());
                mCost2.setM_Product_ID(mPPProductBOMLine.getM_Product_ID());
                mCost2.setM_CostType_ID(mCost.getM_CostType_ID());
                mCost2.setC_AcctSchema_ID(mCost.getC_AcctSchema_ID());
                mCost2.setM_CostElement_ID(mCost.getM_CostElement_ID());
                mCost2.setM_AttributeSetInstance_ID(0);
            }
            mCost2.setCurrentCostPriceLL(bigDecimal2);
            mCost2.saveEx();
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        if (bigDecimal.signum() != 0) {
            mCost.setCurrentCostPriceLL(bigDecimal);
        }
    }

    private BigDecimal getCurrentCostPriceLL(MPPProductBOM mPPProductBOM, MCostElement mCostElement) {
        this.log.info("Element: " + mCostElement);
        BigDecimal bigDecimal = Env.ZERO;
        if (mPPProductBOM == null) {
            return bigDecimal;
        }
        for (MPPProductBOMLine mPPProductBOMLine : mPPProductBOM.getLines()) {
            if (mPPProductBOMLine.isCoProduct()) continue;
            MProduct mProduct = MProduct.get(this.getCtx(), mPPProductBOMLine.getM_Product_ID());
            for (MCost mCost : this.getCosts(mProduct, mCostElement.get_ID())) {
                BigDecimal bigDecimal2 = mPPProductBOMLine.getQty(true);
                if (mPPProductBOMLine.isByProduct()) {
                    mCost.setCurrentCostPriceLL(Env.ZERO);
                }
                BigDecimal bigDecimal3 = mCost.getCurrentCostPrice().add(mCost.getCurrentCostPriceLL());
                BigDecimal bigDecimal4 = bigDecimal3.multiply(bigDecimal2);
                bigDecimal = bigDecimal.add(bigDecimal4);
                this.log.info("CostElement: " + mCostElement.getName() + ", Component: " + mProduct.getValue() + ", CostPrice: " + bigDecimal3 + ", Qty: " + bigDecimal2 + ", Cost: " + bigDecimal4 + " => Total Cost Element: " + bigDecimal);
            }
        }
        return bigDecimal;
    }

    private Collection<MCost> getCosts(MProduct mProduct, int n) {
        MAcctSchema mAcctSchema = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
        CostDimension costDimension = new CostDimension(mProduct, mAcctSchema, this.p_M_CostType_ID, this.p_AD_Org_ID, 0, n);
        return costDimension.toQuery(MCost.class, this.get_TrxName()).list();
    }

    private Collection<MProduct> getProducts(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer("AD_Client_ID=?").append(" AND ").append("LowLevel").append("=?");
        arrayList.add(this.getAD_Client_ID());
        arrayList.add(n);
        stringBuffer.append(" AND ").append("IsBOM").append("=?");
        arrayList.add(true);
        if (this.p_M_Product_ID > 0) {
            stringBuffer.append(" AND ").append("M_Product_ID").append("=?");
            arrayList.add(this.p_M_Product_ID);
        } else if (this.p_M_Product_Category_ID > 0) {
            stringBuffer.append(" AND ").append("M_Product_Category_ID").append("=?");
            arrayList.add(this.p_M_Product_Category_ID);
        }
        if (this.p_M_Product_ID <= 0 && this.p_ProductType != null) {
            stringBuffer.append(" AND ").append("ProductType").append("=?");
            arrayList.add(this.p_ProductType);
        }
        return new Query(this.getCtx(), "M_Product", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).list();
    }

    private void resetCostsLLForLLC0() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AD_Client_ID=? AND LowLevel=?");
        arrayList.add(this.getAD_Client_ID());
        arrayList.add(0);
        if (this.p_M_Product_ID > 0) {
            stringBuffer.append(" AND ").append("M_Product_ID").append("=?");
            arrayList.add(this.p_M_Product_ID);
        } else if (this.p_M_Product_Category_ID > 0) {
            stringBuffer.append(" AND ").append("M_Product_Category_ID").append("=?");
            arrayList.add(this.p_M_Product_Category_ID);
        }
        String string = "UPDATE M_Cost c SET CurrentCostPriceLL=0 WHERE EXISTS (SELECT 1 FROM M_Product p WHERE p.M_Product_ID=c.M_Product_ID AND " + stringBuffer + ")";
        int n = DB.executeUpdateEx(string, arrayList.toArray(), this.get_TrxName());
        this.log.info("Updated #" + n);
    }

    private Collection<MCostElement> getCostElements() {
        if (this.m_costElements == null) {
            this.m_costElements = MCostElement.getByCostingMethod(this.getCtx(), this.p_ConstingMethod);
        }
        return this.m_costElements;
    }

    private void createNotice(MProduct mProduct, String string) {
        String string2 = mProduct != null ? mProduct.getValue() : "-";
        this.addLog("WARNING: Product " + string2 + ": " + string);
    }
}

