/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.Enumeration;
import java.util.Hashtable;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ProcessInfoHandler {
    protected ProcessInfo pi;
    protected MPInstance pinstance;
    protected Hashtable param;
    protected MProcess process;

    public ProcessInfoHandler(int n) {
        this.init(n);
    }

    private void init(int n) {
        this.process = new MProcess(Env.getCtx(), n, null);
        if (this.process != null) {
            this.pi = this.getProcessInfo(Msg.translate(Env.getCtx(), this.process.getName()), this.process.get_ID());
            this.pinstance = this.getProcessInstance(this.pi);
            this.pi.setAD_PInstance_ID(this.pinstance.getAD_PInstance_ID());
        }
    }

    protected ProcessInfo getProcessInfo(String string, int n) {
        ProcessInfo processInfo = new ProcessInfo(string, n);
        processInfo.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
        processInfo.setAD_Client_ID(Env.getAD_Client_ID(Env.getCtx()));
        return processInfo;
    }

    protected MPInstance getProcessInstance(ProcessInfo processInfo) {
        MPInstance mPInstance = new MPInstance(Env.getCtx(), processInfo.getAD_Process_ID(), processInfo.getRecord_ID());
        if (!mPInstance.save()) {
            processInfo.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            processInfo.setError(true);
            return null;
        }
        return mPInstance;
    }

    protected int countParams() {
        return this.process != null ? this.process.getParameters().length : 0;
    }

    protected Hashtable extractParameters() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        MPInstancePara mPInstancePara = null;
        int n = this.countParams();
        for (int i = 0; i < n; ++i) {
            mPInstancePara = new MPInstancePara(this.getProcessInstance(), i);
            mPInstancePara.load((String)null);
            hashtable.put(mPInstancePara.getParameterName(), this.getValueFrom(mPInstancePara));
        }
        return hashtable;
    }

    protected Object getValueFrom(MPInstancePara mPInstancePara) {
        Object object = null;
        object = object == null ? mPInstancePara.getP_Date() : object;
        object = object == null ? mPInstancePara.getP_Date_To() : object;
        object = object == null ? mPInstancePara.getP_Number() : object;
        object = object == null ? mPInstancePara.getP_Number_To() : object;
        object = object == null ? mPInstancePara.getP_String() : object;
        object = object == null ? mPInstancePara.getP_String_To() : object;
        return object;
    }

    public void setProcessError() {
        this.pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessCancelled"));
        this.pi.setError(true);
    }

    public MPInstance getProcessInstance() {
        return this.pinstance;
    }

    public ProcessInfo getProcessInfo() {
        return this.pi;
    }

    public Object getParameterValue(String string) {
        if (this.param == null) {
            this.param = this.extractParameters();
        }
        return this.param.get(string);
    }

    public Enumeration getParameters() {
        if (this.param == null) {
            this.param = this.extractParameters();
        }
        return this.param.keys();
    }
}

