/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.X_T_BOMLine;

public class PrintBOM
extends SvrProcess {
    private static final Properties ctx = Env.getCtx();
    private int p_M_Product_ID = 0;
    private boolean p_implosion = false;
    private int LevelNo = 1;
    private int SeqNo = 0;
    private String levels = new String("....................");
    private int AD_PInstance_ID = 0;
    private static final int X_RV_PP_Product_BOMLine_Table_ID = 53063;
    private static final String X_RV_PP_Product_BOMLine_Table_Name = "RV_PP_Product_BOMLine";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (string.equals("M_Product_ID")) {
                this.p_M_Product_ID = ((BigDecimal)processInfoParameterArray[i].getParameter()).intValue();
                continue;
            }
            if (string.equals("Implosion")) {
                this.p_implosion = !((String)processInfoParameterArray[i].getParameter()).equals("N");
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.AD_PInstance_ID = this.getAD_PInstance_ID();
        try {
            this.loadBOM();
            this.print();
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, "PrintBOM", exception.toString());
            throw new Exception(exception.getLocalizedMessage());
        }
        finally {
            String string = "DELETE FROM T_BomLine WHERE AD_PInstance_ID = " + this.AD_PInstance_ID;
            DB.executeUpdate(string, null);
        }
        return "@OK@";
    }

    void print() throws Exception {
        Language language = Language.getLoginLanguage();
        MPrintFormat mPrintFormat = null;
        int n = 0;
        RowSet rowSet = MPrintFormat.getAccessiblePrintFormats(53063, -1, null);
        rowSet.next();
        n = rowSet.getInt("AD_PrintFormat_ID");
        mPrintFormat = rowSet.getInt("AD_Client_ID") != 0 ? MPrintFormat.get(this.getCtx(), n, false) : MPrintFormat.copyToClient(this.getCtx(), n, this.getAD_Client_ID());
        rowSet.close();
        if (mPrintFormat == null) {
            this.raiseError("Error: ", "No Print Format");
        }
        mPrintFormat.setLanguage(language);
        mPrintFormat.setTranslationLanguage(language);
        MQuery mQuery = MQuery.get(this.getCtx(), this.AD_PInstance_ID, X_RV_PP_Product_BOMLine_Table_Name);
        mQuery.addRestriction("AD_PInstance_ID", "=", this.AD_PInstance_ID);
        PrintInfo printInfo = new PrintInfo(X_RV_PP_Product_BOMLine_Table_Name, 53063, this.getRecord_ID());
        ReportEngine reportEngine = new ReportEngine(this.getCtx(), mPrintFormat, mQuery, printInfo);
        ReportCtl.preview(reportEngine);
        while (reportEngine.getView().isDisplayable()) {
            Env.sleep(1);
        }
    }

    private void loadBOM() throws Exception {
        block14: {
            ResultSet resultSet;
            CPreparedStatement cPreparedStatement;
            block12: {
                int n;
                block13: {
                    ResultSet resultSet2;
                    CPreparedStatement cPreparedStatement2;
                    block11: {
                        n = 0;
                        if (this.p_M_Product_ID == 0) {
                            this.raiseError("Error: ", "Product ID not found");
                        }
                        X_T_BOMLine x_T_BOMLine = new X_T_BOMLine(ctx, 0, null);
                        x_T_BOMLine.setPP_Product_BOM_ID(0);
                        x_T_BOMLine.setPP_Product_BOMLine_ID(0);
                        x_T_BOMLine.setM_Product_ID(this.p_M_Product_ID);
                        x_T_BOMLine.setSel_Product_ID(this.p_M_Product_ID);
                        x_T_BOMLine.setImplosion(this.p_implosion);
                        x_T_BOMLine.setLevelNo(0);
                        x_T_BOMLine.setLevels("0");
                        x_T_BOMLine.setSeqNo(0);
                        x_T_BOMLine.setAD_PInstance_ID(this.AD_PInstance_ID);
                        x_T_BOMLine.save();
                        if (!this.p_implosion) break block13;
                        cPreparedStatement2 = null;
                        resultSet2 = null;
                        String string = "SELECT PP_Product_BOMLine_ID FROM PP_Product_BOMLine WHERE IsActive = 'Y' AND M_Product_ID = ? ";
                        try {
                            cPreparedStatement2 = DB.prepareStatement(string, this.get_TrxName());
                            cPreparedStatement2.setInt(1, this.p_M_Product_ID);
                            resultSet2 = cPreparedStatement2.executeQuery();
                            while (resultSet2.next()) {
                                this.parentImplotion(resultSet2.getInt(1));
                                ++n;
                            }
                            if (n != 0) break block11;
                            this.raiseError("Error: ", "Product is not a component");
                        }
                        catch (SQLException sQLException) {
                            try {
                                this.log.log(Level.SEVERE, sQLException.getLocalizedMessage() + string, sQLException);
                                throw new Exception("SQLException: " + sQLException.getLocalizedMessage());
                            }
                            catch (Throwable throwable) {
                                DB.close(resultSet2, cPreparedStatement2);
                                resultSet2 = null;
                                cPreparedStatement2 = null;
                                throw throwable;
                            }
                        }
                    }
                    DB.close(resultSet2, cPreparedStatement2);
                    resultSet2 = null;
                    cPreparedStatement2 = null;
                    break block14;
                }
                cPreparedStatement = null;
                resultSet = null;
                String string = "SELECT PP_Product_BOM_ID FROM PP_Product_BOM WHERE IsActive = 'Y' AND M_Product_ID = ? ";
                try {
                    cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
                    cPreparedStatement.setInt(1, this.p_M_Product_ID);
                    resultSet = cPreparedStatement.executeQuery();
                    while (resultSet.next()) {
                        this.parentExplotion(resultSet.getInt(1));
                        ++n;
                    }
                    if (n != 0) break block12;
                    this.raiseError("Error: ", "Product is not a BOM");
                }
                catch (SQLException sQLException) {
                    try {
                        this.log.log(Level.SEVERE, sQLException.getLocalizedMessage() + string, sQLException);
                        throw new Exception("SQLException: " + sQLException.getLocalizedMessage());
                    }
                    catch (Throwable throwable) {
                        DB.close(resultSet, cPreparedStatement);
                        resultSet = null;
                        cPreparedStatement = null;
                        throw throwable;
                    }
                }
            }
            DB.close(resultSet, cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
        }
    }

    public void parentImplotion(int n) throws Exception {
        int n2 = 0;
        int n3 = 0;
        X_T_BOMLine x_T_BOMLine = new X_T_BOMLine(ctx, 0, null);
        n2 = DB.getSQLValue(null, "SELECT PP_Product_BOM_ID FROM PP_Product_BOMLine WHERE PP_Product_BOMLine_ID=?", n);
        if (n2 < 0) {
            throw new Exception(CLogger.retrieveErrorString("Error: PrintBOM.parentImplotion()"));
        }
        n3 = DB.getSQLValue(null, "SELECT M_Product_ID FROM PP_Product_BOM WHERE PP_Product_BOM_ID=?", n2);
        if (n3 < 0) {
            throw new Exception(CLogger.retrieveErrorString("Error: PrintBOM.parentImplotion()"));
        }
        x_T_BOMLine.setPP_Product_BOM_ID(n2);
        x_T_BOMLine.setPP_Product_BOMLine_ID(n);
        x_T_BOMLine.setM_Product_ID(n3);
        x_T_BOMLine.setLevelNo(this.LevelNo);
        x_T_BOMLine.setSel_Product_ID(this.p_M_Product_ID);
        x_T_BOMLine.setImplosion(this.p_implosion);
        if (this.LevelNo >= 11) {
            x_T_BOMLine.setLevels(this.levels + ">" + this.LevelNo);
        } else if (this.LevelNo >= 1) {
            x_T_BOMLine.setLevels(this.levels.substring(0, this.LevelNo) + this.LevelNo);
        }
        x_T_BOMLine.setSeqNo(this.SeqNo);
        x_T_BOMLine.setAD_PInstance_ID(this.AD_PInstance_ID);
        x_T_BOMLine.save();
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        String string = "SELECT PP_Product_BOM_ID, M_Product_ID FROM PP_Product_BOM WHERE IsActive = 'Y' AND M_Product_ID = ? ";
        try {
            cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
            cPreparedStatement.setInt(1, n3);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                ++this.SeqNo;
                this.component(resultSet.getInt(2));
            }
        }
        catch (SQLException sQLException) {
            try {
                this.log.log(Level.SEVERE, sQLException.getLocalizedMessage() + string, sQLException);
                throw new Exception("SQLException: " + sQLException.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
    }

    public void parentExplotion(int n) throws Exception {
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        String string = "SELECT PP_Product_BOMLine_ID, M_Product_ID FROM PP_Product_BOMLine boml WHERE IsActive = 'Y' AND PP_Product_BOM_ID = ? ORDER BY Line ";
        try {
            cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
            cPreparedStatement.setInt(1, n);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                ++this.SeqNo;
                X_T_BOMLine x_T_BOMLine = new X_T_BOMLine(ctx, 0, null);
                x_T_BOMLine.setPP_Product_BOM_ID(n);
                x_T_BOMLine.setPP_Product_BOMLine_ID(resultSet.getInt(1));
                x_T_BOMLine.setM_Product_ID(resultSet.getInt(2));
                x_T_BOMLine.setLevelNo(this.LevelNo);
                x_T_BOMLine.setLevels(this.levels.substring(0, this.LevelNo) + this.LevelNo);
                x_T_BOMLine.setSeqNo(this.SeqNo);
                x_T_BOMLine.setAD_PInstance_ID(this.AD_PInstance_ID);
                x_T_BOMLine.setSel_Product_ID(this.p_M_Product_ID);
                x_T_BOMLine.setImplosion(this.p_implosion);
                x_T_BOMLine.save();
                this.component(resultSet.getInt(2));
            }
        }
        catch (SQLException sQLException) {
            try {
                this.log.log(Level.SEVERE, sQLException.getLocalizedMessage() + string, sQLException);
                throw new Exception("SQLException: " + sQLException.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
    }

    public void component(int n) throws Exception {
        if (this.p_implosion) {
            ++this.LevelNo;
            CPreparedStatement cPreparedStatement = null;
            ResultSet resultSet = null;
            String string = "SELECT PP_Product_BOMLine_ID FROM PP_Product_BOMLine WHERE IsActive = 'Y' AND M_Product_ID = ? ";
            try {
                cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
                cPreparedStatement.setInt(1, n);
                resultSet = cPreparedStatement.executeQuery();
                while (resultSet.next()) {
                    this.parentImplotion(resultSet.getInt(1));
                }
                resultSet.close();
                cPreparedStatement.close();
                --this.LevelNo;
            }
            catch (SQLException sQLException) {
                try {
                    this.log.log(Level.SEVERE, sQLException.getLocalizedMessage() + string, sQLException);
                    throw new Exception("SQLException: " + sQLException.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    DB.close(resultSet, cPreparedStatement);
                    resultSet = null;
                    cPreparedStatement = null;
                    throw throwable;
                }
            }
            DB.close(resultSet, cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
            return;
        }
        String string = "SELECT PP_Product_BOM_ID FROM PP_Product_BOM  WHERE IsActive = 'Y' AND Value = ? ";
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = DB.getSQLValueString(this.get_TrxName(), "SELECT Value FROM M_PRODUCT WHERE M_PRODUCT_ID=?", n);
            if (string2 == null) {
                throw new Exception(CLogger.retrieveErrorString("Error: PrintBOM.component()"));
            }
            cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
            cPreparedStatement.setString(1, string2);
            resultSet = cPreparedStatement.executeQuery();
            boolean bl = false;
            while (resultSet.next()) {
                if (!bl) {
                    ++this.LevelNo;
                }
                bl = true;
                this.parentExplotion(resultSet.getInt(1));
                --this.LevelNo;
            }
        }
        catch (SQLException sQLException) {
            try {
                this.log.log(Level.SEVERE, sQLException.getLocalizedMessage() + string, sQLException);
                throw new Exception("SQLException: " + sQLException.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
    }

    private void raiseError(String string, String string2) throws Exception {
        String string3 = string;
        ValueNamePair valueNamePair = CLogger.retrieveError();
        if (valueNamePair != null) {
            string3 = valueNamePair.getName() + " - ";
        }
        string3 = string3 + string2;
        throw new Exception(string3);
    }
}

