/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class PP_Product_BOM_Check
extends SvrProcess {
    private int p_Record_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Check BOM Structure");
        MProduct mProduct = new MProduct(Env.getCtx(), this.p_Record_ID, this.get_TrxName());
        if (!mProduct.isBOM()) {
            this.log.info("Product is not a BOM");
            return "OK";
        }
        int n = MPPProductBOMLine.getLowLevel(this.getCtx(), this.p_Record_ID, this.get_TrxName());
        mProduct.setLowLevel(n);
        mProduct.setIsVerified(true);
        mProduct.saveEx();
        MPPProductBOM mPPProductBOM = MPPProductBOM.getDefault(mProduct, this.get_TrxName());
        if (mPPProductBOM == null) {
            this.raiseError("No Default BOM found: ", "Check BOM Parent search key");
        }
        if (mPPProductBOM.getM_Product_ID() != 0) {
            MPPProductBOMLine[] mPPProductBOMLineArray;
            for (MPPProductBOMLine mPPProductBOMLine : mPPProductBOMLineArray = mPPProductBOM.getLines()) {
                n = mPPProductBOMLine.getLowLevel();
                MProduct mProduct2 = new MProduct(this.getCtx(), mPPProductBOMLine.getM_Product_ID(), this.get_TrxName());
                mProduct2.setLowLevel(n);
                mProduct2.setIsVerified(true);
                mProduct2.saveEx();
            }
        }
        return "OK";
    }

    private void raiseError(String string, String string2) throws Exception {
        DB.rollback(false, this.get_TrxName());
        MProduct mProduct = new MProduct(this.getCtx(), this.p_Record_ID, null);
        mProduct.setIsVerified(false);
        mProduct.saveEx();
        String string3 = string;
        ValueNamePair valueNamePair = CLogger.retrieveError();
        if (valueNamePair != null) {
            string3 = valueNamePair.getName() + " - ";
        }
        string3 = string3 + string2;
        throw new AdempiereUserError(string3);
    }
}

