/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MStorage;
import org.compiere.model.PO;
import org.compiere.model.X_M_AttributeSet;
import org.compiere.model.X_M_MovementLine;
import org.compiere.model.X_M_Product;
import org.compiere.model.X_M_Product_Category;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;

public class MovementGenerate
extends SvrProcess {
    private boolean p_Selection = false;
    private int p_M_Warehouse_ID = 0;
    private int p_C_BPartner_ID = 0;
    private Timestamp p_DatePromised = null;
    private boolean p_IsUnconfirmedInOut = false;
    private String p_docAction = "CO";
    private boolean p_ConsolidateDocument = true;
    private Timestamp p_DateShipped = null;
    private MMovement m_movement = null;
    private int m_created = 0;
    private int m_line = 0;
    private Timestamp m_movementDate = null;
    private int m_lastC_BPartner_Location_ID = -1;
    private String m_sql = null;
    private HashMap<SParameter, MStorage[]> m_map = new HashMap();
    private SParameter m_lastPP = null;
    private MStorage[] m_lastStorages = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() != null) {
                if (string.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = processInfoParameter.getParameterAsInt();
                } else if (string.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = processInfoParameter.getParameterAsInt();
                } else if (string.equals("DatePromised")) {
                    this.p_DatePromised = (Timestamp)processInfoParameter.getParameter();
                } else if (string.equals("Selection")) {
                    this.p_Selection = "Y".equals(processInfoParameter.getParameter());
                } else if (string.equals("IsUnconfirmedInOut")) {
                    this.p_IsUnconfirmedInOut = "Y".equals(processInfoParameter.getParameter());
                } else if (string.equals("ConsolidateDocument")) {
                    this.p_ConsolidateDocument = "Y".equals(processInfoParameter.getParameter());
                } else if (string.equals("DocAction")) {
                    this.p_docAction = (String)processInfoParameter.getParameter();
                } else if (string.equals("MovementDate")) {
                    this.p_DateShipped = (Timestamp)processInfoParameter.getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
                }
            }
            if (this.p_DateShipped == null) {
                this.m_movementDate = Env.getContextAsDate(this.getCtx(), "#Date");
                if (this.m_movementDate == null) {
                    this.m_movementDate = new Timestamp(System.currentTimeMillis());
                }
            } else {
                this.m_movementDate = this.p_DateShipped;
            }
            if ("CO".equals(this.p_docAction)) continue;
            this.p_docAction = "PR";
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Selection=" + this.p_Selection + ", M_Warehouse_ID=" + this.p_M_Warehouse_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", Consolidate=" + this.p_ConsolidateDocument + ", IsUnconfirmed=" + this.p_IsUnconfirmedInOut + ", Movement=" + this.m_movementDate);
        if (this.p_M_Warehouse_ID == 0) {
            throw new AdempiereUserError("@NotFound@ @M_Warehouse_ID@");
        }
        if (this.p_Selection) {
            this.m_sql = "SELECT DD_Order.* FROM DD_Order, T_Selection WHERE DD_Order.DocStatus='CO' AND DD_Order.AD_Client_ID=? AND DD_Order.DD_Order_ID = T_Selection.T_Selection_ID AND T_Selection.AD_PInstance_ID=? ";
        } else {
            this.m_sql = "SELECT * FROM DD_Order o WHERE DocStatus='CO'  AND o.C_DocType_ID IN (SELECT C_DocType_ID FROM C_DocType WHERE DocBaseType='DOO')\tAND o.IsDropShip='N' AND o.DeliveryRule<>'M' AND EXISTS (SELECT * FROM DD_OrderLine ol WHERE ol.M_Warehouse_ID=?";
            if (this.p_DatePromised != null) {
                this.m_sql = this.m_sql + " AND TRUNC(ol.DatePromised)<=?";
            }
            this.m_sql = this.m_sql + " AND o.DD_Order_ID=ol.DD_Order_ID AND ol.QtyOrdered<>ol.QtyIntransit)";
            if (this.p_C_BPartner_ID != 0) {
                this.m_sql = this.m_sql + " AND o.C_BPartner_ID=?";
            }
            this.m_sql = this.m_sql + " ORDER BY M_Warehouse_ID, PriorityRule, M_Shipper_ID, C_BPartner_ID, C_BPartner_Location_ID, DD_Order_ID";
        }
        CPreparedStatement cPreparedStatement = null;
        try {
            cPreparedStatement = DB.prepareStatement(this.m_sql, this.get_TrxName());
            int n = 1;
            if (this.p_Selection) {
                cPreparedStatement.setInt(n++, Env.getAD_Client_ID(this.getCtx()));
                cPreparedStatement.setInt(n++, this.getAD_PInstance_ID());
            } else {
                cPreparedStatement.setInt(n++, this.p_M_Warehouse_ID);
                if (this.p_DatePromised != null) {
                    cPreparedStatement.setTimestamp(n++, this.p_DatePromised);
                }
                if (this.p_C_BPartner_ID != 0) {
                    cPreparedStatement.setInt(n++, this.p_C_BPartner_ID);
                }
            }
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, this.m_sql, exception);
        }
        return this.generate(cPreparedStatement);
    }

    private String generate(PreparedStatement preparedStatement) {
        MClient mClient = MClient.get(this.getCtx());
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object object;
                Serializable serializable;
                MStorage[] mStorageArray;
                BigDecimal bigDecimal;
                Serializable serializable2;
                MLocator mLocator;
                MDDOrderLine mDDOrderLine;
                int n;
                MDDOrder mDDOrder = new MDDOrder(this.getCtx(), resultSet, this.get_TrxName());
                if (!this.p_ConsolidateDocument || this.m_movement != null && (this.m_movement.getC_BPartner_Location_ID() != mDDOrder.getC_BPartner_Location_ID() || this.m_movement.getM_Shipper_ID() != mDDOrder.getM_Shipper_ID())) {
                    this.completeMovement();
                }
                this.log.fine("check: " + mDDOrder + " - DeliveryRule=" + mDDOrder.getDeliveryRule());
                Timestamp timestamp = this.m_movementDate;
                boolean bl = "O".equals(mDDOrder.getDeliveryRule());
                String string = " " + this.p_M_Warehouse_ID + " IN (SELECT l.M_Warehouse_ID FROM M_Locator l WHERE l.M_Locator_ID=M_Locator_ID) ";
                if (this.p_DatePromised != null) {
                    string = string + " AND (TRUNC(DatePromised)<=" + DB.TO_DATE(this.p_DatePromised, true) + " OR DatePromised IS NULL)";
                }
                if (!"F".equals(mDDOrder.getDeliveryRule())) {
                    string = string + " AND (DD_OrderLine.M_Product_ID IS NULL OR EXISTS (SELECT * FROM M_Product p WHERE DD_OrderLine.M_Product_ID=p.M_Product_ID AND IsExcludeAutoDelivery='N'))";
                }
                if (!this.p_IsUnconfirmedInOut) {
                    string = string + " AND NOT EXISTS (SELECT * FROM M_MovementLine iol INNER JOIN M_Movement io ON (iol.M_Movement_ID=io.M_Movement_ID) WHERE iol.DD_OrderLine_ID=DD_OrderLine.DD_OrderLine_ID AND io.DocStatus IN ('IP','WC'))";
                }
                MDDOrderLine[] mDDOrderLineArray = mDDOrder.getLines(string, "M_Product_ID");
                for (n = 0; n < mDDOrderLineArray.length; ++n) {
                    Serializable serializable3;
                    int n2;
                    MStorage[] mStorageArray2;
                    Object object2;
                    mDDOrderLine = mDDOrderLineArray[n];
                    mLocator = new MLocator(this.getCtx(), mDDOrderLine.getM_Locator_ID(), this.get_TrxName());
                    if (mLocator.getM_Warehouse_ID() != this.p_M_Warehouse_ID) continue;
                    this.log.fine("check: " + mDDOrderLine);
                    serializable2 = Env.ZERO;
                    bigDecimal = mDDOrderLine.getConfirmedQty();
                    mStorageArray = mDDOrderLine.getProduct();
                    if (mStorageArray != null && bigDecimal.signum() == 0 || mDDOrderLine.getC_Charge_ID() != 0 && bigDecimal.signum() == 0) continue;
                    serializable = Env.ZERO;
                    if (this.p_IsUnconfirmedInOut && mStorageArray != null && bigDecimal.signum() != 0) {
                        object = "EXISTS (SELECT * FROM M_Movement io WHERE io.M_Movement_ID=M_MovementLine.M_Movement_ID AND io.DocStatus IN ('IP','WC'))";
                        object2 = MMovementLine.getOfOrderLine(this.getCtx(), mDDOrderLine.getDD_OrderLine_ID(), (String)object, null);
                        for (int i = 0; i < ((MMovementLine[])object2).length; ++i) {
                            serializable = ((BigDecimal)serializable).add(object2[i].getMovementQty());
                        }
                        mStorageArray2 = "Unconfirmed Qty=" + serializable + " - ToDeliver=" + bigDecimal + "->";
                        bigDecimal = bigDecimal.subtract((BigDecimal)serializable);
                        mStorageArray2 = (String)mStorageArray2 + bigDecimal;
                        if (bigDecimal.signum() < 0) {
                            bigDecimal = Env.ZERO;
                            mStorageArray2 = (String)mStorageArray2 + " (set to 0)";
                        }
                        serializable2 = ((BigDecimal)serializable2).subtract((BigDecimal)serializable);
                        this.log.fine((String)mStorageArray2);
                    }
                    if (!(mStorageArray != null && mStorageArray.isStocked() || mDDOrderLine.getQtyOrdered().signum() != 0 && bigDecimal.signum() == 0)) {
                        if ("O".equals(mDDOrder.getDeliveryRule())) continue;
                        this.createLine(mDDOrder, mDDOrderLine, bigDecimal, null, false);
                        continue;
                    }
                    object = MProductCategory.get(mDDOrder.getCtx(), mStorageArray.getM_Product_Category_ID());
                    object2 = ((X_M_Product_Category)object).getMMPolicy();
                    if (object2 == null || object2.length() == 0) {
                        object2 = mClient.getMMPolicy();
                    }
                    mStorageArray2 = this.getStorages(mLocator.getM_Warehouse_ID(), mDDOrderLine.getM_Product_ID(), mDDOrderLine.getM_AttributeSetInstance_ID(), mStorageArray.getM_AttributeSet_ID(), mDDOrderLine.getM_AttributeSetInstance_ID() == 0, timestamp, "F".equals(object2));
                    for (n2 = 0; n2 < mStorageArray2.length; ++n2) {
                        serializable3 = mStorageArray2[n2];
                        serializable2 = ((BigDecimal)serializable2).add(serializable3.getQtyOnHand());
                    }
                    int n3 = n2 = ((BigDecimal)serializable2).compareTo(bigDecimal) >= 0 || bigDecimal.signum() < 0 ? 1 : 0;
                    if (bl && n2 == 0) {
                        this.log.fine("Failed CompleteOrder - OnHand=" + serializable2 + " (Unconfirmed=" + serializable + "), ToDeliver=" + bigDecimal + " - " + mDDOrderLine);
                        bl = false;
                        break;
                    }
                    if (n2 != 0 && "L".equals(mDDOrder.getDeliveryRule())) {
                        this.log.fine("CompleteLine - OnHand=" + serializable2 + " (Unconfirmed=" + serializable + ", ToDeliver=" + bigDecimal + " - " + mDDOrderLine);
                        this.createLine(mDDOrder, mDDOrderLine, bigDecimal, mStorageArray2, false);
                        continue;
                    }
                    if ("A".equals(mDDOrder.getDeliveryRule()) && (((BigDecimal)serializable2).signum() > 0 || bigDecimal.signum() < 0)) {
                        serializable3 = bigDecimal;
                        if (((BigDecimal)serializable3).compareTo((BigDecimal)serializable2) > 0) {
                            serializable3 = serializable2;
                        }
                        this.log.fine("Available - OnHand=" + serializable2 + " (Unconfirmed=" + serializable + "), ToDeliver=" + bigDecimal + ", Delivering=" + serializable3 + " - " + mDDOrderLine);
                        this.createLine(mDDOrder, mDDOrderLine, (BigDecimal)serializable3, mStorageArray2, false);
                        continue;
                    }
                    if ("F".equals(mDDOrder.getDeliveryRule())) {
                        serializable3 = bigDecimal;
                        this.log.fine("Force - OnHand=" + serializable2 + " (Unconfirmed=" + serializable + "), ToDeliver=" + bigDecimal + ", Delivering=" + serializable3 + " - " + mDDOrderLine);
                        this.createLine(mDDOrder, mDDOrderLine, (BigDecimal)serializable3, mStorageArray2, true);
                        continue;
                    }
                    if ("M".equals(mDDOrder.getDeliveryRule())) {
                        this.log.fine("Manual - OnHand=" + serializable2 + " (Unconfirmed=" + serializable + ") - " + mDDOrderLine);
                        continue;
                    }
                    this.log.fine("Failed: " + mDDOrder.getDeliveryRule() + " - OnHand=" + serializable2 + " (Unconfirmed=" + serializable + "), ToDeliver=" + bigDecimal + " - " + mDDOrderLine);
                }
                if (bl && "O".equals(mDDOrder.getDeliveryRule())) {
                    for (n = 0; n < mDDOrderLineArray.length; ++n) {
                        mDDOrderLine = mDDOrderLineArray[n];
                        mLocator = new MLocator(this.getCtx(), mDDOrderLine.getM_Locator_ID(), this.get_TrxName());
                        if (mLocator.getM_Warehouse_ID() != this.p_M_Warehouse_ID) continue;
                        serializable2 = mDDOrderLine.getProduct();
                        bigDecimal = mDDOrderLine.getQtyOrdered().subtract(mDDOrderLine.getQtyDelivered());
                        mStorageArray = null;
                        if (serializable2 != null && ((MProduct)serializable2).isStocked()) {
                            serializable = MProductCategory.get(mDDOrder.getCtx(), ((X_M_Product)serializable2).getM_Product_Category_ID());
                            object = ((X_M_Product_Category)serializable).getMMPolicy();
                            if (object == null || ((String)object).length() == 0) {
                                object = mClient.getMMPolicy();
                            }
                            mStorageArray = this.getStorages(mLocator.getM_Warehouse_ID(), mDDOrderLine.getM_Product_ID(), mDDOrderLine.getM_AttributeSetInstance_ID(), ((X_M_Product)serializable2).getM_AttributeSet_ID(), mDDOrderLine.getM_AttributeSetInstance_ID() == 0, timestamp, "F".equals(object));
                        }
                        this.createLine(mDDOrder, mDDOrderLine, bigDecimal, mStorageArray, false);
                    }
                }
                this.m_line += 1000;
            }
            resultSet.close();
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, this.m_sql, exception);
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            preparedStatement = null;
        }
        catch (Exception exception) {
            preparedStatement = null;
        }
        this.completeMovement();
        return "@Created@ = " + this.m_created;
    }

    private void createLine(MDDOrder mDDOrder, MDDOrderLine mDDOrderLine, BigDecimal bigDecimal, MStorage[] mStorageArray, boolean bl) {
        boolean bl2;
        Serializable serializable;
        PO pO;
        if (this.m_lastC_BPartner_Location_ID != mDDOrder.getC_BPartner_Location_ID()) {
            this.completeMovement();
        }
        this.m_lastC_BPartner_Location_ID = mDDOrder.getC_BPartner_Location_ID();
        if (this.m_movement == null) {
            int n;
            pO = MLocator.get(this.getCtx(), mDDOrderLine.getM_Locator_ID());
            this.m_movement = MovementGenerate.createMovement(mDDOrder, this.m_movementDate);
            this.m_movement.setAD_Org_ID(pO.getAD_Org_ID());
            this.m_movement.setIsInTransit(true);
            this.m_movement.setDD_Order_ID(mDDOrder.getDD_Order_ID());
            if (mDDOrder.getC_BPartner_ID() != mDDOrder.getC_BPartner_ID()) {
                this.m_movement.setC_BPartner_ID(mDDOrder.getC_BPartner_ID());
            }
            if (mDDOrder.getC_BPartner_Location_ID() != mDDOrder.getC_BPartner_Location_ID()) {
                this.m_movement.setC_BPartner_Location_ID(mDDOrder.getC_BPartner_Location_ID());
            }
            if ((n = this.getDocType("MMM", this.m_movement.getAD_Org_ID())) > 0) {
                this.m_movement.setC_DocType_ID(n);
            }
            if (!this.m_movement.save()) {
                throw new IllegalStateException("Could not create Movement");
            }
        }
        if (mStorageArray == null) {
            pO = new MMovementLine(this.m_movement);
            ((MMovementLine)pO).setOrderLine(mDDOrderLine, Env.ZERO, false);
            ((MMovementLine)pO).setMovementQty(bigDecimal);
            if (mDDOrderLine.getQtyEntered().compareTo(mDDOrderLine.getQtyOrdered()) != 0) {
                ((MMovementLine)pO).setMovementQty(bigDecimal.multiply(mDDOrderLine.getQtyEntered()).divide(mDDOrderLine.getQtyOrdered(), 12, 4));
            }
            ((X_M_MovementLine)pO).setLine(this.m_line + mDDOrderLine.getLine());
            if (!pO.save()) {
                throw new IllegalStateException("Could not create Shipment Line");
            }
            this.log.fine(((MMovementLine)pO).toString());
            return;
        }
        pO = mDDOrderLine.getProduct();
        boolean bl3 = false;
        if (((X_M_Product)pO).getM_AttributeSet_ID() != 0) {
            serializable = MAttributeSet.get(this.getCtx(), ((X_M_Product)pO).getM_AttributeSet_ID());
            bl2 = ((X_M_AttributeSet)serializable).isInstanceAttribute();
        }
        serializable = new ArrayList();
        BigDecimal bigDecimal2 = bigDecimal;
        for (int i = 0; i < mStorageArray.length; ++i) {
            BigDecimal bigDecimal3 = bigDecimal2;
            MStorage mStorage = mStorageArray[i];
            if (bigDecimal3.compareTo(mStorage.getQtyOnHand()) > 0 && mStorage.getQtyOnHand().signum() >= 0 && (!bl || bl && i + 1 != mStorageArray.length)) {
                bigDecimal3 = mStorage.getQtyOnHand();
            }
            if (bigDecimal3.signum() == 0) continue;
            int n = mStorage.getM_Locator_ID();
            X_M_MovementLine x_M_MovementLine = null;
            if (!bl2) {
                for (int j = 0; j < ((ArrayList)serializable).size(); ++j) {
                    MMovementLine mMovementLine = (MMovementLine)((ArrayList)serializable).get(j);
                    if (mMovementLine.getM_Locator_ID() != n) continue;
                    x_M_MovementLine = mMovementLine;
                    break;
                }
            }
            if (x_M_MovementLine == null) {
                x_M_MovementLine = new MMovementLine(this.m_movement);
                ((MMovementLine)x_M_MovementLine).setOrderLine(mDDOrderLine, bigDecimal3, false);
                ((MMovementLine)x_M_MovementLine).setMovementQty(bigDecimal3);
                ((ArrayList)serializable).add(x_M_MovementLine);
            } else {
                ((MMovementLine)x_M_MovementLine).setMovementQty(x_M_MovementLine.getMovementQty().add(bigDecimal3));
            }
            if (mDDOrderLine.getQtyEntered().compareTo(mDDOrderLine.getQtyOrdered()) != 0) {
                ((MMovementLine)x_M_MovementLine).setMovementQty(x_M_MovementLine.getMovementQty().multiply(mDDOrderLine.getQtyEntered()).divide(mDDOrderLine.getQtyOrdered(), 12, 4));
            }
            x_M_MovementLine.setLine(this.m_line + mDDOrderLine.getLine());
            if (bl2) {
                x_M_MovementLine.setM_AttributeSetInstance_ID(mStorage.getM_AttributeSetInstance_ID());
            }
            if (!x_M_MovementLine.save()) {
                throw new IllegalStateException("Could not create Shipment Line");
            }
            this.log.fine("ToDeliver=" + bigDecimal + "/" + bigDecimal3 + " - " + x_M_MovementLine);
            bigDecimal2 = bigDecimal2.subtract(bigDecimal3);
            mStorage.setQtyOnHand(mStorage.getQtyOnHand().subtract(bigDecimal3));
            if (bigDecimal2.signum() == 0) break;
        }
        if (bigDecimal2.signum() != 0) {
            throw new IllegalStateException("Not All Delivered - Remainder=" + bigDecimal2);
        }
    }

    private static MMovement createMovement(MDDOrder mDDOrder, Timestamp timestamp) {
        MMovement mMovement = new MMovement(mDDOrder.getCtx(), 0, mDDOrder.get_TrxName());
        mMovement.setC_BPartner_ID(mDDOrder.getC_BPartner_ID());
        mMovement.setC_BPartner_Location_ID(mDDOrder.getC_BPartner_Location_ID());
        mMovement.setAD_User_ID(mDDOrder.getAD_User_ID());
        if (timestamp != null) {
            mMovement.setMovementDate(timestamp);
        }
        mMovement.setDD_Order_ID(mDDOrder.getC_Order_ID());
        mMovement.setDeliveryRule(mDDOrder.getDeliveryRule());
        mMovement.setDeliveryViaRule(mDDOrder.getDeliveryViaRule());
        mMovement.setM_Shipper_ID(mDDOrder.getM_Shipper_ID());
        mMovement.setFreightCostRule(mDDOrder.getFreightCostRule());
        mMovement.setFreightAmt(mDDOrder.getFreightAmt());
        mMovement.setSalesRep_ID(mDDOrder.getSalesRep_ID());
        mMovement.setC_Activity_ID(mDDOrder.getC_Activity_ID());
        mMovement.setC_Campaign_ID(mDDOrder.getC_Campaign_ID());
        mMovement.setC_Charge_ID(mDDOrder.getC_Charge_ID());
        mMovement.setChargeAmt(mDDOrder.getChargeAmt());
        mMovement.setC_Project_ID(mDDOrder.getC_Project_ID());
        mMovement.setDescription(mDDOrder.getDescription());
        mMovement.setSalesRep_ID(mDDOrder.getSalesRep_ID());
        mMovement.setAD_OrgTrx_ID(mDDOrder.getAD_OrgTrx_ID());
        mMovement.setUser1_ID(mDDOrder.getUser1_ID());
        mMovement.setUser2_ID(mDDOrder.getUser2_ID());
        mMovement.setPriorityRule(mDDOrder.getPriorityRule());
        return mMovement;
    }

    private int getDocType(String string, int n) {
        MDocType[] mDocTypeArray = MDocType.getOfDocBaseType(this.getCtx(), string);
        if (mDocTypeArray == null || mDocTypeArray.length == 0) {
            String string2 = "Not found default document type for docbasetype " + string;
            throw new AdempiereException(string2);
        }
        for (MDocType mDocType : mDocTypeArray) {
            if (mDocType.getAD_Org_ID() != n) continue;
            return mDocType.getC_DocType_ID();
        }
        this.log.info("Doc Type for " + string + ": " + mDocTypeArray[0].getC_DocType_ID());
        return mDocTypeArray[0].getC_DocType_ID();
    }

    private MStorage[] getStorages(int n, int n2, int n3, int n4, boolean bl, Timestamp timestamp, boolean bl2) {
        this.m_lastPP = new SParameter(n, n2, n3, n4, bl, timestamp, bl2);
        this.m_lastStorages = this.m_map.get(this.m_lastPP);
        if (this.m_lastStorages == null) {
            this.m_lastStorages = MStorage.getWarehouse(this.getCtx(), n, n2, n3, n4, bl, timestamp, bl2, this.get_TrxName());
            this.m_map.put(this.m_lastPP, this.m_lastStorages);
        }
        return this.m_lastStorages;
    }

    private void completeMovement() {
        if (this.m_movement != null) {
            if (!this.m_movement.processIt(this.p_docAction)) {
                this.log.warning("Failed: " + this.m_movement);
            }
            this.m_movement.saveEx();
            this.addLog(this.m_movement.getM_Movement_ID(), this.m_movement.getMovementDate(), null, this.m_movement.getDocumentNo());
            ++this.m_created;
            this.m_map = new HashMap();
            if (this.m_lastPP != null && this.m_lastStorages != null) {
                this.m_map.put(this.m_lastPP, this.m_lastStorages);
            }
        }
        this.m_movement = null;
        this.m_line = 0;
    }

    class SParameter {
        public int M_Warehouse_ID;
        public int M_Product_ID;
        public int M_AttributeSetInstance_ID;
        public int M_AttributeSet_ID;
        public boolean allAttributeInstances;
        public Timestamp minGuaranteeDate;
        public boolean FiFo;

        protected SParameter(int n, int n2, int n3, int n4, boolean bl, Timestamp timestamp, boolean bl2) {
            this.M_Warehouse_ID = n;
            this.M_Product_ID = n2;
            this.M_AttributeSetInstance_ID = n3;
            this.M_AttributeSet_ID = n4;
            this.allAttributeInstances = bl;
            this.minGuaranteeDate = timestamp;
            this.FiFo = bl2;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof SParameter) {
                boolean bl;
                SParameter sParameter = (SParameter)object;
                boolean bl2 = bl = sParameter.M_Warehouse_ID == this.M_Warehouse_ID && sParameter.M_Product_ID == this.M_Product_ID && sParameter.M_AttributeSetInstance_ID == this.M_AttributeSetInstance_ID && sParameter.M_AttributeSet_ID == this.M_AttributeSet_ID && sParameter.allAttributeInstances == this.allAttributeInstances && sParameter.FiFo == this.FiFo;
                if (!(!bl || sParameter.minGuaranteeDate == null && this.minGuaranteeDate == null || sParameter.minGuaranteeDate != null && this.minGuaranteeDate != null && sParameter.minGuaranteeDate.equals(this.minGuaranteeDate))) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            long l = this.M_Warehouse_ID + this.M_Product_ID * 2 + this.M_AttributeSetInstance_ID * 3 + this.M_AttributeSet_ID * 4;
            if (this.allAttributeInstances) {
                l *= -1L;
            }
            if (this.FiFo) {
                // empty if block
            }
            if ((l *= -2L) < 0L) {
                l = -l + 7L;
            }
            while (l > Integer.MAX_VALUE) {
                l -= Integer.MAX_VALUE;
            }
            if (this.minGuaranteeDate != null) {
                l += (long)this.minGuaranteeDate.hashCode();
                while (l > Integer.MAX_VALUE) {
                    l -= Integer.MAX_VALUE;
                }
            }
            return (int)l;
        }
    }
}

