/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrg;
import org.compiere.model.MResource;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MPPMRP;

public class MRPUpdate
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_S_Resource_ID = 0;
    private int p_M_Warehouse_ID = 0;

    @Override
    protected void prepare() {
        this.m_AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (string.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("S_Resource_ID")) {
                this.p_S_Resource_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        List list;
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer("ManufacturingResourceType=? AND AD_Client_ID=?");
        arrayList.add("PT");
        arrayList.add(this.m_AD_Client_ID);
        if (this.p_S_Resource_ID > 0) {
            stringBuffer.append(" AND S_Resource_ID=?");
            arrayList.add(this.p_S_Resource_ID);
        }
        if ((list = new Query(this.getCtx(), "S_Resource", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).list()).size() == 0) {
            throw new AdempiereException("No plants found");
        }
        for (MResource mResource : list) {
            this.log.info("Run MRP to Plant: " + mResource.getName());
            arrayList = new ArrayList();
            stringBuffer = new StringBuffer("AD_Client_ID=?");
            arrayList.add(this.m_AD_Client_ID);
            if (this.p_AD_Org_ID > 0) {
                stringBuffer.append(" AND AD_Org_ID=?");
                arrayList.add(this.p_AD_Org_ID);
            }
            List list2 = new Query(this.getCtx(), "AD_Org", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).list();
            for (MOrg mOrg : list2) {
                this.log.info("Run MRP to Organization: " + mOrg.getName());
                if (this.p_M_Warehouse_ID == 0) {
                    MWarehouse[] mWarehouseArray;
                    for (MWarehouse mWarehouse : mWarehouseArray = MWarehouse.getForOrg(this.getCtx(), mOrg.getAD_Org_ID())) {
                        this.log.info("Run MRP to Wharehouse: " + mWarehouse.getName());
                        this.deleteRecords(this.m_AD_Client_ID, mOrg.getAD_Org_ID(), mResource.getS_Resource_ID(), mWarehouse.getM_Warehouse_ID());
                        this.createRecords(this.m_AD_Client_ID, mOrg.getAD_Org_ID(), mResource.getS_Resource_ID(), mWarehouse.getM_Warehouse_ID());
                        string = string + "<br>finish MRP to Warehouse " + mWarehouse.getName();
                    }
                } else {
                    this.log.info("Run MRP to Wharehouse: " + this.p_M_Warehouse_ID);
                    this.deleteRecords(this.m_AD_Client_ID, mOrg.getAD_Org_ID(), mResource.getS_Resource_ID(), this.p_M_Warehouse_ID);
                    this.createRecords(this.m_AD_Client_ID, mOrg.getAD_Org_ID(), mResource.getS_Resource_ID(), this.p_M_Warehouse_ID);
                }
                string = string + "<br>finish MRP to Organization " + mOrg.getName();
            }
            string = string + "<br>finish MRP to Plant " + mResource.getName();
        }
        if (Util.isEmpty(string, true)) {
            return "No records found";
        }
        return Msg.getMsg(this.getCtx(), "ProcessOK");
    }

    private void deleteRecords(int n, int n2, int n3, int n4) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n);
        arrayList.add(n2);
        arrayList.add(n4);
        String string = "OrderType IN ('FCT','POR', 'SOO', 'POO') AND AD_Client_ID=? AND AD_Org_ID=? AND M_Warehouse_ID=?";
        this.executeUpdate("DELETE FROM PP_MRP WHERE " + string, arrayList);
        string = "DocStatus IN ('DR','CL') AND AD_Client_ID=? AND AD_Org_ID=? AND M_Warehouse_ID=?";
        this.deletePO("M_Requisition", string, arrayList);
        string = "DocStatus IN ('DR') AND AD_Client_ID=? AND AD_Org_ID=? AND M_Warehouse_ID=?";
        this.deletePO("DD_Order", string, arrayList);
        arrayList = new ArrayList();
        arrayList.add(n);
        arrayList.add(n2);
        arrayList.add(n3);
        arrayList.add(n4);
        string = "OrderType IN ('MOP','DOO') AND AD_Client_ID=? AND AD_Org_ID=? AND S_Resource_ID= ? AND M_Warehouse_ID=?";
        this.executeUpdate("DELETE FROM PP_MRP WHERE " + string, arrayList);
        string = "DocStatus='DR' AND AD_Client_ID=? AND AD_Org_ID=? AND S_Resource_ID= ? AND M_Warehouse_ID=?";
        this.deletePO("PP_Order", string, arrayList);
        arrayList = new ArrayList();
        arrayList.add(n);
        arrayList.add(n2);
        string = "AD_Table_ID=" + MPPMRP.Table_ID + " AND AD_Client_ID=? AND AD_Org_ID=?";
        this.executeUpdate("DELETE FROM AD_Note WHERE " + string, arrayList);
    }

    private void createRecords(int n, int n2, int n3, int n4) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n);
        arrayList.add(n2);
        arrayList.add(n4);
        String string = " SELECT t.ad_org_id,t.created, t.createdby , t.datepromised,t.datepromised, t.datepromised, t.datepromised, f.Name,'IP', t.isactive , t.m_forecastline_id, t.m_forecast_id, null, null,null, null,null, null,t.m_product_id, t.m_warehouse_id,nextidfunc(53040,'N'), null ,t.qty,  'D', 'FCT', t.updated, t.updatedby, f.Name,t.ad_client_id , null as S_Resource_ID, null as C_BPartner_ID  FROM M_ForecastLine t  INNER JOIN M_Forecast f ON (f.M_Forecast_ID=t.M_Forecast_ID)  WHERE t.Qty > 0 AND t.AD_Client_ID=? AND t.AD_Org_ID=? AND t.M_Warehouse_ID= ?";
        this.executeUpdate("INSERT INTO PP_MRP (ad_org_id, created, createdby , dateordered,datepromised, datestart, datestartschedule, description,docstatus, isactive , m_forecastline_id, m_forecast_id,pp_order_id, pp_order_bomline_id,c_order_id, c_orderline_id,m_requisition_id, m_requisitionline_id,m_product_id, m_warehouse_id, pp_mrp_id, planner_id, qty, typemrp, ordertype, updated, updatedby, value, ad_client_id, s_resource_id, c_bpartner_id )" + string, arrayList);
        string = " SELECT t.ad_org_id,t.created, t.createdby , t.datepromised,t.datepromised, t.datepromised, t.datepromised, o.DocumentNo,o.DocStatus, o.isactive ,  null, null,  null, null,  t.c_order_id, t.c_orderline_id,  null, null, t.m_product_id, t.m_warehouse_id,nextidfunc(53040,'N'), null ,t.QtyOrdered-t.QtyDelivered,  (case when o.IsSOTrx='Y' then 'D' else 'S' end) , (case when o.IsSOTrx='Y' then 'SOO' else 'POO' end), t.updated, t.updatedby, o.DocumentNo,t.ad_client_id , null as S_Resource_ID, o.C_BPartner_ID FROM C_OrderLine t INNER JOIN C_Order o  ON (o.c_order_id=t.c_order_id) WHERE  (t.QtyOrdered - t.QtyDelivered) <> 0 AND o.DocStatus IN ('IP','CO') AND t.AD_Client_ID=? AND t.AD_Org_ID=? AND t.M_Warehouse_ID= ?";
        this.executeUpdate("INSERT INTO PP_MRP (ad_org_id, created, createdby , dateordered,datepromised, datestart, datestartschedule, description,docstatus, isactive , m_forecastline_id, m_forecast_id,pp_order_id, pp_order_bomline_id,c_order_id, c_orderline_id,m_requisition_id, m_requisitionline_id,m_product_id, m_warehouse_id, pp_mrp_id, planner_id, qty, typemrp, ordertype, updated, updatedby, value, ad_client_id, s_resource_id, c_bpartner_id )" + string, arrayList);
        string = " SELECT rl.ad_org_id,rl.created, rl.createdby , t.daterequired, t.daterequired,  t.daterequired,  t.daterequired, t.DocumentNo,t.DocStatus, t.isactive ,  null, null,  null, null,  null, null, rl.m_requisition_id, rl.m_requisitionline_id, rl.m_product_id, t.m_warehouse_id,nextidfunc(53040,'N'), null ,rl.Qty, 'S', 'POR', rl.updated, rl.updatedby, t.DocumentNo,rl.ad_client_id , null as S_Resource_ID, null as C_BPartner_ID  FROM M_RequisitionLine rl INNER JOIN M_Requisition t ON (rl.m_requisition_id=t.m_requisition_id) WHERE rl.Qty > 0 AND t.DocStatus IN ('DR','IN') AND t.AD_Client_ID=? AND t.AD_Org_ID=? AND t.M_Warehouse_ID= ?";
        this.executeUpdate("INSERT INTO PP_MRP (ad_org_id, created, createdby , dateordered,datepromised, datestart, datestartschedule, description,docstatus, isactive , m_forecastline_id, m_forecast_id,pp_order_id, pp_order_bomline_id,c_order_id, c_orderline_id,m_requisition_id, m_requisitionline_id,m_product_id, m_warehouse_id, pp_mrp_id, planner_id, qty, typemrp, ordertype, updated, updatedby, value, ad_client_id, s_resource_id, c_bpartner_id )" + string, arrayList);
        arrayList = new ArrayList();
        arrayList.add(n);
        arrayList.add(n2);
        arrayList.add(n3);
        arrayList.add(n4);
        string = " SELECT t.ad_org_id,t.created, t.createdby , t.datepromised,t.datepromised, t.datepromised, t.datepromised, t.DocumentNo,t.DocStatus, t.isactive ,  null, null, t.pp_order_id, null, null, null,  null, null, t.m_product_id, t.m_warehouse_id,nextidfunc(53040,'N'), null ,t.QtyOrdered-t.QtyDelivered,  'S', 'MOP', t.updated, t.updatedby, t.DocumentNo,t.ad_client_id, t.S_Resource_ID, null as C_BPartner_ID  FROM PP_Order t  WHERE (t.QtyOrdered - t.QtyDelivered) <> 0 AND t.DocStatus IN ('DR','IP','CO') AND t.AD_Client_ID=? AND t.AD_Org_ID=? AND t.S_Resource_ID=? AND t.M_Warehouse_ID= ?";
        this.executeUpdate("INSERT INTO PP_MRP (ad_org_id, created, createdby , dateordered,datepromised, datestart, datestartschedule, description,docstatus, isactive , m_forecastline_id, m_forecast_id,pp_order_id, pp_order_bomline_id,c_order_id, c_orderline_id,m_requisition_id, m_requisitionline_id,m_product_id, m_warehouse_id, pp_mrp_id, planner_id, qty, typemrp, ordertype, updated, updatedby, value, ad_client_id, s_resource_id, c_bpartner_id )" + string, arrayList);
        string = " SELECT t.ad_org_id,t.created, t.createdby , o.datepromised,o.datepromised, o.datepromised, o.datepromised, o.DocumentNo,o.DocStatus, o.isactive ,  null, null, t.pp_order_id, t.pp_order_bomline_id, null, null,  null, null, t.m_product_id, t.m_warehouse_id,nextidfunc(53040,'N'), null ,t.QtyRequiered-t.QtyDelivered,  'D', 'MOP', t.updated, t.updatedby, o.DocumentNo,t.ad_client_id, o.S_Resource_ID, null as C_BPartner_ID  FROM PP_Order_BOMLine t  INNER JOIN PP_Order o ON (o.pp_order_id=t.pp_order_id) WHERE  (t.QtyRequiered-t.QtyDelivered) <> 0 AND o.DocStatus IN ('DR','IP','CO') AND t.AD_Client_ID=? AND t.AD_Org_ID=? AND o.S_Resource_ID=? AND t.M_Warehouse_ID= ?";
        this.executeUpdate("INSERT INTO PP_MRP (ad_org_id, created, createdby , dateordered,datepromised, datestart, datestartschedule, description,docstatus, isactive , m_forecastline_id, m_forecast_id,pp_order_id, pp_order_bomline_id,c_order_id, c_orderline_id,m_requisition_id, m_requisitionline_id,m_product_id, m_warehouse_id, pp_mrp_id, planner_id, qty, typemrp, ordertype, updated, updatedby, value, ad_client_id, s_resource_id, c_bpartner_id )" + string, arrayList);
    }

    private void executeUpdate(String string, List<Object> list) throws SQLException {
        Object[] objectArray = null;
        objectArray = list != null ? list.toArray(new Object[list.size()]) : new Object[]{};
        int n = DB.executeUpdateEx(string, objectArray, this.get_TrxName());
        this.commitEx();
        this.log.fine("#" + n + " -- " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePO(String string, String string2, List<Object> list) throws SQLException {
        POResultSet pOResultSet = new Query(this.getCtx(), string, string2, this.get_TrxName()).setParameters(list).scroll();
        try {
            while (pOResultSet.hasNext()) {
                ((PO)pOResultSet.next()).deleteEx(true);
                this.commitEx();
            }
        }
        finally {
            pOResultSet.close();
        }
    }
}

