/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMessage;
import org.compiere.model.MNote;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MResource;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.model.X_C_BPartner;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.I_PP_Product_Planning;
import org.eevolution.model.MDDNetworkDistribution;
import org.eevolution.model.MDDNetworkDistributionLine;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.model.X_DD_Order;

public class MRP
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_S_Resource_ID = 0;
    private int p_M_Warehouse_ID = 0;
    private boolean p_IsRequiredDRP = false;
    private int p_Planner_ID = 0;
    private String p_Version = "1";
    protected int p_M_Product_ID = 0;
    private MPPProductPlanning m_product_planning = null;
    private BigDecimal QtyProjectOnHand = Env.ZERO;
    private BigDecimal QtyGrossReqs = Env.ZERO;
    private BigDecimal QtyScheduledReceipts = Env.ZERO;
    private Timestamp DatePromisedFrom = null;
    private Timestamp DatePromisedTo = null;
    private Timestamp Today = new Timestamp(System.currentTimeMillis());
    private Timestamp TimeFence = null;
    private Timestamp Planning_Horizon = null;
    private int docTypeReq_ID = 0;
    private int docTypeMO_ID = 0;
    private int docTypeMF_ID = 0;
    private int docTypeDO_ID = 0;
    private int count_MO = 0;
    private int count_MR = 0;
    private int count_DO = 0;
    private int count_Msg = 0;
    private static CCache<String, Integer> dd_order_id_cache = new CCache("DD_Order_ID", 50);
    private static CCache<Integer, MBPartner> partner_cache = new CCache("C_BPartner", 50);

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (string.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("S_Resource_ID")) {
                this.p_S_Resource_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("IsRequiredDRP")) {
                this.p_IsRequiredDRP = processInfoParameterArray[i].getParameterAsBoolean();
                continue;
            }
            if (string.equals("Version")) {
                this.p_Version = (String)processInfoParameterArray[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    public int getAD_Org_ID() {
        return this.p_AD_Org_ID;
    }

    public int getPlant_ID() {
        return this.p_S_Resource_ID;
    }

    public int getM_Warehouse_ID() {
        return this.p_M_Warehouse_ID;
    }

    public boolean isRequiredDRP() {
        return this.p_IsRequiredDRP;
    }

    public int getPlanner_ID() {
        if (this.p_Planner_ID <= 0) {
            this.p_Planner_ID = Env.getAD_User_ID(this.getCtx());
        }
        return this.p_Planner_ID;
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        dd_order_id_cache.clear();
        partner_cache.clear();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer2 = new StringBuffer("ManufacturingResourceType=? AND AD_Client_ID=?");
        arrayList.add("PT");
        arrayList.add(this.getAD_Client_ID());
        if (this.getPlant_ID() > 0) {
            stringBuffer2.append(" AND S_Resource_ID=?");
            arrayList.add(this.getPlant_ID());
        }
        List list = new Query(this.getCtx(), "S_Resource", stringBuffer2.toString(), this.get_TrxName()).setParameters(arrayList).list();
        for (MResource mResource : list) {
            this.log.info("Run MRP to Plant: " + mResource.getName());
            this.Planning_Horizon = TimeUtil.addDays(this.getToday(), mResource.getPlanningHorizon());
            arrayList = new ArrayList();
            stringBuffer2 = new StringBuffer("AD_Client_ID=?");
            arrayList.add(this.getAD_Client_ID());
            if (this.getAD_Org_ID() > 0) {
                stringBuffer2.append(" AND AD_Org_ID=?");
                arrayList.add(this.getAD_Org_ID());
            }
            List list2 = new Query(this.getCtx(), "AD_Org", stringBuffer2.toString(), this.get_TrxName()).setParameters(arrayList).list();
            for (MOrg mOrg : list2) {
                this.docTypeReq_ID = this.getDocType("POR", mOrg.getAD_Org_ID());
                this.docTypeMO_ID = this.getDocType("MOP", mOrg.getAD_Org_ID());
                this.docTypeMF_ID = this.getDocType("MOF", mOrg.getAD_Org_ID());
                this.docTypeDO_ID = this.getDocType("DOO", mOrg.getAD_Org_ID());
                this.log.info("Run MRP to Organization: " + mOrg.getName());
                MWarehouse[] mWarehouseArray = this.getM_Warehouse_ID() <= 0 ? MWarehouse.getForOrg(this.getCtx(), mOrg.getAD_Org_ID()) : new MWarehouse[]{MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID())};
                for (MWarehouse mWarehouse : mWarehouseArray) {
                    if (mResource.getM_Warehouse_ID() == mWarehouse.getM_Warehouse_ID() && this.isRequiredDRP()) continue;
                    this.log.info("Run MRP to Wharehouse: " + mWarehouse.getName());
                    this.runMRP(this.getAD_Client_ID(), mOrg.getAD_Org_ID(), mResource.getS_Resource_ID(), mWarehouse.getM_Warehouse_ID());
                    stringBuffer.append("<br>finish MRP to Warehouse " + mWarehouse.getName());
                }
                stringBuffer.append("<br>finish MRP to Organization " + mOrg.getName());
            }
            stringBuffer.append("<br> " + Msg.translate(this.getCtx(), "Created"));
            stringBuffer.append("<br> ");
            stringBuffer.append("<br> " + Msg.translate(this.getCtx(), "PP_Order_ID") + ":" + this.count_MO);
            stringBuffer.append("<br> " + Msg.translate(this.getCtx(), "DD_Order_ID") + ":" + this.count_DO);
            stringBuffer.append("<br> " + Msg.translate(this.getCtx(), "M_Requisition_ID") + ":" + this.count_MR);
            stringBuffer.append("<br> " + Msg.translate(this.getCtx(), "AD_Note_ID") + ":" + this.count_Msg);
            stringBuffer.append("<br>finish MRP to Plant " + mResource.getName());
        }
        return stringBuffer.toString();
    }

    protected void deleteMRP(int n, int n2, int n3, int n4) throws SQLException {
        String string = "DELETE FROM PP_MRP WHERE OrderType = 'MOP' AND DocStatus ='CL' AND AD_Client_ID=" + n + " AND AD_Org_ID=" + n2 + " AND M_Warehouse_ID=" + n4 + " AND S_Resource_ID=" + n3;
        DB.executeUpdateEx(string, this.get_TrxName());
        this.commitEx();
        String string2 = "DocStatus='DR' AND AD_Client_ID=? AND AD_Org_ID=? AND M_Warehouse_ID=? AND S_Resource_ID=?";
        this.deletePO("PP_Order", string2, new Object[]{n, n2, n4, n3});
        string = "DELETE FROM PP_MRP WHERE OrderType = 'POR' AND DocStatus IN ('CL') AND AD_Client_ID = " + n + " AND AD_Org_ID=" + n2 + " AND M_Warehouse_ID=" + n4;
        DB.executeUpdateEx(string, this.get_TrxName());
        this.commitEx();
        string2 = "DocStatus IN ('DR') AND AD_Client_ID=? AND AD_Org_ID=? AND M_Warehouse_ID=?";
        this.deletePO("M_Requisition", string2, new Object[]{n, n2, n4});
        string = "DELETE FROM AD_Note WHERE AD_Table_ID=? AND AD_Client_ID=? AND AD_Org_ID=?";
        DB.executeUpdateEx(string, new Object[]{MPPMRP.Table_ID, n, n2}, this.get_TrxName());
        this.commitEx();
        if (this.isRequiredDRP()) {
            string2 = "DocStatus='DR' AND AD_Client_ID=? AND AD_Org_ID=? AND EXISTS (SELECT 1 FROM PP_MRP mrp WHERE  mrp.DD_Order_ID=DD_Order.DD_Order_ID AND mrp.S_Resource_ID=? ) AND EXISTS (SELECT 1 FROM DD_OrderLine ol INNER JOIN  M_Locator l ON (l.M_Locator_ID=ol.M_LocatorTo_ID)  WHERE ol.DD_Order_ID=DD_Order.DD_Order_ID AND l.M_Warehouse_ID=?)";
            this.deletePO("DD_Order", string2, new Object[]{n, n2, n3, n4});
        }
        DB.executeUpdateEx("UPDATE PP_MRP SET IsAvailable ='Y' WHERE TypeMRP = 'S' AND AD_Client_ID = ? AND AD_Org_ID=? AND M_Warehouse_ID=?", new Object[]{n, n2, n4}, this.get_TrxName());
        this.commitEx();
    }

    protected String runMRP(int n, int n2, int n3, int n4) throws SQLException {
        this.deleteMRP(n, n2, n3, n4);
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            PO pO = null;
            int n5 = 0;
            Timestamp timestamp = null;
            Timestamp timestamp2 = null;
            int n6 = MPPMRP.getMaxLowLevel(this.getCtx(), this.get_TrxName());
            this.log.info("Low Level Is :" + n6);
            for (int i = 0; i <= n6; ++i) {
                this.log.info("Current Level Is :" + i);
                String string = "SELECT mrp.M_Product_ID, mrp.LowLevel, mrp.Qty, mrp.DatePromised, mrp.TypeMRP, mrp.OrderType, mrp.DateOrdered, mrp.M_Warehouse_ID, mrp.PP_MRP_ID, mrp.DateStartSchedule, mrp.DateFinishSchedule FROM RV_PP_MRP mrp WHERE mrp.TypeMRP=? AND mrp.AD_Client_ID=? AND mrp.AD_Org_ID=?  AND mrp.M_Warehouse_ID=? AND mrp.DatePromised<=? AND COALESCE(mrp.LowLevel,0)=? " + (this.p_M_Product_ID > 0 ? " AND mrp.M_Product_ID=" + this.p_M_Product_ID : "") + " ORDER BY  mrp.M_Product_ID , mrp.DatePromised";
                cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
                cPreparedStatement.setString(1, "D");
                cPreparedStatement.setInt(2, n);
                cPreparedStatement.setInt(3, n2);
                cPreparedStatement.setInt(4, n4);
                cPreparedStatement.setTimestamp(5, this.Planning_Horizon);
                cPreparedStatement.setInt(6, i);
                resultSet = cPreparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n7 = resultSet.getInt("PP_MRP_ID");
                    String string2 = resultSet.getString("TypeMRP");
                    String string3 = resultSet.getString("OrderType");
                    Timestamp timestamp3 = resultSet.getTimestamp("DatePromised");
                    Timestamp timestamp4 = resultSet.getTimestamp("DateStartSchedule");
                    BigDecimal bigDecimal = resultSet.getBigDecimal("Qty");
                    int n8 = resultSet.getInt("M_Product_ID");
                    if ("D".equals(string2) && "FCT".equals(string3) && timestamp3.compareTo(this.getToday()) <= 0) continue;
                    if (pO == null || pO.get_ID() != n8) {
                        if (this.QtyGrossReqs.signum() != 0) {
                            if (pO == null) {
                                throw new IllegalStateException("MRP Internal Error: QtyGrossReqs=" + this.QtyGrossReqs + " and we do not have previous demand defined");
                            }
                            if ("POQ".equals(this.m_product_planning.getOrder_Policy()) && timestamp2.compareTo(this.Planning_Horizon) < 0) {
                                timestamp = timestamp2;
                                this.calculatePlan(n, n2, n4, n5, (MProduct)pO, timestamp);
                            } else if ("LFL".equals(this.m_product_planning.getOrder_Policy()) && timestamp.compareTo(this.Planning_Horizon) <= 0) {
                                this.calculatePlan(n, n2, n4, n5, (MProduct)pO, timestamp);
                            }
                            this.QtyGrossReqs = Env.ZERO;
                        }
                        pO = MProduct.get(this.getCtx(), n8);
                        this.log.info("Calculte Plan to this Product:" + pO);
                        this.setProduct(n, n2, n3, n4, (MProduct)pO);
                        if (this.m_product_planning == null) continue;
                        if ("POQ".equals(this.m_product_planning.getOrder_Policy())) {
                            this.DatePromisedFrom = timestamp3;
                            this.DatePromisedTo = TimeUtil.addDays(timestamp3, this.m_product_planning.getOrder_Period().intValueExact());
                            timestamp2 = timestamp3;
                        }
                    }
                    if (this.m_product_planning == null) continue;
                    if (timestamp3.compareTo(this.getToday()) < 0) {
                        String string4 = Msg.translate(this.getCtx(), "DatePromised") + ": " + timestamp3;
                        this.createMRPNote("MRP-150", n2, n7, (MProduct)pO, MPPMRP.getDocumentNo(n7), bigDecimal, string4);
                    }
                    n5 = n7;
                    if ("POQ".equals(this.m_product_planning.getOrder_Policy())) {
                        if (this.DatePromisedTo != null && timestamp3.compareTo(this.DatePromisedTo) < 0) {
                            this.QtyGrossReqs = this.QtyGrossReqs.add(bigDecimal);
                            this.log.info("Accumulation   QtyGrossReqs:" + this.QtyGrossReqs);
                            this.log.info("DatePromised:" + timestamp3);
                            this.log.info("DatePromisedTo:" + this.DatePromisedTo);
                            continue;
                        }
                        timestamp = timestamp2;
                        this.QtyGrossReqs = this.QtyGrossReqs.add(bigDecimal);
                        this.calculatePlan(n, n2, n4, n7, (MProduct)pO, timestamp);
                        this.DatePromisedFrom = timestamp3;
                        this.DatePromisedTo = TimeUtil.addDays(timestamp3, this.m_product_planning.getOrder_Period().intValueExact());
                        timestamp2 = i == 0 ? timestamp3 : timestamp4;
                        continue;
                    }
                    if (!"LFL".equals(this.m_product_planning.getOrder_Policy())) continue;
                    this.QtyGrossReqs = this.QtyGrossReqs.add(bigDecimal);
                    timestamp = timestamp3;
                    this.calculatePlan(n, n2, n4, n7, (MProduct)pO, timestamp);
                }
                if (this.QtyGrossReqs.signum() != 0 && pO != null) {
                    if ("POQ".equals(this.m_product_planning.getOrder_Policy()) && timestamp2.compareTo(this.Planning_Horizon) < 0) {
                        timestamp = timestamp2;
                        this.calculatePlan(n, n2, n4, n5, (MProduct)pO, timestamp);
                    } else if ("LFL".equals(this.m_product_planning.getOrder_Policy()) && timestamp.compareTo(this.Planning_Horizon) <= 0) {
                        this.calculatePlan(n, n2, n4, n5, (MProduct)pO, timestamp);
                    }
                } else if (pO != null) {
                    this.getNetRequirements(n, n2, n4, (MProduct)pO, null);
                }
                DB.close(resultSet, cPreparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw new DBException(sQLException);
        }
        finally {
            DB.close(resultSet, cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
        }
        return "ok";
    }

    private void setProduct(int n, int n2, int n3, int n4, MProduct mProduct) throws SQLException {
        String string;
        this.DatePromisedTo = null;
        this.DatePromisedFrom = null;
        this.m_product_planning = this.getProductPlanning(n, n2, n3, n4, mProduct);
        if (this.m_product_planning == null) {
            this.createMRPNote("MRP-120", n2, 0, mProduct, (String)null, null, null);
            return;
        }
        if (this.m_product_planning.getTimeFence().signum() > 0) {
            this.TimeFence = TimeUtil.addDays(this.getToday(), this.m_product_planning.getTimeFence().intValueExact());
        }
        this.QtyProjectOnHand = this.getQtyOnHand(this.m_product_planning);
        if (this.QtyProjectOnHand.signum() < 0) {
            string = Msg.translate(this.getCtx(), "QtyOnHand") + ": " + this.QtyProjectOnHand;
            this.createMRPNote("MRP-140", n2, 0, mProduct, null, this.QtyProjectOnHand, string);
        }
        if (this.m_product_planning.getSafetyStock().signum() > 0 && this.m_product_planning.getSafetyStock().compareTo(this.QtyProjectOnHand) > 0) {
            string = Msg.translate(this.getCtx(), "QtyOnHand") + ": " + this.QtyProjectOnHand + " " + Msg.translate(this.getCtx(), "SafetyStock") + ": " + this.m_product_planning.getSafetyStock();
            this.createMRPNote("MRP-001", n2, 0, mProduct, null, this.QtyProjectOnHand, string);
        }
        this.log.info("QtyOnHand :" + this.QtyProjectOnHand);
    }

    protected MPPProductPlanning getProductPlanning(int n, int n2, int n3, int n4, MProduct mProduct) throws SQLException {
        MPPProductPlanning mPPProductPlanning = MPPProductPlanning.find(this.getCtx(), n2, n4, n3, mProduct.getM_Product_ID(), this.get_TrxName());
        if (mPPProductPlanning == null) {
            return null;
        }
        MPPProductPlanning mPPProductPlanning2 = new MPPProductPlanning(this.getCtx(), 0, null);
        MPPProductPlanning.copyValues(mPPProductPlanning, mPPProductPlanning2);
        mPPProductPlanning2.setIsRequiredDRP(this.isRequiredDRP());
        if (mPPProductPlanning2.getPP_Product_BOM_ID() <= 0 && mProduct.isBOM()) {
            mPPProductPlanning2.setPP_Product_BOM_ID(MPPProductBOM.getBOMSearchKey(mProduct));
        }
        if (mPPProductPlanning2.getAD_Workflow_ID() <= 0 && mProduct.isBOM()) {
            mPPProductPlanning2.setAD_Workflow_ID(MWorkflow.getWorkflowSearchKey(mProduct));
        }
        if (mPPProductPlanning2.getPlanner_ID() <= 0) {
            mPPProductPlanning2.setPlanner_ID(this.getPlanner_ID());
        }
        if (mPPProductPlanning2.getM_Warehouse_ID() <= 0) {
            mPPProductPlanning2.setM_Warehouse_ID(n4);
        }
        if (mPPProductPlanning2.getS_Resource_ID() <= 0) {
            mPPProductPlanning2.setS_Resource_ID(n3);
        }
        if (mPPProductPlanning2.getOrder_Policy() == null) {
            mPPProductPlanning2.setOrder_Policy("LFL");
        }
        if (!this.isRequiredDRP()) {
            if (mProduct.isPurchased()) {
                int n5 = 0;
                MProductPO[] mProductPOArray = MProductPO.getOfProduct(this.getCtx(), mProduct.getM_Product_ID(), this.get_TrxName());
                for (int i = 0; i < mProductPOArray.length; ++i) {
                    if (!mProductPOArray[i].isCurrentVendor() || mProductPOArray[i].getC_BPartner_ID() == 0) continue;
                    n5 = mProductPOArray[i].getC_BPartner_ID();
                    mPPProductPlanning2.setDeliveryTime_Promised(BigDecimal.valueOf(mProductPOArray[i].getDeliveryTime_Promised()));
                    mPPProductPlanning2.setOrder_Min(mProductPOArray[i].getOrder_Min());
                    mPPProductPlanning2.setOrder_Max(Env.ZERO);
                    mPPProductPlanning2.setOrder_Pack(mProductPOArray[i].getOrder_Pack());
                    mPPProductPlanning2.setC_BPartner_ID(n5);
                    break;
                }
                if (n5 <= 0) {
                    this.createMRPNote("MRP-130", n2, 0, mProduct, (String)null, null, null);
                    mPPProductPlanning2.setIsCreatePlan(false);
                }
            }
            if (mProduct.isBOM() && mPPProductPlanning2.getAD_Workflow_ID() <= 0) {
                this.log.info("Error: Do not exist workflow (" + mProduct.getValue() + ")");
            }
        }
        return mPPProductPlanning2;
    }

    protected BigDecimal getQtyOnHand(I_PP_Product_Planning i_PP_Product_Planning) {
        return MPPMRP.getQtyOnHand(this.getCtx(), i_PP_Product_Planning.getM_Warehouse_ID(), i_PP_Product_Planning.getM_Product_ID(), this.get_TrxName());
    }

    protected Timestamp getToday() {
        return this.Today;
    }

    private void calculatePlan(int n, int n2, int n3, int n4, MProduct mProduct, Timestamp timestamp) throws SQLException {
        String string;
        this.log.info("Create Plan ...");
        if (this.m_product_planning.getM_Product_ID() != mProduct.get_ID()) {
            throw new IllegalStateException("MRP Internal Error: DataPlanningProduct(" + this.m_product_planning.getM_Product_ID() + ")" + " <> Product(" + mProduct + ")");
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(this.m_product_planning.getYield());
        if (bigDecimal.signum() != 0) {
            this.QtyGrossReqs = this.QtyGrossReqs.multiply(Env.ONEHUNDRED).divide(bigDecimal, 4, RoundingMode.HALF_UP);
        }
        BigDecimal bigDecimal2 = this.getNetRequirements(n, n2, n3, mProduct, timestamp);
        BigDecimal bigDecimal3 = Env.ZERO;
        ((PO)this.m_product_planning).dump();
        this.log.info("                    Product:" + mProduct);
        this.log.info(" Demand Date Start Schedule:" + timestamp);
        this.log.info("           DatePromisedFrom:" + this.DatePromisedFrom + " DatePromisedTo:" + this.DatePromisedTo);
        this.log.info("                Qty Planned:" + bigDecimal3);
        this.log.info("     Qty Scheduled Receipts:" + this.QtyScheduledReceipts);
        this.log.info("           QtyProjectOnHand:" + this.QtyProjectOnHand);
        this.log.info("               QtyGrossReqs:" + this.QtyGrossReqs);
        this.log.info("                     Supply:" + this.QtyScheduledReceipts.add(this.QtyProjectOnHand));
        this.log.info("                 QtyNetReqs:" + bigDecimal2);
        if (bigDecimal2.signum() > 0) {
            this.QtyProjectOnHand = bigDecimal2;
            bigDecimal2 = Env.ZERO;
            this.QtyScheduledReceipts = Env.ZERO;
            bigDecimal3 = Env.ZERO;
            this.QtyGrossReqs = Env.ZERO;
            return;
        }
        bigDecimal3 = bigDecimal2.negate();
        this.QtyGrossReqs = Env.ZERO;
        this.QtyScheduledReceipts = Env.ZERO;
        if (bigDecimal3.signum() > 0 && this.m_product_planning.getOrder_Min().signum() > 0) {
            if (this.m_product_planning.getOrder_Min().compareTo(bigDecimal3) > 0) {
                string = Msg.translate(this.getCtx(), "Order_Min") + ":" + this.m_product_planning.getOrder_Min();
                this.createMRPNote("MRP-080", n2, n4, mProduct, null, bigDecimal3, string);
            }
            bigDecimal3 = bigDecimal3.max(this.m_product_planning.getOrder_Min());
        }
        if (this.m_product_planning.getOrder_Pack().signum() > 0 && bigDecimal3.signum() > 0) {
            bigDecimal3 = this.m_product_planning.getOrder_Pack().multiply(bigDecimal3.divide(this.m_product_planning.getOrder_Pack(), 0, 0));
        }
        if (bigDecimal3.compareTo(this.m_product_planning.getOrder_Max()) > 0 && this.m_product_planning.getOrder_Max().signum() > 0) {
            string = Msg.translate(this.getCtx(), "Order_Max") + ":" + this.m_product_planning.getOrder_Max();
            this.createMRPNote("MRP-090", n2, n4, mProduct, null, bigDecimal3, string);
        }
        this.QtyProjectOnHand = bigDecimal3.add(bigDecimal2);
        this.log.info("QtyNetReqs:" + bigDecimal2);
        this.log.info("QtyPlanned:" + bigDecimal3);
        this.log.info("QtyProjectOnHand:" + this.QtyProjectOnHand);
        if (this.TimeFence != null && timestamp.compareTo(this.TimeFence) < 0) {
            string = Msg.translate(this.getCtx(), "TimeFence") + ":" + this.m_product_planning.getTimeFence() + "-" + Msg.getMsg(this.getCtx(), "Date") + ":" + this.TimeFence + " " + Msg.translate(this.getCtx(), "DatePromised") + ":" + timestamp;
            this.createMRPNote("MRP-100", n2, n4, mProduct, null, bigDecimal3, string);
        }
        if (!this.m_product_planning.isCreatePlan() && bigDecimal3.signum() > 0) {
            this.createMRPNote("MRP-020", n2, n4, mProduct, null, bigDecimal3, null);
            return;
        }
        if (bigDecimal3.signum() > 0) {
            int n5 = 1;
            if (this.m_product_planning.getOrder_Policy().equals("FOQ")) {
                if (this.m_product_planning.getOrder_Qty().signum() != 0) {
                    n5 = bigDecimal3.divide(this.m_product_planning.getOrder_Qty(), 0, 0).intValueExact();
                }
                bigDecimal3 = this.m_product_planning.getOrder_Qty();
            }
            for (int i = 1; i <= n5; ++i) {
                this.log.info("Is Purchased: " + mProduct.isPurchased() + " Is BOM: " + mProduct.isBOM());
                try {
                    this.createSupply(n2, n4, mProduct, bigDecimal3, timestamp);
                    continue;
                }
                catch (Exception exception) {
                    this.createMRPNote("MRP-160", n2, n4, mProduct, bigDecimal3, timestamp, exception);
                }
            }
        } else {
            this.log.info("No Create Plan");
        }
    }

    protected void createSupply(int n, int n2, MProduct mProduct, BigDecimal bigDecimal, Timestamp timestamp) throws AdempiereException, SQLException {
        if (this.isRequiredDRP() && this.m_product_planning.getDD_NetworkDistribution_ID() > 0) {
            this.createDDOrder(n, n2, mProduct, bigDecimal, timestamp);
        } else if (mProduct.isPurchased()) {
            this.createRequisition(n, n2, mProduct, bigDecimal, timestamp);
        } else if (mProduct.isBOM()) {
            this.createPPOrder(n, n2, mProduct, bigDecimal, timestamp);
        } else {
            throw new IllegalStateException("MRP Internal Error: Don't know what document to create for " + mProduct + "(" + this.m_product_planning + ")");
        }
    }

    protected void createDDOrder(int n, int n2, MProduct mProduct, BigDecimal bigDecimal, Timestamp timestamp) throws AdempiereException, SQLException {
        if (this.m_product_planning.getDD_NetworkDistribution_ID() == 0) {
            this.createMRPNote("DRP-060", n, n2, mProduct, (String)null, null, null);
        }
        MDDNetworkDistribution mDDNetworkDistribution = MDDNetworkDistribution.get(this.getCtx(), this.m_product_planning.getDD_NetworkDistribution_ID());
        MDDNetworkDistributionLine[] mDDNetworkDistributionLineArray = mDDNetworkDistribution.getLines(this.m_product_planning.getM_Warehouse_ID());
        int n3 = 0;
        X_DD_Order x_DD_Order = null;
        Integer n4 = 0;
        for (MDDNetworkDistributionLine mDDNetworkDistributionLine : mDDNetworkDistributionLineArray) {
            Object object;
            Object object2;
            Object object3;
            MWarehouse mWarehouse = MWarehouse.get(this.getCtx(), mDDNetworkDistributionLine.getM_WarehouseSource_ID());
            MLocator mLocator = mWarehouse.getDefaultLocator();
            MWarehouse mWarehouse2 = MWarehouse.get(this.getCtx(), mDDNetworkDistributionLine.getM_Warehouse_ID());
            MLocator mLocator2 = mWarehouse2.getDefaultLocator();
            BigDecimal bigDecimal2 = mDDNetworkDistributionLine.getTransfertTime();
            if (bigDecimal2.compareTo(Env.ZERO) <= 0) {
                bigDecimal2 = this.m_product_planning.getTransfertTime();
            }
            if (mLocator == null || mLocator2 == null) {
                object3 = Msg.translate(this.getCtx(), "M_WarehouseSource_ID") + ":" + mWarehouse.getName();
                this.createMRPNote("DRP-001", n, n2, mProduct, null, null, (String)object3);
                continue;
            }
            object3 = MWarehouse.getInTransitForOrg(this.getCtx(), mWarehouse.getAD_Org_ID());
            if (object3 == null || ((MWarehouse[])object3).length == 0) {
                object2 = Msg.translate(this.getCtx(), "Name") + ":" + MOrg.get(this.getCtx(), n).getName();
                this.createMRPNote("DRP-010", n, n2, mProduct, null, null, (String)object2);
                continue;
            }
            if (mDDNetworkDistributionLine.getM_Shipper_ID() == 0) {
                object2 = Msg.translate(this.getCtx(), "Name") + ":" + mDDNetworkDistribution.getName();
                this.createMRPNote("DRP-030", n, n2, mProduct, null, null, (String)object2);
                continue;
            }
            if (n3 != mDDNetworkDistributionLine.getM_Shipper_ID()) {
                Object object4;
                object2 = MOrg.get(this.getCtx(), mLocator2.getAD_Org_ID());
                int n5 = ((MOrg)object2).getLinkedC_BPartner_ID(this.get_TrxName());
                if (n5 == 0) {
                    object4 = Msg.translate(this.getCtx(), "Name") + ":" + MOrg.get(this.getCtx(), n).getName();
                    this.createMRPNote("DRP-020", n, n2, mProduct, null, null, (String)object4);
                    continue;
                }
                object4 = this.getBPartner(n5);
                n4 = this.getDDOrder_ID(n, object3[0].get_ID(), mDDNetworkDistributionLine.getM_Shipper_ID(), ((X_C_BPartner)object4).getC_BPartner_ID(), timestamp);
                if (n4 <= 0) {
                    x_DD_Order = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
                    x_DD_Order.setAD_Org_ID(mWarehouse2.getAD_Org_ID());
                    x_DD_Order.setC_BPartner_ID(n5);
                    x_DD_Order.setAD_User_ID(((MBPartner)object4).getPrimaryAD_User_ID());
                    x_DD_Order.setC_DocType_ID(this.docTypeDO_ID);
                    x_DD_Order.setM_Warehouse_ID(object3[0].get_ID());
                    ((MDDOrder)x_DD_Order).setDocAction("CO");
                    x_DD_Order.setDateOrdered(this.getToday());
                    x_DD_Order.setDatePromised(timestamp);
                    x_DD_Order.setM_Shipper_ID(mDDNetworkDistributionLine.getM_Shipper_ID());
                    x_DD_Order.setIsInDispute(false);
                    x_DD_Order.setIsInTransit(false);
                    x_DD_Order.setSalesRep_ID(this.m_product_planning.getPlanner_ID());
                    x_DD_Order.saveEx();
                    n4 = x_DD_Order.get_ID();
                    object = x_DD_Order.getAD_Org_ID() + "#" + x_DD_Order.getM_Warehouse_ID() + "#" + mDDNetworkDistributionLine.getM_Shipper_ID() + "#" + n5 + "#" + timestamp + "DR";
                    dd_order_id_cache.put((String)object, n4);
                } else {
                    x_DD_Order = new MDDOrder(this.getCtx(), n4, this.get_TrxName());
                }
                n3 = mDDNetworkDistributionLine.getM_Shipper_ID();
            }
            object2 = bigDecimal.multiply(mDDNetworkDistributionLine.getPercent()).divide(Env.ONEHUNDRED);
            MDDOrderLine mDDOrderLine = new MDDOrderLine(this.getCtx(), 0, this.get_TrxName());
            mDDOrderLine.setDD_Order_ID(x_DD_Order.getDD_Order_ID());
            mDDOrderLine.setAD_Org_ID(mWarehouse2.getAD_Org_ID());
            mDDOrderLine.setM_Locator_ID(mLocator.getM_Locator_ID());
            mDDOrderLine.setM_LocatorTo_ID(mLocator2.getM_Locator_ID());
            mDDOrderLine.setM_Product_ID(this.m_product_planning.getM_Product_ID());
            mDDOrderLine.setDateOrdered(this.getToday());
            mDDOrderLine.setDatePromised(timestamp);
            mDDOrderLine.setQtyEntered((BigDecimal)object2);
            mDDOrderLine.setQtyOrdered((BigDecimal)object2);
            mDDOrderLine.setTargetQty(MPPMRP.getQtyReserved(this.getCtx(), mWarehouse2.getM_Warehouse_ID(), this.m_product_planning.getM_Product_ID(), timestamp, this.get_TrxName()));
            mDDOrderLine.setIsInvoiced(false);
            mDDOrderLine.saveEx();
            object = new Query(this.getCtx(), "PP_MRP", "DD_OrderLine_ID=?", this.get_TrxName()).setParameters(mDDOrderLine.getDD_OrderLine_ID()).list();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                MPPMRP mPPMRP = (MPPMRP)iterator.next();
                mPPMRP.setDateOrdered(this.getToday());
                mPPMRP.setS_Resource_ID(this.m_product_planning.getS_Resource_ID());
                mPPMRP.setDatePromised(TimeUtil.addDays(timestamp, this.m_product_planning.getDeliveryTime_Promised().add(bigDecimal2).negate().intValueExact()));
                mPPMRP.setDateFinishSchedule(timestamp);
                mPPMRP.saveEx();
            }
            ++this.count_DO;
        }
        this.commitEx();
    }

    protected void createRequisition(int n, int n2, MProduct mProduct, BigDecimal bigDecimal, Timestamp timestamp) throws AdempiereException, SQLException {
        this.log.info("Create Requisition");
        int n3 = MPPMRP.getDurationDays(bigDecimal, this.m_product_planning);
        int n4 = -1;
        if (this.m_product_planning.getC_BPartner_ID() > 0) {
            n4 = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?", this.m_product_planning.getC_BPartner_ID());
        }
        MRequisition mRequisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
        mRequisition.setAD_Org_ID(n);
        mRequisition.setAD_User_ID(this.m_product_planning.getPlanner_ID());
        mRequisition.setDateRequired(TimeUtil.addDays(timestamp, 0 - n3));
        mRequisition.setDescription("Generate from MRP");
        mRequisition.setM_Warehouse_ID(this.m_product_planning.getM_Warehouse_ID());
        mRequisition.setC_DocType_ID(this.docTypeReq_ID);
        if (n4 > 0) {
            mRequisition.setM_PriceList_ID(n4);
        }
        mRequisition.saveEx();
        MRequisitionLine mRequisitionLine = new MRequisitionLine(mRequisition);
        mRequisitionLine.setLine(10);
        mRequisitionLine.setAD_Org_ID(n);
        mRequisitionLine.setC_BPartner_ID(this.m_product_planning.getC_BPartner_ID());
        mRequisitionLine.setM_Product_ID(this.m_product_planning.getM_Product_ID());
        mRequisitionLine.setPrice();
        mRequisitionLine.setPriceActual(Env.ZERO);
        mRequisitionLine.setQty(bigDecimal);
        mRequisitionLine.saveEx();
        List list = new Query(this.getCtx(), "PP_MRP", "M_Requisition_ID=?", this.get_TrxName()).setParameters(mRequisition.getM_Requisition_ID()).list();
        for (MPPMRP mPPMRP : list) {
            mPPMRP.setDateOrdered(this.getToday());
            mPPMRP.setS_Resource_ID(this.m_product_planning.getS_Resource_ID());
            mPPMRP.setDatePromised(mRequisition.getDateRequired());
            mPPMRP.setDateStartSchedule(mRequisition.getDateRequired());
            mPPMRP.setDateFinishSchedule(timestamp);
            mPPMRP.saveEx();
        }
        this.commitEx();
        ++this.count_MR;
    }

    protected void createPPOrder(int n, int n2, MProduct mProduct, BigDecimal bigDecimal, Timestamp timestamp) throws AdempiereException, SQLException {
        this.log.info("PP_Product_BOM_ID:" + this.m_product_planning.getPP_Product_BOM_ID() + ", AD_Workflow_ID:" + this.m_product_planning.getAD_Workflow_ID());
        if (this.m_product_planning.getPP_Product_BOM_ID() == 0 || this.m_product_planning.getAD_Workflow_ID() == 0) {
            throw new AdempiereException("@FillMandatory@ @PP_Product_BOM_ID@, @AD_Workflow_ID@ ( @M_Product_ID@=" + mProduct.getValue() + ")");
        }
        int n3 = MPPMRP.getDurationDays(bigDecimal, this.m_product_planning);
        MPPOrder mPPOrder = new MPPOrder(this.getCtx(), 0, this.get_TrxName());
        mPPOrder.addDescription("Generated by MRP");
        mPPOrder.setAD_Org_ID(n);
        mPPOrder.setLine(10);
        if ("M".equals(this.getBOMType())) {
            this.log.info("Maintenance Order Created");
            mPPOrder.setC_DocTypeTarget_ID(this.docTypeMF_ID);
            mPPOrder.setC_DocType_ID(this.docTypeMF_ID);
        } else {
            this.log.info("Manufacturing Order Created");
            mPPOrder.setC_DocTypeTarget_ID(this.docTypeMO_ID);
            mPPOrder.setC_DocType_ID(this.docTypeMO_ID);
        }
        mPPOrder.setS_Resource_ID(this.m_product_planning.getS_Resource_ID());
        mPPOrder.setM_Warehouse_ID(this.m_product_planning.getM_Warehouse_ID());
        mPPOrder.setM_Product_ID(this.m_product_planning.getM_Product_ID());
        mPPOrder.setM_AttributeSetInstance_ID(0);
        mPPOrder.setPP_Product_BOM_ID(this.m_product_planning.getPP_Product_BOM_ID());
        mPPOrder.setAD_Workflow_ID(this.m_product_planning.getAD_Workflow_ID());
        mPPOrder.setPlanner_ID(this.m_product_planning.getPlanner_ID());
        mPPOrder.setDateOrdered(this.getToday());
        mPPOrder.setDatePromised(timestamp);
        mPPOrder.setDateStartSchedule(TimeUtil.addDays(timestamp, 0 - n3));
        mPPOrder.setDateFinishSchedule(timestamp);
        mPPOrder.setQty(bigDecimal);
        mPPOrder.setC_UOM_ID(mProduct.getC_UOM_ID());
        mPPOrder.setYield(Env.ZERO);
        mPPOrder.setScheduleType("D");
        mPPOrder.setPriorityRule("5");
        mPPOrder.setDocAction("CO");
        mPPOrder.saveEx();
        this.commitEx();
        ++this.count_MO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePO(String string, String string2, Object[] objectArray) throws SQLException {
        POResultSet pOResultSet = new Query(this.getCtx(), string, string2, this.get_TrxName()).setParameters(objectArray).scroll();
        try {
            while (pOResultSet.hasNext()) {
                ((PO)pOResultSet.next()).deleteEx(true);
            }
        }
        finally {
            pOResultSet.close();
        }
        this.commitEx();
    }

    protected void createMRPNote(String string, int n, int n2, MProduct mProduct, String string2, BigDecimal bigDecimal, String string3) throws SQLException {
        string2 = string2 != null ? string2 : "";
        string3 = string3 != null ? string3 : "";
        bigDecimal = bigDecimal != null ? bigDecimal : Env.ZERO;
        MMessage mMessage = MMessage.get(this.getCtx(), string);
        if (mMessage == null) {
            mMessage = MMessage.get(this.getCtx(), "MRP-999");
        }
        String string4 = Msg.getMsg(this.getCtx(), mMessage.getValue());
        int n3 = 0;
        if (this.m_product_planning != null) {
            n3 = this.m_product_planning.getPlanner_ID();
        }
        String string5 = "";
        if (mProduct != null) {
            string5 = mProduct.getValue() + " " + mProduct.getName();
        }
        if (!Util.isEmpty(string2, true)) {
            string4 = string4 + " " + Msg.translate(this.getCtx(), "DocumentNo") + ":" + string2;
        }
        if (bigDecimal != null) {
            string4 = string4 + " " + Msg.translate(this.getCtx(), "QtyPlan") + ":" + bigDecimal;
        }
        if (!Util.isEmpty(string3, true)) {
            string4 = string4 + " " + string3;
        }
        MNote mNote = new MNote(this.getCtx(), mMessage.getAD_Message_ID(), n3, MPPMRP.Table_ID, n2, string5, string4, this.get_TrxName());
        mNote.setAD_Org_ID(n);
        mNote.saveEx();
        this.commitEx();
        this.log.info(string + ": " + mNote.getTextMsg());
        ++this.count_Msg;
    }

    private void createMRPNote(String string, MPPMRP mPPMRP, MProduct mProduct, String string2) throws SQLException {
        this.createMRPNote(string, mPPMRP.getAD_Org_ID(), mPPMRP.get_ID(), mProduct, MPPMRP.getDocumentNo(mPPMRP.get_ID()), mPPMRP.getQty(), string2);
    }

    protected void createMRPNote(String string, int n, int n2, MProduct mProduct, BigDecimal bigDecimal, Timestamp timestamp, Exception exception) throws SQLException {
        String string2 = null;
        String string3 = exception.getLocalizedMessage();
        this.createMRPNote(string, n, n2, mProduct, string2, bigDecimal, string3);
    }

    private int getDDOrder_ID(int n, int n2, int n3, int n4, Timestamp timestamp) {
        String string = n + "#" + n2 + "#" + n3 + "#" + n4 + "#" + timestamp + "DR";
        Integer n5 = dd_order_id_cache.get(string.toString());
        if (n5 == null) {
            String string2 = "SELECT DD_Order_ID FROM DD_Order WHERE AD_Org_ID=? AND M_Warehouse_ID=? AND M_Shipper_ID = ? AND C_BPartner_ID=? AND DatePromised=? AND DocStatus=?";
            n5 = DB.getSQLValueEx(this.get_TrxName(), string2, n, n2, n3, n4, timestamp, "DR");
            if (n5 > 0) {
                dd_order_id_cache.put(string, n5);
            }
        }
        return n5;
    }

    private MBPartner getBPartner(int n) {
        MBPartner mBPartner = partner_cache.get(n);
        if (mBPartner == null) {
            mBPartner = MBPartner.get(this.getCtx(), n);
            partner_cache.put(n, mBPartner);
        }
        return mBPartner;
    }

    private BigDecimal getNetRequirements(int n, int n2, int n3, MProduct mProduct, Timestamp timestamp) throws SQLException {
        BigDecimal bigDecimal = this.QtyProjectOnHand.subtract(this.QtyGrossReqs);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(n);
        arrayList.add(n2);
        arrayList.add(mProduct.get_ID());
        arrayList.add(n3);
        arrayList.add("S");
        arrayList.add("CO");
        arrayList.add("IP");
        arrayList.add("DR");
        arrayList.add(true);
        List list = new Query(this.getCtx(), "PP_MRP", "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_Warehouse_ID=? AND TypeMRP=? AND DocStatus IN (?,?,?) AND Qty<>0 AND IsAvailable=?", this.get_TrxName()).setParameters(arrayList).setOrderBy("DateStartSchedule").list();
        for (MPPMRP mPPMRP : list) {
            String string;
            if (mPPMRP.isReleased()) {
                this.QtyScheduledReceipts = this.QtyScheduledReceipts.add(mPPMRP.getQty());
            }
            if (timestamp != null) {
                if (mPPMRP.isReleased() && bigDecimal.negate().signum() > 0 && mPPMRP.getDateStartSchedule() != null && mPPMRP.getDateStartSchedule().compareTo(timestamp) < 0) {
                    string = Msg.translate(this.getCtx(), "DateStartSchedule") + ":" + mPPMRP.getDateStartSchedule() + " " + Msg.translate(this.getCtx(), "DatePromised") + ":" + timestamp;
                    this.createMRPNote("MRP-030", mPPMRP, mProduct, string);
                }
                if (mPPMRP.isReleased() && bigDecimal.negate().signum() > 0 && mPPMRP.getDateStartSchedule() != null && mPPMRP.getDateStartSchedule().compareTo(timestamp) > 0) {
                    string = Msg.translate(this.getCtx(), "DateStartSchedule") + ":" + mPPMRP.getDateStartSchedule() + " " + Msg.translate(this.getCtx(), "DatePromised") + ":" + timestamp;
                    this.createMRPNote("MRP-040", mPPMRP, mProduct, string);
                }
                if (!mPPMRP.isReleased() && bigDecimal.negate().signum() > 0 && mPPMRP.getDateStartSchedule() != null && mPPMRP.getDatePromised().compareTo(this.getToday()) >= 0) {
                    string = Msg.translate(this.getCtx(), "DatePromised") + ":" + mPPMRP.getDatePromised();
                    this.createMRPNote("MRP-060", mPPMRP, mProduct, string);
                }
                if (!mPPMRP.isReleased() && bigDecimal.negate().signum() > 0 && mPPMRP.getDateStartSchedule() != null && mPPMRP.getDatePromised().compareTo(this.getToday()) < 0) {
                    string = Msg.translate(this.getCtx(), "DatePromised") + ":" + mPPMRP.getDatePromised();
                    this.createMRPNote("MRP-070", mPPMRP, mProduct, string);
                }
                if (mPPMRP.isReleased() && mPPMRP.getDateStartSchedule() != null && mPPMRP.getDatePromised().compareTo(this.getToday()) < 0) {
                    string = Msg.translate(this.getCtx(), "DatePromised") + ":" + mPPMRP.getDatePromised();
                    this.createMRPNote("MRP-110", mPPMRP, mProduct, string);
                }
                mPPMRP.setIsAvailable(false);
                mPPMRP.saveEx();
                if ((bigDecimal = bigDecimal.add(mPPMRP.getQty())).signum() < 0) continue;
                return bigDecimal;
            }
            if (mPPMRP.isReleased() && this.QtyScheduledReceipts.signum() > 0) {
                string = Msg.translate(this.getCtx(), "DatePromised") + ":" + mPPMRP.getDatePromised();
                this.createMRPNote("MRP-050", mPPMRP, mProduct, string);
            }
            mPPMRP.setIsAvailable(false);
            mPPMRP.saveEx();
            bigDecimal = bigDecimal.add(mPPMRP.getQty());
        }
        return bigDecimal;
    }

    protected int getDocType(String string, int n) {
        MDocType[] mDocTypeArray = MDocType.getOfDocBaseType(this.getCtx(), string);
        if (mDocTypeArray == null || mDocTypeArray.length == 0) {
            String string2 = Msg.getMsg(this.getCtx(), "SequenceDocNotFound");
            String string3 = "Not found default document type for docbasetype " + string;
            MNote mNote = new MNote(this.getCtx(), MMessage.getAD_Message_ID(this.getCtx(), "SequenceDocNotFound"), this.getPlanner_ID(), MPPMRP.Table_ID, 0, string2, string3, this.get_TrxName());
            mNote.saveEx();
            throw new AdempiereException(string3);
        }
        for (MDocType mDocType : mDocTypeArray) {
            if (mDocType.getAD_Org_ID() != n) continue;
            return mDocType.getC_DocType_ID();
        }
        this.log.info("Doc Type for " + string + ": " + mDocTypeArray[0].getC_DocType_ID());
        return mDocTypeArray[0].getC_DocType_ID();
    }

    private String getBOMType() {
        if (this.m_product_planning == null || this.m_product_planning.getPP_Product_BOM_ID() == 0) {
            return null;
        }
        String string = DB.getSQLValueString(this.get_TrxName(), "SELECT BOMType FROM PP_Product_BOM WHERE PP_Product_BOM_ID = ?", this.m_product_planning.getPP_Product_BOM_ID());
        return string;
    }
}

