/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MForecast;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_M_ForecastLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.model.X_I_ProductPlanning;

public class ImportProductPlanning
extends SvrProcess {
    private boolean isImported = false;
    private boolean p_DeleteOldImported = false;
    private boolean p_IsImportOnlyNoErrors = true;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray;
        for (ProcessInfoParameter processInfoParameter : processInfoParameterArray = this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("IsImportOnlyNoErrors")) {
                this.p_IsImportOnlyNoErrors = "Y".equals(processInfoParameter.getParameter());
                continue;
            }
            if (string.equals("DeleteOldImported")) {
                this.p_DeleteOldImported = "Y".equals(processInfoParameter.getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.deleteImportedRecords();
        this.fillIDValues();
        this.importRecords();
        return "";
    }

    private void importRecords() {
        for (X_I_ProductPlanning x_I_ProductPlanning : this.getRecords(false, this.p_IsImportOnlyNoErrors)) {
            if (x_I_ProductPlanning.getM_Product_ID() > 0 && x_I_ProductPlanning.getS_Resource_ID() > 0 && x_I_ProductPlanning.getM_Warehouse_ID() > 0) {
                this.importProductPlanning(x_I_ProductPlanning);
            } else if (x_I_ProductPlanning.getForecastValue() == null || x_I_ProductPlanning.getM_Forecast_ID() == 0) {
                String string = "";
                if (x_I_ProductPlanning.getM_Product_ID() == 0) {
                    string = string + " @M_Product_ID@ @NotFound@ ,";
                }
                if (x_I_ProductPlanning.getS_Resource_ID() == 0) {
                    string = string + " @S_Resource_ID@ @NotFound@ ,";
                }
                if (x_I_ProductPlanning.getM_Warehouse_ID() == 0) {
                    string = string + " @M_Waehouse_ID@ @NotFound@";
                }
                x_I_ProductPlanning.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), string));
                this.isImported = false;
                x_I_ProductPlanning.saveEx();
                return;
            }
            if (x_I_ProductPlanning.getForecastValue() == null) {
                this.isImported = true;
            } else if (x_I_ProductPlanning.getM_Forecast_ID() > 0 && x_I_ProductPlanning.getM_Warehouse_ID() > 0 && x_I_ProductPlanning.getM_Product_ID() > 0 && x_I_ProductPlanning.getQty().signum() > 0) {
                this.importForecast(x_I_ProductPlanning);
            } else {
                String string = "";
                if (x_I_ProductPlanning.getM_Forecast_ID() == 0) {
                    string = string + " @M_Forecast_ID@ @NotFound@ ,";
                }
                if (x_I_ProductPlanning.getM_Warehouse_ID() == 0) {
                    string = string + " @M_Warehouse_ID@ @NotFound@ ,";
                }
                if (x_I_ProductPlanning.getQty().signum() <= 0) {
                    string = string + " @Qty@ @Error@";
                }
                x_I_ProductPlanning.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), string));
                this.isImported = false;
                x_I_ProductPlanning.saveEx();
                return;
            }
            if (!this.isImported) continue;
            x_I_ProductPlanning.setI_IsImported(true);
            x_I_ProductPlanning.setProcessed(true);
            x_I_ProductPlanning.saveEx();
        }
    }

    private void importProductPlanning(X_I_ProductPlanning x_I_ProductPlanning) {
        MPPProductPlanning mPPProductPlanning = null;
        mPPProductPlanning = x_I_ProductPlanning.getPP_Product_Planning_ID() > 0 ? new MPPProductPlanning(this.getCtx(), x_I_ProductPlanning.getPP_Product_Planning_ID(), this.get_TrxName()) : this.getProductPlanning(x_I_ProductPlanning);
        if (mPPProductPlanning == null) {
            mPPProductPlanning = new MPPProductPlanning(this.getCtx(), 0, this.get_TrxName());
        }
        this.fillValue(mPPProductPlanning, x_I_ProductPlanning);
        if (x_I_ProductPlanning.getC_BPartner_ID() > 0 && x_I_ProductPlanning.getVendorProductNo() != null) {
            this.importPurchaseProductPlanning(x_I_ProductPlanning);
        }
    }

    private void importPurchaseProductPlanning(X_I_ProductPlanning x_I_ProductPlanning) {
        MProduct mProduct = MProduct.get(this.getCtx(), x_I_ProductPlanning.getM_Product_ID());
        if (mProduct.isPurchased()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("M_Product_ID").append("=? AND ");
            stringBuffer.append("C_BPartner_ID").append("=?");
            MProductPO mProductPO = (MProductPO)new Query(this.getCtx(), "M_Product_PO", stringBuffer.toString(), this.get_TrxName()).setClient_ID().setParameters(x_I_ProductPlanning.getM_Product_ID(), x_I_ProductPlanning.getC_BPartner_ID()).first();
            if (mProductPO == null) {
                mProductPO = new MProductPO(this.getCtx(), 0, this.get_TrxName());
            }
            mProductPO.setAD_Org_ID(x_I_ProductPlanning.getAD_Org_ID());
            mProductPO.setM_Product_ID(x_I_ProductPlanning.getM_Product_ID());
            mProductPO.setC_BPartner_ID(x_I_ProductPlanning.getC_BPartner_ID());
            mProductPO.setOrder_Min(x_I_ProductPlanning.getOrder_Min());
            mProductPO.setOrder_Pack(x_I_ProductPlanning.getOrder_Pack());
            mProductPO.setDeliveryTime_Promised(x_I_ProductPlanning.getDeliveryTime_Promised().intValue());
            mProductPO.setVendorProductNo(x_I_ProductPlanning.getVendorProductNo());
            mProductPO.saveEx();
        }
    }

    private void importForecast(X_I_ProductPlanning x_I_ProductPlanning) {
        if (x_I_ProductPlanning.getForecastValue() == null && x_I_ProductPlanning.getM_Forecast_ID() == 0) {
            x_I_ProductPlanning.setI_ErrorMsg(Msg.getMsg(this.getCtx(), "@M_Forecast_ID@ @NotFound@"));
            x_I_ProductPlanning.saveEx();
            this.isImported = false;
            return;
        }
        MForecast mForecast = new MForecast(this.getCtx(), x_I_ProductPlanning.getM_Forecast_ID(), this.get_TrxName());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("M_Forecast_ID").append("=? AND ").append("M_Product_ID").append("=? AND ").append("M_Warehouse_ID").append("=? AND ").append("DatePromised").append("=? AND ").append("SalesRep_ID").append("=?");
        X_M_ForecastLine x_M_ForecastLine = null;
        x_M_ForecastLine = x_I_ProductPlanning.getM_ForecastLine_ID() > 0 ? new X_M_ForecastLine(this.getCtx(), x_I_ProductPlanning.getM_ForecastLine_ID(), this.get_TrxName()) : (X_M_ForecastLine)new Query(this.getCtx(), "M_ForecastLine", stringBuffer.toString(), this.get_TrxName()).setClient_ID().setParameters(x_I_ProductPlanning.getM_Forecast_ID(), x_I_ProductPlanning.getM_Product_ID(), x_I_ProductPlanning.getM_Warehouse_ID(), x_I_ProductPlanning.getDatePromised(), x_I_ProductPlanning.getSalesRep_ID()).first();
        if (x_M_ForecastLine == null) {
            x_M_ForecastLine = new X_M_ForecastLine(this.getCtx(), 0, this.get_TrxName());
        }
        x_M_ForecastLine.setM_Forecast_ID(x_I_ProductPlanning.getM_Forecast_ID());
        x_M_ForecastLine.setAD_Org_ID(x_I_ProductPlanning.getAD_Org_ID());
        x_M_ForecastLine.setM_Product_ID(x_I_ProductPlanning.getM_Product_ID());
        x_M_ForecastLine.setM_Warehouse_ID(x_I_ProductPlanning.getM_Warehouse_ID());
        x_M_ForecastLine.setC_Period_ID(MPeriod.getC_Period_ID(this.getCtx(), x_I_ProductPlanning.getDatePromised(), x_I_ProductPlanning.getAD_Org_ID()));
        x_M_ForecastLine.setDatePromised(x_I_ProductPlanning.getDatePromised());
        x_M_ForecastLine.setSalesRep_ID(x_I_ProductPlanning.getSalesRep_ID());
        x_M_ForecastLine.setQty(x_I_ProductPlanning.getQty());
        x_M_ForecastLine.saveEx();
        x_I_ProductPlanning.setM_ForecastLine_ID(x_M_ForecastLine.getM_ForecastLine_ID());
        x_I_ProductPlanning.saveEx();
        this.isImported = true;
    }

    private void fillValue(MPPProductPlanning mPPProductPlanning, X_I_ProductPlanning x_I_ProductPlanning) {
        for (MColumn mColumn : this.getProductPlanningColumns()) {
            if ("IsRequiredDRP".equals(mColumn.getColumnName()) || "IsRequiredMRP".equals(mColumn.getColumnName()) || "PP_Product_Planning_ID".equals(mColumn.getColumnName()) || "Updated".equals(mColumn.getColumnName()) || mColumn.getAD_Reference_ID() == 13 || x_I_ProductPlanning.get_Value(mColumn.getColumnName()) != null && mPPProductPlanning.get_Value(mColumn.getColumnName()).equals(x_I_ProductPlanning.get_Value(mColumn.getColumnName()))) continue;
            mPPProductPlanning.set_ValueOfColumn(mColumn.getColumnName(), x_I_ProductPlanning.get_Value(mColumn.getColumnName()));
        }
        mPPProductPlanning.setIsRequiredDRP(false);
        mPPProductPlanning.setIsRequiredMRP(false);
        Object var3_4 = null;
        try {
            mPPProductPlanning.saveEx();
            x_I_ProductPlanning.setPP_Product_Planning_ID(mPPProductPlanning.getPP_Product_Planning_ID());
            x_I_ProductPlanning.saveEx();
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            x_I_ProductPlanning.setI_ErrorMsg(string);
            this.isImported = false;
            return;
        }
        this.isImported = true;
    }

    private MColumn[] getProductPlanningColumns() {
        return MTable.get(this.getCtx(), "PP_Product_Planning").getColumns(false);
    }

    private MPPProductPlanning getProductPlanning(X_I_ProductPlanning x_I_ProductPlanning) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MColumn[] mColumnArray = this.getProductPlanningColumns();
        int n = 0;
        for (MColumn mColumn : mColumnArray) {
            if (!"AD_Org_ID".equals(mColumn.getColumnName()) && !"S_Resource_ID".equals(mColumn.getColumnName()) && !"M_Warehouse_ID".equals(mColumn.getColumnName()) && !"M_Product_ID".equals(mColumn.getColumnName())) continue;
            stringBuffer.append(mColumn.getColumnName()).append("=?");
            arrayList.add(x_I_ProductPlanning.get_Value(mColumn.getColumnName()));
            if (n >= 3) continue;
            stringBuffer.append(" AND ");
            ++n;
        }
        return (MPPProductPlanning)new Query(this.getCtx(), "PP_Product_Planning", stringBuffer.toString(), this.get_TrxName()).setClient_ID().setParameters(arrayList).firstOnly();
    }

    private void fillIDValues() {
        for (X_I_ProductPlanning x_I_ProductPlanning : this.getRecords(false, this.p_IsImportOnlyNoErrors)) {
            if (x_I_ProductPlanning.getC_BPartner_ID() == 0) {
                x_I_ProductPlanning.setC_BPartner_ID(this.getID("C_BPartner", "Value=?", new Object[]{x_I_ProductPlanning.getBPartner_Value()}));
            }
            if (x_I_ProductPlanning.getM_Product_ID() == 0) {
                x_I_ProductPlanning.setM_Product_ID(this.getID("M_Product", "Value=?", new Object[]{x_I_ProductPlanning.getProductValue()}));
            }
            if (x_I_ProductPlanning.getM_Warehouse_ID() == 0) {
                x_I_ProductPlanning.setM_Warehouse_ID(this.getID("M_Warehouse", "Value=?", new Object[]{x_I_ProductPlanning.getWarehouseValue()}));
            }
            if (x_I_ProductPlanning.getAD_Org_ID() == 0) {
                x_I_ProductPlanning.setAD_Org_ID(this.getID("AD_Org", "Value=?", new Object[]{x_I_ProductPlanning.getOrgValue()}));
            }
            if (x_I_ProductPlanning.getDD_NetworkDistribution_ID() == 0) {
                x_I_ProductPlanning.setDD_NetworkDistribution_ID(this.getID("DD_NetworkDistribution", "Value=?", new Object[]{x_I_ProductPlanning.getNetworkDistributionValue()}));
            }
            if (x_I_ProductPlanning.getPP_Product_BOM_ID() == 0) {
                x_I_ProductPlanning.setPP_Product_BOM_ID(this.getID("PP_Product_BOM", "Value=?", new Object[]{x_I_ProductPlanning.getProduct_BOM_Value()}));
            }
            if (x_I_ProductPlanning.getM_Forecast_ID() == 0) {
                x_I_ProductPlanning.setM_Forecast_ID(this.getID("M_Forecast", "Name=?", new Object[]{x_I_ProductPlanning.getForecastValue()}));
            }
            if (x_I_ProductPlanning.getS_Resource_ID() == 0) {
                x_I_ProductPlanning.setS_Resource_ID(this.getID("S_Resource", "Value=? AND ManufacturingResourceType=?", new Object[]{x_I_ProductPlanning.getResourceValue(), "PT"}));
            }
            x_I_ProductPlanning.saveEx();
        }
    }

    private int getID(String string, String string2, Object[] objectArray) {
        return new Query(this.getCtx(), string, string2, this.get_TrxName()).setClient_ID().setParameters(objectArray).firstId();
    }

    private Collection<X_I_ProductPlanning> getRecords(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("I_IsImported").append("=?");
        if (bl2) {
            stringBuffer.append(" AND ").append("I_ErrorMsg").append(" IS NULL");
        }
        return new Query(this.getCtx(), "I_ProductPlanning", stringBuffer.toString(), this.get_TrxName()).setClient_ID().setParameters(bl).list();
    }

    private void deleteImportedRecords() {
        if (this.p_DeleteOldImported) {
            for (X_I_ProductPlanning x_I_ProductPlanning : this.getRecords(false, this.p_IsImportOnlyNoErrors)) {
                x_I_ProductPlanning.deleteEx(true);
            }
        }
    }
}

