/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MCashLine;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class FixPaymentCashLine
extends SvrProcess {
    private static final Properties ctx = Env.getCtx();
    private static CLogger s_log = CLogger.getCLogger(FixPaymentCashLine.class);

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
    }

    @Override
    protected String doIt() throws Exception {
        String string = "SELECT cl.C_CashLine_ID, c.Name FROM C_CashLine cl INNER JOIN C_Cash c ON (c.C_Cash_ID=cl.C_Cash_ID) WHERE cl.CashType='T'";
        CPreparedStatement cPreparedStatement = null;
        try {
            cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                Trx trx = Trx.get(Trx.createTrxName(), true);
                MCashLine mCashLine = new MCashLine(Env.getCtx(), resultSet.getInt(1), trx.getTrxName());
                Integer n = mCashLine.getC_CashLine_ID();
                int n2 = 0;
                MPayment[] mPaymentArray = FixPaymentCashLine.getOfCash(Env.getCtx(), resultSet.getString(2), mCashLine.getAmount(), mCashLine.getC_BankAccount_ID(), mCashLine.getAD_Client_ID(), trx.getTrxName());
                MPayment[] mPaymentArray2 = mPaymentArray;
                int n3 = mPaymentArray2.length;
                if (n2 < n3) {
                    MPayment mPayment = mPaymentArray2[n2];
                    mCashLine.setC_Payment_ID(mPayment.getC_Payment_ID());
                    if (!mCashLine.save()) {
                        throw new IllegalStateException("Cannot assign payment to Cash Line");
                    }
                }
                trx.commit();
            }
            resultSet.close();
            cPreparedStatement.close();
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            s_log.log(Level.SEVERE, string, exception);
        }
        try {
            if (cPreparedStatement != null) {
                cPreparedStatement.close();
            }
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            cPreparedStatement = null;
        }
        return "@ProcessOK@";
    }

    public static MPayment[] getOfCash(Properties properties, String string, BigDecimal bigDecimal, int n, int n2, String string2) {
        Object object;
        String string3 = "SELECT * FROM C_Payment p WHERE p.DocumentNo=? AND R_PnRef=? AND PayAmt=? AND C_BankAccount_ID=? AND AD_Client_ID=?  AND TrxType='X' AND TenderType='X'";
        ArrayList<MPayment> arrayList = new ArrayList<MPayment>();
        CPreparedStatement cPreparedStatement = null;
        try {
            cPreparedStatement = DB.prepareStatement(string3, string2);
            cPreparedStatement.setString(1, string);
            cPreparedStatement.setString(2, string);
            cPreparedStatement.setBigDecimal(3, bigDecimal.negate());
            cPreparedStatement.setInt(4, n);
            cPreparedStatement.setInt(5, n2);
            object = cPreparedStatement.executeQuery();
            while (object.next()) {
                arrayList.add(new MPayment(properties, (ResultSet)object, string2));
            }
            object.close();
            cPreparedStatement.close();
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            s_log.log(Level.SEVERE, string3, exception);
        }
        try {
            if (cPreparedStatement != null) {
                cPreparedStatement.close();
            }
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            cPreparedStatement = null;
        }
        object = new MPayment[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public static void main(String[] stringArray) {
        Adempiere.startup(true);
        Env.setContext(Env.getCtx(), "#AD_Client_ID", 11);
        FixPaymentCashLine fixPaymentCashLine = new FixPaymentCashLine();
        try {
            fixPaymentCashLine.doIt();
        }
        catch (Exception exception) {
            System.out.println("Error" + exception.getMessage());
        }
    }
}

