/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDistributionRun;
import org.compiere.model.MDistributionRunLine;
import org.compiere.model.MDocType;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.X_M_DistributionRunLine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class DistributionRunOrders
extends SvrProcess {
    private int p_M_DistributionList_ID = 0;
    private Timestamp p_DatePromised = null;
    private int p_AD_Org_ID = 0;
    private String p_IsTest = "N";
    private int p_M_Warehouse_ID = 0;
    private String p_ConsolidateDocument = "N";
    private String p_BasedInDamnd = "N";
    private MDistributionRun m_run = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (string.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)processInfoParameterArray[i].getParameter()).intValue();
                continue;
            }
            if (string.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = ((BigDecimal)processInfoParameterArray[i].getParameter()).intValue();
                continue;
            }
            if (string.equals("M_DistributionList_ID")) {
                this.p_M_DistributionList_ID = ((BigDecimal)processInfoParameterArray[i].getParameter()).intValue();
                continue;
            }
            if (string.equals("DatePromised")) {
                this.p_DatePromised = (Timestamp)processInfoParameterArray[i].getParameter();
                continue;
            }
            if (string.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = (String)processInfoParameterArray[i].getParameter();
                continue;
            }
            if (string.equals("IsRequiredDRP")) {
                this.p_BasedInDamnd = (String)processInfoParameterArray[i].getParameter();
                continue;
            }
            if (string.equals("IsTest")) {
                this.p_IsTest = (String)processInfoParameterArray[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_BasedInDamnd.equals("Y") ? !this.generateDistributionDemand() : !this.generateDistribution()) {
            throw new Exception(Msg.getMsg(this.getCtx(), "ProcessFailed"), CLogger.retrieveException());
        }
        if (!this.executeDistribution()) {
            throw new Exception(Msg.getMsg(this.getCtx(), "ProcessFailed"), CLogger.retrieveException());
        }
        return Msg.getMsg(this.getCtx(), "ProcessOK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateDistribution() {
        this.m_run = new MDistributionRun(this.getCtx(), 0, this.get_TrxName());
        this.m_run.setName("Generate from DRP " + this.p_DatePromised);
        this.m_run.save();
        StringBuffer stringBuffer = new StringBuffer("SELECT M_Product_ID , SUM (QtyOrdered-QtyDelivered) AS TotalQty, l.M_Warehouse_ID FROM DD_OrderLine ol INNER JOIN M_Locator l ON (l.M_Locator_ID=ol.M_Locator_ID) INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID) ");
        stringBuffer.append(" WHERE o.DocStatus IN ('DR','IN') AND ol.DatePromised <= ? AND l.M_Warehouse_ID=? GROUP BY M_Product_ID");
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), this.get_TrxName());
            cPreparedStatement.setTimestamp(1, this.p_DatePromised);
            cPreparedStatement.setInt(2, this.p_M_Warehouse_ID);
            resultSet = cPreparedStatement.executeQuery();
            int n = 10;
            while (resultSet.next()) {
                int n2 = resultSet.getInt("M_Product_ID");
                BigDecimal bigDecimal = MStorage.getQtyAvailable(this.p_M_Warehouse_ID, 0, n2, 0, this.get_TrxName());
                BigDecimal bigDecimal2 = resultSet.getBigDecimal("TotalQty");
                MDistributionRunLine mDistributionRunLine = new MDistributionRunLine(this.getCtx(), 0, this.get_TrxName());
                mDistributionRunLine.setM_DistributionRun_ID(this.m_run.getM_DistributionRun_ID());
                mDistributionRunLine.setAD_Org_ID(this.p_AD_Org_ID);
                mDistributionRunLine.setM_DistributionList_ID(this.p_M_DistributionList_ID);
                mDistributionRunLine.setLine(n);
                mDistributionRunLine.setM_Product_ID(n2);
                mDistributionRunLine.setDescription(Msg.getMsg(this.getCtx(), "QtyAvailable") + " : " + bigDecimal + " " + Msg.getMsg(this.getCtx(), "QtyOrdered") + " : " + bigDecimal2);
                if (bigDecimal2.compareTo(bigDecimal) > 0) {
                    bigDecimal2 = bigDecimal;
                }
                mDistributionRunLine.setTotalQty(bigDecimal2);
                mDistributionRunLine.save();
                n += 10;
            }
        }
        catch (Exception exception) {
            boolean bl;
            try {
                this.log.log(Level.SEVERE, "doIt - " + stringBuffer, exception);
                bl = false;
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
            DB.close(resultSet, cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
            return bl;
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateDistributionDemand() {
        this.m_run = new MDistributionRun(this.getCtx(), 0, null);
        this.m_run.setName("Generate from DRP " + this.p_DatePromised);
        this.m_run.save();
        StringBuffer stringBuffer = new StringBuffer("SELECT M_Product_ID , SUM (TargetQty) AS MinQty, SUM (QtyOrdered-QtyDelivered) AS TotalQty FROM DD_OrderLine ol INNER JOIN M_Locator l ON (l.M_Locator_ID=ol.M_Locator_ID) INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID) ");
        stringBuffer.append(" WHERE o.DocStatus IN ('DR','IN') AND ol.DatePromised <= ? AND l.M_Warehouse_ID=? GROUP BY M_Product_ID");
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), this.get_TrxName());
            cPreparedStatement.setTimestamp(1, this.p_DatePromised);
            cPreparedStatement.setInt(2, this.p_M_Warehouse_ID);
            resultSet = cPreparedStatement.executeQuery();
            int n = 10;
            while (resultSet.next()) {
                Serializable serializable;
                int n2 = resultSet.getInt("M_Product_ID");
                BigDecimal bigDecimal = MStorage.getQtyAvailable(this.p_M_Warehouse_ID, 0, n2, 0, this.get_TrxName());
                if (bigDecimal.signum() <= 0) continue;
                BigDecimal bigDecimal2 = resultSet.getBigDecimal("TotalQty");
                if (bigDecimal.compareTo(bigDecimal2) >= 0) {
                    bigDecimal = bigDecimal2;
                } else {
                    serializable = this.getTargetQty(n2);
                    bigDecimal2 = bigDecimal.subtract((BigDecimal)serializable);
                }
                serializable = new MDistributionRunLine(this.getCtx(), 0, this.get_TrxName());
                ((X_M_DistributionRunLine)serializable).setM_DistributionRun_ID(this.m_run.getM_DistributionRun_ID());
                ((PO)serializable).setAD_Org_ID(this.p_AD_Org_ID);
                ((X_M_DistributionRunLine)serializable).setM_DistributionList_ID(this.p_M_DistributionList_ID);
                ((X_M_DistributionRunLine)serializable).setLine(n);
                ((X_M_DistributionRunLine)serializable).setM_Product_ID(n2);
                ((X_M_DistributionRunLine)serializable).setDescription(Msg.translate(this.getCtx(), "QtyAvailable") + " : " + bigDecimal + " " + Msg.translate(this.getCtx(), "QtyOrdered") + " : " + bigDecimal2);
                ((X_M_DistributionRunLine)serializable).setTotalQty(bigDecimal2);
                ((PO)serializable).saveEx();
                n += 10;
            }
        }
        catch (Exception exception) {
            boolean bl;
            try {
                this.log.log(Level.SEVERE, "doIt - " + stringBuffer, exception);
                bl = false;
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
            DB.close(resultSet, cPreparedStatement);
            resultSet = null;
            cPreparedStatement = null;
            return bl;
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        return true;
    }

    private BigDecimal getTargetQty(int n) {
        StringBuffer stringBuffer = new StringBuffer("SELECT SUM (TargetQty)  FROM DD_OrderLine ol INNER JOIN M_Locator l ON (l.M_Locator_ID=ol.M_Locator_ID) INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID) ");
        stringBuffer.append(" WHERE o.DocStatus IN ('DR','IN') AND ol.DatePromised <= ? AND l.M_Warehouse_ID=? AND ol.M_Product_ID=? GROUP BY M_Product_ID");
        BigDecimal bigDecimal = DB.getSQLValueBD(this.get_TrxName(), stringBuffer.toString(), this.p_DatePromised, this.p_M_Warehouse_ID, n);
        if (bigDecimal == null) {
            return Env.ZERO;
        }
        return bigDecimal;
    }

    public boolean executeDistribution() throws Exception {
        int n = 0;
        MDocType[] mDocTypeArray = MDocType.getOfDocBaseType(this.getCtx(), "DOO");
        if (mDocTypeArray == null || mDocTypeArray.length == 0) {
            this.log.severe("Not found default document type for docbasetype DOO");
            throw new Exception(Msg.getMsg(this.getCtx(), "SequenceDocNotFound"), CLogger.retrieveException());
        }
        n = mDocTypeArray[0].getC_DocType_ID();
        String string = Trx.createTrxName("Run Distribution to DRP");
        Trx trx = Trx.get(string, true);
        int n2 = 271;
        n2 = MProcess.getProcess_ID("M_DistributionRun Create", this.get_TrxName());
        MPInstance mPInstance = new MPInstance(Env.getCtx(), n2, 0);
        if (!mPInstance.save()) {
            throw new Exception(Msg.getMsg(this.getCtx(), "ProcessNoInstance"), CLogger.retrieveException());
        }
        ProcessInfo processInfo = new ProcessInfo("M_DistributionRun Orders", n2);
        processInfo.setAD_PInstance_ID(mPInstance.getAD_PInstance_ID());
        processInfo.setRecord_ID(this.m_run.getM_DistributionRun_ID());
        MPInstancePara mPInstancePara = new MPInstancePara(mPInstance, 10);
        mPInstancePara.setParameter("C_DocType_ID", n);
        if (!mPInstancePara.save()) {
            String string2 = "No Parameter added";
            throw new Exception(string2, CLogger.retrieveException());
        }
        mPInstancePara = new MPInstancePara(mPInstance, 20);
        mPInstancePara.setParameter("DatePromised", "");
        mPInstancePara.setP_Date(this.p_DatePromised);
        if (!mPInstancePara.save()) {
            String string3 = "No Parameter added";
            throw new Exception(string3, CLogger.retrieveException());
        }
        mPInstancePara = new MPInstancePara(mPInstance, 30);
        mPInstancePara.setParameter("M_Warehouse_ID", this.p_M_Warehouse_ID);
        if (!mPInstancePara.save()) {
            String string4 = "No Parameter added";
            throw new Exception(string4, CLogger.retrieveException());
        }
        mPInstancePara = new MPInstancePara(mPInstance, 40);
        mPInstancePara.setParameter("ConsolidateDocument", this.p_ConsolidateDocument);
        if (!mPInstancePara.save()) {
            String string5 = "No Parameter added";
            throw new Exception(string5, CLogger.retrieveException());
        }
        mPInstancePara = new MPInstancePara(mPInstance, 50);
        mPInstancePara.setParameter("IsTest", this.p_IsTest);
        if (!mPInstancePara.save()) {
            String string6 = "No Parameter added";
            throw new Exception(string6, CLogger.retrieveException());
        }
        mPInstancePara = new MPInstancePara(mPInstance, 60);
        mPInstancePara.setParameter("M_DistributionList_ID", this.p_M_DistributionList_ID);
        if (!mPInstancePara.save()) {
            String string7 = "No Parameter added";
            throw new Exception(string7, CLogger.retrieveException());
        }
        mPInstancePara = new MPInstancePara(mPInstance, 70);
        mPInstancePara.setParameter("IsRequiredDRP", this.p_BasedInDamnd);
        if (!mPInstancePara.save()) {
            String string8 = "No Parameter added";
            throw new Exception(string8, CLogger.retrieveException());
        }
        MProcess mProcess = new MProcess(this.getCtx(), n2, this.get_TrxName());
        mProcess.processIt(processInfo, Trx.get(this.get_TrxName(), true));
        this.m_run.delete(true);
        return true;
    }

    public String groovy(String string, Properties properties, int n, int n2, int n3) {
        MPriceListVersion mPriceListVersion = new MPriceListVersion(properties, n2, string);
        MPriceList mPriceList = new MPriceList(properties, mPriceListVersion.getM_PriceList_ID(), string);
        MWarehouse mWarehouse = new MWarehouse(properties, n, string);
        MDistributionRun mDistributionRun = new MDistributionRun(properties, 0, string);
        mDistributionRun.setName(mPriceListVersion.getName());
        mDistributionRun.setIsActive(true);
        mDistributionRun.setAD_Org_ID(mWarehouse.getAD_Org_ID());
        mDistributionRun.saveEx();
        MProductPrice[] mProductPriceArray = mPriceListVersion.getProductPrice(true);
        int n4 = 10;
        for (MProductPrice mProductPrice : mProductPriceArray) {
            int n5 = mProductPrice.getM_Product_ID();
            BigDecimal bigDecimal = MStorage.getQtyAvailable(n, n5, 0, 0, string);
            BigDecimal bigDecimal2 = MPPMRP.getQtyOnHand(properties, n, n5, string);
            MDistributionRunLine mDistributionRunLine = new MDistributionRunLine(properties, 0, string);
            mDistributionRunLine.setM_DistributionRun_ID(mDistributionRun.get_ID());
            mDistributionRunLine.setLine(n4);
            mDistributionRunLine.setM_Product_ID(n5);
            mDistributionRunLine.setM_DistributionList_ID(n3);
            mDistributionRunLine.setDescription(Msg.translate(properties, "QtyAvailable") + " = " + bigDecimal + " | " + Msg.translate(properties, "QtyOnHand") + " = " + bigDecimal2);
            mDistributionRunLine.setTotalQty(bigDecimal);
            mDistributionRunLine.saveEx();
        }
        return "";
    }

    public String groovy1(String string, Properties properties, int n, int n2, int n3) {
        MDistributionRunLine mDistributionRunLine = new MDistributionRunLine(properties, 0, string);
        MProduct mProduct = MProduct.get(properties, mDistributionRunLine.getM_Product_ID());
        BigDecimal bigDecimal = mDistributionRunLine.getTotalQty();
        int n4 = mDistributionRunLine.getLine();
        int n5 = 1;
        if (mProduct.isBOM() && bigDecimal.signum() > 0) {
            ++n4;
            MPPProductBOM mPPProductBOM = MPPProductBOM.getDefault(mProduct, string);
            for (MPPProductBOMLine mPPProductBOMLine : mPPProductBOM.getLines()) {
                ++n5;
                int n6 = mPPProductBOMLine.getM_Product_ID();
                BigDecimal bigDecimal2 = mPPProductBOMLine.getQtyBOM().multiply(bigDecimal);
                BigDecimal bigDecimal3 = MStorage.getQtyAvailable(n, n6, 0, 0, string);
                BigDecimal bigDecimal4 = MPPMRP.getQtyOnHand(properties, n, n6, string);
                BigDecimal bigDecimal5 = bigDecimal2;
                if (bigDecimal2.compareTo(bigDecimal3) > 0) {
                    bigDecimal5 = bigDecimal3;
                }
                MDistributionRunLine mDistributionRunLine2 = new MDistributionRunLine(properties, 0, string);
                mDistributionRunLine2.setM_DistributionRun_ID(mDistributionRunLine.getM_DistributionRun_ID());
                mDistributionRunLine2.setLine(n4);
                mDistributionRunLine2.setM_Product_ID(n6);
                mDistributionRunLine2.setM_DistributionList_ID(mDistributionRunLine.getM_DistributionList_ID());
                mDistributionRunLine2.setDescription(Msg.translate(properties, "QtyRequiered") + " = " + bigDecimal2.intValue() + " | " + Msg.translate(properties, "QtyAvailable") + " = " + bigDecimal3 + " | " + Msg.translate(properties, "QtyOnHand") + " = " + bigDecimal4);
                mDistributionRunLine2.setTotalQty(bigDecimal5);
                mDistributionRunLine2.saveEx();
            }
        }
        mDistributionRunLine.setIsActive(false);
        return "Componentes del Juego:" + n5;
    }
}

