/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MWarehouse;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductPlanning;

public class CreateProductPlanning
extends SvrProcess {
    private int p_M_Product_Category_ID = 0;
    private int p_M_Warehouse_ID = 0;
    private int p_S_Resource_ID = 0;
    private int p_Planner = 0;
    private BigDecimal p_DeliveryTime_Promised = Env.ZERO;
    private int p_DD_NetworkDistribution_ID = 0;
    private int p_AD_Workflow_ID = 0;
    private BigDecimal p_TimeFence = Env.ZERO;
    private boolean p_CreatePlan = false;
    private boolean p_MPS = false;
    private String p_OrderPolicy = "";
    private BigDecimal p_OrderPeriod = Env.ZERO;
    private BigDecimal p_TransferTime = Env.ZERO;
    private BigDecimal p_SafetyStock = Env.ZERO;
    private BigDecimal p_Order_Min = Env.ZERO;
    private BigDecimal p_Order_Max = Env.ZERO;
    private BigDecimal p_Order_Pack = Env.ZERO;
    private BigDecimal p_Order_Qty = Env.ZERO;
    private BigDecimal p_WorkingTime = Env.ZERO;
    private int p_Yield = 0;
    private int m_AD_Org_ID = 0;
    private int m_AD_Client_ID = 0;
    private int count_created = 0;
    private int count_updated = 0;
    private int count_error = 0;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("S_Resource_ID")) {
                this.p_S_Resource_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("IsCreatePlan")) {
                this.p_CreatePlan = "Y".equals((String)processInfoParameter.getParameter());
                continue;
            }
            if (string.equals("IsMPS")) {
                this.p_MPS = "Y".equals((String)processInfoParameter.getParameter());
                continue;
            }
            if (string.equals("DD_NetworkDistribution_ID")) {
                this.p_DD_NetworkDistribution_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("AD_Workflow_ID")) {
                this.p_AD_Workflow_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("TimeFence")) {
                this.p_TimeFence = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("TransfertTime")) {
                this.p_TransferTime = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("SafetyStock")) {
                this.p_SafetyStock = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("Order_Min")) {
                this.p_Order_Min = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("Order_Max")) {
                this.p_Order_Max = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("Order_Pack")) {
                this.p_Order_Pack = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("Order_Qty")) {
                this.p_Order_Qty = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("WorkingTime")) {
                this.p_WorkingTime = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("Yield")) {
                this.p_Yield = ((BigDecimal)processInfoParameter.getParameter()).intValue();
                continue;
            }
            if (string.equals("DeliveryTime_Promised")) {
                this.p_DeliveryTime_Promised = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("Order_Period")) {
                this.p_OrderPeriod = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("Order_Policy")) {
                this.p_OrderPolicy = (String)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("Planner_ID")) {
                this.p_Planner = processInfoParameter.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
        this.m_AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
        if (this.p_M_Warehouse_ID > 0) {
            MWarehouse mWarehouse = MWarehouse.get(this.getCtx(), this.p_M_Warehouse_ID);
            this.m_AD_Org_ID = mWarehouse.getAD_Org_ID();
        }
    }

    @Override
    protected String doIt() throws Exception {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string = "SELECT p.M_Product_ID FROM M_Product p WHERE p.AD_Client_ID=?";
        arrayList.add(this.m_AD_Client_ID);
        if (this.p_M_Product_Category_ID > 0) {
            string = string + " AND p.M_Product_Category_ID=?";
            arrayList.add(this.p_M_Product_Category_ID);
        }
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
            DB.setParameters((PreparedStatement)cPreparedStatement, arrayList);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                this.createPlanning(n);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException(sQLException, string);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        return "@Created@ #" + this.count_created + " @Updated@ #" + this.count_updated + " @Error@ #" + this.count_error;
    }

    private void createPlanning(int n) {
        boolean bl;
        MPPProductPlanning mPPProductPlanning = MPPProductPlanning.get(this.getCtx(), this.m_AD_Client_ID, this.m_AD_Org_ID, this.p_M_Warehouse_ID, this.p_S_Resource_ID, n, this.get_TrxName());
        boolean bl2 = bl = mPPProductPlanning == null;
        if (mPPProductPlanning == null) {
            mPPProductPlanning = new MPPProductPlanning(this.getCtx(), 0, this.get_TrxName());
            mPPProductPlanning.setAD_Org_ID(this.m_AD_Org_ID);
            mPPProductPlanning.setM_Warehouse_ID(this.p_M_Warehouse_ID);
            mPPProductPlanning.setS_Resource_ID(this.p_S_Resource_ID);
            mPPProductPlanning.setM_Product_ID(n);
        }
        mPPProductPlanning.setDD_NetworkDistribution_ID(this.p_DD_NetworkDistribution_ID);
        mPPProductPlanning.setAD_Workflow_ID(this.p_AD_Workflow_ID);
        mPPProductPlanning.setIsCreatePlan(this.p_CreatePlan);
        mPPProductPlanning.setIsMPS(this.p_MPS);
        mPPProductPlanning.setIsRequiredMRP(true);
        mPPProductPlanning.setIsRequiredDRP(true);
        mPPProductPlanning.setDeliveryTime_Promised(this.p_DeliveryTime_Promised);
        mPPProductPlanning.setOrder_Period(this.p_OrderPeriod);
        mPPProductPlanning.setPlanner_ID(this.p_Planner);
        mPPProductPlanning.setOrder_Policy(this.p_OrderPolicy);
        mPPProductPlanning.setSafetyStock(this.p_SafetyStock);
        mPPProductPlanning.setOrder_Qty(this.p_Order_Qty);
        mPPProductPlanning.setOrder_Min(this.p_Order_Min);
        mPPProductPlanning.setOrder_Max(this.p_Order_Max);
        mPPProductPlanning.setOrder_Pack(this.p_Order_Pack);
        mPPProductPlanning.setTimeFence(this.p_TimeFence);
        mPPProductPlanning.setTransfertTime(this.p_TransferTime);
        mPPProductPlanning.setIsPhantom(false);
        mPPProductPlanning.setWorkingTime(this.p_WorkingTime);
        mPPProductPlanning.setYield(this.p_Yield);
        if (!mPPProductPlanning.save()) {
            ++this.count_error;
        }
        if (bl) {
            ++this.count_created;
        } else {
            ++this.count_updated;
        }
    }
}

