/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.engines.CostDimension;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class CopyPriceToStandard
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private int p_M_CostType_ID = 0;
    private int p_M_CostElement_ID = 0;
    private int p_M_PriceList_Version_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (string.equals("M_CostType_ID")) {
                this.p_M_CostType_ID = ((BigDecimal)processInfoParameterArray[i].getParameter()).intValue();
                continue;
            }
            if (string.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)processInfoParameterArray[i].getParameter()).intValue();
                continue;
            }
            if (string.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = ((BigDecimal)processInfoParameterArray[i].getParameter()).intValue();
                continue;
            }
            if (string.equals("M_CostElement_ID")) {
                this.p_M_CostElement_ID = ((BigDecimal)processInfoParameterArray[i].getParameter()).intValue();
                continue;
            }
            if (string.equals("M_PriceList_Version_ID")) {
                this.p_M_PriceList_Version_ID = ((BigDecimal)processInfoParameterArray[i].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        MAcctSchema mAcctSchema = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
        MCostElement mCostElement = MCostElement.get(this.getCtx(), this.p_M_CostElement_ID);
        if (!"M".equals(mCostElement.getCostElementType())) {
            throw new AdempiereException("Only Material Cost Elements are allowed");
        }
        int n = 0;
        MPriceListVersion mPriceListVersion = new MPriceListVersion(this.getCtx(), this.p_M_PriceList_Version_ID, this.get_TrxName());
        block0: for (MProductPrice mProductPrice : mPriceListVersion.getProductPrice(" AND PriceStd<>0")) {
            BigDecimal bigDecimal = mProductPrice.getPriceStd();
            int n2 = mPriceListVersion.getPriceList().getC_Currency_ID();
            if (n2 != mAcctSchema.getC_Currency_ID()) {
                bigDecimal = MConversionRate.convert(this.getCtx(), mProductPrice.getPriceStd(), n2, mAcctSchema.getC_Currency_ID(), this.getAD_Client_ID(), this.p_AD_Org_ID);
            }
            MProduct mProduct = MProduct.get(this.getCtx(), mProductPrice.getM_Product_ID());
            CostDimension costDimension = new CostDimension(mProduct, mAcctSchema, this.p_M_CostType_ID, this.p_AD_Org_ID, 0, this.p_M_CostElement_ID);
            List list = costDimension.toQuery(MCost.class, this.get_TrxName()).list();
            for (MCost mCost : list) {
                if (mCost.getM_CostElement_ID() != mCostElement.get_ID()) continue;
                mCost.setFutureCostPrice(bigDecimal);
                mCost.saveEx();
                ++n;
                continue block0;
            }
        }
        return "@Updated@ #" + n;
    }
}

