/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class CopyFromBOM
extends SvrProcess {
    private int p_Record_ID = 0;
    private int p_PP_Product_BOM_ID = 0;
    private int no = 0;
    private Properties ctx = Env.getCtx();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (string.equals("PP_Product_BOM_ID")) {
                this.p_PP_Product_BOM_ID = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MPPProductBOMLine[] mPPProductBOMLineArray;
        this.log.info("From PP_Product_BOM_ID=" + this.p_PP_Product_BOM_ID + " to " + this.p_Record_ID);
        if (this.p_Record_ID == 0) {
            throw new IllegalArgumentException("Target PP_Product_BOM_ID == 0");
        }
        if (this.p_PP_Product_BOM_ID == 0) {
            throw new IllegalArgumentException("Source PP_Product_BOM_ID == 0");
        }
        if (this.p_Record_ID == this.p_PP_Product_BOM_ID) {
            return "";
        }
        MPPProductBOM mPPProductBOM = new MPPProductBOM(this.ctx, this.p_PP_Product_BOM_ID, this.get_TrxName());
        MPPProductBOM mPPProductBOM2 = new MPPProductBOM(this.ctx, this.p_Record_ID, this.get_TrxName());
        if (mPPProductBOM2.getLines().length > 0) {
            throw new AdempiereSystemError("@Error@ Existing BOM Line(s)");
        }
        for (MPPProductBOMLine mPPProductBOMLine : mPPProductBOMLineArray = mPPProductBOM.getLines()) {
            MPPProductBOMLine mPPProductBOMLine2 = new MPPProductBOMLine(this.ctx, 0, this.get_TrxName());
            MPPProductBOMLine.copyValues(mPPProductBOMLine, mPPProductBOMLine2);
            mPPProductBOMLine2.setPP_Product_BOM_ID(mPPProductBOM2.getPP_Product_BOM_ID());
            mPPProductBOMLine2.save();
            ++this.no;
        }
        return "OK";
    }

    @Override
    protected void postProcess(boolean bl) {
        this.addLog("@Copied@=" + this.no);
    }
}

