/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MRefList;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.eevolution.model.MPPProductBOMLine;

public class ComponentChange
extends SvrProcess {
    private static final int ACTION_AD_Reference_ID = 53227;
    private static final String ACTION_Add = "A";
    private static final String ACTION_Deactivate = "D";
    private static final String ACTION_Expire = "E";
    private static final String ACTION_Replace = "R";
    private static final String ACTION_ReplaceAndExpire = "RE";
    private int p_M_Product_ID = 0;
    private Timestamp p_ValidTo = null;
    private Timestamp p_ValidFrom = null;
    private String p_Action;
    private int p_New_M_Product_ID = 0;
    private BigDecimal p_Qty = null;
    private int p_M_ChangeNotice_ID = 0;

    @Override
    protected void prepare() {
        boolean bl = false;
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("M_Product_ID") && !bl) {
                this.p_M_Product_ID = processInfoParameter.getParameterAsInt();
                bl = true;
                continue;
            }
            if (string.equals("ValidTo")) {
                this.p_ValidTo = (Timestamp)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("ValidFrom")) {
                this.p_ValidFrom = (Timestamp)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("Action")) {
                this.p_Action = (String)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("M_Product_ID")) {
                this.p_New_M_Product_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("Qty")) {
                this.p_Qty = (BigDecimal)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("M_ChangeNotice_ID")) {
                this.p_M_ChangeNotice_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_Action == null) {
            throw new FillMandatoryException(new String[]{"Action"});
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("M_Product_ID=?");
        arrayList.add(this.p_M_Product_ID);
        if (this.p_ValidTo != null) {
            stringBuffer.append(" AND TRUNC(ValidTo) <= ?");
            arrayList.add(this.p_ValidTo);
        }
        if (this.p_ValidFrom != null) {
            stringBuffer.append(" AND TRUNC(ValidFrom) >= ?");
            arrayList.add(this.p_ValidFrom);
        }
        List list = new Query(this.getCtx(), "PP_Product_BOMLine", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).list();
        for (MPPProductBOMLine mPPProductBOMLine : list) {
            if (this.p_Action.equals(ACTION_Add)) {
                this.actionAdd(mPPProductBOMLine, 0);
            } else if (this.p_Action.equals(ACTION_Deactivate)) {
                this.actionDeactivate(mPPProductBOMLine);
            } else if (this.p_Action.equals(ACTION_Expire)) {
                this.actionExpire(mPPProductBOMLine);
            } else if (this.p_Action.equals(ACTION_Replace)) {
                this.actionAdd(mPPProductBOMLine, mPPProductBOMLine.getLine() + 1);
                this.actionDeactivate(mPPProductBOMLine);
            } else if (this.p_Action.equals(ACTION_ReplaceAndExpire)) {
                this.actionAdd(mPPProductBOMLine, mPPProductBOMLine.getLine() + 1);
                this.actionExpire(mPPProductBOMLine);
            } else {
                throw new AdempiereException("Action not supported - " + this.p_Action);
            }
            this.addLog(MRefList.getListName(this.getCtx(), 53227, this.p_Action));
        }
        return "@OK@";
    }

    protected void actionAdd(MPPProductBOMLine mPPProductBOMLine, int n) {
        MPPProductBOMLine mPPProductBOMLine2 = new MPPProductBOMLine(this.getCtx(), 0, this.get_TrxName());
        MPPProductBOMLine.copyValues(mPPProductBOMLine, mPPProductBOMLine2);
        mPPProductBOMLine2.setIsActive(true);
        mPPProductBOMLine2.setLine(n);
        mPPProductBOMLine2.setM_ChangeNotice_ID(this.p_M_ChangeNotice_ID);
        mPPProductBOMLine2.setM_Product_ID(this.p_New_M_Product_ID);
        if (this.p_Qty.signum() != 0) {
            mPPProductBOMLine2.setQtyBOM(this.p_Qty);
        }
        mPPProductBOMLine2.setValidFrom(mPPProductBOMLine2.getUpdated());
        mPPProductBOMLine2.saveEx();
    }

    protected void actionDeactivate(MPPProductBOMLine mPPProductBOMLine) {
        mPPProductBOMLine.setIsActive(false);
        mPPProductBOMLine.setM_ChangeNotice_ID(this.p_M_ChangeNotice_ID);
        mPPProductBOMLine.saveEx();
    }

    protected void actionExpire(MPPProductBOMLine mPPProductBOMLine) {
        mPPProductBOMLine.setIsActive(true);
        mPPProductBOMLine.setValidTo(mPPProductBOMLine.getUpdated());
        mPPProductBOMLine.setM_ChangeNotice_ID(this.p_M_ChangeNotice_ID);
        mPPProductBOMLine.saveEx();
    }
}

