/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.X_PP_Order;

public class CompletePrintOrder
extends SvrProcess
implements ClientProcess {
    private int p_PP_Order_ID = 0;
    private boolean p_IsPrintPickList = false;
    private boolean p_IsPrintWorkflow = false;
    private boolean p_IsPrintPackList = false;
    private boolean p_IsComplete = false;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("PP_Order_ID")) {
                this.p_PP_Order_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("IsPrintPickList")) {
                this.p_IsPrintPickList = processInfoParameter.getParameterAsBoolean();
                continue;
            }
            if (string.equals("IsPrintWorkflow")) {
                this.p_IsPrintWorkflow = processInfoParameter.getParameterAsBoolean();
                continue;
            }
            if (string.equals("IsPrintPackingList")) {
                this.p_IsPrintPackList = processInfoParameter.getParameterAsBoolean();
                continue;
            }
            if (string.equals("IsComplete")) {
                this.p_IsComplete = processInfoParameter.getParameterAsBoolean();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        Object object;
        if (this.p_PP_Order_ID == 0) {
            throw new FillMandatoryException(new String[]{"PP_Order_ID"});
        }
        if (this.p_IsComplete) {
            object = new MPPOrder(this.getCtx(), this.p_PP_Order_ID, this.get_TrxName());
            if (!((MPPOrder)object).isAvailable()) {
                throw new AdempiereException("@NoQtyAvailable@");
            }
            boolean bl = ((MPPOrder)object).processIt("CO");
            ((PO)object).saveEx();
            if (!bl) {
                throw new AdempiereException(((MPPOrder)object).getProcessMsg());
            }
            if (!"CO".equals(((X_PP_Order)object).getDocStatus())) {
                throw new AdempiereException(((MPPOrder)object).getProcessMsg());
            }
        }
        if (this.p_IsPrintPickList) {
            object = this.getReportEngine("Manufacturing_Order_BOM_Header ** TEMPLATE **", "PP_Order_BOM_Header_v");
            if (object == null) {
                return "";
            }
            ReportCtl.preview((ReportEngine)object);
            ((ReportEngine)object).print();
        }
        if (this.p_IsPrintPackList) {
            object = this.getReportEngine("Manufacturing_Order_BOM_Header_Packing ** TEMPLATE **", "PP_Order_BOM_Header_v");
            if (object == null) {
                return "";
            }
            ReportCtl.preview((ReportEngine)object);
            ((ReportEngine)object).print();
        }
        if (this.p_IsPrintWorkflow) {
            object = this.getReportEngine("Manufacturing_Order_Workflow_Header ** TEMPLATE **", "PP_Order_Workflow_Header_v");
            if (object == null) {
                return "";
            }
            ReportCtl.preview((ReportEngine)object);
            ((ReportEngine)object).print();
        }
        return "@OK@";
    }

    private ReportEngine getReportEngine(String string, String string2) {
        int n = MPrintFormat.getPrintFormat_ID(string, MTable.getTable_ID(string2), this.getAD_Client_ID());
        MPrintFormat mPrintFormat = MPrintFormat.get(this.getCtx(), n, true);
        if (mPrintFormat == null) {
            this.addLog("@NotFound@ @AD_PrintFormat_ID@");
            return null;
        }
        MQuery mQuery = new MQuery(string2);
        mQuery.addRestriction("PP_Order_ID", "=", this.p_PP_Order_ID);
        PrintInfo printInfo = new PrintInfo(string2, MTable.getTable_ID(string2), this.p_PP_Order_ID);
        ReportEngine reportEngine = new ReportEngine(this.getCtx(), mPrintFormat, mQuery, printInfo);
        return reportEngine;
    }
}

