/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MUOM;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.X_T_MRP_CRP;

public class CRPSummary
extends SvrProcess {
    private int p_S_Resource_ID = 0;
    private Timestamp p_DateFrom = null;
    private Timestamp p_DateTo = null;
    private String p_FrequencyType = null;
    private int AD_Client_ID = 0;
    private int AD_PInstance_ID = 0;

    @Override
    protected void prepare() {
        this.AD_Client_ID = Integer.parseInt(Env.getContext(Env.getCtx(), "#AD_Client_ID"));
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        this.AD_PInstance_ID = this.getAD_PInstance_ID();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) continue;
            if (string.equals("S_Resource_ID")) {
                this.p_S_Resource_ID = ((BigDecimal)processInfoParameterArray[i].getParameter()).intValue();
                continue;
            }
            if (string.equals("DateFrom")) {
                this.p_DateFrom = (Timestamp)processInfoParameterArray[i].getParameter();
                continue;
            }
            if (string.equals("DateTo")) {
                this.p_DateTo = (Timestamp)processInfoParameterArray[i].getParameter();
                continue;
            }
            if (string.equals("FrequencyType")) {
                this.p_FrequencyType = (String)processInfoParameterArray[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        return this.runCRP();
    }

    protected String runCRP() {
        return "";
    }

    public static Timestamp addSecond(Timestamp timestamp, long l) {
        if (timestamp == null) {
            timestamp = new Timestamp(System.currentTimeMillis());
        }
        if (l == 0L) {
            return timestamp;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(timestamp);
        gregorianCalendar.add(13, new Long(l).intValue());
        return new Timestamp(gregorianCalendar.getTimeInMillis());
    }

    public long getHoursAvailable(Timestamp timestamp, Timestamp timestamp2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(timestamp.getTime());
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(timestamp2.getTime());
        Date date = gregorianCalendar.getTime();
        Date date2 = gregorianCalendar2.getTime();
        long l = date.getTime();
        long l2 = date2.getTime();
        long l3 = l2 - l;
        System.out.println("Elapsed milliseconds: " + l3);
        return l3;
    }

    public int getNotAvailbleDays(Timestamp timestamp, Timestamp timestamp2, MResourceType mResourceType) {
        GregorianCalendar gregorianCalendar;
        GregorianCalendar gregorianCalendar2;
        if (!mResourceType.isDateSlot()) {
            return 0;
        }
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
        gregorianCalendar3.setTimeInMillis(timestamp.getTime());
        GregorianCalendar gregorianCalendar4 = new GregorianCalendar();
        gregorianCalendar4.setTimeInMillis(timestamp2.getTime());
        if (gregorianCalendar4.after(gregorianCalendar3)) {
            gregorianCalendar2 = (GregorianCalendar)gregorianCalendar4.clone();
            gregorianCalendar = (GregorianCalendar)gregorianCalendar3.clone();
        } else {
            gregorianCalendar2 = (GregorianCalendar)gregorianCalendar3.clone();
            gregorianCalendar = (GregorianCalendar)gregorianCalendar4.clone();
        }
        gregorianCalendar.clear(14);
        gregorianCalendar.clear(13);
        gregorianCalendar.clear(12);
        gregorianCalendar.clear(11);
        gregorianCalendar2.clear(14);
        gregorianCalendar2.clear(13);
        gregorianCalendar2.clear(12);
        gregorianCalendar2.clear(11);
        int n = 0;
        while (gregorianCalendar.before(gregorianCalendar2)) {
            gregorianCalendar.add(5, 1);
            switch (gregorianCalendar.get(7)) {
                case 1: {
                    if (mResourceType.isOnSunday()) break;
                    ++n;
                    break;
                }
                case 2: {
                    if (mResourceType.isOnMonday()) break;
                    ++n;
                    break;
                }
                case 3: {
                    if (mResourceType.isOnTuesday()) break;
                    ++n;
                    break;
                }
                case 4: {
                    if (mResourceType.isOnWednesday()) break;
                    ++n;
                    break;
                }
                case 5: {
                    if (mResourceType.isOnThursday()) break;
                    ++n;
                    break;
                }
                case 6: {
                    if (mResourceType.isOnFriday()) break;
                    ++n;
                    break;
                }
                case 7: {
                    if (mResourceType.isOnSaturday()) break;
                    ++n;
                }
            }
        }
        System.out.println("DaysNotAvialable" + n);
        return n;
    }

    public void Summary(Timestamp timestamp, Timestamp timestamp2, MResource mResource) {
        int n;
        Serializable serializable;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(timestamp.getTime());
        gregorianCalendar.clear(14);
        gregorianCalendar.clear(13);
        gregorianCalendar.clear(12);
        gregorianCalendar.clear(11);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeInMillis(timestamp2.getTime());
        gregorianCalendar2.clear(14);
        gregorianCalendar2.clear(13);
        gregorianCalendar2.clear(12);
        gregorianCalendar2.clear(11);
        MResourceType mResourceType = MResourceType.get(Env.getCtx(), mResource.getS_ResourceType_ID());
        long l = 0L;
        l = mResourceType.isTimeSlot() ? this.getHoursAvailable(mResourceType.getTimeSlotStart(), mResourceType.getTimeSlotStart()) : 24L;
        boolean bl = false;
        ArrayList<Col> arrayList = new ArrayList<Col>();
        int n2 = 0;
        boolean bl2 = true;
        int n3 = 0;
        Col col = new Col();
        col.setFrom("Past Due");
        col.setTo(timestamp.toString());
        col.setDays(0);
        col.setCapacity(0);
        col.setLoad(0);
        col.setSummary(0);
        arrayList.add(0, col);
        ++n2;
        while (gregorianCalendar.before(gregorianCalendar2)) {
            gregorianCalendar.add(5, 1);
            switch (gregorianCalendar.get(7)) {
                case 1: {
                    if (!mResourceType.isOnSunday()) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (!mResourceType.isOnMonday()) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (!mResourceType.isOnTuesday()) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (!mResourceType.isOnWednesday()) break;
                    bl = true;
                    break;
                }
                case 5: {
                    if (!mResourceType.isOnThursday()) break;
                    bl = true;
                    break;
                }
                case 6: {
                    if (!mResourceType.isOnFriday()) break;
                    bl = true;
                    break;
                }
                case 7: {
                    if (!mResourceType.isOnSaturday()) break;
                    bl = true;
                }
            }
            if (!bl) continue;
            col = new Col();
            col.setFrom(gregorianCalendar.getTime().toString());
            col.setTo(gregorianCalendar.getTime().toString());
            col.setDays(1);
            Long l2 = new Long(l);
            col.setCapacity(l2.intValue());
            int n4 = DB.getSQLValue(null, "SELECT C_UOM_ID FROM M_Product WHERE S_Resource_ID = ? ", mResource.getS_Resource_ID());
            MUOM mUOM = MUOM.get(this.getCtx(), n4);
            if (mUOM.isHour()) {
                serializable = new Timestamp(gregorianCalendar.getTimeInMillis());
                int n5 = this.getLoad(mResource.getS_Resource_ID(), (Timestamp)serializable, (Timestamp)serializable);
                col.setLoad(n5 / 3600);
            }
            col.setSummary(n3 + col.getDifference());
            n3 = col.getSummary();
            arrayList.add(n2, col);
        }
        n2 = 0;
        boolean bl3 = true;
        Col[] colArray = new Col[arrayList.size()];
        for (n = 0; n <= colArray.length; ++n) {
        }
        for (n = 0; n <= colArray.length; ++n) {
            if (bl3) {
                serializable = new X_T_MRP_CRP(this.getCtx(), 0, null);
                serializable.setDescription("CRP Resource" + mResource.getName());
            }
            switch (n2) {
                case 0: {
                    ++n2;
                }
                case 1: {
                    ++n2;
                }
                case 2: {
                    ++n2;
                }
                case 3: {
                    ++n2;
                }
                case 4: {
                    ++n2;
                }
                case 5: {
                    ++n2;
                }
                case 6: {
                    ++n2;
                }
                case 7: {
                    ++n2;
                }
                case 8: {
                    ++n2;
                }
                case 9: {
                    ++n2;
                }
                case 10: {
                    ++n2;
                }
                case 11: {
                    ++n2;
                }
                case 12: {
                    n2 = 0;
                    bl3 = true;
                }
            }
            ++n2;
        }
    }

    int getLoad(int n, Timestamp timestamp, Timestamp timestamp2) {
        int n2 = 0;
        String string = "SELECT SUM( CASE WHEN ow.DurationUnit = 's'  THEN 1 * (onode.QueuingTime + onode.SetupTime + (onode.Duration * (o.QtyOrdered - o.QtyDelivered - o.QtyScrap)) + onode.MovingTime + onode.WaitingTime) WHEN ow.DurationUnit = 'm' THEN 60 * (onode.QueuingTime + onode.SetupTime + (onode.Duration * (o.QtyOrdered - o.QtyDelivered - o.QtyScrap)) + onode.MovingTime + onode.WaitingTime) WHEN ow.DurationUnit = 'h'  THEN 3600 * (onode.QueuingTime + onode.SetupTime + (onode.Duration * (o.QtyOrdered - o.QtyDelivered - o.QtyScrap)) + onode.MovingTime + onode.WaitingTime) WHEN ow.DurationUnit = 'Y'  THEN 31536000 *  (onode.QueuingTime + onode.SetupTime + (onode.Duration * (o.QtyOrdered - o.QtyDelivered - o.QtyScrap)) + onode.MovingTime + onode.WaitingTime) WHEN ow.DurationUnit = 'M' THEN 2592000 * (onode.QueuingTime + onode.SetupTime + (onode.Duration * (o.QtyOrdered - o.QtyDelivered - o.QtyScrap)) + onode.MovingTime + onode.WaitingTime) WHEN ow.DurationUnit = 'D' THEN 86400 END ) AS Load FROM PP_Order_Node onode INNER JOIN PP_Order_Workflow ow ON (ow.PP_Order_Workflow_ID =  onode.PP_Order_Workflow_ID) INNER JOIN PP_Order o ON (o.PP_Order_ID = onode.PP_Order_ID)  WHERE onode. = ?  AND onode.DateStartSchedule => ? AND onode.DateFinishSchedule =< ? AND onode.AD_Client_ID = ?";
        try {
            CPreparedStatement cPreparedStatement = null;
            cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
            cPreparedStatement.setInt(1, n);
            cPreparedStatement.setTimestamp(1, timestamp);
            cPreparedStatement.setTimestamp(2, timestamp2);
            cPreparedStatement.setInt(3, this.AD_Client_ID);
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            cPreparedStatement.close();
            return n2;
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, "doIt - " + string, exception);
            return 0;
        }
    }

    private class Col {
        int Day = 0;
        String From = null;
        String To = null;
        int Capacity = 0;
        int Load = 0;
        int Summary = 0;

        void setDays(int n) {
            this.Day = n;
        }

        int getDays() {
            return this.Day;
        }

        void setCapacity(int n) {
            this.Capacity = n;
        }

        int getCapacity() {
            return this.Capacity;
        }

        void setLoad(int n) {
            this.Load = n;
        }

        int getLoad() {
            return this.Load;
        }

        int getDifference() {
            return this.Capacity - this.Load;
        }

        void setSummary(int n) {
            this.Summary = n;
        }

        int getSummary() {
            return this.Summary;
        }

        void setFrom(String string) {
            this.From = string;
        }

        String getFrom() {
            return this.From;
        }

        void setTo(String string) {
            this.To = string;
        }

        String getTo() {
            return this.To;
        }
    }
}

