/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.compiere.model.I_S_Resource;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.TimeUtil;
import org.eevolution.exceptions.CRPException;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.model.MPPOrderWorkflow;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;
import org.eevolution.model.reasoner.CRPReasoner;

public class CRP
extends SvrProcess {
    public static final String FORWARD_SCHEDULING = "F";
    public static final String BACKWARD_SCHEDULING = "B";
    private int p_S_Resource_ID;
    private String p_ScheduleType;
    private int p_MaxIterationsNo = -1;
    public static final String SYSCONFIG_MaxIterationsNo = "CRP.MaxIterationsNo";
    public static final int DEFAULT_MaxIterationsNo = 1000;
    public RoutingService routingService = null;
    private CRPReasoner reasoner;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) {
                // empty if block
            }
            if (string.equals("S_Resource_ID")) {
                this.p_S_Resource_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("ScheduleType")) {
                this.p_ScheduleType = (String)processInfoParameter.getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + string);
        }
        this.p_MaxIterationsNo = MSysConfig.getIntValue(SYSCONFIG_MaxIterationsNo, 1000, this.getAD_Client_ID());
    }

    @Override
    protected String doIt() throws Exception {
        this.reasoner = new CRPReasoner();
        this.routingService = RoutingServiceFactory.get().getRoutingService(this.getAD_Client_ID());
        return this.runCRP();
    }

    private String runCRP() {
        Iterator iterator = this.reasoner.getPPOrdersNotCompletedQuery(this.p_S_Resource_ID, this.get_TrxName()).iterate();
        while (iterator.hasNext()) {
            MPPOrder mPPOrder = (MPPOrder)iterator.next();
            try {
                this.runCRP(mPPOrder);
            }
            catch (Exception exception) {
                if (exception instanceof CRPException) {
                    CRPException cRPException = (CRPException)exception;
                    cRPException.setPP_Order(mPPOrder);
                    throw cRPException;
                }
                CRPException cRPException = new CRPException(exception);
                throw cRPException;
            }
        }
        return "OK";
    }

    public void runCRP(MPPOrder mPPOrder) {
        this.log.info("PP_Order DocumentNo:" + mPPOrder.getDocumentNo());
        MPPOrderWorkflow mPPOrderWorkflow = mPPOrder.getMPPOrderWorkflow();
        if (mPPOrderWorkflow == null) {
            this.addLog("WARNING: No workflow found - " + mPPOrder);
            return;
        }
        this.log.info("PP_Order Workflow:" + mPPOrderWorkflow.getName());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.p_ScheduleType.equals(FORWARD_SCHEDULING)) {
            Timestamp timestamp = mPPOrder.getDateStartSchedule();
            int n = mPPOrderWorkflow.getPP_Order_Node_ID();
            MPPOrderNode mPPOrderNode = null;
            while (n != 0) {
                mPPOrderNode = mPPOrderWorkflow.getNode(n);
                if (arrayList.contains(n)) {
                    throw new CRPException("Cyclic transition found").setPP_Order_Node(mPPOrderNode);
                }
                arrayList.add(n);
                this.log.info("PP_Order Node:" + mPPOrderNode.getName() != null ? mPPOrderNode.getName() : (" Description:" + mPPOrderNode.getDescription() != null ? mPPOrderNode.getDescription() : ""));
                MResource mResource = MResource.get(this.getCtx(), mPPOrderNode.getS_Resource_ID());
                if (mResource == null) {
                    n = mPPOrderWorkflow.getNext(n, this.getAD_Client_ID());
                    continue;
                }
                if (!this.reasoner.isAvailable(mResource)) {
                    throw new CRPException("@ResourceNotInSlotDay@").setS_Resource(mResource);
                }
                long l = this.calculateMillisFor(mPPOrderNode, mPPOrderWorkflow.getDurationBaseSec());
                Timestamp timestamp2 = this.scheduleForward(timestamp, l, mResource);
                mPPOrderNode.setDateStartSchedule(timestamp);
                mPPOrderNode.setDateFinishSchedule(timestamp2);
                mPPOrderNode.saveEx();
                timestamp = mPPOrderNode.getDateFinishSchedule();
                n = mPPOrderWorkflow.getNext(n, this.getAD_Client_ID());
            }
            if (mPPOrderNode != null && mPPOrderNode.getDateFinishSchedule() != null) {
                mPPOrder.setDateFinishSchedule(mPPOrderNode.getDateFinishSchedule());
            }
        } else if (this.p_ScheduleType.equals(BACKWARD_SCHEDULING)) {
            Timestamp timestamp = mPPOrder.getDateFinishSchedule();
            int n = mPPOrderWorkflow.getNodeLastID(this.getAD_Client_ID());
            MPPOrderNode mPPOrderNode = null;
            while (n != 0) {
                mPPOrderNode = mPPOrderWorkflow.getNode(n);
                if (arrayList.contains(n)) {
                    throw new CRPException("Cyclic transition found - ").setPP_Order_Node(mPPOrderNode);
                }
                arrayList.add(n);
                this.log.info("PP_Order Node:" + mPPOrderNode.getName() != null ? mPPOrderNode.getName() : (" Description:" + mPPOrderNode.getDescription() != null ? mPPOrderNode.getDescription() : ""));
                MResource mResource = MResource.get(this.getCtx(), mPPOrderNode.getS_Resource_ID());
                if (mResource == null) {
                    n = mPPOrderWorkflow.getPrevious(n, this.getAD_Client_ID());
                    continue;
                }
                if (!this.reasoner.isAvailable(mResource)) {
                    throw new CRPException("@ResourceNotInSlotDay@").setS_Resource(mResource);
                }
                long l = this.calculateMillisFor(mPPOrderNode, mPPOrderWorkflow.getDurationBaseSec());
                Timestamp timestamp3 = this.scheduleBackward(timestamp, l, mResource);
                mPPOrderNode.setDateStartSchedule(timestamp3);
                mPPOrderNode.setDateFinishSchedule(timestamp);
                mPPOrderNode.saveEx();
                timestamp = mPPOrderNode.getDateStartSchedule();
                n = mPPOrderWorkflow.getPrevious(n, this.getAD_Client_ID());
            }
            if (mPPOrderNode != null && mPPOrderNode.getDateStartSchedule() != null) {
                mPPOrder.setDateStartSchedule(mPPOrderNode.getDateStartSchedule());
            }
        } else {
            throw new CRPException("Unknown scheduling method - " + this.p_ScheduleType);
        }
        mPPOrder.saveEx(this.get_TrxName());
    }

    private long calculateMillisFor(MPPOrderNode mPPOrderNode, long l) {
        BigDecimal bigDecimal = mPPOrderNode.getQtyToDeliver();
        long l2 = mPPOrderNode.getQueuingTime() + mPPOrderNode.getSetupTimeRequiered() + mPPOrderNode.getMovingTime() + mPPOrderNode.getWaitingTime();
        BigDecimal bigDecimal2 = this.routingService.estimateWorkingTime(mPPOrderNode, bigDecimal);
        l2 = (long)((double)l2 + bigDecimal2.doubleValue());
        return l2 * l * 1000L;
    }

    private long getAvailableDurationMillis(Timestamp timestamp, Timestamp timestamp2, I_S_Resource i_S_Resource) {
        long l = timestamp2.getTime() - timestamp.getTime();
        this.log.info("--> availableDayDuration  " + l);
        if (l < 0L) {
            throw new CRPException("@TimeSlotStart@ > @TimeSlotEnd@ (" + timestamp2 + " > " + timestamp + ")").setS_Resource(i_S_Resource);
        }
        return l;
    }

    private Timestamp scheduleForward(Timestamp timestamp, long l, MResource mResource) {
        MResourceType mResourceType = mResource.getResourceType();
        int n = 0;
        Timestamp timestamp2 = timestamp;
        Timestamp timestamp3 = null;
        long l2 = l;
        do {
            long l3;
            timestamp2 = this.reasoner.getAvailableDate(mResource, timestamp2, false);
            Timestamp timestamp4 = mResourceType.getDayStart(timestamp2);
            Timestamp timestamp5 = mResourceType.getDayEnd(timestamp2);
            if (timestamp2.after(timestamp4) && timestamp2.before(timestamp5)) {
                timestamp4 = timestamp2;
            }
            if ((l3 = this.getAvailableDurationMillis(timestamp4, timestamp5, mResource)) >= l2) {
                timestamp3 = new Timestamp(timestamp4.getTime() + l2);
                l2 = 0L;
                break;
            }
            timestamp2 = TimeUtil.addDays(TimeUtil.getDayBorder(timestamp2, null, false), 1);
            l2 -= l3;
            if (++n <= this.p_MaxIterationsNo) continue;
            throw new CRPException("Maximum number of iterations exceeded (" + this.p_MaxIterationsNo + ")" + " - Date:" + timestamp2 + ", RemainingMillis:" + l2);
        } while (l2 > 0L);
        return timestamp3;
    }

    private Timestamp scheduleBackward(Timestamp timestamp, long l, MResource mResource) {
        MResourceType mResourceType = mResource.getResourceType();
        this.log.info("--> ResourceType " + mResourceType);
        Timestamp timestamp2 = null;
        Timestamp timestamp3 = timestamp;
        long l2 = l;
        int n = 0;
        do {
            long l3;
            this.log.info("--> end=" + timestamp3);
            this.log.info("--> nodeDuration=" + l2);
            timestamp3 = this.reasoner.getAvailableDate(mResource, timestamp3, true);
            this.log.info("--> end(available)=" + timestamp3);
            Timestamp timestamp4 = mResourceType.getDayEnd(timestamp3);
            Timestamp timestamp5 = mResourceType.getDayStart(timestamp3);
            this.log.info("--> dayStart=" + timestamp5 + ", dayEnd=" + timestamp4);
            if (timestamp3.before(timestamp4) && timestamp3.after(timestamp5)) {
                timestamp4 = timestamp3;
            }
            if ((l3 = this.getAvailableDurationMillis(timestamp5, timestamp4, mResource)) >= l2) {
                this.log.info("--> availableDayDuration >= nodeDuration true " + l3 + "|" + l2);
                timestamp2 = new Timestamp(timestamp4.getTime() - l2);
                l2 = 0L;
                break;
            }
            this.log.info("--> availableDayDuration >= nodeDuration false " + l3 + "|" + l2);
            this.log.info("--> nodeDuration-availableDayDuration " + (l2 - l3));
            timestamp3 = TimeUtil.addDays(TimeUtil.getDayBorder(timestamp3, null, true), -1);
            l2 -= l3;
            if (++n <= this.p_MaxIterationsNo) continue;
            throw new CRPException("Maximum number of iterations exceeded (" + this.p_MaxIterationsNo + ")" + " - Date:" + timestamp2 + ", RemainingMillis:" + l2);
        } while (l2 > 0L);
        this.log.info("         -->  start=" + timestamp2 + " <---------------------------------------- ");
        return timestamp2;
    }
}

