/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.msg;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.reasoner.StorageReasoner;
import org.eevolution.model.wrapper.BOMLineWrapper;
import org.eevolution.model.wrapper.BOMWrapper;

public class HTMLMessenger {
    protected final String PRODUCT_TOOLTIP = "<html><H1 align=\"CENTER\">" + Msg.translate(Env.getCtx(), "M_Product_ID") + "</H1>" + "<table cellpadding=\"5\" cellspacing=\"5\">" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "Description") + ":</b></td><td>{0}</td></tr>" + "</table></html>";
    protected final String LENGTHTRANSFORM_INFO_PATTERN = "<html><table cellpadding=\"5\" cellspacing=\"5\"><tr><td><b>{0}</b></td></tr><tr><td>{1}</td></tr><tr><td>{2}</td></tr></table></html>";
    protected final String PP_ORDER_INFO_PATTERN = "<html><H1 align=\"CENTER\">" + Msg.translate(Env.getCtx(), "PP_Order_ID") + "</H1>" + "<table cellpadding=\"5\" cellspacing=\"5\">" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "DocumentNo") + ":</b></td><td>{0}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "DateStartSchedule") + ":</b></td><td>{1}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "DateFinishSchedule") + ":</b></td><td>{2}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "C_Project_ID") + ":</b></td><td>{3}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "M_Product_ID") + ":</b></td><td>{4}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "QtyOrdered") + ":</b></td><td>{5}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "QtyDelivered") + ":</b></td><td>{6}</td></tr>" + "</table></html>";
    protected final String PP_ORDER_HEADER_INFO_PATTERN = "<html><H1 align=\"LEFT\">{0}</H1><table cellpadding=\"5\" cellspacing=\"5\"><tr><td><b>" + Msg.translate(Env.getCtx(), "DocumentNo") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "DateStartSchedule") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "DateFinishSchedule") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "C_Project_ID") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "M_Product_ID") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "QtyOrdered") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "QtyDelivered") + "</b></td>" + "<tr>" + "</table></html>";
    protected final String PP_ORDER_LINE_INFO_PATTERN = "<html><table cellpadding=\"5\" cellspacing=\"5\"><tr><td>{0}</td><td>{1}</td><td>{2}</td><td>{3}</td><td>{4}</td><td>{5}</td><td>{6}</td></tr></table></html>";
    protected final String BOM_INFO_PATTERN = "<html><H1 align=\"CENTER\">" + Msg.translate(Env.getCtx(), "PP_Product_BOM_ID") + "</H1>" + "<table cellpadding=\"5\" cellspacing=\"5\">" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "DocumentNo") + ":</b></td><td>{0}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "PP_Product_BOM_ID") + ":</b></td><td>{1}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "ValidFrom") + ":</b></td><td>{2} - {3}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "Value") + ":</b></td><td>{4}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "M_Product_ID") + ":</b></td><td>{5}</td></tr>" + "<tr><td></td><td>{6}</td></tr>" + "</table>" + "<p>{7}</p>" + "</html>";
    protected final String BOM_HEADER_INFO_PATTERN = "<table align=\"CENTER\" cellpadding=\"5\" cellspacing=\"5\"><tr><td><b>" + Msg.translate(Env.getCtx(), "Line") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "Qty") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "M_Product_ID") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID") + "</b></td>" + "</tr>";
    protected final String BOM_LINE_INFO_PATTERN = "<tr><td align=RIGHT>{0}</td><td align=RIGHT>{1}</td><td>{2}</td><td>{3}</td></tr>";
    protected final String BOMLINE_INFO_PATTERN = "<html><H1 align=\"CENTER\">" + Msg.translate(Env.getCtx(), "Line") + ":&nbsp;{0}</H1>" + "<table cellpadding=\"5\" cellspacing=\"5\">" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "ComponentType") + ":</b></td><td>{1}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "ValidFrom") + ":</b></td><td>{2} - {3}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "Qty") + ":</b></td><td>{4}</td></tr>" + "<tr><td><b>" + Msg.translate(Env.getCtx(), "M_Product_ID") + ":</b></td><td>{5}</td></tr>" + "<tr><td></td><td>{6}</td></tr>" + "</table>" + "<p>{7}</p>" + "</html>";
    protected final String STORAGE_HEADER_INFO_PATTERN = "<table align=\"CENTER\" cellpadding=\"5\" cellspacing=\"5\"><tr><td><b>" + Msg.translate(Env.getCtx(), "M_Locator_ID") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "M_Warehouse_ID") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "QtyOnHand") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "QtyReserved") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "QtyOrdered") + "</b></td>" + "<td><b>" + Msg.translate(Env.getCtx(), "QtyAvailable") + "</b></td>" + "</tr>";
    protected final String STORAGE_LINE_INFO_PATTERN = "<tr><td>{0}</td><td>{1}</td><td align=RIGHT>{2}</td><td align=RIGHT>{3}</td><td align=RIGHT>{4}</td><td align=RIGHT>{5}</td></tr>";
    protected final String STORAGE_SUM_LINE_INFO_PATTERN = "<tr><td></td><td></td><td align=RIGHT><hr size=\"1\" noshade=\"NOSHADE\">{0}</td><td align=RIGHT><hr size=\"1\" noshade=\"NOSHADE\">{1}</td><td align=RIGHT><hr size=\"1\" noshade=\"NOSHADE\">{2}</td><td align=RIGHT><hr size=\"1\" noshade=\"NOSHADE\">{3}</td></tr>";
    protected final String STORAGE_NOINVENTORY_INFO_PATTERN = "<tr><td align=\"CENTER\" colspan=\"6\">" + Msg.translate(Env.getCtx(), Msg.getMsg(Env.getCtx(), "NoQtyAvailable")) + "</td>" + "</tr>";
    protected final String STORAGE_FOOTER_INFO_PATTERN = "</table>";
    protected final String ATTRIBUTE_INFO_PATTERN = "{0}&nbsp;=&nbsp;<i>{1}</i>";

    public String getProductInfo(MProduct mProduct) {
        Object[] objectArray = new Object[]{mProduct.getDescription() == null ? "" : mProduct.getDescription()};
        return MessageFormat.format(this.PRODUCT_TOOLTIP, objectArray);
    }

    public String getLengthTransformInfo(MProduct mProduct, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        BigDecimal bigDecimal4 = bigDecimal.subtract(bigDecimal2.multiply(bigDecimal3));
        Object[] objectArray = new Object[]{mProduct.getName() + " (" + mProduct.getValue() + ")", "1 x " + bigDecimal.setScale(2, 5) + " &#8594; " + bigDecimal3 + " x " + bigDecimal2.setScale(2, 5), Msg.translate(Env.getCtx(), "Scrap") + ": 1 x " + bigDecimal4.setScale(2, 5)};
        return MessageFormat.format("<html><table cellpadding=\"5\" cellspacing=\"5\"><tr><td><b>{0}</b></td></tr><tr><td>{1}</td></tr><tr><td>{2}</td></tr></table></html>", objectArray);
    }

    public String getMfcOrderInfo(MPPOrder mPPOrder) {
        MProject mProject = new MProject(Env.getCtx(), mPPOrder.getC_Project_ID(), null);
        MProduct mProduct = new MProduct(Env.getCtx(), mPPOrder.getM_Product_ID(), null);
        Object[] objectArray = new Object[]{mPPOrder.getDocumentNo(), mPPOrder.getDateStartSchedule(), mPPOrder.getDateFinishSchedule(), (mProject.getName() == null ? "-" : mProject.getName()) + (mProject.getValue() == null ? "" : " (" + mProject.getValue() + ")"), mProduct.getName() + " (" + mProduct.getValue() + ")", mPPOrder.getQtyOrdered(), mPPOrder.getQtyDelivered()};
        return MessageFormat.format(this.PP_ORDER_INFO_PATTERN, objectArray);
    }

    public String getBOMLinesInfo(BOMLineWrapper[] bOMLineWrapperArray) {
        MProduct mProduct = null;
        MAttributeSetInstance mAttributeSetInstance = null;
        StringBuffer stringBuffer = new StringBuffer(this.BOM_HEADER_INFO_PATTERN);
        for (int i = 0; i < bOMLineWrapperArray.length; ++i) {
            mProduct = new MProduct(Env.getCtx(), bOMLineWrapperArray[i].getM_Product_ID(), "M_Product");
            mAttributeSetInstance = new MAttributeSetInstance(Env.getCtx(), bOMLineWrapperArray[i].getM_AttributeSetInstance_ID(), "M_AttributeSetInstance");
            Object[] objectArray = new Object[]{new Integer(bOMLineWrapperArray[i].getPo()), bOMLineWrapperArray[i].getQtyBOM(), mProduct.getName(), this.getAttributeSetInstanceInfo(mAttributeSetInstance, true)};
            stringBuffer.append(MessageFormat.format("<tr><td align=RIGHT>{0}</td><td align=RIGHT>{1}</td><td>{2}</td><td>{3}</td></tr>", objectArray));
        }
        return stringBuffer.toString();
    }

    public String getBOMLineInfo(BOMLineWrapper bOMLineWrapper) {
        SimpleDateFormat simpleDateFormat = Env.getLanguage(Env.getCtx()).getDateFormat();
        MProduct mProduct = new MProduct(Env.getCtx(), bOMLineWrapper.getM_Product_ID(), "M_Product");
        MAttributeSetInstance mAttributeSetInstance = new MAttributeSetInstance(Env.getCtx(), bOMLineWrapper.getM_AttributeSetInstance_ID(), "M_AttributeSetInstance");
        Object[] objectArray = new Object[]{new Integer(bOMLineWrapper.getPo()), bOMLineWrapper.getComponentType(), bOMLineWrapper.getValidFrom() == null ? "" : simpleDateFormat.format(bOMLineWrapper.getValidFrom()), bOMLineWrapper.getValidTo() == null ? "" : simpleDateFormat.format(bOMLineWrapper.getValidTo()), bOMLineWrapper.getQtyBOM(), mProduct.getName(), this.getAttributeSetInstanceInfo(mAttributeSetInstance, false), this.getStorageInfo(mProduct, mAttributeSetInstance)};
        return MessageFormat.format(this.BOMLINE_INFO_PATTERN, objectArray);
    }

    public String getBOMInfo(BOMWrapper bOMWrapper) {
        SimpleDateFormat simpleDateFormat = Env.getLanguage(Env.getCtx()).getDateFormat();
        MProduct mProduct = new MProduct(Env.getCtx(), bOMWrapper.getM_Product_ID(), "M_Product");
        MAttributeSetInstance mAttributeSetInstance = new MAttributeSetInstance(Env.getCtx(), bOMWrapper.getM_AttributeSetInstance_ID(), "M_AttributeSetInstance");
        Object[] objectArray = new Object[]{bOMWrapper.getDocumentNo(), bOMWrapper.getName(), bOMWrapper.getValidFrom() == null ? "" : simpleDateFormat.format(bOMWrapper.getValidFrom()), bOMWrapper.getValidTo() == null ? "" : simpleDateFormat.format(bOMWrapper.getValidTo()), bOMWrapper.getValue(), mProduct.getName(), this.getAttributeSetInstanceInfo(mAttributeSetInstance, false), this.getBOMLinesInfo(bOMWrapper.getLines())};
        return MessageFormat.format(this.BOM_INFO_PATTERN, objectArray);
    }

    public String getAttributeSetInstanceInfo(MAttributeSetInstance mAttributeSetInstance, boolean bl) {
        MAttributeSet mAttributeSet = new MAttributeSet(Env.getCtx(), mAttributeSetInstance.getM_AttributeSet_ID(), null);
        StorageReasoner storageReasoner = new StorageReasoner();
        int[] nArray = storageReasoner.getAttributeIDs(mAttributeSetInstance);
        MAttributeInstance mAttributeInstance = null;
        MAttribute mAttribute = null;
        MAttributeValue mAttributeValue = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        Object[] objectArray = null;
        for (int i = 0; i < nArray.length; ++i) {
            mAttributeInstance = new MAttributeInstance(Env.getCtx(), nArray[i], mAttributeSetInstance.get_ID(), (String)null, null);
            mAttributeInstance.load((String)null);
            mAttribute = new MAttribute(Env.getCtx(), mAttributeInstance.getM_Attribute_ID(), null);
            mAttributeValue = new MAttributeValue(Env.getCtx(), mAttributeInstance.getM_AttributeValue_ID(), null);
            if (mAttributeInstance.getValue() == null) {
                string = mAttributeValue.getValue();
            } else if ("N".equals(mAttribute.getAttributeValueType())) {
                BigDecimal bigDecimal = mAttributeInstance.getValueNumber();
                string = bigDecimal.setScale(2, 4).toString();
            } else {
                string = mAttributeInstance.getValue();
            }
            objectArray = new Object[]{mAttribute.getName(), string};
            stringBuffer.append(MessageFormat.format("{0}&nbsp;=&nbsp;<i>{1}</i>", objectArray));
            if (bl) {
                stringBuffer.append("&nbsp;");
                continue;
            }
            stringBuffer.append("<br>");
        }
        return stringBuffer.toString();
    }

    public String getStorageInfo(MProduct mProduct, MAttributeSetInstance mAttributeSetInstance) {
        StorageReasoner storageReasoner = new StorageReasoner();
        int[] nArray = storageReasoner.getPOIDs("M_Locator", null, null);
        MWarehouse mWarehouse = null;
        MStorage mStorage = null;
        MLocator mLocator = null;
        StringBuffer stringBuffer = new StringBuffer(this.STORAGE_HEADER_INFO_PATTERN);
        Object[] objectArray = null;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        BigDecimal bigDecimal3 = BigDecimal.ZERO;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            mStorage = MStorage.get(Env.getCtx(), nArray[i], mProduct.get_ID(), mAttributeSetInstance.get_ID(), null);
            if (mStorage == null) continue;
            ++n;
            mWarehouse = new MWarehouse(Env.getCtx(), mStorage.getM_Warehouse_ID(), null);
            mLocator = new MLocator(Env.getCtx(), mStorage.getM_Locator_ID(), null);
            bigDecimal = bigDecimal.add(mStorage.getQtyOnHand());
            bigDecimal2 = bigDecimal2.add(mStorage.getQtyReserved());
            bigDecimal3 = bigDecimal3.add(mStorage.getQtyOrdered());
            objectArray = new Object[]{mLocator.getX() + " - " + mLocator.getY() + " - " + mLocator.getZ(), mWarehouse.getName(), mStorage.getQtyOnHand(), mStorage.getQtyReserved(), mStorage.getQtyOrdered(), mStorage.getQtyOnHand().subtract(mStorage.getQtyReserved())};
            stringBuffer.append(MessageFormat.format("<tr><td>{0}</td><td>{1}</td><td align=RIGHT>{2}</td><td align=RIGHT>{3}</td><td align=RIGHT>{4}</td><td align=RIGHT>{5}</td></tr>", objectArray));
        }
        if (n > 1) {
            objectArray = new Object[]{bigDecimal, bigDecimal2, bigDecimal3, bigDecimal.subtract(bigDecimal2)};
            stringBuffer.append(MessageFormat.format("<tr><td></td><td></td><td align=RIGHT><hr size=\"1\" noshade=\"NOSHADE\">{0}</td><td align=RIGHT><hr size=\"1\" noshade=\"NOSHADE\">{1}</td><td align=RIGHT><hr size=\"1\" noshade=\"NOSHADE\">{2}</td><td align=RIGHT><hr size=\"1\" noshade=\"NOSHADE\">{3}</td></tr>", objectArray));
        }
        double d = bigDecimal.subtract(bigDecimal2).setScale(2, 4).doubleValue();
        if (n == 0 || d <= 0.0) {
            stringBuffer.append(MessageFormat.format(this.STORAGE_NOINVENTORY_INFO_PATTERN, objectArray));
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }
}

