/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model.reasoner;

import java.math.BigDecimal;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderWorkflow;
import org.eevolution.model.wrapper.BOMLineWrapper;

public class StorageReasoner {
    public MPPOrderWorkflow getPPOrderWorkflow(MPPOrder mPPOrder) {
        int[] nArray = PO.getAllIDs("PP_Order_Workflow", "PP_Order_ID = " + mPPOrder.get_ID(), null);
        if (nArray.length != 1) {
            return null;
        }
        return new MPPOrderWorkflow(Env.getCtx(), nArray[0], null);
    }

    public boolean equalAttributeInstanceValue(MAttributeInstance mAttributeInstance, MAttributeInstance mAttributeInstance2) {
        if (mAttributeInstance.getM_Attribute_ID() != mAttributeInstance2.getM_Attribute_ID()) {
            return false;
        }
        boolean bl = true;
        MAttribute mAttribute = new MAttribute(Env.getCtx(), mAttributeInstance.getM_Attribute_ID(), null);
        if ("N".equals(mAttribute.getAttributeValueType())) {
            bl = mAttributeInstance.getValue() == null ? mAttributeInstance2.getValueNumber() == null : mAttributeInstance.getValueNumber().compareTo(mAttributeInstance2.getValueNumber()) == 0;
        } else if ("S".equals(mAttribute.getAttributeValueType())) {
            bl = mAttributeInstance.getValue() == null ? mAttributeInstance2.getValue() == null : mAttributeInstance.getValue().equals(mAttributeInstance2.getValue());
        } else if ("L".equals(mAttribute.getAttributeValueType())) {
            bl = mAttributeInstance.getM_AttributeValue_ID() == mAttributeInstance2.getM_AttributeValue_ID();
        }
        return bl;
    }

    public int[] getAttributeIDs(MAttributeSetInstance mAttributeSetInstance) {
        MAttributeSet mAttributeSet = new MAttributeSet(Env.getCtx(), mAttributeSetInstance.getM_AttributeSet_ID(), null);
        return this.getPOIDs("M_Attribute", "M_Attribute_ID IN (SELECT M_Attribute_ID FROM M_AttributeUse WHERE M_AttributeSet_ID = " + mAttributeSet.get_ID() + ")", null);
    }

    public BigDecimal getSumQtyAvailable(MProduct mProduct, MAttributeSetInstance mAttributeSetInstance) {
        int[] nArray = this.getPOIDs("M_Locator", null, null);
        MStorage mStorage = null;
        Object var5_5 = null;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            mStorage = MStorage.get(Env.getCtx(), nArray[i], mProduct.get_ID(), mAttributeSetInstance.get_ID(), null);
            if (mStorage == null) continue;
            ++n;
            bigDecimal = bigDecimal.add(mStorage.getQtyOnHand().subtract(mStorage.getQtyReserved()));
        }
        return bigDecimal;
    }

    public BigDecimal getSumQtyRequired(BOMLineWrapper bOMLineWrapper) {
        MProduct mProduct = new MProduct(Env.getCtx(), bOMLineWrapper.getM_Product_ID(), null);
        MAttributeSetInstance mAttributeSetInstance = new MAttributeSetInstance(Env.getCtx(), bOMLineWrapper.getM_AttributeSetInstance_ID(), null);
        return this.getSumQtyAvailable(mProduct, mAttributeSetInstance).subtract(bOMLineWrapper.getQtyBOM()).negate();
    }

    public MStorage getAvailableQtyLocator(MProduct mProduct, MAttributeSetInstance mAttributeSetInstance, BigDecimal bigDecimal) {
        int[] nArray = this.getPOIDs("M_Locator", null, null);
        MStorage mStorage = null;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        BigDecimal bigDecimal3 = BigDecimal.ZERO;
        BigDecimal bigDecimal4 = BigDecimal.ZERO;
        for (int i = 0; i < nArray.length; ++i) {
            mStorage = MStorage.get(Env.getCtx(), nArray[i], mProduct.get_ID(), mAttributeSetInstance.get_ID(), null);
            if (mStorage == null) continue;
            bigDecimal3 = mStorage.getQtyOnHand() == null ? BigDecimal.ZERO : mStorage.getQtyOnHand();
            bigDecimal2 = bigDecimal3.subtract(bigDecimal4 = mStorage.getQtyReserved() == null ? BigDecimal.ZERO : mStorage.getQtyReserved());
            if (bigDecimal.compareTo(bigDecimal2) <= 0 && bigDecimal3.compareTo(BigDecimal.ZERO) > 0) break;
            mStorage = null;
        }
        return mStorage;
    }

    public boolean isQtyAvailable(BOMLineWrapper bOMLineWrapper) {
        MProduct mProduct = new MProduct(Env.getCtx(), bOMLineWrapper.getM_Product_ID(), null);
        MAttributeSetInstance mAttributeSetInstance = new MAttributeSetInstance(Env.getCtx(), bOMLineWrapper.getM_AttributeSetInstance_ID(), null);
        return this.isQtyAvailable(mProduct, mAttributeSetInstance);
    }

    public boolean isQtyAvailable(MProduct mProduct, MAttributeSetInstance mAttributeSetInstance) {
        int[] nArray = this.getPOIDs("M_Locator", null, null);
        MStorage mStorage = null;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            mStorage = MStorage.get(Env.getCtx(), nArray[i], mProduct.get_ID(), mAttributeSetInstance.get_ID(), null);
            if (mStorage == null) continue;
            ++n;
            bigDecimal = bigDecimal.add(mStorage.getQtyOnHand());
            bigDecimal2 = bigDecimal2.add(mStorage.getQtyReserved());
        }
        double d = bigDecimal.subtract(bigDecimal2).setScale(2, 4).doubleValue();
        return n != 0 && !(d <= 0.0);
    }

    public int[] getPOIDs(String string, String string2, String string3) {
        String string4 = "AD_Client_ID = " + Env.getAD_Client_ID(Env.getCtx());
        String string5 = null;
        string5 = string2 == null || string2.length() == 0 ? string4 : string2 + " AND " + string4;
        return PO.getAllIDs(string, string5, string3);
    }
}

