/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model.reasoner;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.I_S_Resource;
import org.compiere.model.MResourceType;
import org.compiere.model.MResourceUnAvailable;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderNode;

public class CRPReasoner {
    public Properties getCtx() {
        return this.getCtx(null);
    }

    private Properties getCtx(Object object) {
        if (object instanceof PO) {
            return ((PO)object).getCtx();
        }
        return Env.getCtx();
    }

    private String getSQLDayRestriction(Timestamp timestamp, I_S_Resource i_S_Resource, List<Object> list) {
        MResourceType mResourceType = MResourceType.get(this.getCtx(), i_S_Resource.getS_ResourceType_ID());
        Timestamp timestamp2 = mResourceType.getDayStart(timestamp);
        Timestamp timestamp3 = mResourceType.getDayEnd(timestamp);
        String string = "(DateStartSchedule<=? AND DateFinishSchedule>=? AND DateFinishSchedule<=?)";
        list.add(timestamp2);
        list.add(timestamp2);
        list.add(timestamp3);
        string = string + " OR (DateStartSchedule>=? AND DateStartSchedule<=? AND DateFinishSchedule>=? AND DateFinishSchedule<=?)";
        list.add(timestamp2);
        list.add(timestamp3);
        list.add(timestamp2);
        list.add(timestamp3);
        string = string + " OR (DateStartSchedule>=? AND DateStartSchedule<=? AND DateFinishSchedule>=?)";
        list.add(timestamp2);
        list.add(timestamp3);
        list.add(timestamp3);
        string = string + " OR (DateStartSchedule<=? AND DateFinishSchedule>=?)";
        list.add(timestamp2);
        list.add(timestamp3);
        return "(" + string + ")";
    }

    public Query getPPOrdersNotCompletedQuery(int n, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AD_Client_ID=?");
        arrayList.add(Env.getAD_Client_ID(this.getCtx()));
        stringBuffer.append(" AND ").append("DocStatus").append(" NOT IN (?,?,?)");
        arrayList.add("VO");
        arrayList.add("RE");
        arrayList.add("CL");
        if (n > 0) {
            stringBuffer.append(" AND ").append("S_Resource_ID").append("=?");
            arrayList.add(n);
        }
        return new Query(this.getCtx(), "PP_Order", stringBuffer.toString(), string).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("DatePromised");
    }

    public MPPOrder[] getPPOrders(Timestamp timestamp, I_S_Resource i_S_Resource) {
        if (!this.isAvailable(i_S_Resource, timestamp)) {
            return new MPPOrder[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(i_S_Resource.getS_Resource_ID());
        String string = "EXISTS (SELECT 1 FROM PP_Order_Node WHERE  PP_Order_Node.PP_Order_ID=PP_Order.PP_Order_ID AND S_Resource_ID=? AND " + this.getSQLDayRestriction(timestamp, i_S_Resource, arrayList) + ")" + " AND AD_Client_ID=?";
        arrayList.add(i_S_Resource.getAD_Client_ID());
        List<MPPOrder> list = new Query(this.getCtx(i_S_Resource), "PP_Order", string, null).setParameters(arrayList).list();
        return list.toArray(new MPPOrder[list.size()]);
    }

    public MPPOrderNode[] getPPOrderNodes(Timestamp timestamp, I_S_Resource i_S_Resource) {
        if (!this.isAvailable(i_S_Resource, timestamp)) {
            return new MPPOrderNode[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = "S_Resource_ID=? AND AD_Client_ID=?";
        arrayList.add(i_S_Resource.getS_Resource_ID());
        arrayList.add(i_S_Resource.getAD_Client_ID());
        string = string + " AND " + this.getSQLDayRestriction(timestamp, i_S_Resource, arrayList);
        List<MPPOrderNode> list = new Query(this.getCtx(i_S_Resource), "PP_Order_Node", string, null).setParameters(arrayList).list();
        return list.toArray(new MPPOrderNode[list.size()]);
    }

    public boolean isAvailable(I_S_Resource i_S_Resource, Timestamp timestamp) {
        MResourceType mResourceType = MResourceType.get(this.getCtx(i_S_Resource), i_S_Resource.getS_ResourceType_ID());
        return mResourceType.isDayAvailable(timestamp) && !MResourceUnAvailable.isUnAvailable(i_S_Resource, timestamp);
    }

    public boolean isAvailable(I_S_Resource i_S_Resource) {
        MResourceType mResourceType = MResourceType.get(this.getCtx(i_S_Resource), i_S_Resource.getS_ResourceType_ID());
        return mResourceType.isAvailable();
    }

    private Timestamp getAvailableDate(MResourceType mResourceType, Timestamp timestamp, boolean bl) {
        Timestamp timestamp2 = timestamp;
        int n = bl ? -1 : 1;
        int n2 = 0;
        do {
            if (mResourceType.isDayAvailable(timestamp2)) {
                return timestamp2;
            }
            timestamp2 = TimeUtil.addDays(timestamp2, n);
        } while (++n2 < 7);
        return timestamp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getAvailableDate(I_S_Resource i_S_Resource, Timestamp timestamp, boolean bl) {
        int n;
        String string;
        String string2;
        MResourceType mResourceType = MResourceType.get(this.getCtx(i_S_Resource), i_S_Resource.getS_ResourceType_ID());
        Timestamp timestamp2 = timestamp;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            string2 = "DateFrom <= ?";
            arrayList.add(timestamp2);
            string = "DateFrom DESC";
            n = 1;
        } else {
            string2 = "DateTo >= ?";
            arrayList.add(timestamp2);
            string = "DateTo";
            n = -1;
        }
        string2 = string2 + " AND S_Resource_ID=? AND AD_Client_ID=?";
        arrayList.add(i_S_Resource.getS_Resource_ID());
        arrayList.add(i_S_Resource.getAD_Client_ID());
        POResultSet pOResultSet = new Query(this.getCtx(i_S_Resource), "S_ResourceUnAvailable", string2, null).setOrderBy(string).setParameters(arrayList).scroll();
        try {
            while (pOResultSet.hasNext()) {
                MResourceUnAvailable mResourceUnAvailable = (MResourceUnAvailable)pOResultSet.next();
                if (mResourceUnAvailable.isUnAvailable(timestamp2)) {
                    timestamp2 = TimeUtil.addDays(mResourceUnAvailable.getDateTo(), 1 * n);
                }
                timestamp2 = this.getAvailableDate(mResourceType, timestamp, bl);
            }
        }
        finally {
            DB.close(pOResultSet);
        }
        timestamp2 = this.getAvailableDate(mResourceType, timestamp, bl);
        return timestamp2;
    }
}

