/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_WF_Node;
import org.compiere.model.I_AD_Workflow;
import org.compiere.model.I_C_UOM;
import org.compiere.model.I_S_Resource;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.I_PP_Cost_Collector;
import org.eevolution.model.I_PP_Order_Node;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.model.RoutingService;

public class DefaultRoutingServiceImpl
implements RoutingService {
    @Override
    public BigDecimal estimateWorkingTime(I_AD_WF_Node i_AD_WF_Node) {
        double d = i_AD_WF_Node.getUnitsCycles().signum() == 0 ? (double)i_AD_WF_Node.getDuration() : (double)i_AD_WF_Node.getDuration() / i_AD_WF_Node.getUnitsCycles().doubleValue();
        return BigDecimal.valueOf(d);
    }

    @Override
    public BigDecimal estimateWorkingTime(I_PP_Order_Node i_PP_Order_Node, BigDecimal bigDecimal) {
        double d = i_PP_Order_Node.getDuration();
        double d2 = this.calculateCycles(i_PP_Order_Node.getUnitsCycles(), bigDecimal);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(d * d2);
        return bigDecimal2;
    }

    @Override
    public BigDecimal estimateWorkingTime(I_PP_Cost_Collector i_PP_Cost_Collector) {
        String string = i_PP_Cost_Collector instanceof PO ? ((PO)((Object)i_PP_Cost_Collector)).get_TrxName() : null;
        BigDecimal bigDecimal = i_PP_Cost_Collector.getMovementQty();
        MPPOrderNode mPPOrderNode = MPPOrderNode.get(Env.getCtx(), i_PP_Cost_Collector.getPP_Order_Node_ID(), string);
        return this.estimateWorkingTime(mPPOrderNode, bigDecimal);
    }

    protected int calculateCycles(int n, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = BigDecimal.valueOf(n);
        if (bigDecimal3.signum() > 0) {
            bigDecimal2 = bigDecimal.divide(bigDecimal3, 0, RoundingMode.UP);
        }
        return bigDecimal2.intValue();
    }

    protected BigDecimal calculateDuration(I_AD_WF_Node i_AD_WF_Node, I_PP_Cost_Collector i_PP_Cost_Collector) {
        double d;
        double d2;
        if (i_AD_WF_Node == null) {
            i_AD_WF_Node = i_PP_Cost_Collector.getPP_Order_Node().getAD_WF_Node();
        }
        I_AD_Workflow i_AD_Workflow = i_AD_WF_Node.getAD_Workflow();
        double d3 = i_AD_Workflow.getQtyBatchSize().doubleValue();
        if (i_PP_Cost_Collector != null) {
            d2 = i_PP_Cost_Collector.getSetupTimeReal().doubleValue();
            d = i_PP_Cost_Collector.getDurationReal().doubleValue();
        } else {
            d2 = i_AD_WF_Node.getSetupTime();
            d = this.estimateWorkingTime(i_AD_WF_Node).doubleValue();
        }
        double d4 = d3 > 0.0 ? d2 / d3 + d : d2 + d;
        return BigDecimal.valueOf(d4);
    }

    @Override
    public BigDecimal calculateDuration(I_AD_WF_Node i_AD_WF_Node) {
        return this.calculateDuration(i_AD_WF_Node, null);
    }

    @Override
    public BigDecimal calculateDuration(I_PP_Cost_Collector i_PP_Cost_Collector) {
        return this.calculateDuration(this.getAD_WF_Node(i_PP_Cost_Collector), i_PP_Cost_Collector);
    }

    @Override
    public BigDecimal calculateDuration(I_AD_Workflow i_AD_Workflow, I_S_Resource i_S_Resource, BigDecimal bigDecimal) {
        if (i_S_Resource == null) {
            return Env.ZERO;
        }
        Properties properties = ((PO)((Object)i_AD_Workflow)).getCtx();
        MResourceType mResourceType = MResourceType.get(properties, i_S_Resource.getS_ResourceType_ID());
        BigDecimal bigDecimal2 = BigDecimal.valueOf(mResourceType.getTimeSlotHours());
        int n = mResourceType.getAvailableDaysWeek();
        double d = this.getDurationBaseSec(i_AD_Workflow.getDurationUnit());
        double d2 = 0.0;
        MWFNode[] mWFNodeArray = ((MWorkflow)i_AD_Workflow).getNodes(false, Env.getAD_Client_ID(properties));
        for (MWFNode mWFNode : mWFNodeArray) {
            d2 += (double)mWFNode.getQueuingTime();
            d2 += (double)mWFNode.getSetupTime();
            d2 += (double)mWFNode.getWaitingTime();
            d2 += (double)mWFNode.getMovingTime();
            double d3 = bigDecimal.doubleValue();
            if (mWFNode.getOverlapUnits() > 0 && (double)mWFNode.getOverlapUnits() < d3) {
                d3 = mWFNode.getOverlapUnits();
            }
            double d4 = (double)mWFNode.getDuration() * d3;
            d2 += d4;
        }
        BigDecimal bigDecimal3 = BigDecimal.valueOf(d2 * d / 60.0 / 60.0);
        BigDecimal bigDecimal4 = BigDecimal.valueOf(7L).divide(BigDecimal.valueOf(n), 8, RoundingMode.UP);
        return bigDecimal3.multiply(bigDecimal4).divide(bigDecimal2, 0, RoundingMode.UP);
    }

    protected BigDecimal convertDurationToResourceUOM(BigDecimal bigDecimal, int n, I_AD_WF_Node i_AD_WF_Node) {
        MResource mResource = MResource.get(Env.getCtx(), n);
        MWorkflow mWorkflow = MWorkflow.get(Env.getCtx(), i_AD_WF_Node.getAD_Workflow_ID());
        MUOM mUOM = MUOM.get(Env.getCtx(), mResource.getC_UOM_ID());
        return this.convertDuration(bigDecimal, mWorkflow.getDurationUnit(), mUOM);
    }

    @Override
    public BigDecimal getResourceBaseValue(int n, I_PP_Cost_Collector i_PP_Cost_Collector) {
        return this.getResourceBaseValue(n, null, i_PP_Cost_Collector);
    }

    @Override
    public BigDecimal getResourceBaseValue(int n, I_AD_WF_Node i_AD_WF_Node) {
        return this.getResourceBaseValue(n, i_AD_WF_Node, null);
    }

    protected BigDecimal getResourceBaseValue(int n, I_AD_WF_Node i_AD_WF_Node, I_PP_Cost_Collector i_PP_Cost_Collector) {
        MResource mResource;
        Properties properties;
        MUOM mUOM;
        if (i_AD_WF_Node == null) {
            i_AD_WF_Node = i_PP_Cost_Collector.getPP_Order_Node().getAD_WF_Node();
        }
        if (this.isTime(mUOM = MUOM.get(properties = i_AD_WF_Node instanceof PO ? ((PO)((Object)i_AD_WF_Node)).getCtx() : Env.getCtx(), (mResource = MResource.get(properties, n)).getC_UOM_ID()))) {
            BigDecimal bigDecimal = this.calculateDuration(i_AD_WF_Node, i_PP_Cost_Collector);
            MWorkflow mWorkflow = MWorkflow.get(properties, i_AD_WF_Node.getAD_Workflow_ID());
            BigDecimal bigDecimal2 = this.convertDuration(bigDecimal, mWorkflow.getDurationUnit(), mUOM);
            return bigDecimal2;
        }
        throw new AdempiereException("@NotSupported@ @C_UOM_ID@ - " + mUOM);
    }

    protected I_AD_WF_Node getAD_WF_Node(I_PP_Cost_Collector i_PP_Cost_Collector) {
        I_PP_Order_Node i_PP_Order_Node = i_PP_Cost_Collector.getPP_Order_Node();
        return i_PP_Order_Node.getAD_WF_Node();
    }

    public long getDurationBaseSec(String string) {
        if (string == null) {
            return 0L;
        }
        if ("s".equals(string)) {
            return 1L;
        }
        if ("m".equals(string)) {
            return 60L;
        }
        if ("h".equals(string)) {
            return 3600L;
        }
        if ("D".equals(string)) {
            return 86400L;
        }
        if ("M".equals(string)) {
            return 2592000L;
        }
        if ("Y".equals(string)) {
            return 31536000L;
        }
        return 0L;
    }

    public long getDurationBaseSec(I_C_UOM i_C_UOM) {
        MUOM mUOM = (MUOM)i_C_UOM;
        if (mUOM.isWeek()) {
            return 604800L;
        }
        if (mUOM.isDay()) {
            return 86400L;
        }
        if (mUOM.isHour()) {
            return 3600L;
        }
        if (mUOM.isMinute()) {
            return 60L;
        }
        if (mUOM.isSecond()) {
            return 1L;
        }
        throw new AdempiereException("@NotSupported@ @C_UOM_ID@=" + i_C_UOM.getName());
    }

    public boolean isTime(I_C_UOM i_C_UOM) {
        String string = i_C_UOM.getX12DE355();
        return "03".equals(string) || "MJ".equals(string) || "HR".equals(string) || "DA".equals(string) || "WD".equals(string) || "WK".equals(string) || "MO".equals(string) || "WM".equals(string) || "YR".equals(string);
    }

    public BigDecimal convertDuration(BigDecimal bigDecimal, String string, I_C_UOM i_C_UOM) {
        double d = this.getDurationBaseSec(string);
        double d2 = this.getDurationBaseSec(i_C_UOM);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(bigDecimal.doubleValue() * d / d2);
        int n = i_C_UOM.getStdPrecision();
        if (bigDecimal2.scale() > n) {
            bigDecimal2 = bigDecimal2.setScale(n, RoundingMode.HALF_UP);
        }
        return bigDecimal2;
    }
}

