/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.util.HashMap;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Env;
import org.eevolution.model.RoutingService;

public class RoutingServiceFactory {
    public static final String DEFAULT_ServiceName = "org.eevolution.model.impl.DefaultRoutingServiceImpl";
    public static RoutingServiceFactory s_instance = null;
    private static final HashMap<Integer, String> s_serviceClassnames = new HashMap(5);
    private static final HashMap<Integer, RoutingService> s_services = new HashMap(5);

    public static RoutingServiceFactory get() {
        if (s_instance == null) {
            s_instance = new RoutingServiceFactory();
        }
        return s_instance;
    }

    public static void registerServiceClassname(int n, String string) {
        s_serviceClassnames.put(n > 0 ? n : 0, string);
    }

    private RoutingServiceFactory() {
    }

    private final String getRoutingServiceClassname(int n) {
        String string = s_serviceClassnames.get(n);
        if (string == null && n != 0) {
            string = s_serviceClassnames.get(0);
        }
        if (string == null) {
            string = DEFAULT_ServiceName;
        }
        return string;
    }

    public RoutingService getRoutingService(int n) {
        RoutingService routingService = s_services.get(n);
        if (routingService != null) {
            return routingService;
        }
        String string = this.getRoutingServiceClassname(n);
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            routingService = (RoutingService)clazz.newInstance();
            s_services.put(n, routingService);
        }
        catch (Exception exception) {
            throw new AdempiereException(exception);
        }
        return routingService;
    }

    public RoutingService getRoutingService(Properties properties) {
        return this.getRoutingService(Env.getAD_Client_ID(properties));
    }

    public RoutingService getRoutingService() {
        return this.getRoutingService(Env.getCtx());
    }
}

