/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.X_PP_WF_Node_Product;

public class MPPWFNodeProduct
extends X_PP_WF_Node_Product {
    private static final long serialVersionUID = 1L;
    private static CCache<Integer, Collection<MPPWFNodeProduct>> s_cache = new CCache("PP_WF_Node_Product", 20);

    public static Collection<MPPWFNodeProduct> forAD_WF_Node_ID(Properties properties, int n) {
        Collection<MPPWFNodeProduct> collection = s_cache.get(n);
        if (collection != null) {
            return collection;
        }
        collection = new Query(properties, "PP_WF_Node_Product", "AD_WF_Node_ID=?", null).setParameters(n).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        s_cache.put(n, collection);
        return collection;
    }

    public MPPWFNodeProduct(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            // empty if block
        }
    }

    public MPPWFNodeProduct(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (this.getSeqNo() == 0) {
            int n = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(MAX(SeqNo),0)+10 FROM PP_WF_Node_Product WHERE  AD_WF_Node_ID=? AND PP_WF_Node_Product_ID<>?", this.getAD_WF_Node_ID(), this.get_ID());
            this.setSeqNo(n);
        }
        if (this.getQty().compareTo(Env.ZERO) == 0 && this.isSubcontracting()) {
            this.setQty(Env.ONE);
        }
        return true;
    }
}

