/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.model.MPPOrderNodeNext;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;
import org.eevolution.model.X_PP_Order_Workflow;

public class MPPOrderWorkflow
extends X_PP_Order_Workflow {
    private static final long serialVersionUID = 1L;
    private static CCache<Integer, MPPOrderWorkflow> s_cache = new CCache("PP_Order_Workflow", 20);
    private List<MPPOrderNode> m_nodes = null;
    private MPPOrder m_order = null;

    public static MPPOrderWorkflow get(Properties properties, int n) {
        if (n <= 0) {
            return null;
        }
        MPPOrderWorkflow mPPOrderWorkflow = s_cache.get(n);
        if (mPPOrderWorkflow != null) {
            return mPPOrderWorkflow;
        }
        mPPOrderWorkflow = new MPPOrderWorkflow(properties, n, null);
        if (mPPOrderWorkflow.get_ID() != 0) {
            s_cache.put(n, mPPOrderWorkflow);
        }
        return mPPOrderWorkflow;
    }

    public MPPOrderWorkflow(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setAccessLevel("1");
            this.setAuthor(MClient.get(properties).getName());
            this.setDurationUnit("D");
            this.setDuration(1);
            this.setEntityType("U");
            this.setIsDefault(false);
            this.setPublishStatus("U");
            this.setVersion(0);
            this.setCost(Env.ZERO);
            this.setWaitingTime(0);
            this.setWorkingTime(0);
        }
    }

    public MPPOrderWorkflow(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MPPOrderWorkflow(MWorkflow mWorkflow, int n, String string) {
        this(mWorkflow.getCtx(), 0, string);
        this.setPP_Order_ID(n);
        this.setValue(mWorkflow.getValue());
        this.setWorkflowType(mWorkflow.getWorkflowType());
        this.setQtyBatchSize(mWorkflow.getQtyBatchSize());
        this.setName(mWorkflow.getName());
        this.setAccessLevel(mWorkflow.getAccessLevel());
        this.setAuthor(mWorkflow.getAuthor());
        this.setDurationUnit(mWorkflow.getDurationUnit());
        this.setDuration(mWorkflow.getDuration());
        this.setEntityType(mWorkflow.getEntityType());
        this.setIsDefault(mWorkflow.isDefault());
        this.setPublishStatus(mWorkflow.getPublishStatus());
        this.setVersion(mWorkflow.getVersion());
        this.setCost(mWorkflow.getCost());
        this.setWaitingTime(mWorkflow.getWaitingTime());
        this.setWorkingTime(mWorkflow.getWorkingTime());
        this.setAD_WF_Responsible_ID(mWorkflow.getAD_WF_Responsible_ID());
        this.setAD_Workflow_ID(mWorkflow.getAD_Workflow_ID());
        this.setLimit(mWorkflow.getLimit());
        this.setPriority(mWorkflow.getPriority());
        this.setS_Resource_ID(mWorkflow.getS_Resource_ID());
        this.setQueuingTime(mWorkflow.getQueuingTime());
        this.setSetupTime(mWorkflow.getSetupTime());
        this.setMovingTime(mWorkflow.getMovingTime());
        this.setProcessType(mWorkflow.getProcessType());
        this.setAD_Table_ID(mWorkflow.getAD_Table_ID());
        this.setAD_WF_Node_ID(mWorkflow.getAD_WF_Node_ID());
        this.setAD_WorkflowProcessor_ID(mWorkflow.getAD_WorkflowProcessor_ID());
        this.setDescription(mWorkflow.getDescription());
        this.setValidFrom(mWorkflow.getValidFrom());
        this.setValidTo(mWorkflow.getValidTo());
    }

    protected List<MPPOrderNode> getNodes(boolean bl) {
        if (this.m_nodes == null || bl) {
            this.m_nodes = new Query(this.getCtx(), "PP_Order_Node", "PP_Order_Workflow_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOnlyActiveRecords(true).list();
            this.log.fine("#" + this.m_nodes.size());
        }
        return this.m_nodes;
    }

    protected List<MPPOrderNode> getNodes() {
        return this.getNodes(false);
    }

    public int getNodeCount() {
        return this.getNodes().size();
    }

    public MPPOrderNode[] getNodes(boolean bl, int n) {
        if (bl) {
            return this.getNodesInOrder(n);
        }
        ArrayList<MPPOrderNode> arrayList = new ArrayList<MPPOrderNode>();
        for (MPPOrderNode mPPOrderNode : this.getNodes()) {
            if (mPPOrderNode.getAD_Client_ID() != 0 && mPPOrderNode.getAD_Client_ID() != n) continue;
            arrayList.add(mPPOrderNode);
        }
        return arrayList.toArray(new MPPOrderNode[arrayList.size()]);
    }

    public MPPOrderNode getFirstNode() {
        return this.getNode(this.getPP_Order_Node_ID());
    }

    private MPPOrderNode getNode(int n, int n2) {
        if (n <= 0) {
            return null;
        }
        for (MPPOrderNode mPPOrderNode : this.getNodes()) {
            if (mPPOrderNode.getPP_Order_Node_ID() != n) continue;
            if (n2 >= 0) {
                if (mPPOrderNode.getAD_Client_ID() == 0 || mPPOrderNode.getAD_Client_ID() == n2) {
                    return mPPOrderNode;
                }
                return null;
            }
            return mPPOrderNode;
        }
        return null;
    }

    public MPPOrderNode getNode(int n) {
        return this.getNode(n, -1);
    }

    public MPPOrderNode[] getNextNodes(int n, int n2) {
        MPPOrderNode mPPOrderNode = this.getNode(n);
        if (mPPOrderNode == null || mPPOrderNode.getNextNodeCount() == 0) {
            return null;
        }
        ArrayList<MPPOrderNode> arrayList = new ArrayList<MPPOrderNode>();
        for (MPPOrderNodeNext mPPOrderNodeNext : mPPOrderNode.getTransitions(n2)) {
            MPPOrderNode mPPOrderNode2 = this.getNode(mPPOrderNodeNext.getPP_Order_Next_ID(), n2);
            if (mPPOrderNode2 == null) continue;
            arrayList.add(mPPOrderNode2);
        }
        return arrayList.toArray(new MPPOrderNode[arrayList.size()]);
    }

    private MPPOrderNode[] getNodesInOrder(int n) {
        ArrayList<MPPOrderNode> arrayList = new ArrayList<MPPOrderNode>();
        this.addNodesSF(arrayList, this.getPP_Order_Node_ID(), n);
        if (this.getNodeCount() != arrayList.size()) {
            for (MPPOrderNode mPPOrderNode : this.getNodes()) {
                if (mPPOrderNode.getAD_Client_ID() != 0 && mPPOrderNode.getAD_Client_ID() != n) continue;
                boolean bl = false;
                for (MPPOrderNode mPPOrderNode2 : arrayList) {
                    if (mPPOrderNode2.getPP_Order_Node_ID() != mPPOrderNode.getPP_Order_Node_ID()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.log.log(Level.WARNING, "Added Node w/o transition: " + mPPOrderNode);
                arrayList.add(mPPOrderNode);
            }
        }
        MPPOrderNode[] mPPOrderNodeArray = new MPPOrderNode[arrayList.size()];
        arrayList.toArray(mPPOrderNodeArray);
        return mPPOrderNodeArray;
    }

    private void addNodesSF(Collection<MPPOrderNode> collection, int n, int n2) {
        MPPOrderNode mPPOrderNode = this.getNode(n, n2);
        if (mPPOrderNode != null) {
            if (!collection.contains(mPPOrderNode)) {
                collection.add(mPPOrderNode);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (MPPOrderNodeNext mPPOrderNodeNext : mPPOrderNode.getTransitions(n2)) {
                MPPOrderNode mPPOrderNode2 = this.getNode(mPPOrderNodeNext.getPP_Order_Next_ID(), n2);
                if (mPPOrderNode2 == null) continue;
                if (!collection.contains(mPPOrderNode2)) {
                    collection.add(mPPOrderNode2);
                    arrayList.add(mPPOrderNodeNext.getPP_Order_Next_ID());
                    continue;
                }
                this.log.saveError("Error", "Cyclic transition found - " + mPPOrderNode + " -> " + mPPOrderNode2);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                this.addNodesSF(collection, n3, n2);
            }
        }
    }

    public int getNext(int n, int n2) {
        MPPOrderNode[] mPPOrderNodeArray = this.getNodesInOrder(n2);
        for (int i = 0; i < mPPOrderNodeArray.length; ++i) {
            if (mPPOrderNodeArray[i].getPP_Order_Node_ID() != n) continue;
            MPPOrderNodeNext[] mPPOrderNodeNextArray = mPPOrderNodeArray[i].getTransitions(n2);
            if (mPPOrderNodeNextArray.length > 0) {
                return mPPOrderNodeNextArray[0].getPP_Order_Next_ID();
            }
            return 0;
        }
        return 0;
    }

    public MPPOrderNodeNext[] getNodeNexts(int n, int n2) {
        MPPOrderNode[] mPPOrderNodeArray = this.getNodesInOrder(n2);
        for (int i = 0; i < mPPOrderNodeArray.length; ++i) {
            if (mPPOrderNodeArray[i].getPP_Order_Node_ID() != n) continue;
            return mPPOrderNodeArray[i].getTransitions(n2);
        }
        return new MPPOrderNodeNext[0];
    }

    public int getPrevious(int n, int n2) {
        MPPOrderNode[] mPPOrderNodeArray = this.getNodesInOrder(n2);
        for (int i = 0; i < mPPOrderNodeArray.length; ++i) {
            if (mPPOrderNodeArray[i].getPP_Order_Node_ID() != n) continue;
            if (i > 0) {
                return mPPOrderNodeArray[i - 1].getPP_Order_Node_ID();
            }
            return 0;
        }
        return 0;
    }

    public int getNodeLastID(int n) {
        MPPOrderNode[] mPPOrderNodeArray = this.getNodesInOrder(n);
        if (mPPOrderNodeArray.length > 0) {
            return mPPOrderNodeArray[mPPOrderNodeArray.length - 1].getPP_Order_Node_ID();
        }
        return 0;
    }

    public MPPOrderNode getLastNode(int n) {
        MPPOrderNode[] mPPOrderNodeArray = this.getNodesInOrder(n);
        if (mPPOrderNodeArray.length > 0) {
            return mPPOrderNodeArray[mPPOrderNodeArray.length - 1];
        }
        return null;
    }

    public boolean isFirst(int n, int n2) {
        return n == this.getPP_Order_Node_ID();
    }

    public boolean isLast(int n, int n2) {
        MPPOrderNode[] mPPOrderNodeArray = this.getNodesInOrder(n2);
        return n == mPPOrderNodeArray[mPPOrderNodeArray.length - 1].getPP_Order_Node_ID();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MPPOrderWorkflow[");
        stringBuffer.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return stringBuffer.toString();
    }

    @Override
    protected boolean afterSave(boolean bl, boolean bl2) {
        this.log.fine("Success=" + bl2);
        if (bl2 && bl) {
            MPPOrderNode[] mPPOrderNodeArray = this.getNodesInOrder(0);
            for (int i = 0; i < mPPOrderNodeArray.length; ++i) {
                mPPOrderNodeArray[i].saveEx(this.get_TrxName());
            }
        }
        return bl2;
    }

    public long getDurationBaseSec() {
        if (this.getDurationUnit() == null) {
            return 0L;
        }
        if ("s".equals(this.getDurationUnit())) {
            return 1L;
        }
        if ("m".equals(this.getDurationUnit())) {
            return 60L;
        }
        if ("h".equals(this.getDurationUnit())) {
            return 3600L;
        }
        if ("D".equals(this.getDurationUnit())) {
            return 86400L;
        }
        if ("M".equals(this.getDurationUnit())) {
            return 2592000L;
        }
        if ("Y".equals(this.getDurationUnit())) {
            return 31536000L;
        }
        return 0L;
    }

    public int getDurationCalendarField() {
        if (this.getDurationUnit() == null) {
            return 12;
        }
        if ("s".equals(this.getDurationUnit())) {
            return 13;
        }
        if ("m".equals(this.getDurationUnit())) {
            return 12;
        }
        if ("h".equals(this.getDurationUnit())) {
            return 10;
        }
        if ("D".equals(this.getDurationUnit())) {
            return 6;
        }
        if ("M".equals(this.getDurationUnit())) {
            return 2;
        }
        if ("Y".equals(this.getDurationUnit())) {
            return 1;
        }
        return 12;
    }

    public void closeActivities(MPPOrderNode mPPOrderNode, Timestamp timestamp, boolean bl) {
        if (mPPOrderNode.getPP_Order_Workflow_ID() != this.get_ID()) {
            throw new AdempiereException("Activity and Order Workflow not matching (" + mPPOrderNode + ", PP_Order_Workflow_ID=" + this.get_ID() + ")");
        }
        MPPOrder mPPOrder = this.getMPPOrder();
        int n = mPPOrderNode.get_ID();
        while (n != 0) {
            MPPOrderNode mPPOrderNode2 = this.getNode(n);
            if (bl && mPPOrderNode2.isMilestone() && mPPOrderNode2.get_ID() != mPPOrderNode.get_ID()) break;
            if ("DR".equals(mPPOrderNode2.getDocStatus())) {
                BigDecimal bigDecimal = mPPOrderNode2.getQtyToDeliver();
                if (bigDecimal.signum() > 0) {
                    int n2 = mPPOrderNode2.getSetupTimeRequiered() - mPPOrderNode2.getSetupTimeReal();
                    RoutingService routingService = RoutingServiceFactory.get().getRoutingService(mPPOrderNode2.getAD_Client_ID());
                    BigDecimal bigDecimal2 = routingService.estimateWorkingTime(mPPOrderNode2, bigDecimal);
                    MPPCostCollector.createCollector(mPPOrder, mPPOrder.getM_Product_ID(), mPPOrder.getM_Locator_ID(), mPPOrder.getM_AttributeSetInstance_ID(), mPPOrderNode2.getS_Resource_ID(), 0, mPPOrderNode2.get_ID(), MDocType.getDocType("MCC"), "160", timestamp, bigDecimal, Env.ZERO, Env.ZERO, n2, bigDecimal2);
                    mPPOrderNode2.load(mPPOrder.get_TrxName());
                    mPPOrderNode2.closeIt();
                    mPPOrderNode2.saveEx();
                }
            } else if ("CO".equals(mPPOrderNode2.getDocStatus()) || "IP".equals(mPPOrderNode2.getDocStatus())) {
                mPPOrderNode2.closeIt();
                mPPOrderNode2.saveEx();
            }
            n = this.getPrevious(n, this.getAD_Client_ID());
        }
        this.m_nodes = null;
    }

    public void voidActivities() {
        for (MPPOrderNode mPPOrderNode : this.getNodes(true, this.getAD_Client_ID())) {
            BigDecimal bigDecimal = mPPOrderNode.getQtyRequiered();
            if (bigDecimal.signum() == 0) continue;
            mPPOrderNode.addDescription(Msg.getMsg(this.getCtx(), "Voided") + " (" + bigDecimal + ")");
            mPPOrderNode.voidIt();
            mPPOrderNode.saveEx();
        }
    }

    public MPPOrder getMPPOrder() {
        if (this.m_order == null) {
            this.m_order = new MPPOrder(this.getCtx(), this.getPP_Order_ID(), this.get_TrxName());
        }
        return this.m_order;
    }
}

