/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.eevolution.model.I_PP_Order_Workflow;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPOrderNodeNext;
import org.eevolution.model.MPPOrderWorkflow;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;
import org.eevolution.model.X_PP_Order_Node;

public class MPPOrderNode
extends X_PP_Order_Node {
    private static final long serialVersionUID = 1L;
    private static CCache<Integer, MPPOrderNode> s_cache = new CCache("PP_Order_Node", 50);
    MPPOrderWorkflow m_order_wf = null;
    private List<MPPOrderNodeNext> m_next = null;
    private long m_durationBaseMS = -1L;

    public static MPPOrderNode get(Properties properties, int n) {
        return MPPOrderNode.get(properties, n, null);
    }

    public static MPPOrderNode get(Properties properties, int n, String string) {
        if (n <= 0) {
            return null;
        }
        MPPOrderNode mPPOrderNode = null;
        if (string == null && (mPPOrderNode = s_cache.get(n)) != null) {
            return mPPOrderNode;
        }
        mPPOrderNode = new MPPOrderNode(properties, n, string);
        if (mPPOrderNode.getPP_Order_Node_ID() <= 0) {
            mPPOrderNode = null;
        }
        if (mPPOrderNode != null && string == null) {
            s_cache.put(n, mPPOrderNode);
        }
        return mPPOrderNode;
    }

    public static boolean isLastNode(Properties properties, int n, String string) {
        String string2 = "PP_Order_Node_ID=?";
        return false == new Query(properties, "PP_Order_NodeNext", string2, string).setOnlyActiveRecords(true).setParameters(n).match();
    }

    public MPPOrderNode(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setDefault();
        }
        if (this.get_ID() != 0 && string == null) {
            s_cache.put(this.getPP_Order_Node_ID(), this);
        }
    }

    public MPPOrderNode(MPPOrderWorkflow mPPOrderWorkflow, String string, String string2) {
        this(mPPOrderWorkflow.getCtx(), 0, mPPOrderWorkflow.get_TrxName());
        this.setClientOrg(mPPOrderWorkflow);
        this.setPP_Order_Workflow_ID(mPPOrderWorkflow.getPP_Order_Workflow_ID());
        this.setValue(string);
        this.setName(string2);
        this.m_durationBaseMS = mPPOrderWorkflow.getDurationBaseSec() * 1000L;
    }

    public MPPOrderNode(MWFNode mWFNode, MPPOrderWorkflow mPPOrderWorkflow, BigDecimal bigDecimal, String string) {
        this(mWFNode.getCtx(), 0, string);
        this.setPP_Order_ID(mPPOrderWorkflow.getPP_Order_ID());
        this.setPP_Order_Workflow_ID(mPPOrderWorkflow.getPP_Order_Workflow_ID());
        this.setAction(mWFNode.getAction());
        this.setAD_WF_Node_ID(mWFNode.getAD_WF_Node_ID());
        this.setAD_WF_Responsible_ID(mWFNode.getAD_WF_Responsible_ID());
        this.setAD_Workflow_ID(mWFNode.getAD_Workflow_ID());
        this.setIsSubcontracting(mWFNode.isSubcontracting());
        this.setIsMilestone(mWFNode.isMilestone());
        this.setC_BPartner_ID(mWFNode.getC_BPartner_ID());
        this.setCost(mWFNode.getCost());
        this.setDuration(mWFNode.getDuration());
        this.setUnitsCycles(mWFNode.getUnitsCycles().intValueExact());
        this.setOverlapUnits(mWFNode.getOverlapUnits());
        this.setEntityType(mWFNode.getEntityType());
        this.setIsCentrallyMaintained(mWFNode.isCentrallyMaintained());
        this.setJoinElement(mWFNode.getJoinElement());
        this.setLimit(mWFNode.getLimit());
        this.setName(mWFNode.getName());
        this.setPriority(mWFNode.getPriority());
        this.setSplitElement(mWFNode.getSplitElement());
        this.setSubflowExecution(mWFNode.getSubflowExecution());
        this.setValue(mWFNode.getValue());
        this.setS_Resource_ID(mWFNode.getS_Resource_ID());
        this.setSetupTime(mWFNode.getSetupTime());
        this.setSetupTimeRequiered(mWFNode.getSetupTime());
        this.setMovingTime(mWFNode.getMovingTime());
        this.setWaitingTime(mWFNode.getWaitingTime());
        this.setWorkingTime(mWFNode.getWorkingTime());
        this.setQueuingTime(mWFNode.getQueuingTime());
        this.setXPosition(mWFNode.getXPosition());
        this.setYPosition(mWFNode.getYPosition());
        this.setDocAction(mWFNode.getDocAction());
        this.setAD_Column_ID(mWFNode.getAD_Column_ID());
        this.setAD_Form_ID(mWFNode.getAD_Form_ID());
        this.setAD_Image_ID(mWFNode.getAD_Image_ID());
        this.setAD_Window_ID(mWFNode.getAD_Window_ID());
        this.setAD_Process_ID(mWFNode.getAD_Process_ID());
        this.setAttributeName(mWFNode.getAttributeName());
        this.setAttributeValue(mWFNode.getAttributeValue());
        this.setC_BPartner_ID(mWFNode.getC_BPartner_ID());
        this.setStartMode(mWFNode.getStartMode());
        this.setFinishMode(mWFNode.getFinishMode());
        this.setValidFrom(mWFNode.getValidFrom());
        this.setValidTo(mWFNode.getValidTo());
        this.setQtyOrdered(bigDecimal);
        this.setDocStatus("DR");
    }

    public MPPOrderNode(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
        if (string == null) {
            s_cache.put(this.getPP_Order_Node_ID(), this);
        }
    }

    private List<MPPOrderNodeNext> getNodeNexts() {
        if (this.m_next != null) {
            return this.m_next;
        }
        boolean bl = "A".equals(this.getSplitElement());
        String string = "PP_Order_Node_ID=?";
        this.m_next = new Query(this.getCtx(), "PP_Order_NodeNext", string, this.get_TrxName()).setParameters(this.get_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo,PP_Order_Node_ID").list();
        for (MPPOrderNodeNext mPPOrderNodeNext : this.m_next) {
            mPPOrderNodeNext.setFromSplitAnd(bl);
        }
        this.log.fine("#" + this.m_next.size());
        return this.m_next;
    }

    public void setQtyOrdered(BigDecimal bigDecimal) {
        this.setQtyRequiered(bigDecimal);
        RoutingService routingService = RoutingServiceFactory.get().getRoutingService(this.getAD_Client_ID());
        BigDecimal bigDecimal2 = routingService.estimateWorkingTime(this, bigDecimal);
        this.setDurationRequiered(bigDecimal2.intValueExact());
    }

    public BigDecimal getQtyToDeliver() {
        return this.getQtyRequiered().subtract(this.getQtyDelivered());
    }

    public int getNextNodeCount() {
        return this.getNodeNexts().size();
    }

    public MPPOrderNodeNext[] getTransitions(int n) {
        ArrayList<MPPOrderNodeNext> arrayList = new ArrayList<MPPOrderNodeNext>();
        for (MPPOrderNodeNext mPPOrderNodeNext : this.getNodeNexts()) {
            if (mPPOrderNodeNext.getAD_Client_ID() != 0 && mPPOrderNodeNext.getAD_Client_ID() != n) continue;
            arrayList.add(mPPOrderNodeNext);
        }
        return arrayList.toArray(new MPPOrderNodeNext[arrayList.size()]);
    }

    public long getDurationMS() {
        long l = super.getDuration();
        if (l == 0L) {
            return 0L;
        }
        if (this.m_durationBaseMS == -1L) {
            this.m_durationBaseMS = this.getMPPOrderWorkflow().getDurationBaseSec() * 1000L;
        }
        return l * this.m_durationBaseMS;
    }

    public long getLimitMS() {
        long l = super.getLimit();
        if (l == 0L) {
            return 0L;
        }
        if (this.m_durationBaseMS == -1L) {
            this.m_durationBaseMS = this.getMPPOrderWorkflow().getDurationBaseSec() * 1000L;
        }
        return l * this.m_durationBaseMS;
    }

    public int getDurationCalendarField() {
        return this.getMPPOrderWorkflow().getDurationCalendarField();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MPPOrderNode[");
        stringBuffer.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return stringBuffer.toString();
    }

    public MPPOrderWorkflow getMPPOrderWorkflow() {
        if (this.m_order_wf == null) {
            this.m_order_wf = new MPPOrderWorkflow(this.getCtx(), this.getPP_Order_Workflow_ID(), this.get_TrxName());
        }
        return this.m_order_wf;
    }

    @Override
    public I_PP_Order_Workflow getPP_Order_Workflow() {
        return this.getMPPOrderWorkflow();
    }

    public void completeIt() {
        this.setDocStatus("CO");
        this.setDocAction("--");
        this.setDateFinish(true);
    }

    public void closeIt() {
        this.setDocStatus("CL");
        this.setDocAction("--");
        this.setDateFinish(false);
        int n = this.getDurationRequiered();
        if (n != this.getDurationReal()) {
            this.addDescription(Msg.parseTranslation(this.getCtx(), "@closed@ ( @Duration@ :" + n + ") ( @QtyRequiered@ :" + this.getQtyRequiered() + ")"));
            this.setDurationRequiered(this.getDurationReal());
            this.setQtyRequiered(this.getQtyDelivered());
        }
    }

    public void voidIt() {
        String string = this.getDocStatus();
        if ("VO".equals(string)) {
            this.log.warning("Activity already voided - " + this);
            return;
        }
        BigDecimal bigDecimal = this.getQtyRequiered();
        if (bigDecimal.signum() != 0) {
            this.addDescription(Msg.getMsg(this.getCtx(), "Voided") + " (" + bigDecimal + ")");
        }
        this.setDocStatus("VO");
        this.setDocAction("--");
        this.setQtyRequiered(Env.ZERO);
        this.setSetupTimeRequiered(0);
        this.setDurationRequiered(0);
    }

    public void setInProgress(MPPCostCollector mPPCostCollector) {
        if (this.isProcessed()) {
            throw new IllegalStateException("Cannot change status from " + this.getDocStatus() + " to " + "IP");
        }
        this.setDocStatus("IP");
        this.setDocAction("CO");
        if (mPPCostCollector != null && this.getDateStart() == null) {
            this.setDateStart(mPPCostCollector.getDateStart());
        }
    }

    public boolean isProcessed() {
        String string = this.getDocStatus();
        return "CO".equals(string) || "CL".equals(string);
    }

    public void addDescription(String string) {
        String string2 = this.getDescription();
        if (string2 == null) {
            this.setDescription(string);
        } else {
            this.setDescription(string2 + " | " + string);
        }
    }

    private void setDefault() {
        this.setAction("Z");
        this.setCost(Env.ZERO);
        this.setDuration(0);
        this.setEntityType("U");
        this.setIsCentrallyMaintained(true);
        this.setJoinElement("X");
        this.setLimit(0);
        this.setSplitElement("X");
        this.setWaitingTime(0);
        this.setXPosition(0);
        this.setYPosition(0);
        this.setDocStatus("DR");
    }

    private void setDateFinish(boolean bl) {
        if (!"CO".equals(this.getDocStatus()) && !"CL".equals(this.getDocStatus())) {
            throw new IllegalStateException("Calling setDateFinish when the activity is not completed/closed is not allowed");
        }
        if (!bl && this.getDateFinish() != null) {
            this.log.fine("DateFinish already set : Date=" + this.getDateFinish() + ", Override=" + bl);
            return;
        }
        Timestamp timestamp = DB.getSQLValueTSEx(this.get_TrxName(), "SELECT MAX(MovementDate) FROM PP_Cost_Collector WHERE PP_Order_Node_ID=? AND DocStatus IN (?,?,?) AND CostCollectorType=?", this.get_ID(), "IP", "CO", "CL", "160");
        if (timestamp == null) {
            this.log.warning("Activity Completed/Closed but no cost collectors found!");
            return;
        }
        this.setDateFinish(timestamp);
    }

    public BigDecimal getVariance(String string, String string2) {
        BigDecimal bigDecimal = new Query(this.getCtx(), "PP_Cost_Collector", "PP_Order_Node_ID=? AND PP_Order_ID=? AND DocStatus IN (?,?) AND CostCollectorType=?", this.get_TrxName()).setParameters(this.getPP_Order_Node_ID(), this.getPP_Order_ID(), "CO", "CL", string).sum(string2);
        return bigDecimal;
    }

    public BigDecimal getSetupTimeUsageVariance() {
        return this.getVariance("120", "SetupTimeReal");
    }

    public BigDecimal getDurationUsageVariance() {
        return this.getVariance("120", "DurationReal");
    }
}

