/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.X_PP_Order_BOMLine;

public class MPPOrderBOMLine
extends X_PP_Order_BOMLine {
    private static final long serialVersionUID = -201479481618586562L;
    private MPPOrder m_parent = null;
    private boolean m_isExplodePhantom = false;
    private BigDecimal m_qtyRequieredPhantom = null;
    private BigDecimal m_qtyOnHand = null;
    private BigDecimal m_qtyAvailable = null;

    public static MPPOrderBOMLine forM_Product_ID(Properties properties, int n, int n2, String string) {
        return (MPPOrderBOMLine)new Query(properties, "PP_Order_BOMLine", "PP_Order_ID=? AND M_Product_ID=?", string).setParameters(n, n2).firstOnly();
    }

    public MPPOrderBOMLine(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setDefault();
        }
    }

    public MPPOrderBOMLine(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MPPOrderBOMLine(MPPProductBOMLine mPPProductBOMLine, int n, int n2, int n3, String string) {
        this(mPPProductBOMLine.getCtx(), 0, string);
        this.setPP_Order_BOM_ID(n2);
        this.setPP_Order_ID(n);
        this.setM_Warehouse_ID(n3);
        this.setM_ChangeNotice_ID(mPPProductBOMLine.getM_ChangeNotice_ID());
        this.setDescription(mPPProductBOMLine.getDescription());
        this.setHelp(mPPProductBOMLine.getHelp());
        this.setAssay(mPPProductBOMLine.getAssay());
        this.setQtyBatch(mPPProductBOMLine.getQtyBatch());
        this.setQtyBOM(mPPProductBOMLine.getQtyBOM());
        this.setIsQtyPercentage(mPPProductBOMLine.isQtyPercentage());
        this.setComponentType(mPPProductBOMLine.getComponentType());
        this.setC_UOM_ID(mPPProductBOMLine.getC_UOM_ID());
        this.setForecast(mPPProductBOMLine.getForecast());
        this.setIsCritical(mPPProductBOMLine.isCritical());
        this.setIssueMethod(mPPProductBOMLine.getIssueMethod());
        this.setLeadTimeOffset(mPPProductBOMLine.getLeadTimeOffset());
        this.setM_AttributeSetInstance_ID(mPPProductBOMLine.getM_AttributeSetInstance_ID());
        this.setM_Product_ID(mPPProductBOMLine.getM_Product_ID());
        this.setScrap(mPPProductBOMLine.getScrap());
        this.setValidFrom(mPPProductBOMLine.getValidFrom());
        this.setValidTo(mPPProductBOMLine.getValidTo());
        this.setBackflushGroup(mPPProductBOMLine.getBackflushGroup());
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (!this.isActive()) {
            throw new AdempiereException("De-Activating an BOM Line is not allowed");
        }
        if (!bl && this.is_ValueChanged("M_Product_ID")) {
            throw new AdempiereException("Changing Product is not allowed");
        }
        if (this.getLine() == 0) {
            String string = "SELECT COALESCE(MAX(Line),0)+10 FROM PP_Order_BOMLine WHERE PP_Order_ID=?";
            int n = DB.getSQLValueEx(this.get_TrxName(), string, this.getPP_Order_ID());
            this.setLine(n);
        }
        if (bl && "PH".equals(this.getComponentType())) {
            this.m_qtyRequieredPhantom = this.getQtyRequiered();
            this.m_isExplodePhantom = true;
            this.setQtyRequiered(Env.ZERO);
        }
        if (bl || this.is_ValueChanged("C_UOM_ID") || this.is_ValueChanged("QtyEntered") || this.is_ValueChanged("QtyRequiered")) {
            int n = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            this.setQtyEntered(this.getQtyEntered().setScale(n, RoundingMode.UP));
            this.setQtyRequiered(this.getQtyRequiered().setScale(n, RoundingMode.UP));
        }
        if (this.is_ValueChanged("QtyDelivered") || this.is_ValueChanged("QtyRequiered")) {
            this.reserveStock();
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean bl, boolean bl2) {
        if (!bl2) {
            return false;
        }
        this.explodePhantom();
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        this.setQtyRequiered(Env.ZERO);
        this.reserveStock();
        return true;
    }

    private void explodePhantom() {
        if (this.m_isExplodePhantom && this.m_qtyRequieredPhantom != null) {
            MProduct mProduct = MProduct.get(this.getCtx(), this.getM_Product_ID());
            int n = MPPProductBOM.getBOMSearchKey(mProduct);
            if (n <= 0) {
                return;
            }
            MPPProductBOM mPPProductBOM = MPPProductBOM.get(this.getCtx(), n);
            if (mPPProductBOM != null) {
                for (MPPProductBOMLine mPPProductBOMLine : mPPProductBOM.getLines()) {
                    MPPOrderBOMLine mPPOrderBOMLine = new MPPOrderBOMLine(mPPProductBOMLine, this.getPP_Order_ID(), this.getPP_Order_BOM_ID(), this.getM_Warehouse_ID(), this.get_TrxName());
                    mPPOrderBOMLine.setAD_Org_ID(this.getAD_Org_ID());
                    mPPOrderBOMLine.setQtyOrdered(this.m_qtyRequieredPhantom);
                    mPPOrderBOMLine.saveEx();
                }
            }
            this.m_isExplodePhantom = false;
        }
    }

    @Override
    public MProduct getM_Product() {
        return MProduct.get(this.getCtx(), this.getM_Product_ID());
    }

    @Override
    public MUOM getC_UOM() {
        return MUOM.get(this.getCtx(), this.getC_UOM_ID());
    }

    @Override
    public MWarehouse getM_Warehouse() {
        return MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
    }

    public BigDecimal getQtyRequieredPhantom() {
        return this.m_qtyRequieredPhantom != null ? this.m_qtyRequieredPhantom : Env.ZERO;
    }

    public MPPOrder getParent() {
        int n = this.getPP_Order_ID();
        if (n <= 0) {
            this.m_parent = null;
            return null;
        }
        if (this.m_parent == null || this.m_parent.get_ID() != n) {
            this.m_parent = new MPPOrder(this.getCtx(), n, this.get_TrxName());
        }
        return this.m_parent;
    }

    public int getPrecision() {
        return MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
    }

    public BigDecimal getQtyMultiplier() {
        BigDecimal bigDecimal = this.isQtyPercentage() ? this.getQtyBatch().divide(Env.ONEHUNDRED, 8, RoundingMode.HALF_UP) : this.getQtyBOM();
        return bigDecimal;
    }

    public void setQtyOrdered(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.getQtyMultiplier();
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2).setScale(8, RoundingMode.UP);
        if (this.isComponentType("CO", "PH", "BY", "CP")) {
            this.setQtyRequiered(bigDecimal3);
            this.setQtyEntered(bigDecimal3);
        } else if (this.isComponentType("PK", "TL")) {
            this.setQtyRequiered(bigDecimal2);
            this.setQtyEntered(bigDecimal2);
        } else {
            throw new AdempiereException("@NotSupported@ @ComponentType@ " + this.getComponentType());
        }
        BigDecimal bigDecimal4 = this.getScrap();
        if (bigDecimal4.signum() != 0) {
            bigDecimal4 = bigDecimal4.divide(Env.ONEHUNDRED, 8, 0);
            this.setQtyRequiered(this.getQtyRequiered().divide(Env.ONE.subtract(bigDecimal4), 8, 4));
            this.setQtyEntered(this.getQtyEntered().divide(Env.ONE.subtract(bigDecimal4), 8, 4));
        }
    }

    @Override
    public void setQtyRequiered(BigDecimal bigDecimal) {
        if (bigDecimal != null && this.getC_UOM_ID() != 0) {
            int n = this.getPrecision();
            bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        }
        super.setQtyRequiered(bigDecimal);
    }

    @Override
    public void setQtyReserved(BigDecimal bigDecimal) {
        if (bigDecimal != null && this.getC_UOM_ID() != 0) {
            int n = this.getPrecision();
            bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        }
        super.setQtyReserved(bigDecimal);
    }

    public BigDecimal getQtyOpen() {
        return this.getQtyEntered().subtract(this.getQtyDelivered());
    }

    private void loadStorage(boolean bl) {
        if (!bl && this.m_qtyOnHand != null && this.m_qtyAvailable != null) {
            return;
        }
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement("SELECT  bomQtyAvailable(M_Product_ID, M_Warehouse_ID, 0),bomQtyOnHand(M_Product_ID, M_Warehouse_ID, 0) FROM PP_Order_BOMLine WHERE PP_Order_BOMLine_ID=?", this.get_TrxName());
            DB.setParameters((PreparedStatement)cPreparedStatement, new Object[]{this.get_ID()});
            resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                this.m_qtyAvailable = resultSet.getBigDecimal(1);
                this.m_qtyOnHand = resultSet.getBigDecimal(2);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException(sQLException, "SELECT  bomQtyAvailable(M_Product_ID, M_Warehouse_ID, 0),bomQtyOnHand(M_Product_ID, M_Warehouse_ID, 0) FROM PP_Order_BOMLine WHERE PP_Order_BOMLine_ID=?");
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
    }

    public BigDecimal getQtyAvailable() {
        this.loadStorage(false);
        return this.m_qtyAvailable;
    }

    public BigDecimal getQtyVariance() {
        BigDecimal bigDecimal = new Query(this.getCtx(), "PP_Cost_Collector", "PP_Order_BOMLine_ID=? AND PP_Order_ID=? AND DocStatus IN (?,?) AND CostCollectorType=?", this.get_TrxName()).setParameters(this.getPP_Order_BOMLine_ID(), this.getPP_Order_ID(), "CO", "CL", "120").sum("MovementQty");
        return bigDecimal;
    }

    public BigDecimal getQtyMethodChangeVariance() {
        BigDecimal bigDecimal = new Query(this.getCtx(), "PP_Cost_Collector", "PP_Order_BOMLine_ID=? AND PP_Order_ID=? AND DocStatus IN (?,?) AND CostCollectorType=?", this.get_TrxName()).setParameters(this.getPP_Order_BOMLine_ID(), this.getPP_Order_ID(), "CO", "CL", "130").sum("MovementQty");
        return bigDecimal;
    }

    public BigDecimal getQtyOnHand() {
        this.loadStorage(false);
        return this.m_qtyOnHand;
    }

    public boolean isComponentType(String ... stringArray) {
        String string = this.getComponentType();
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isCoProduct() {
        return this.isComponentType("CP");
    }

    public boolean isByProduct() {
        return this.isComponentType("BY");
    }

    public boolean isComponent() {
        return this.isComponentType("CO", "PK");
    }

    public void addDescription(String string) {
        String string2 = this.getDescription();
        if (string2 == null) {
            this.setDescription(string);
        } else {
            this.setDescription(string2 + " | " + string);
        }
    }

    private void setDefault() {
        this.setDescription("");
        this.setQtyDelivered(Env.ZERO);
        this.setQtyPost(Env.ZERO);
        this.setQtyReject(Env.ZERO);
        this.setQtyRequiered(Env.ZERO);
        this.setQtyReserved(Env.ZERO);
        this.setQtyScrap(Env.ZERO);
    }

    protected void reserveStock() {
        int n = this.getParent().getM_Warehouse_ID();
        if (n != 0) {
            if (n != this.getM_Warehouse_ID()) {
                this.setM_Warehouse_ID(n);
            }
            if (this.getAD_Org_ID() != this.getAD_Org_ID()) {
                this.setAD_Org_ID(this.getAD_Org_ID());
            }
        }
        BigDecimal bigDecimal = this.getQtyRequiered();
        BigDecimal bigDecimal2 = bigDecimal.subtract(this.getQtyReserved()).subtract(this.getQtyDelivered());
        this.log.fine("Line=" + this.getLine() + " - Target=" + bigDecimal + ",Difference=" + bigDecimal2 + " - Requiered=" + this.getQtyRequiered() + ",Reserved=" + this.getQtyReserved() + ",Delivered=" + this.getQtyDelivered());
        if (bigDecimal2.signum() == 0) {
            return;
        }
        MProduct mProduct = this.getM_Product();
        if (!mProduct.isStocked()) {
            return;
        }
        BigDecimal bigDecimal3 = bigDecimal2;
        int n2 = this.getM_Locator_ID(bigDecimal3);
        if (!MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), n2, this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_AttributeSetInstance_ID(), Env.ZERO, bigDecimal3, Env.ZERO, this.get_TrxName())) {
            throw new AdempiereException();
        }
        this.setQtyReserved(this.getQtyReserved().add(bigDecimal2));
    }

    private int getM_Locator_ID(BigDecimal bigDecimal) {
        MLocator mLocator;
        int n = 0;
        int n2 = this.getM_AttributeSetInstance_ID();
        if (n2 != 0) {
            n = MStorage.getM_Locator_ID(this.getM_Warehouse_ID(), this.getM_Product_ID(), n2, bigDecimal, this.get_TrxName());
        }
        if (n == 0) {
            n = this.getM_Locator_ID();
        }
        if (n == 0 && (mLocator = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID()).getDefaultLocator()) != null) {
            n = mLocator.get_ID();
        }
        return n;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.get_ID() + ", Product=" + this.getM_Product_ID() + ", ComponentType=" + this.getComponentType() + ",QtyBatch=" + this.getQtyBatch() + ",QtyRequiered=" + this.getQtyRequiered() + ",QtyScrap=" + this.getQtyScrap() + "]";
    }
}

