/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.adempiere.model.engines.CostDimension;
import org.compiere.model.I_AD_Workflow;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MResource;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Workflow;
import org.compiere.model.X_M_Product;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.eevolution.exceptions.BOMExpiredException;
import org.eevolution.exceptions.RoutingExpiredException;
import org.eevolution.model.I_PP_Order;
import org.eevolution.model.I_PP_Order_BOMLine;
import org.eevolution.model.I_PP_Order_Node;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPOrderBOM;
import org.eevolution.model.MPPOrderBOMLine;
import org.eevolution.model.MPPOrderCost;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.model.MPPOrderNodeAsset;
import org.eevolution.model.MPPOrderNodeNext;
import org.eevolution.model.MPPOrderNodeProduct;
import org.eevolution.model.MPPOrderWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.MPPWFNodeAsset;
import org.eevolution.model.MPPWFNodeProduct;
import org.eevolution.model.MQMSpecification;
import org.eevolution.model.X_PP_Order;
import org.eevolution.model.X_PP_Order_BOMLine;
import org.eevolution.model.X_PP_Order_Node;

public class MPPOrder
extends X_PP_Order
implements DocAction {
    private static final long serialVersionUID = 1L;
    private MPPOrderBOMLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MPPOrderWorkflow m_PP_Order_Workflow = null;

    public static MPPOrder forC_OrderLine_ID(Properties properties, int n, String string) {
        MOrderLine mOrderLine = new MOrderLine(properties, n, string);
        return (MPPOrder)new Query(properties, "PP_Order", "C_OrderLine_ID=? AND M_Product_ID=?", string).setParameters(n, mOrderLine.getM_Product_ID()).firstOnly();
    }

    public static void updateQtyBatchs(Properties properties, I_PP_Order i_PP_Order, boolean bl) {
        BigDecimal bigDecimal = i_PP_Order.getQtyBatchSize();
        if (bigDecimal.signum() == 0 || bl) {
            int n = i_PP_Order.getAD_Workflow_ID();
            if (n <= 0) {
                return;
            }
            MWorkflow mWorkflow = MWorkflow.get(properties, n);
            bigDecimal = mWorkflow.getQtyBatchSize().setScale(0, RoundingMode.UP);
            i_PP_Order.setQtyBatchSize(bigDecimal);
        }
        BigDecimal bigDecimal2 = bigDecimal.signum() == 0 ? Env.ONE : i_PP_Order.getQtyOrdered().divide(bigDecimal, 0, 0);
        i_PP_Order.setQtyBatchs(bigDecimal2);
    }

    public static boolean isQtyAvailable(MPPOrder mPPOrder, ArrayList[][] arrayListArray, Timestamp timestamp) {
        boolean bl = false;
        for (int i = 0; i < arrayListArray.length; ++i) {
            Serializable serializable;
            int n;
            KeyNamePair keyNamePair = (KeyNamePair)arrayListArray[i][0].get(0);
            boolean bl2 = keyNamePair.getName().equals("Y");
            if (keyNamePair == null || !bl2) continue;
            String string = (String)arrayListArray[i][0].get(2);
            KeyNamePair keyNamePair2 = (KeyNamePair)arrayListArray[i][0].get(3);
            int n2 = keyNamePair2.getKey();
            BigDecimal bigDecimal = (BigDecimal)arrayListArray[i][0].get(4);
            BigDecimal bigDecimal2 = (BigDecimal)arrayListArray[i][0].get(5);
            MProduct mProduct = MProduct.get(mPPOrder.getCtx(), n2);
            if (mProduct == null || !mProduct.isStocked()) continue;
            int n3 = 0;
            if (string == null && bl2) {
                n3 = keyNamePair.getKey();
            } else if (string != null && bl2 && (n = Integer.valueOf(keyNamePair.getKey()).intValue()) > 0) {
                serializable = new MPPOrderBOMLine(mPPOrder.getCtx(), n, mPPOrder.get_TrxName());
                n3 = ((X_PP_Order_BOMLine)serializable).getM_AttributeSetInstance_ID();
            }
            MStorage[] mStorageArray = MPPOrder.getStorages(mPPOrder.getCtx(), n2, mPPOrder.getM_Warehouse_ID(), n3, timestamp, mPPOrder.get_TrxName());
            if (n3 == 0) {
                serializable = bigDecimal.add(bigDecimal2);
                for (MStorage mStorage : mStorageArray) {
                    BigDecimal bigDecimal3;
                    if (mStorage.getQtyOnHand().signum() != 0 && ((BigDecimal)(serializable = ((BigDecimal)serializable).subtract(bigDecimal3 = ((BigDecimal)serializable).min(mStorage.getQtyOnHand())))).signum() <= 0) break;
                }
            } else {
                serializable = bigDecimal;
                ((BigDecimal)serializable).setScale(4, 4);
                serializable = Env.ZERO;
            }
            serializable = Env.ZERO;
            for (MStorage mStorage : mStorageArray) {
                serializable = ((BigDecimal)serializable).add(mStorage.getQtyOnHand());
            }
            boolean bl3 = bl = ((BigDecimal)serializable).compareTo(bigDecimal.add(bigDecimal2)) >= 0;
            if (!bl) break;
        }
        return bl;
    }

    public static MStorage[] getStorages(Properties properties, int n, int n2, int n3, Timestamp timestamp, String string) {
        MProduct mProduct = MProduct.get(properties, n);
        if (mProduct != null && mProduct.isStocked()) {
            if (mProduct.getM_AttributeSetInstance_ID() == 0) {
                String string2 = mProduct.getMMPolicy();
                return MStorage.getWarehouse(properties, n2, n, n3, timestamp, "F".equals(string2), true, 0, string);
            }
            String string3 = mProduct.getMMPolicy();
            return MStorage.getWarehouse(properties, n2, n, 0, timestamp, "F".equals(string3), true, 0, string);
        }
        return new MStorage[0];
    }

    public MPPOrder(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setDefault();
        }
    }

    public MPPOrder(MProject mProject, int n, int n2) {
        this(mProject.getCtx(), 0, mProject.get_TrxName());
        this.setAD_Client_ID(mProject.getAD_Client_ID());
        this.setAD_Org_ID(mProject.getAD_Org_ID());
        this.setC_Campaign_ID(mProject.getC_Campaign_ID());
        this.setC_Project_ID(mProject.getC_Project_ID());
        this.setDescription(mProject.getName());
        this.setLine(10);
        this.setPriorityRule("5");
        if (mProject.getDateContract() == null) {
            throw new IllegalStateException("Date Contract is mandatory for Manufacturing Order.");
        }
        if (mProject.getDateFinish() == null) {
            throw new IllegalStateException("Date Finish is mandatory for Manufacturing Order.");
        }
        Timestamp timestamp = mProject.getDateContract();
        Timestamp timestamp2 = mProject.getDateContract();
        if (timestamp != null) {
            this.setDateOrdered(timestamp);
        }
        if (timestamp != null) {
            this.setDateStartSchedule(timestamp);
        }
        timestamp = mProject.getDateFinish();
        if (timestamp2 != null) {
            this.setDatePromised(timestamp2);
        }
        this.setM_Warehouse_ID(mProject.getM_Warehouse_ID());
        this.setPP_Product_BOM_ID(n);
        this.setAD_Workflow_ID(n2);
        this.setQtyEntered(Env.ONE);
        this.setQtyOrdered(Env.ONE);
        MPPProductBOM mPPProductBOM = new MPPProductBOM(mProject.getCtx(), n, mProject.get_TrxName());
        MProduct mProduct = MProduct.get(mProject.getCtx(), mPPProductBOM.getM_Product_ID());
        this.setC_UOM_ID(mProduct.getC_UOM_ID());
        this.setM_Product_ID(mPPProductBOM.getM_Product_ID());
        String string = "IsManufacturingResource = 'Y' AND ManufacturingResourceType = 'PT' AND M_Warehouse_ID = " + mProject.getM_Warehouse_ID();
        MResource mResource = (MResource)MTable.get(mProject.getCtx(), MResource.Table_ID).getPO(string, mProject.get_TrxName());
        if (mResource == null) {
            throw new IllegalStateException("Resource is mandatory.");
        }
        this.setS_Resource_ID(mResource.getS_Resource_ID());
    }

    public MPPOrder(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public BigDecimal getQtyOpen() {
        return this.getQtyOrdered().subtract(this.getQtyDelivered()).subtract(this.getQtyScrap());
    }

    public MPPOrderBOMLine[] getLines(boolean bl) {
        if (this.m_lines != null && !bl) {
            MPPOrder.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String string = "PP_Order_ID=?";
        List<MPPOrderBOMLine> list = new Query(this.getCtx(), "PP_Order_BOMLine", string, this.get_TrxName()).setParameters(this.getPP_Order_ID()).setOrderBy("Line").list();
        this.m_lines = list.toArray(new MPPOrderBOMLine[list.size()]);
        return this.m_lines;
    }

    public MPPOrderBOMLine[] getLines() {
        return this.getLines(true);
    }

    public void setC_DocTypeTarget_ID(String string) {
        if (this.getC_DocTypeTarget_ID() > 0) {
            return;
        }
        MDocType[] mDocTypeArray = MDocType.getOfDocBaseType(this.getCtx(), string);
        if (mDocTypeArray == null) {
            throw new DocTypeNotFoundException(string, "");
        }
        this.setC_DocTypeTarget_ID(mDocTypeArray[0].get_ID());
    }

    @Override
    public void setProcessed(boolean bl) {
        super.setProcessed(bl);
        if (this.get_ID() <= 0) {
            return;
        }
        DB.executeUpdateEx("UPDATE PP_Order SET Processed=? WHERE PP_Order_ID=?", new Object[]{bl, this.get_ID()}, this.get_TrxName());
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        int n;
        if (this.getAD_Client_ID() == 0) {
            this.m_processMsg = "AD_Client_ID = 0";
            return false;
        }
        if (this.getAD_Org_ID() == 0) {
            n = Env.getAD_Org_ID(this.getCtx());
            if (n == 0) {
                this.m_processMsg = "AD_Org_ID = 0";
                return false;
            }
            this.setAD_Org_ID(n);
            this.log.warning("beforeSave - Changed Org to Context=" + n);
        }
        if (this.getM_Warehouse_ID() == 0 && (n = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID")) != 0) {
            this.setM_Warehouse_ID(n);
        }
        if (this.getC_UOM_ID() <= 0 && this.getM_Product_ID() > 0) {
            this.setC_UOM_ID(this.getM_Product().getC_UOM_ID());
        }
        if (this.getDateFinishSchedule() == null) {
            this.setDateFinishSchedule(this.getDatePromised());
        }
        if (this.is_ValueChanged("QtyDelivered") || this.is_ValueChanged("QtyOrdered")) {
            this.orderStock();
        }
        MPPOrder.updateQtyBatchs(this.getCtx(), this, false);
        return true;
    }

    @Override
    protected boolean afterSave(boolean bl, boolean bl2) {
        if (!bl2) {
            return false;
        }
        if ("CL".equals(this.getDocAction()) || "VO".equals(this.getDocAction())) {
            return true;
        }
        if (this.is_ValueChanged("QtyEntered") && !this.isDelivered()) {
            this.deleteWorkflowAndBOM();
            this.explotion();
        }
        if (this.is_ValueChanged("QtyEntered") && this.isDelivered()) {
            throw new AdempiereException("Cannot Change Quantity, Only is allow with Draft or In Process Status");
        }
        if (!bl) {
            return bl2;
        }
        this.explotion();
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.getDocStatus().equals("DR") || this.getDocStatus().equals("IP")) {
            String string = "PP_Order_ID=? AND AD_Client_ID=?";
            Object[] objectArray = new Object[]{this.get_ID(), this.getAD_Client_ID()};
            this.deletePO("PP_Order_Cost", string, objectArray);
            this.deleteWorkflowAndBOM();
        }
        this.setQtyOrdered(Env.ZERO);
        this.orderStock();
        return true;
    }

    private void deleteWorkflowAndBOM() {
        if (this.get_ID() <= 0) {
            return;
        }
        String string = "PP_Order_ID=? AND AD_Client_ID=?";
        Object[] objectArray = new Object[]{this.get_ID(), this.getAD_Client_ID()};
        DB.executeUpdateEx("UPDATE PP_Order_Workflow SET PP_Order_Node_ID=NULL WHERE " + string, objectArray, this.get_TrxName());
        this.deletePO("PP_Order_Node_Asset", string, objectArray);
        this.deletePO("PP_Order_Node_Product", string, objectArray);
        this.deletePO("PP_Order_NodeNext", string, objectArray);
        this.deletePO("PP_Order_Node", string, objectArray);
        this.deletePO("PP_Order_Workflow", string, objectArray);
        this.deletePO("PP_Order_BOMLine", string, objectArray);
        this.deletePO("PP_Order_BOM", string, objectArray);
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        String string;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPPOrderBOMLine[] mPPOrderBOMLineArray = this.getLines(true);
        if (mPPOrderBOMLineArray.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getC_DocType_ID() != 0) {
            for (int i = 0; i < mPPOrderBOMLineArray.length; ++i) {
                if (mPPOrderBOMLineArray[i].getM_Warehouse_ID() == this.getM_Warehouse_ID()) continue;
                this.log.warning("different Warehouse " + mPPOrderBOMLineArray[i]);
                this.m_processMsg = "@CannotChangeDocType@";
                return "IN";
            }
        }
        if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        if (!"MQO".equals(string = MDocType.get(this.getCtx(), this.getC_DocType_ID()).getDocBaseType())) {
            this.reserveStock(mPPOrderBOMLineArray);
            this.orderStock();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    private void orderStock() {
        MProduct mProduct = this.getM_Product();
        if (!mProduct.isStocked()) {
            return;
        }
        BigDecimal bigDecimal = this.getQtyOrdered();
        BigDecimal bigDecimal2 = bigDecimal.subtract(this.getQtyReserved()).subtract(this.getQtyDelivered());
        if (bigDecimal2.signum() == 0) {
            return;
        }
        BigDecimal bigDecimal3 = bigDecimal2;
        int n = this.getM_Locator_ID(bigDecimal3);
        if ("CL".equals(this.getDocAction()) ? !MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), n, this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_AttributeSetInstance_ID(), Env.ZERO, Env.ZERO, bigDecimal3, this.get_TrxName()) : !MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), n, this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_AttributeSetInstance_ID(), Env.ZERO, Env.ZERO, bigDecimal3, this.get_TrxName())) {
            throw new AdempiereException();
        }
        this.setQtyReserved(this.getQtyReserved().add(bigDecimal2));
    }

    private void reserveStock(MPPOrderBOMLine[] mPPOrderBOMLineArray) {
        for (MPPOrderBOMLine mPPOrderBOMLine : mPPOrderBOMLineArray) {
            mPPOrderBOMLine.reserveStock();
            mPPOrderBOMLine.saveEx();
        }
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (mDocType.getDocBaseType().equals("MQO")) {
            String string = "PP_Product_BOM_ID=? AND AD_Workflow_ID=?";
            MQMSpecification mQMSpecification = (MQMSpecification)new Query(this.getCtx(), "QM_Specification", string, this.get_TrxName()).setParameters(this.getPP_Product_BOM_ID(), this.getAD_Workflow_ID()).firstOnly();
            return mQMSpecification != null ? mQMSpecification.isValid(this.getM_AttributeSetInstance_ID()) : true;
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String string;
        if ("PR".equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (!this.m_justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.createStandardCosts();
        this.autoReportActivities();
        this.setDocAction("CL");
        string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        return "CO";
    }

    public boolean isAvailable() {
        String string = "QtyOnHand >= QtyRequiered AND PP_Order_ID=?";
        boolean bl = new Query(this.getCtx(), "RV_PP_Order_Storage", string, this.get_TrxName()).setParameters(this.get_ID()).match();
        return bl;
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.isDelivered()) {
            throw new AdempiereException("Cannot void this document because exist transactions");
        }
        for (MPPOrderBOMLine mPPOrderBOMLine : this.getLines()) {
            BigDecimal bigDecimal = mPPOrderBOMLine.getQtyRequiered();
            if (bigDecimal.signum() == 0) continue;
            mPPOrderBOMLine.addDescription(Msg.parseTranslation(this.getCtx(), "@Voided@ @QtyRequiered@ : (" + bigDecimal + ")"));
            mPPOrderBOMLine.setQtyRequiered(Env.ZERO);
            mPPOrderBOMLine.saveEx();
        }
        this.getMPPOrderWorkflow().voidActivities();
        BigDecimal bigDecimal = this.getQtyOrdered();
        if (bigDecimal.signum() != 0) {
            this.addDescription(Msg.parseTranslation(this.getCtx(), "@Voided@ @QtyOrdered@ : (" + bigDecimal + ")"));
            this.setQtyOrdered(Env.ZERO);
            this.setQtyEntered(Env.ZERO);
            this.saveEx();
        }
        this.orderStock();
        this.reserveStock(this.getLines());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        Object object;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus())) {
            return true;
        }
        if (!"CO".equals(this.getDocStatus())) {
            object = this.completeIt();
            this.setDocStatus((String)object);
            this.setDocAction("--");
        }
        if (!this.isDelivered()) {
            throw new AdempiereException("Cannot close this document because do not exist transactions");
        }
        this.createVariances();
        for (MPPOrderBOMLine mPPOrderBOMLine : this.getLines()) {
            BigDecimal bigDecimal = mPPOrderBOMLine.getQtyRequiered();
            if (bigDecimal.compareTo(mPPOrderBOMLine.getQtyDelivered()) == 0) continue;
            mPPOrderBOMLine.setQtyRequiered(mPPOrderBOMLine.getQtyDelivered());
            mPPOrderBOMLine.addDescription(Msg.parseTranslation(this.getCtx(), "@closed@ @QtyRequiered@ (" + bigDecimal + ")"));
            mPPOrderBOMLine.saveEx();
        }
        object = this.getMPPOrderWorkflow();
        ((MPPOrderWorkflow)object).closeActivities(((MPPOrderWorkflow)object).getLastNode(this.getAD_Client_ID()), this.getUpdated(), false);
        BigDecimal bigDecimal = this.getQtyOrdered();
        if (bigDecimal.signum() != 0) {
            this.addDescription(Msg.parseTranslation(this.getCtx(), "@closed@ @QtyOrdered@ : (" + bigDecimal + ")"));
            this.setQtyOrdered(this.getQtyDelivered());
            this.saveEx();
        }
        this.orderStock();
        this.reserveStock(this.getLines());
        this.setDocStatus("CL");
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return this.voidIt();
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.isDelivered()) {
            throw new AdempiereException("Cannot re activate this document because exist transactions");
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getPlanner_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public String getSummary() {
        return "" + this.getDocumentNo() + "/" + this.getDatePromised();
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine reportEngine = ReportEngine.get(this.getCtx(), 8, this.getPP_Order_ID());
        if (reportEngine == null) {
            return null;
        }
        return reportEngine.getPDF(file);
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePO(String string, String string2, Object[] objectArray) {
        POResultSet pOResultSet = new Query(this.getCtx(), string, string2, this.get_TrxName()).setParameters(objectArray).scroll();
        try {
            while (pOResultSet.hasNext()) {
                ((PO)pOResultSet.next()).deleteEx(true);
            }
        }
        finally {
            pOResultSet.close();
        }
    }

    public void setQty(BigDecimal bigDecimal) {
        super.setQtyEntered(bigDecimal);
        super.setQtyOrdered(this.getQtyEntered());
    }

    @Override
    public void setQtyEntered(BigDecimal bigDecimal) {
        if (bigDecimal != null && this.getC_UOM_ID() != 0) {
            int n = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            bigDecimal = bigDecimal.setScale(n, 4);
        }
        super.setQtyEntered(bigDecimal);
    }

    @Override
    public void setQtyOrdered(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            int n = this.getM_Product().getUOMPrecision();
            bigDecimal = bigDecimal.setScale(n, 4);
        }
        super.setQtyOrdered(bigDecimal);
    }

    @Override
    public MProduct getM_Product() {
        return MProduct.get(this.getCtx(), this.getM_Product_ID());
    }

    public MPPOrderBOM getMPPOrderBOM() {
        return (MPPOrderBOM)new Query(this.getCtx(), "PP_Order_BOM", "PP_Order_ID=?", this.get_TrxName()).setParameters(this.getPP_Order_ID()).firstOnly();
    }

    public MPPOrderWorkflow getMPPOrderWorkflow() {
        if (this.m_PP_Order_Workflow != null) {
            return this.m_PP_Order_Workflow;
        }
        this.m_PP_Order_Workflow = (MPPOrderWorkflow)new Query(this.getCtx(), "PP_Order_Workflow", "PP_Order_ID=?", this.get_TrxName()).setParameters(this.getPP_Order_ID()).firstOnly();
        return this.m_PP_Order_Workflow;
    }

    private void explotion() {
        MPPOrderWorkflow mPPOrderWorkflow;
        PO pO;
        MPPProductBOM mPPProductBOM = MPPProductBOM.get(this.getCtx(), this.getPP_Product_BOM_ID());
        if (this.getM_Product_ID() != mPPProductBOM.getM_Product_ID()) {
            throw new AdempiereException("@NotMatch@ @PP_Product_BOM_ID@ , @M_Product_ID@");
        }
        MProduct mProduct = MProduct.get(this.getCtx(), mPPProductBOM.getM_Product_ID());
        if (!mProduct.isVerified()) {
            throw new AdempiereException("Product BOM Configuration not verified. Please verify the product first - " + mProduct.getValue());
        }
        if (mPPProductBOM.isValidFromTo(this.getDateStartSchedule())) {
            pO = new MPPOrderBOM(mPPProductBOM, this.getPP_Order_ID(), this.get_TrxName());
            pO.setAD_Org_ID(this.getAD_Org_ID());
            pO.saveEx();
            for (MPPProductBOMLine mPPProductBOMLine : mPPProductBOM.getLines(true)) {
                if (mPPProductBOMLine.isValidFromTo(this.getDateStartSchedule())) {
                    MPPOrderBOMLine pO2 = new MPPOrderBOMLine(mPPProductBOMLine, this.getPP_Order_ID(), pO.get_ID(), this.getM_Warehouse_ID(), this.get_TrxName());
                    pO2.setAD_Org_ID(this.getAD_Org_ID());
                    pO2.setM_Warehouse_ID(this.getM_Warehouse_ID());
                    pO2.setM_Locator_ID(this.getM_Locator_ID());
                    pO2.setQtyOrdered(this.getQtyOrdered());
                    pO2.saveEx();
                    continue;
                }
                this.log.fine("BOM Line skiped - " + mPPProductBOMLine);
            }
        } else {
            throw new BOMExpiredException(mPPProductBOM, this.getDateStartSchedule());
        }
        pO = MWorkflow.get(this.getCtx(), this.getAD_Workflow_ID());
        if (!((X_AD_Workflow)pO).isValid()) {
            throw new AdempiereException("Routing is not valid. Please validate it first - " + ((X_AD_Workflow)pO).getValue());
        }
        if (((MWorkflow)pO).isValidFromTo(this.getDateStartSchedule())) {
            mPPOrderWorkflow = new MPPOrderWorkflow((MWorkflow)pO, this.get_ID(), this.get_TrxName());
            mPPOrderWorkflow.setAD_Org_ID(this.getAD_Org_ID());
            mPPOrderWorkflow.saveEx();
            for (MWFNode mWFNode : ((MWorkflow)pO).getNodes(false, this.getAD_Client_ID())) {
                if (!mWFNode.isValidFromTo(this.getDateStartSchedule())) continue;
                MPPOrderNodeNext[] mPPOrderNodeNextArray = new MPPOrderNode(mWFNode, mPPOrderWorkflow, this.getQtyOrdered(), this.get_TrxName());
                mPPOrderNodeNextArray.setAD_Org_ID(this.getAD_Org_ID());
                mPPOrderNodeNextArray.saveEx();
                for (MWFNodeNext mWFNodeNext : mWFNode.getTransitions(this.getAD_Client_ID())) {
                    MPPOrderNodeNext mPPOrderNodeNext = new MPPOrderNodeNext(mWFNodeNext, (MPPOrderNode)mPPOrderNodeNextArray);
                    mPPOrderNodeNext.setAD_Org_ID(this.getAD_Org_ID());
                    mPPOrderNodeNext.saveEx();
                }
                for (MPPWFNodeProduct mPPWFNodeProduct : MPPWFNodeProduct.forAD_WF_Node_ID(this.getCtx(), mWFNode.get_ID())) {
                    MPPOrderNodeProduct mPPOrderNodeProduct = new MPPOrderNodeProduct(mPPWFNodeProduct, (MPPOrderNode)mPPOrderNodeNextArray);
                    mPPOrderNodeProduct.setAD_Org_ID(this.getAD_Org_ID());
                    mPPOrderNodeProduct.saveEx();
                }
                for (MPPWFNodeAsset mPPWFNodeAsset : MPPWFNodeAsset.forAD_WF_Node_ID(this.getCtx(), mWFNode.get_ID())) {
                    MPPOrderNodeAsset mPPOrderNodeAsset = new MPPOrderNodeAsset(mPPWFNodeAsset, (MPPOrderNode)mPPOrderNodeNextArray);
                    mPPOrderNodeAsset.setAD_Org_ID(this.getAD_Org_ID());
                    mPPOrderNodeAsset.saveEx();
                }
            }
            mPPOrderWorkflow.getNodes(true);
            for (PO pO2 : mPPOrderWorkflow.getNodes(false, this.getAD_Client_ID())) {
                if (mPPOrderWorkflow.getAD_WF_Node_ID() == ((X_PP_Order_Node)pO2).getAD_WF_Node_ID()) {
                    mPPOrderWorkflow.setPP_Order_Node_ID(((X_PP_Order_Node)pO2).getPP_Order_Node_ID());
                }
                for (MPPOrderNodeNext mPPOrderNodeNext : ((MPPOrderNode)pO2).getTransitions(this.getAD_Client_ID())) {
                    mPPOrderNodeNext.setPP_Order_Next_ID();
                    mPPOrderNodeNext.saveEx();
                }
            }
        } else {
            throw new RoutingExpiredException((I_AD_Workflow)((Object)pO), this.getDateStartSchedule());
        }
        mPPOrderWorkflow.saveEx();
    }

    public static void createReceipt(MPPOrder mPPOrder, Timestamp timestamp, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, int n, int n2) {
        if (bigDecimal2.signum() != 0 || bigDecimal3.signum() != 0 || bigDecimal4.signum() != 0) {
            MPPCostCollector.createCollector(mPPOrder, mPPOrder.getM_Product_ID(), n, n2, mPPOrder.getS_Resource_ID(), 0, 0, MDocType.getDocType("MCC"), "100", timestamp, bigDecimal2, bigDecimal3, bigDecimal4, 0, Env.ZERO);
        }
        mPPOrder.setDateDelivered(timestamp);
        if (mPPOrder.getDateStart() == null) {
            mPPOrder.setDateStart(timestamp);
        }
        BigDecimal bigDecimal5 = bigDecimal;
        BigDecimal bigDecimal6 = bigDecimal3;
        BigDecimal bigDecimal7 = bigDecimal2;
        if (bigDecimal5.add(bigDecimal6).compareTo(bigDecimal7) >= 0) {
            mPPOrder.setDateFinish(timestamp);
        }
        mPPOrder.saveEx();
    }

    public static void createIssue(MPPOrder mPPOrder, int n, Timestamp timestamp, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, MStorage[] mStorageArray, boolean bl) {
        if (bigDecimal.signum() == 0) {
            return;
        }
        MPPOrderBOMLine mPPOrderBOMLine = new MPPOrderBOMLine(mPPOrder.getCtx(), n, mPPOrder.get_TrxName());
        BigDecimal bigDecimal4 = bigDecimal.add(bigDecimal2);
        for (MStorage mStorage : mStorageArray) {
            if (mStorage.getQtyOnHand().signum() == 0) continue;
            BigDecimal bigDecimal5 = bigDecimal4.min(mStorage.getQtyOnHand());
            if (bigDecimal5.signum() != 0 || bigDecimal2.signum() != 0 || bigDecimal3.signum() != 0) {
                String string = "110";
                if (mPPOrderBOMLine.getQtyBatch().signum() == 0 && mPPOrderBOMLine.getQtyBOM().signum() == 0) {
                    string = "130";
                } else if (mPPOrderBOMLine.isComponentType("CP")) {
                    string = "150";
                }
                MPPCostCollector.createCollector(mPPOrder, mPPOrderBOMLine.getM_Product_ID(), mStorage.getM_Locator_ID(), mStorage.getM_AttributeSetInstance_ID(), mPPOrder.getS_Resource_ID(), n, 0, MDocType.getDocType("MCC"), string, timestamp, bigDecimal5, bigDecimal2, bigDecimal3, 0, Env.ZERO);
            }
            if ((bigDecimal4 = bigDecimal4.subtract(bigDecimal5)).signum() == 0) break;
        }
        if (bl && bigDecimal4.signum() != 0) {
            MPPCostCollector.createCollector(mPPOrder, mPPOrderBOMLine.getM_Product_ID(), mPPOrderBOMLine.getM_Locator_ID(), mPPOrderBOMLine.getM_AttributeSetInstance_ID(), mPPOrder.getS_Resource_ID(), n, 0, MDocType.getDocType("MCC"), "110", timestamp, bigDecimal4, Env.ZERO, Env.ZERO, 0, Env.ZERO);
            return;
        }
        if (bigDecimal4.signum() != 0) {
            throw new AdempiereException("Should not happen toIssue=" + bigDecimal4);
        }
    }

    public static boolean isQtyAvailable(MPPOrder mPPOrder, I_PP_Order_BOMLine i_PP_Order_BOMLine) {
        MProduct mProduct = MProduct.get(mPPOrder.getCtx(), i_PP_Order_BOMLine.getM_Product_ID());
        if (mProduct == null || !mProduct.isStocked()) {
            return true;
        }
        BigDecimal bigDecimal = i_PP_Order_BOMLine.getQtyRequiered();
        BigDecimal bigDecimal2 = i_PP_Order_BOMLine.getQtyScrap();
        BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2);
        BigDecimal bigDecimal4 = MStorage.getQtyAvailable(mPPOrder.getM_Warehouse_ID(), 0, i_PP_Order_BOMLine.getM_Product_ID(), i_PP_Order_BOMLine.getM_AttributeSetInstance_ID(), mPPOrder.get_TrxName());
        return bigDecimal4.compareTo(bigDecimal3) >= 0;
    }

    public int getM_Locator_ID() {
        MWarehouse mWarehouse = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
        return mWarehouse.getDefaultLocator().getM_Locator_ID();
    }

    private int getM_Locator_ID(BigDecimal bigDecimal) {
        int n = 0;
        int n2 = this.getM_AttributeSetInstance_ID();
        if (n2 != 0) {
            n = MStorage.getM_Locator_ID(this.getM_Warehouse_ID(), this.getM_Product_ID(), n2, bigDecimal, this.get_TrxName());
        }
        if (n == 0) {
            n = this.getM_Locator_ID();
        }
        return n;
    }

    public boolean isDelivered() {
        if (this.getQtyDelivered().signum() > 0 || this.getQtyScrap().signum() > 0 || this.getQtyReject().signum() > 0) {
            return true;
        }
        for (MPPOrderBOMLine pO : this.getLines()) {
            if (pO.getQtyDelivered().signum() <= 0) continue;
            return true;
        }
        for (PO pO : this.getMPPOrderWorkflow().getNodes(true, this.getAD_Client_ID())) {
            if (((X_PP_Order_Node)pO).getQtyDelivered().signum() > 0) {
                return true;
            }
            if (((X_PP_Order_Node)pO).getDurationReal() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setDefault() {
        this.setLine(10);
        this.setPriorityRule("5");
        this.setDescription("");
        this.setQtyDelivered(Env.ZERO);
        this.setQtyReject(Env.ZERO);
        this.setQtyScrap(Env.ZERO);
        this.setIsSelected(false);
        this.setIsSOTrx(false);
        this.setIsApproved(false);
        this.setIsPrinted(false);
        this.setProcessed(false);
        this.setProcessing(false);
        this.setPosted(false);
        this.setC_DocTypeTarget_ID("MOP");
        this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        this.setDocStatus("DR");
        this.setDocAction("PR");
    }

    public void addDescription(String string) {
        String string2 = this.getDescription();
        if (string2 == null) {
            this.setDescription(string);
        } else {
            this.setDescription(string2 + " | " + string);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MPPOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append("]");
        return stringBuffer.toString();
    }

    public void autoReportActivities() {
        for (MPPOrderNode mPPOrderNode : this.getMPPOrderWorkflow().getNodes()) {
            if (!mPPOrderNode.isMilestone() || !mPPOrderNode.isSubcontracting() && mPPOrderNode.get_ID() != this.getMPPOrderWorkflow().getPP_Order_Node_ID()) continue;
            MPPCostCollector mPPCostCollector = MPPCostCollector.createCollector(this, this.getM_Product_ID(), this.getM_Locator_ID(), this.getM_AttributeSetInstance_ID(), this.getS_Resource_ID(), 0, mPPOrderNode.getPP_Order_Node_ID(), MDocType.getDocType("MCC"), "160", this.getUpdated(), mPPOrderNode.getQtyToDeliver(), Env.ZERO, Env.ZERO, 0, Env.ZERO);
        }
    }

    private final void createStandardCosts() {
        PO pO;
        List list;
        Object object2;
        MAcctSchema mAcctSchema = MClient.get(this.getCtx(), this.getAD_Client_ID()).getAcctSchema();
        this.log.info("Cost_Group_ID" + mAcctSchema.getM_CostType_ID());
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        MPPOrderBOMLine[] mPPOrderBOMLineArray = this.getM_Product();
        treeSet.add(mPPOrderBOMLineArray.getM_Product_ID());
        CostDimension costDimension = new CostDimension((MProduct)mPPOrderBOMLineArray, mAcctSchema, mAcctSchema.getM_CostType_ID(), this.getAD_Org_ID(), this.getM_AttributeSetInstance_ID(), -10);
        List list2 = costDimension.toQuery(MCost.class, this.get_TrxName()).list();
        for (Object object2 : list2) {
            list = new MPPOrderCost((MCost)object2, this.get_ID(), this.get_TrxName());
            ((PO)((Object)list)).saveEx();
        }
        for (MPPOrderBOMLine mPPOrderBOMLine : this.getLines()) {
            object2 = mPPOrderBOMLine.getM_Product();
            if (treeSet.contains(((X_M_Product)object2).getM_Product_ID())) continue;
            treeSet.add(((X_M_Product)object2).getM_Product_ID());
            list = new CostDimension(mPPOrderBOMLine.getM_Product(), mAcctSchema, mAcctSchema.getM_CostType_ID(), mPPOrderBOMLine.getAD_Org_ID(), mPPOrderBOMLine.getM_AttributeSetInstance_ID(), -10);
            List list3 = ((CostDimension)((Object)list)).toQuery(MCost.class, this.get_TrxName()).list();
            Object object3 = list3.iterator();
            while (object3.hasNext()) {
                pO = (MCost)object3.next();
                MPPOrderCost mPPOrderCost = new MPPOrderCost((MCost)pO, this.get_ID(), this.get_TrxName());
                mPPOrderCost.saveEx();
            }
        }
        for (MPPOrderNode mPPOrderNode : this.getMPPOrderWorkflow().getNodes(true)) {
            MProduct mProduct;
            int n = mPPOrderNode.getS_Resource_ID();
            if (n <= 0 || treeSet.contains((mProduct = MProduct.forS_Resource_ID(this.getCtx(), n, null)).getM_Product_ID())) continue;
            treeSet.add(mProduct.getM_Product_ID());
            object2 = new CostDimension(mProduct, mAcctSchema, mAcctSchema.getM_CostType_ID(), mPPOrderNode.getAD_Org_ID(), 0, -10);
            list = ((CostDimension)object2).toQuery(MCost.class, this.get_TrxName()).list();
            for (Object object3 : list) {
                pO = new MPPOrderCost((MCost)object3, this.getPP_Order_ID(), this.get_TrxName());
                pO.saveEx();
            }
        }
    }

    public void createVariances() {
        for (MPPOrderBOMLine mPPOrderBOMLine : this.getLines(true)) {
            this.createUsageVariance(mPPOrderBOMLine);
        }
        this.m_lines = null;
        MPPOrderWorkflow mPPOrderWorkflow = this.getMPPOrderWorkflow();
        if (mPPOrderWorkflow != null) {
            for (MPPOrderNode mPPOrderNode : mPPOrderWorkflow.getNodes(true)) {
                this.createUsageVariance(mPPOrderNode);
            }
        }
    }

    private void createUsageVariance(I_PP_Order_BOMLine i_PP_Order_BOMLine) {
        MLocator mLocator;
        MPPOrder mPPOrder = this;
        Timestamp timestamp = mPPOrder.getUpdated();
        MPPOrderBOMLine mPPOrderBOMLine = (MPPOrderBOMLine)i_PP_Order_BOMLine;
        if (mPPOrderBOMLine.getQtyBatch().signum() == 0 && mPPOrderBOMLine.getQtyBOM().signum() == 0) {
            return;
        }
        BigDecimal bigDecimal = mPPOrderBOMLine.getQtyVariance();
        BigDecimal bigDecimal2 = mPPOrderBOMLine.getQtyOpen();
        BigDecimal bigDecimal3 = bigDecimal2.subtract(bigDecimal);
        if (bigDecimal3.signum() == 0) {
            return;
        }
        int n = mPPOrderBOMLine.getM_Locator_ID();
        if (n <= 0 && (mLocator = MLocator.getDefault(MWarehouse.get(mPPOrder.getCtx(), mPPOrder.getM_Warehouse_ID()))) != null) {
            n = mLocator.getM_Locator_ID();
        }
        MPPCostCollector.createCollector(mPPOrder, mPPOrderBOMLine.getM_Product_ID(), n, mPPOrderBOMLine.getM_AttributeSetInstance_ID(), mPPOrder.getS_Resource_ID(), mPPOrderBOMLine.getPP_Order_BOMLine_ID(), 0, MDocType.getDocType("MCC"), "120", timestamp, bigDecimal3, Env.ZERO, Env.ZERO, 0, Env.ZERO);
    }

    private void createUsageVariance(I_PP_Order_Node i_PP_Order_Node) {
        MPPOrder mPPOrder = this;
        Timestamp timestamp = mPPOrder.getUpdated();
        MPPOrderNode mPPOrderNode = (MPPOrderNode)i_PP_Order_Node;
        BigDecimal bigDecimal = BigDecimal.valueOf(mPPOrderNode.getSetupTimeReal());
        BigDecimal bigDecimal2 = BigDecimal.valueOf(mPPOrderNode.getDurationReal());
        if (bigDecimal.signum() == 0 && bigDecimal2.signum() == 0) {
            return;
        }
        BigDecimal bigDecimal3 = mPPOrderNode.getSetupTimeUsageVariance();
        BigDecimal bigDecimal4 = mPPOrderNode.getDurationUsageVariance();
        BigDecimal bigDecimal5 = BigDecimal.valueOf(mPPOrderNode.getSetupTimeRequiered());
        BigDecimal bigDecimal6 = BigDecimal.valueOf(mPPOrderNode.getDurationRequiered());
        BigDecimal bigDecimal7 = mPPOrderNode.getQtyToDeliver();
        BigDecimal bigDecimal8 = bigDecimal5.subtract(bigDecimal).subtract(bigDecimal3);
        BigDecimal bigDecimal9 = bigDecimal6.subtract(bigDecimal2).subtract(bigDecimal4);
        if (bigDecimal7.signum() == 0 && bigDecimal8.signum() == 0 && bigDecimal9.signum() == 0) {
            return;
        }
        MPPCostCollector.createCollector(mPPOrder, mPPOrder.getM_Product_ID(), mPPOrder.getM_Locator_ID(), mPPOrder.getM_AttributeSetInstance_ID(), mPPOrderNode.getS_Resource_ID(), 0, mPPOrderNode.getPP_Order_Node_ID(), MDocType.getDocType("MCC"), "120", timestamp, bigDecimal7, Env.ZERO, Env.ZERO, bigDecimal8.intValueExact(), bigDecimal9);
    }

    public BigDecimal getQtyToDeliver() {
        return this.getQtyOrdered().subtract(this.getQtyDelivered());
    }

    public void updateMakeToKit(BigDecimal bigDecimal) {
        MPPOrderBOM mPPOrderBOM = this.getMPPOrderBOM();
        this.getLines(true);
        if ("K".equals(mPPOrderBOM.getBOMType()) && "M".equals(mPPOrderBOM.getBOMUse())) {
            Object object;
            Serializable serializable;
            Comparable<BigDecimal> comparable;
            PO pO;
            boolean bl;
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            ArrayList[][] arrayListArray = new ArrayList[this.m_lines.length][1];
            for (bl = false; bl < this.getLines().length; bl += 1) {
                pO = this.m_lines[bl];
                KeyNamePair keyNamePair = null;
                keyNamePair = "1".equals(((X_PP_Order_BOMLine)pO).getIssueMethod()) ? new KeyNamePair(pO.get_ID(), "Y") : new KeyNamePair(pO.get_ID(), "N");
                ArrayList<Object> arrayList = new ArrayList<Object>();
                comparable = bigDecimal.multiply(((MPPOrderBOMLine)pO).getQtyMultiplier());
                arrayList.add(keyNamePair);
                arrayList.add(((X_PP_Order_BOMLine)pO).isCritical());
                serializable = ((MPPOrderBOMLine)pO).getM_Product();
                arrayList.add(((X_M_Product)serializable).getValue());
                object = new KeyNamePair(((PO)serializable).get_ID(), ((X_M_Product)serializable).getName());
                arrayList.add(object);
                arrayList.add(comparable);
                arrayList.add(Env.ZERO);
                arrayListArray[bl][0] = arrayList;
            }
            bl = false;
            pO = (MOrderLine)this.getC_OrderLine();
            if ("L".equals(((MOrderLine)pO).getParent().getDeliveryRule()) || "O".equals(((MOrderLine)pO).getParent().getDeliveryRule())) {
                boolean bl2 = MPPOrder.isQtyAvailable(this, arrayListArray, timestamp);
                if (!bl2) {
                    throw new AdempiereException("@NoQtyAvailable@");
                }
            } else {
                if ("A".equals(((MOrderLine)pO).getParent().getDeliveryRule()) || "R".equals(((MOrderLine)pO).getParent().getDeliveryRule()) || "M".equals(((MOrderLine)pO).getParent().getDeliveryRule())) {
                    throw new AdempiereException("@ActionNotSupported@");
                }
                if ("F".equals(((MOrderLine)pO).getParent().getDeliveryRule())) {
                    bl = true;
                }
            }
            for (int i = 0; i < arrayListArray.length; ++i) {
                MStorage[] mStorageArray;
                int n = 0;
                comparable = (KeyNamePair)arrayListArray[i][0].get(0);
                serializable = (Boolean)arrayListArray[i][0].get(1);
                object = (String)arrayListArray[i][0].get(2);
                KeyNamePair keyNamePair = (KeyNamePair)arrayListArray[i][0].get(3);
                int n2 = keyNamePair.getKey();
                MProduct mProduct = MProduct.get(this.getCtx(), n2);
                BigDecimal bigDecimal2 = (BigDecimal)arrayListArray[i][0].get(4);
                BigDecimal bigDecimal3 = (BigDecimal)arrayListArray[i][0].get(5);
                int n3 = ((KeyNamePair)comparable).getKey();
                if (n3 > 0) {
                    mStorageArray = new MPPOrderBOMLine(this.getCtx(), n3, this.get_TrxName());
                    n = mStorageArray.getM_AttributeSetInstance_ID();
                }
                mStorageArray = MPPOrder.getStorages(this.getCtx(), n2, this.getM_Warehouse_ID(), n, timestamp, this.get_TrxName());
                MPPOrder.createIssue(this, ((KeyNamePair)comparable).getKey(), timestamp, bigDecimal2, bigDecimal3, Env.ZERO, mStorageArray, bl);
            }
            MPPOrder.createReceipt(this, timestamp, this.getQtyDelivered(), bigDecimal, this.getQtyScrap(), this.getQtyReject(), this.getM_Locator_ID(), this.getM_AttributeSetInstance_ID());
        }
    }
}

