/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MForecastLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRefList;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MResource;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Forecast;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.eevolution.exceptions.NoPlantForWarehouseException;
import org.eevolution.model.I_PP_Product_Planning;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderBOMLine;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;
import org.eevolution.model.X_PP_MRP;

public class MPPMRP
extends X_PP_MRP {
    private static final long serialVersionUID = 6831223361306903297L;
    private static CLogger s_log = CLogger.getCLogger(MPPMRP.class);
    private static HashMap<String, String[]> s_sourceColumnNames = new HashMap();

    public static MPPOrder createMOMakeTo(MOrderLine mOrderLine, BigDecimal bigDecimal) {
        MPPOrder mPPOrder = MPPOrder.forC_OrderLine_ID(mOrderLine.getCtx(), mOrderLine.get_ID(), mOrderLine.get_TrxName());
        if (mPPOrder == null) {
            MPPProductBOM mPPProductBOM = (MPPProductBOM)new Query(mOrderLine.getCtx(), "PP_Product_BOM", "BOMType IN (?,?) AND BOMUse=? AND M_Product_ID=?", mOrderLine.get_TrxName()).setParameters("O", "K", "M", mOrderLine.getM_Product_ID()).firstOnly();
            MPPProductPlanning mPPProductPlanning = null;
            if (mPPProductBOM == null && (mPPProductPlanning = MPPProductPlanning.find(mOrderLine.getCtx(), mOrderLine.getAD_Org_ID(), 0, 0, mOrderLine.getM_Product_ID(), null)) != null && (mPPProductBOM = mPPProductPlanning.getPP_Product_BOM()) != null && !"O".equals(mPPProductBOM.getBOMType()) && !"K".equals(mPPProductBOM.getBOMType())) {
                mPPProductBOM = null;
            }
            if (mPPProductBOM != null) {
                MProduct mProduct = MProduct.get(mOrderLine.getCtx(), mOrderLine.getM_Product_ID());
                int n = MPPProductPlanning.getPlantForWarehouse(mOrderLine.getM_Warehouse_ID());
                if (n <= 0) {
                    throw new NoPlantForWarehouseException(mOrderLine.getM_Warehouse_ID());
                }
                MWorkflow mWorkflow = MWorkflow.get(mOrderLine.getCtx(), MWorkflow.getWorkflowSearchKey(mProduct));
                if (mWorkflow == null && mPPProductPlanning != null) {
                    mWorkflow = mPPProductPlanning.getAD_Workflow();
                }
                if (n > 0 && mWorkflow != null) {
                    String string = Msg.translate(mOrderLine.getCtx(), MRefList.getListName(mOrderLine.getCtx(), 347, mPPProductBOM.getBOMType())) + " " + Msg.translate(mOrderLine.getCtx(), "C_Order_ID") + " : " + mOrderLine.getParent().getDocumentNo();
                    mPPProductPlanning = new MPPProductPlanning(mOrderLine.getCtx(), 0, mOrderLine.get_TrxName());
                    mPPProductPlanning.setAD_Org_ID(mOrderLine.getAD_Org_ID());
                    mPPProductPlanning.setM_Product_ID(mProduct.getM_Product_ID());
                    mPPProductPlanning.setPlanner_ID(mOrderLine.getParent().getSalesRep_ID());
                    mPPProductPlanning.setPP_Product_BOM_ID(mPPProductBOM.getPP_Product_BOM_ID());
                    mPPProductPlanning.setAD_Workflow_ID(mWorkflow.getAD_Workflow_ID());
                    mPPProductPlanning.setM_Warehouse_ID(mOrderLine.getM_Warehouse_ID());
                    mPPProductPlanning.setS_Resource_ID(n);
                    mPPOrder = MPPMRP.createMO(mPPProductPlanning, mOrderLine.getC_OrderLine_ID(), mOrderLine.getM_AttributeSetInstance_ID(), bigDecimal, mOrderLine.getDateOrdered(), mOrderLine.getDatePromised(), string);
                    string = "";
                    if (mOrderLine.getDescription() != null) {
                        string = mOrderLine.getDescription();
                    }
                    string = string + " " + Msg.translate(mOrderLine.getCtx(), MRefList.getListName(mOrderLine.getCtx(), 347, mPPProductBOM.getBOMType())) + " " + Msg.translate(mOrderLine.getCtx(), "PP_Order_ID") + " : " + mPPOrder.getDocumentNo();
                    mOrderLine.setDescription(string);
                    mOrderLine.saveEx();
                }
            }
        } else if (!mPPOrder.isProcessed()) {
            if (mPPOrder.getM_Product_ID() != mOrderLine.getM_Product_ID()) {
                mPPOrder.setDescription("");
                mPPOrder.setQtyEntered(Env.ZERO);
                mPPOrder.setC_OrderLine_ID(0);
                mPPOrder.voidIt();
                mPPOrder.setDocStatus("VO");
                mPPOrder.setDocAction("--");
                mPPOrder.save();
                mOrderLine.setDescription("");
                mOrderLine.saveEx();
            }
            if (mPPOrder.getQtyEntered().compareTo(mOrderLine.getQtyEntered()) != 0) {
                mPPOrder.setQty(mOrderLine.getQtyEntered());
                mPPOrder.saveEx();
            }
            if (mPPOrder.getDatePromised().compareTo(mOrderLine.getDatePromised()) != 0) {
                mPPOrder.setDatePromised(mOrderLine.getDatePromised());
                mPPOrder.saveEx();
            }
        }
        return mPPOrder;
    }

    public static MPPOrder createMO(MPPProductPlanning mPPProductPlanning, int n, int n2, BigDecimal bigDecimal, Timestamp timestamp, Timestamp timestamp2, String string) {
        MPPProductBOM mPPProductBOM = mPPProductPlanning.getPP_Product_BOM();
        MWorkflow mWorkflow = mPPProductPlanning.getAD_Workflow();
        if (mPPProductPlanning.getS_Resource_ID() > 0 && mPPProductBOM != null && mWorkflow != null) {
            RoutingService routingService = RoutingServiceFactory.get().getRoutingService(mPPProductPlanning.getCtx());
            int n3 = routingService.calculateDuration(mWorkflow, MResource.get(mPPProductPlanning.getCtx(), mPPProductPlanning.getS_Resource_ID()), bigDecimal).intValueExact();
            MPPOrder mPPOrder = new MPPOrder(mPPProductPlanning.getCtx(), 0, mPPProductPlanning.get_TrxName());
            mPPOrder.setAD_Org_ID(mPPProductPlanning.getAD_Org_ID());
            mPPOrder.setDescription(string);
            mPPOrder.setC_OrderLine_ID(n);
            mPPOrder.setS_Resource_ID(mPPProductPlanning.getS_Resource_ID());
            mPPOrder.setM_Warehouse_ID(mPPProductPlanning.getM_Warehouse_ID());
            mPPOrder.setM_Product_ID(mPPProductPlanning.getM_Product_ID());
            mPPOrder.setM_AttributeSetInstance_ID(n2);
            mPPOrder.setPP_Product_BOM_ID(mPPProductPlanning.getPP_Product_BOM_ID());
            mPPOrder.setAD_Workflow_ID(mPPProductPlanning.getAD_Workflow_ID());
            mPPOrder.setPlanner_ID(mPPProductPlanning.getPlanner_ID());
            mPPOrder.setLine(10);
            mPPOrder.setDateOrdered(timestamp);
            mPPOrder.setDatePromised(timestamp2);
            mPPOrder.setDateStartSchedule(TimeUtil.addDays(timestamp2, 0 - n3));
            mPPOrder.setDateFinishSchedule(timestamp2);
            mPPOrder.setC_UOM_ID(mPPProductPlanning.getM_Product().getC_UOM_ID());
            mPPOrder.setQty(bigDecimal);
            mPPOrder.setPriorityRule("3");
            mPPOrder.saveEx();
            mPPOrder.setDocStatus(mPPOrder.prepareIt());
            mPPOrder.setDocAction("CO");
            mPPOrder.saveEx();
            return mPPOrder;
        }
        return null;
    }

    public static boolean isChanged(PO pO) {
        String[] stringArray = s_sourceColumnNames.get(pO.get_TableName());
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        if (pO.is_new() || pO.is_ValueChanged("IsActive")) {
            return true;
        }
        for (String string : stringArray) {
            if (!pO.is_ValueChanged(string)) continue;
            return true;
        }
        return false;
    }

    public static Collection<String> getSourceTableNames() {
        return s_sourceColumnNames.keySet();
    }

    public static void deleteMRP(PO pO) {
        MOrderLine mOrderLine;
        MPPOrder mPPOrder;
        String string = pO.get_TableName();
        int n = DB.executeUpdateEx("DELETE FROM PP_MRP WHERE " + string + "_ID=? AND AD_Client_ID=?", new Object[]{pO.get_ID(), pO.getAD_Client_ID()}, pO.get_TrxName());
        s_log.finest("Deleted " + string + " #" + n);
        if (pO instanceof MOrderLine && (mPPOrder = MPPOrder.forC_OrderLine_ID((mOrderLine = (MOrderLine)pO).getCtx(), mOrderLine.get_ID(), mOrderLine.get_TrxName())) != null && !mPPOrder.isProcessed()) {
            mPPOrder.deleteEx(true);
        }
    }

    private static Query getQuery(PO pO, String string, String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AD_Client_ID=?");
        arrayList.add(pO.getAD_Client_ID());
        stringBuffer.append(" AND ").append(pO.get_TableName()).append("_ID=?");
        arrayList.add(pO.get_ID());
        if (string != null) {
            stringBuffer.append(" AND ").append("TypeMRP").append("=?");
            arrayList.add(string);
        }
        if (string2 != null) {
            stringBuffer.append(" AND ").append("OrderType").append("=?");
            arrayList.add(string2);
        }
        if (pO instanceof MPPOrder) {
            stringBuffer.append(" AND ").append("PP_Order_BOMLine_ID").append(" IS NULL");
        }
        return new Query(pO.getCtx(), "PP_MRP", stringBuffer.toString(), pO.get_TrxName()).setParameters(arrayList);
    }

    public MPPMRP(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setValue("MRP");
            this.setName("MRP");
            this.setDateSimulation(new Timestamp(System.currentTimeMillis()));
            this.setIsAvailable(false);
        }
    }

    public MPPMRP(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public void setPP_Order(MPPOrder mPPOrder) {
        this.setPP_Order_ID(mPPOrder.getPP_Order_ID());
        this.setOrderType("MOP");
        this.setName(mPPOrder.getDocumentNo());
        this.setDescription(mPPOrder.getDescription());
        this.setDatePromised(mPPOrder.getDatePromised());
        this.setDateOrdered(mPPOrder.getDateOrdered());
        this.setDateStartSchedule(mPPOrder.getDateStartSchedule());
        this.setDateFinishSchedule(mPPOrder.getDateFinishSchedule());
        this.setS_Resource_ID(mPPOrder.getS_Resource_ID());
        this.setDocStatus(mPPOrder.getDocStatus());
    }

    public void setC_Order(MOrder mOrder) {
        this.setC_Order_ID(mOrder.get_ID());
        this.setC_BPartner_ID(mOrder.getC_BPartner_ID());
        this.setDocStatus(mOrder.getDocStatus());
        if (mOrder.isSOTrx()) {
            this.setOrderType("SOO");
            this.setTypeMRP("D");
        } else {
            this.setOrderType("POO");
            this.setTypeMRP("S");
        }
    }

    public void setDD_Order(MDDOrder mDDOrder) {
        this.setDD_Order_ID(mDDOrder.get_ID());
        this.setC_BPartner_ID(mDDOrder.getC_BPartner_ID());
        this.setDocStatus(mDDOrder.getDocStatus());
    }

    public void setM_Requisition(MRequisition mRequisition) {
        this.setM_Requisition_ID(mRequisition.get_ID());
        this.setOrderType("POR");
        this.setTypeMRP("S");
        this.setDateOrdered(mRequisition.getDateRequired());
        this.setDatePromised(mRequisition.getDateRequired());
        this.setDateStartSchedule(mRequisition.getDateRequired());
        this.setDateFinishSchedule(mRequisition.getDateRequired());
        this.setM_Warehouse_ID(mRequisition.getM_Warehouse_ID());
    }

    public void setM_Forecast(X_M_Forecast x_M_Forecast) {
        this.setOrderType("FCT");
        this.setTypeMRP("D");
        this.setM_Forecast_ID(x_M_Forecast.getM_Forecast_ID());
        this.setDescription(x_M_Forecast.getDescription());
    }

    public boolean isReleased() {
        String string = this.getDocStatus();
        if (string == null) {
            return false;
        }
        return "IP".equals(string) || "CO".equals(string);
    }

    public static void M_Forecast(X_M_Forecast x_M_Forecast) {
        List list = MPPMRP.getQuery(x_M_Forecast, null, null).list();
        for (MPPMRP mPPMRP : list) {
            mPPMRP.setM_Forecast(x_M_Forecast);
        }
    }

    public static void M_ForecastLine(MForecastLine mForecastLine) {
        String string = mForecastLine.get_TrxName();
        Properties properties = mForecastLine.getCtx();
        X_M_Forecast x_M_Forecast = new X_M_Forecast(properties, mForecastLine.getM_Forecast_ID(), string);
        MPPMRP mPPMRP = (MPPMRP)MPPMRP.getQuery(mForecastLine, null, null).firstOnly();
        if (mPPMRP == null) {
            mPPMRP = new MPPMRP(properties, 0, string);
            mPPMRP.setM_ForecastLine_ID(mForecastLine.getM_ForecastLine_ID());
        }
        mPPMRP.setM_Forecast(x_M_Forecast);
        mPPMRP.setName("MRP");
        mPPMRP.setAD_Org_ID(mForecastLine.getAD_Org_ID());
        mPPMRP.setDatePromised(mForecastLine.getDatePromised());
        mPPMRP.setDateStartSchedule(mForecastLine.getDatePromised());
        mPPMRP.setDateFinishSchedule(mForecastLine.getDatePromised());
        mPPMRP.setDateOrdered(mForecastLine.getDatePromised());
        mPPMRP.setM_Warehouse_ID(mForecastLine.getM_Warehouse_ID());
        mPPMRP.setM_Product_ID(mForecastLine.getM_Product_ID());
        mPPMRP.setQty(mForecastLine.getQty());
        mPPMRP.setDocStatus("IP");
        mPPMRP.saveEx();
    }

    public static void C_Order(MOrder mOrder) {
        MDocType mDocType = MDocType.get(mOrder.getCtx(), mOrder.getC_DocTypeTarget_ID());
        String string = mDocType.getDocSubTypeSO();
        if ("SO".equals(string) || !mOrder.isSOTrx()) {
            if (mOrder.getDocStatus().equals("IP") || mOrder.getDocStatus().equals("CO") || !mOrder.isSOTrx()) {
                for (MOrderLine mOrderLine : mOrder.getLines()) {
                    MPPMRP.C_OrderLine(mOrderLine);
                }
            }
            if (mOrder.is_ValueChanged("DocStatus") || mOrder.is_ValueChanged("C_BPartner_ID")) {
                List list = MPPMRP.getQuery(mOrder, null, null).list();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    MPPMRP mPPMRP = (MPPMRP)iterator.next();
                    mPPMRP.setC_Order(mOrder);
                    mPPMRP.saveEx();
                }
            }
        }
    }

    public static void C_OrderLine(MOrderLine mOrderLine) {
        MPPMRP mPPMRP = (MPPMRP)MPPMRP.getQuery(mOrderLine, null, null).firstOnly();
        if (mPPMRP == null) {
            mPPMRP = new MPPMRP(mOrderLine.getCtx(), 0, mOrderLine.get_TrxName());
            mPPMRP.setC_OrderLine_ID(mOrderLine.getC_OrderLine_ID());
        }
        mPPMRP.setAD_Org_ID(mOrderLine.getAD_Org_ID());
        mPPMRP.setC_Order(mOrderLine.getParent());
        mPPMRP.setDescription(mOrderLine.getDescription());
        mPPMRP.setName("MRP");
        mPPMRP.setDatePromised(mOrderLine.getDatePromised());
        mPPMRP.setDateStartSchedule(mOrderLine.getDatePromised());
        mPPMRP.setDateFinishSchedule(mOrderLine.getDatePromised());
        mPPMRP.setDateOrdered(mOrderLine.getDateOrdered());
        mPPMRP.setM_Warehouse_ID(mOrderLine.getM_Warehouse_ID());
        mPPMRP.setM_Product_ID(mOrderLine.getM_Product_ID());
        mPPMRP.setQty(mOrderLine.getQtyOrdered().subtract(mOrderLine.getQtyDelivered()));
        mPPMRP.saveEx();
        MOrder mOrder = mOrderLine.getParent();
        MDocType mDocType = MDocType.get(mOrder.getCtx(), mOrder.getC_DocTypeTarget_ID());
        String string = mDocType.getDocSubTypeSO();
        if ("SO".equals(string)) {
            MPPMRP.createMOMakeTo(mOrderLine, mOrderLine.getQtyOrdered());
        }
    }

    public static void PP_Order(MPPOrder mPPOrder) {
        Properties properties = mPPOrder.getCtx();
        String string = mPPOrder.get_TrxName();
        MPPMRP mPPMRP = (MPPMRP)MPPMRP.getQuery(mPPOrder, "S", "MOP").firstOnly();
        if (mPPMRP == null) {
            mPPMRP = new MPPMRP(properties, 0, string);
            mPPMRP.setAD_Org_ID(mPPOrder.getAD_Org_ID());
            mPPMRP.setTypeMRP("S");
        }
        mPPMRP.setPP_Order(mPPOrder);
        mPPMRP.setM_Product_ID(mPPOrder.getM_Product_ID());
        mPPMRP.setM_Warehouse_ID(mPPOrder.getM_Warehouse_ID());
        mPPMRP.setQty(mPPOrder.getQtyOrdered().subtract(mPPOrder.getQtyDelivered()));
        mPPMRP.saveEx();
        List list = MPPMRP.getQuery(mPPOrder, "D", "MOP").list();
        for (MPPMRP mPPMRP2 : list) {
            mPPMRP2.setPP_Order(mPPOrder);
            mPPMRP2.saveEx();
        }
    }

    public static void PP_Order_BOMLine(MPPOrderBOMLine mPPOrderBOMLine) {
        MPPMRP mPPMRP;
        String string = mPPOrderBOMLine.get_TrxName();
        Properties properties = mPPOrderBOMLine.getCtx();
        String string2 = "D";
        BigDecimal bigDecimal = mPPOrderBOMLine.getQtyRequiered().subtract(mPPOrderBOMLine.getQtyDelivered());
        if (mPPOrderBOMLine.isCoProduct() || mPPOrderBOMLine.isByProduct()) {
            string2 = "S";
            bigDecimal = bigDecimal.negate();
        }
        if ((mPPMRP = (MPPMRP)MPPMRP.getQuery(mPPOrderBOMLine, null, "MOP").firstOnly()) == null) {
            mPPMRP = new MPPMRP(properties, 0, string);
            mPPMRP.setPP_Order_BOMLine_ID(mPPOrderBOMLine.getPP_Order_BOMLine_ID());
        }
        mPPMRP.setAD_Org_ID(mPPOrderBOMLine.getAD_Org_ID());
        mPPMRP.setTypeMRP(string2);
        mPPMRP.setPP_Order(mPPOrderBOMLine.getParent());
        mPPMRP.setM_Warehouse_ID(mPPOrderBOMLine.getM_Warehouse_ID());
        mPPMRP.setM_Product_ID(mPPOrderBOMLine.getM_Product_ID());
        mPPMRP.setQty(bigDecimal);
        mPPMRP.saveEx();
    }

    public static void DD_Order(MDDOrder mDDOrder) {
        if ("IP".equals(mDDOrder.getDocStatus()) || "CO".equals(mDDOrder.getDocStatus())) {
            for (MDDOrderLine mDDOrderLine : mDDOrder.getLines()) {
                MPPMRP.DD_OrderLine(mDDOrderLine);
            }
        }
        if (mDDOrder.is_ValueChanged("DocStatus") || mDDOrder.is_ValueChanged("C_BPartner_ID")) {
            List list = MPPMRP.getQuery(mDDOrder, null, null).list();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MPPMRP mPPMRP = (MPPMRP)iterator.next();
                mPPMRP.setDD_Order(mDDOrder);
                mPPMRP.saveEx();
            }
        }
    }

    public static void DD_OrderLine(MDDOrderLine mDDOrderLine) {
        String string = mDDOrderLine.get_TrxName();
        Properties properties = mDDOrderLine.getCtx();
        MPPMRP mPPMRP = (MPPMRP)MPPMRP.getQuery(mDDOrderLine, "D", "DOO").firstOnly();
        MLocator mLocator = MLocator.get(properties, mDDOrderLine.getM_Locator_ID());
        MLocator mLocator2 = MLocator.get(properties, mDDOrderLine.getM_LocatorTo_ID());
        if (mPPMRP != null) {
            mPPMRP.setAD_Org_ID(mLocator.getAD_Org_ID());
            mPPMRP.setName("MRP");
            mPPMRP.setDescription(mDDOrderLine.getDescription());
            mPPMRP.setDatePromised(mDDOrderLine.getDatePromised());
            mPPMRP.setDateOrdered(mDDOrderLine.getDateOrdered());
            mPPMRP.setM_Warehouse_ID(mLocator.getM_Warehouse_ID());
            mPPMRP.setM_Product_ID(mDDOrderLine.getM_Product_ID());
            mPPMRP.setQty(mDDOrderLine.getQtyOrdered().subtract(mDDOrderLine.getQtyDelivered()));
            mPPMRP.setDocStatus(mDDOrderLine.getParent().getDocStatus());
            mPPMRP.saveEx();
        } else {
            mPPMRP = new MPPMRP(properties, 0, string);
            mPPMRP.setAD_Org_ID(mLocator.getAD_Org_ID());
            mPPMRP.setName("MRP");
            mPPMRP.setDescription(mDDOrderLine.getDescription());
            mPPMRP.setDD_Order_ID(mDDOrderLine.getDD_Order_ID());
            mPPMRP.setDD_OrderLine_ID(mDDOrderLine.getDD_OrderLine_ID());
            mPPMRP.setDatePromised(mDDOrderLine.getDatePromised());
            mPPMRP.setDateOrdered(mDDOrderLine.getDateOrdered());
            mPPMRP.setM_Warehouse_ID(mLocator.getM_Warehouse_ID());
            mPPMRP.setM_Product_ID(mDDOrderLine.getM_Product_ID());
            mPPMRP.setQty(mDDOrderLine.getQtyOrdered().subtract(mDDOrderLine.getQtyDelivered()));
            mPPMRP.setDocStatus(mDDOrderLine.getParent().getDocStatus());
            mPPMRP.setOrderType("DOO");
            mPPMRP.setTypeMRP("D");
            mPPMRP.saveEx();
        }
        mPPMRP = (MPPMRP)MPPMRP.getQuery(mDDOrderLine, "S", "DOO").firstOnly();
        if (mPPMRP != null) {
            mPPMRP.setAD_Org_ID(mLocator2.getAD_Org_ID());
            mPPMRP.setName("MRP");
            mPPMRP.setDescription(mDDOrderLine.getDescription());
            mPPMRP.setDatePromised(mDDOrderLine.getDatePromised());
            mPPMRP.setDateOrdered(mDDOrderLine.getDateOrdered());
            mPPMRP.setM_Product_ID(mDDOrderLine.getM_Product_ID());
            mPPMRP.setM_Warehouse_ID(mLocator2.getM_Warehouse_ID());
            mPPMRP.setQty(mDDOrderLine.getQtyOrdered().subtract(mDDOrderLine.getQtyDelivered()));
            mPPMRP.setDocStatus(mDDOrderLine.getParent().getDocStatus());
            mPPMRP.saveEx();
        } else {
            mPPMRP = new MPPMRP(properties, 0, string);
            mPPMRP.setAD_Org_ID(mLocator2.getAD_Org_ID());
            mPPMRP.setName("MRP");
            mPPMRP.setDescription(mDDOrderLine.getDescription());
            mPPMRP.setDD_Order_ID(mDDOrderLine.getDD_Order_ID());
            mPPMRP.setDD_OrderLine_ID(mDDOrderLine.getDD_OrderLine_ID());
            mPPMRP.setDatePromised(mDDOrderLine.getDatePromised());
            mPPMRP.setDateOrdered(mDDOrderLine.getDateOrdered());
            mPPMRP.setM_Product_ID(mDDOrderLine.getM_Product_ID());
            mPPMRP.setM_Warehouse_ID(mLocator2.getM_Warehouse_ID());
            mPPMRP.setQty(mDDOrderLine.getQtyOrdered().subtract(mDDOrderLine.getQtyDelivered()));
            mPPMRP.setDocStatus(mDDOrderLine.getParent().getDocStatus());
            mPPMRP.setOrderType("DOO");
            mPPMRP.setTypeMRP("S");
            mPPMRP.saveEx();
        }
    }

    public static void M_Requisition(MRequisition mRequisition) {
        List list = MPPMRP.getQuery(mRequisition, null, null).list();
        for (MPPMRP mPPMRP : list) {
            mPPMRP.setM_Requisition(mRequisition);
            mPPMRP.saveEx();
        }
    }

    public static void M_RequisitionLine(MRequisitionLine mRequisitionLine) {
        MPPMRP mPPMRP = (MPPMRP)MPPMRP.getQuery(mRequisitionLine, null, null).firstOnly();
        MRequisition mRequisition = mRequisitionLine.getParent();
        if (mPPMRP == null) {
            mPPMRP = new MPPMRP(mRequisitionLine.getCtx(), 0, mRequisitionLine.get_TrxName());
            mPPMRP.setM_Requisition_ID(mRequisitionLine.getM_Requisition_ID());
            mPPMRP.setM_RequisitionLine_ID(mRequisitionLine.getM_RequisitionLine_ID());
        }
        mPPMRP.setM_Requisition(mRequisition);
        mPPMRP.setAD_Org_ID(mRequisitionLine.getAD_Org_ID());
        mPPMRP.setName("MRP");
        mPPMRP.setDescription(mRequisitionLine.getDescription());
        mPPMRP.setM_Product_ID(mRequisitionLine.getM_Product_ID());
        mPPMRP.setQty(mRequisitionLine.getQty().subtract(mRequisitionLine.getQtyOrdered()));
        mPPMRP.setDocStatus("DR");
        mPPMRP.saveEx();
    }

    public static boolean hasProductRecords(MProduct mProduct) {
        return new Query(mProduct.getCtx(), "PP_MRP", "M_Product_ID=? AND Qty<>0", mProduct.get_TrxName()).setParameters(mProduct.getM_Product_ID()).match();
    }

    public static BigDecimal getQtyOnHand(Properties properties, int n, int n2, String string) {
        return DB.getSQLValueBDEx(string, "SELECT COALESCE(bomQtyOnHand (M_Product_ID,?,0),0) FROM M_Product WHERE AD_Client_ID=? AND M_Product_ID=?", n, Env.getAD_Client_ID(properties), n2);
    }

    public static BigDecimal getQtyReserved(Properties properties, int n, int n2, Timestamp timestamp, String string) {
        BigDecimal bigDecimal = DB.getSQLValueBDEx(string, "SELECT SUM(Qty) FROM PP_MRP WHERE  TypeMRP=? AND DocStatus IN ('IP','CO') AND AD_Client_ID=? AND M_Warehouse_ID =? AND M_Product_ID=? AND DatePromised <=?", "D", Env.getAD_Client_ID(properties), n, n2, timestamp);
        if (bigDecimal == null) {
            return Env.ZERO;
        }
        return bigDecimal;
    }

    public static BigDecimal getQtyReserved(Properties properties, int n, int n2, String string) {
        return MPPMRP.getQtyReserved(properties, n, n2, new Timestamp(System.currentTimeMillis()), string);
    }

    public static BigDecimal getQtyOrdered(Properties properties, int n, int n2, Timestamp timestamp, String string) {
        BigDecimal bigDecimal = DB.getSQLValueBDEx(string, "SELECT SUM(Qty) FROM PP_MRP WHERE  TypeMRP='S' AND DocStatus IN ('IP','CO') AND AD_Client_ID=? AND DatePromised <=? AND M_Warehouse_ID =? AND M_Product_ID=?", Env.getAD_Client_ID(properties), timestamp, n, n2);
        if (bigDecimal == null) {
            return Env.ZERO;
        }
        return bigDecimal;
    }

    public static BigDecimal getQtyOrdered(Properties properties, int n, int n2, String string) {
        return MPPMRP.getQtyOrdered(properties, n, n2, new Timestamp(System.currentTimeMillis()), string);
    }

    public static int getMaxLowLevel(Properties properties, String string) {
        int n = Env.getAD_Client_ID(properties);
        int n2 = DB.getSQLValueEx(string, "SELECT MAX(LowLevel) FROM M_Product WHERE AD_Client_ID=? AND LowLevel IS NOT NULL", n);
        return n2 + 1;
    }

    public static int getDurationDays(BigDecimal bigDecimal, I_PP_Product_Planning i_PP_Product_Planning) {
        Properties properties = null;
        properties = i_PP_Product_Planning instanceof PO ? ((PO)((Object)i_PP_Product_Planning)).getCtx() : Env.getCtx();
        MProduct mProduct = MProduct.get(properties, i_PP_Product_Planning.getM_Product_ID());
        BigDecimal bigDecimal2 = i_PP_Product_Planning.getDeliveryTime_Promised();
        if (bigDecimal2.signum() == 0 && !mProduct.isPurchased()) {
            if (i_PP_Product_Planning.getS_Resource_ID() > 0 && i_PP_Product_Planning.getAD_Workflow_ID() > 0) {
                RoutingService routingService = RoutingServiceFactory.get().getRoutingService(properties);
                bigDecimal2 = routingService.calculateDuration(i_PP_Product_Planning.getAD_Workflow(), i_PP_Product_Planning.getS_Resource(), bigDecimal);
            } else {
                throw new AdempiereException("Cannot calculate leadtime for " + i_PP_Product_Planning);
            }
        }
        return bigDecimal2.add(i_PP_Product_Planning.getTransfertTime()).intValue();
    }

    public static String getDocumentNo(int n) {
        return DB.getSQLValueStringEx(null, "SELECT documentNo(PP_MRP_ID) AS DocumentNo FROM PP_MRP WHERE PP_MRP_ID = ?", n);
    }

    @Override
    public String toString() {
        String string = this.getDescription();
        return this.getClass().getSimpleName() + "[" + ", TypeMRP=" + this.getTypeMRP() + ", DocStatus=" + this.getDocStatus() + ", Qty=" + this.getQty() + ", DatePromised=" + this.getDatePromised() + ", Schedule=" + this.getDateStartSchedule() + "/" + this.getDateFinishSchedule() + ", IsAvailable=" + this.isAvailable() + (!Util.isEmpty(string, true) ? ", Description=" + string : "") + ", ID=" + this.get_ID() + "]";
    }

    static {
        s_sourceColumnNames.put("C_Order", new String[]{"DatePromised", "DocStatus"});
        s_sourceColumnNames.put("C_OrderLine", new String[]{"AD_Org_ID", "DateOrdered", "DatePromised", "C_BPartner_ID", "M_Warehouse_ID", "M_Product_ID", "C_UOM_ID", "QtyOrdered", "QtyDelivered"});
        s_sourceColumnNames.put("M_Requisition", new String[]{"DateRequired", "M_Warehouse_ID"});
        s_sourceColumnNames.put("M_RequisitionLine", new String[]{"AD_Org_ID", "M_Product_ID", "Qty", "C_OrderLine_ID"});
        s_sourceColumnNames.put("M_Forecast", new String[0]);
        s_sourceColumnNames.put("M_ForecastLine", new String[]{"AD_Org_ID", "DatePromised", "M_Warehouse_ID", "M_Product_ID", "Qty"});
        s_sourceColumnNames.put("DD_Order", new String[]{"DocStatus", "C_BPartner_ID"});
        s_sourceColumnNames.put("DD_OrderLine", new String[]{"AD_Org_ID", "M_Product_ID", "C_UOM_ID", "DatePromised", "QtyOrdered", "QtyDelivered", "ConfirmedQty", "M_Locator_ID", "M_LocatorTo_ID", "ConfirmedQty"});
        s_sourceColumnNames.put("PP_Order", new String[]{"AD_Org_ID", "M_Product_ID", "C_UOM_ID", "DatePromised", "QtyOrdered", "QtyDelivered", "PP_Product_BOM_ID", "AD_Workflow_ID", "DocStatus"});
        s_sourceColumnNames.put("PP_Order_BOMLine", new String[]{"M_Product_ID", "C_UOM_ID", "M_Warehouse_ID", "QtyEntered", "QtyDelivered"});
    }
}

