/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.exceptions.NoVendorForProductException;
import org.adempiere.model.engines.CostEngineFactory;
import org.adempiere.model.engines.IDocumentLine;
import org.adempiere.model.engines.StorageEngine;
import org.compiere.model.I_C_UOM;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Product_PO;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.exceptions.ActivityProcessedException;
import org.eevolution.model.I_PP_Cost_Collector;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderBOMLine;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.model.MPPOrderNodeProduct;
import org.eevolution.model.MPPOrderWorkflow;
import org.eevolution.model.X_PP_Cost_Collector;
import org.eevolution.model.X_PP_Order;
import org.eevolution.model.X_PP_Order_BOMLine;
import org.eevolution.model.X_PP_Order_Node;

public class MPPCostCollector
extends X_PP_Cost_Collector
implements DocAction,
IDocumentLine {
    private static final long serialVersionUID = 1L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MPPOrder m_order = null;
    private MPPOrderNode m_orderNode = null;
    private MPPOrderBOMLine m_bomLine = null;

    public static MPPCostCollector createCollector(MPPOrder mPPOrder, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string, Timestamp timestamp, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, int n8, BigDecimal bigDecimal4) {
        MPPCostCollector mPPCostCollector = new MPPCostCollector(mPPOrder);
        mPPCostCollector.setPP_Order_BOMLine_ID(n5);
        mPPCostCollector.setPP_Order_Node_ID(n6);
        mPPCostCollector.setC_DocType_ID(n7);
        mPPCostCollector.setC_DocTypeTarget_ID(n7);
        mPPCostCollector.setCostCollectorType(string);
        mPPCostCollector.setDocAction("CO");
        mPPCostCollector.setDocStatus("DR");
        mPPCostCollector.setIsActive(true);
        mPPCostCollector.setM_Locator_ID(n2);
        mPPCostCollector.setM_AttributeSetInstance_ID(n3);
        mPPCostCollector.setS_Resource_ID(n4);
        mPPCostCollector.setMovementDate(timestamp);
        mPPCostCollector.setDateAcct(timestamp);
        mPPCostCollector.setMovementQty(bigDecimal);
        mPPCostCollector.setScrappedQty(bigDecimal2);
        mPPCostCollector.setQtyReject(bigDecimal3);
        mPPCostCollector.setSetupTimeReal(new BigDecimal(n8));
        mPPCostCollector.setDurationReal(bigDecimal4);
        mPPCostCollector.setPosted(false);
        mPPCostCollector.setProcessed(false);
        mPPCostCollector.setProcessing(false);
        mPPCostCollector.setUser1_ID(mPPOrder.getUser1_ID());
        mPPCostCollector.setUser2_ID(mPPOrder.getUser2_ID());
        mPPCostCollector.setM_Product_ID(n);
        if (n6 > 0) {
            mPPCostCollector.setIsSubcontracting(n6);
        }
        if (n5 > 0) {
            mPPCostCollector.setC_UOM_ID(0);
        }
        mPPCostCollector.saveEx();
        if (!mPPCostCollector.processIt("CO")) {
            throw new AdempiereException(mPPCostCollector.getProcessMsg());
        }
        mPPCostCollector.saveEx();
        return mPPCostCollector;
    }

    public static void setPP_Order(I_PP_Cost_Collector i_PP_Cost_Collector, MPPOrder mPPOrder) {
        i_PP_Cost_Collector.setPP_Order_ID(mPPOrder.getPP_Order_ID());
        i_PP_Cost_Collector.setPP_Order_Workflow_ID(mPPOrder.getMPPOrderWorkflow().get_ID());
        i_PP_Cost_Collector.setAD_Org_ID(mPPOrder.getAD_Org_ID());
        i_PP_Cost_Collector.setM_Warehouse_ID(mPPOrder.getM_Warehouse_ID());
        i_PP_Cost_Collector.setAD_OrgTrx_ID(mPPOrder.getAD_OrgTrx_ID());
        i_PP_Cost_Collector.setC_Activity_ID(mPPOrder.getC_Activity_ID());
        i_PP_Cost_Collector.setC_Campaign_ID(mPPOrder.getC_Campaign_ID());
        i_PP_Cost_Collector.setC_Project_ID(mPPOrder.getC_Project_ID());
        i_PP_Cost_Collector.setDescription(mPPOrder.getDescription());
        i_PP_Cost_Collector.setS_Resource_ID(mPPOrder.getS_Resource_ID());
        i_PP_Cost_Collector.setM_Product_ID(mPPOrder.getM_Product_ID());
        i_PP_Cost_Collector.setC_UOM_ID(mPPOrder.getC_UOM_ID());
        i_PP_Cost_Collector.setM_AttributeSetInstance_ID(mPPOrder.getM_AttributeSetInstance_ID());
        i_PP_Cost_Collector.setMovementQty(mPPOrder.getQtyOrdered());
    }

    public MPPCostCollector(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setIsActive(true);
            this.setPosted(false);
            this.setProcessing(false);
            this.setProcessed(false);
        }
    }

    public MPPCostCollector(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MPPCostCollector(MPPOrder mPPOrder) {
        this(mPPOrder.getCtx(), 0, mPPOrder.get_TrxName());
        MPPCostCollector.setPP_Order(this, mPPOrder);
        this.m_order = mPPOrder;
    }

    public void addDescription(String string) {
        String string2 = this.getDescription();
        if (string2 == null) {
            this.setDescription(string);
        } else {
            this.setDescription(string2 + " | " + string);
        }
    }

    public void setC_DocTypeTarget_ID(String string) {
        MDocType[] mDocTypeArray = MDocType.getOfDocBaseType(this.getCtx(), string);
        if (mDocTypeArray == null) {
            throw new DocTypeNotFoundException(string, "");
        }
        this.setC_DocTypeTarget_ID(mDocTypeArray[0].get_ID());
    }

    @Override
    public void setProcessed(boolean bl) {
        super.setProcessed(bl);
        if (this.get_ID() == 0) {
            return;
        }
        int n = DB.executeUpdateEx("UPDATE PP_Cost_Collector SET Processed=? WHERE PP_Cost_Collector_ID=?", new Object[]{bl, this.get_ID()}, this.get_TrxName());
        this.log.fine("setProcessed - " + bl + " - Lines=" + n);
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocTypeTarget_ID(), this.getAD_Org_ID());
        this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        if (this.isActivityControl()) {
            MPPOrderNode mPPOrderNode = this.getPP_Order_Node();
            if ("CO".equals(mPPOrderNode.getDocStatus())) {
                throw new ActivityProcessedException(mPPOrderNode);
            }
            if (mPPOrderNode.isSubcontracting()) {
                if ("IP".equals(mPPOrderNode.getDocStatus()) && "IP".equals(this.getDocStatus())) {
                    return "IP";
                }
                if ("IP".equals(mPPOrderNode.getDocStatus()) && "DR".equals(this.getDocStatus())) {
                    throw new ActivityProcessedException(mPPOrderNode);
                }
                this.m_processMsg = this.createPO(mPPOrderNode);
                this.m_justPrepared = false;
                mPPOrderNode.setInProgress(this);
                mPPOrderNode.saveEx();
                return "IP";
            }
            mPPOrderNode.setInProgress(this);
            mPPOrderNode.setQtyDelivered(mPPOrderNode.getQtyDelivered().add(this.getMovementQty()));
            mPPOrderNode.setQtyScrap(mPPOrderNode.getQtyScrap().add(this.getScrappedQty()));
            mPPOrderNode.setQtyReject(mPPOrderNode.getQtyReject().add(this.getQtyReject()));
            mPPOrderNode.setDurationReal(mPPOrderNode.getDurationReal() + this.getDurationReal().intValueExact());
            mPPOrderNode.setSetupTimeReal(mPPOrderNode.getSetupTimeReal() + this.getSetupTimeReal().intValueExact());
            mPPOrderNode.saveEx();
            if (mPPOrderNode.isMilestone()) {
                MPPOrderWorkflow mPPOrderWorkflow = mPPOrderNode.getMPPOrderWorkflow();
                mPPOrderWorkflow.closeActivities(mPPOrderNode, this.getMovementDate(), true);
            }
        } else if (this.isIssue()) {
            MProduct mProduct = this.getM_Product();
            if (this.getM_AttributeSetInstance_ID() == 0 && mProduct.isASIMandatory(false)) {
                throw new AdempiereException("@M_AttributeSet_ID@ @IsMandatory@ @M_Product_ID@=" + mProduct.getValue());
            }
        } else if (this.isReceipt()) {
            MProduct mProduct = this.getM_Product();
            if (this.getM_AttributeSetInstance_ID() == 0 && mProduct.isASIMandatory(true)) {
                throw new AdempiereException("@M_AttributeSet_ID@ @IsMandatory@ @M_Product_ID@=" + mProduct.getValue());
            }
        }
        this.m_justPrepared = true;
        this.setDocAction("CO");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        return true;
    }

    @Override
    public String completeIt() {
        Object object;
        if (!this.m_justPrepared && !"IP".equals(object = this.prepareIt())) {
            return object;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (this.isIssue() || this.isReceipt()) {
            PO pO;
            object = this.getM_Product();
            if (object != null && ((MProduct)object).isStocked() && !this.isVariance()) {
                StorageEngine.createTrasaction(this, this.getMovementType(), this.getMovementDate(), this.getMovementQty(), false, this.getM_Warehouse_ID(), this.getPP_Order().getM_AttributeSetInstance_ID(), this.getPP_Order().getM_Warehouse_ID(), false);
            }
            if (this.isIssue()) {
                pO = this.getPP_Order_BOMLine();
                ((X_PP_Order_BOMLine)pO).setQtyDelivered(((X_PP_Order_BOMLine)pO).getQtyDelivered().add(this.getMovementQty()));
                ((X_PP_Order_BOMLine)pO).setQtyScrap(((X_PP_Order_BOMLine)pO).getQtyScrap().add(this.getScrappedQty()));
                ((X_PP_Order_BOMLine)pO).setQtyReject(((X_PP_Order_BOMLine)pO).getQtyReject().add(this.getQtyReject()));
                ((X_PP_Order_BOMLine)pO).setDateDelivered(this.getMovementDate());
                ((X_PP_Order_BOMLine)pO).setM_AttributeSetInstance_ID(this.getM_AttributeSetInstance_ID());
                this.log.fine("OrderLine - Reserved=" + ((X_PP_Order_BOMLine)pO).getQtyReserved() + ", Delivered=" + ((X_PP_Order_BOMLine)pO).getQtyDelivered());
                pO.saveEx();
                this.log.fine("OrderLine -> Reserved=" + ((X_PP_Order_BOMLine)pO).getQtyReserved() + ", Delivered=" + ((X_PP_Order_BOMLine)pO).getQtyDelivered());
            }
            if (this.isReceipt()) {
                pO = this.getPP_Order();
                ((X_PP_Order)pO).setQtyDelivered(((X_PP_Order)pO).getQtyDelivered().add(this.getMovementQty()));
                ((X_PP_Order)pO).setQtyScrap(((X_PP_Order)pO).getQtyScrap().add(this.getScrappedQty()));
                ((X_PP_Order)pO).setQtyReject(((X_PP_Order)pO).getQtyReject().add(this.getQtyReject()));
                ((X_PP_Order)pO).setQtyReserved(((X_PP_Order)pO).getQtyReserved().subtract(this.getMovementQty()));
                ((X_PP_Order)pO).setDateDelivered(this.getMovementDate());
                if (((X_PP_Order)pO).getDateStart() == null) {
                    ((X_PP_Order)pO).setDateStart(this.getDateStart());
                }
                if (((MPPOrder)pO).getQtyOpen().signum() <= 0) {
                    ((X_PP_Order)pO).setDateFinish(this.getDateFinish());
                }
                pO.saveEx();
            }
        } else if (this.isActivityControl()) {
            object = this.getPP_Order_Node();
            if (((MPPOrderNode)object).isProcessed()) {
                throw new ActivityProcessedException((MPPOrderNode)object);
            }
            if (this.isSubcontracting()) {
                String string = "PP_Cost_Collector_ID=?";
                List list = new Query(this.getCtx(), "C_OrderLine", string, this.get_TrxName()).setParameters(this.get_ID()).list();
                String string2 = "CO";
                StringBuffer stringBuffer = new StringBuffer("The quantity do not is complete for next Purchase Order : ");
                for (MOrderLine mOrderLine : list) {
                    if (mOrderLine.getQtyDelivered().compareTo(mOrderLine.getQtyOrdered()) < 0) {
                        string2 = "IP";
                    }
                    stringBuffer.append(mOrderLine.getParent().getDocumentNo()).append(",");
                }
                if ("IP".equals(string2)) {
                    this.m_processMsg = stringBuffer.toString();
                    return string2;
                }
                this.setProcessed(true);
                this.setDocAction("CL");
                this.setDocStatus("CO");
                ((MPPOrderNode)object).completeIt();
                ((PO)object).saveEx();
                this.m_processMsg = Msg.translate(this.getCtx(), "PP_Order_ID") + ": " + this.getPP_Order().getDocumentNo() + " " + Msg.translate(this.getCtx(), "PP_Order_Node_ID") + ": " + this.getPP_Order_Node().getValue();
                return string2;
            }
            CostEngineFactory.getCostEngine(this.getAD_Client_ID()).createActivityControl(this);
            if (((X_PP_Order_Node)object).getQtyDelivered().compareTo(((X_PP_Order_Node)object).getQtyRequiered()) >= 0) {
                ((MPPOrderNode)object).closeIt();
                ((PO)object).saveEx();
            }
        } else if (this.isCostCollectorType("120") && this.getPP_Order_BOMLine_ID() > 0) {
            object = this.getPP_Order_BOMLine();
            ((X_PP_Order_BOMLine)object).setQtyDelivered(((X_PP_Order_BOMLine)object).getQtyDelivered().add(this.getMovementQty()));
            ((X_PP_Order_BOMLine)object).setQtyScrap(((X_PP_Order_BOMLine)object).getQtyScrap().add(this.getScrappedQty()));
            ((X_PP_Order_BOMLine)object).setQtyReject(((X_PP_Order_BOMLine)object).getQtyReject().add(this.getQtyReject()));
            ((X_PP_Order_BOMLine)object).setM_AttributeSetInstance_ID(this.getM_AttributeSetInstance_ID());
            this.log.fine("OrderLine - Reserved=" + ((X_PP_Order_BOMLine)object).getQtyReserved() + ", Delivered=" + ((X_PP_Order_BOMLine)object).getQtyDelivered());
            ((PO)object).saveEx();
            this.log.fine("OrderLine -> Reserved=" + ((X_PP_Order_BOMLine)object).getQtyReserved() + ", Delivered=" + ((X_PP_Order_BOMLine)object).getQtyDelivered());
            CostEngineFactory.getCostEngine(this.getAD_Client_ID()).createUsageVariances(this);
        } else if (this.isCostCollectorType("120") && this.getPP_Order_Node_ID() > 0) {
            object = this.getPP_Order_Node();
            ((X_PP_Order_Node)object).setDurationReal(((X_PP_Order_Node)object).getDurationReal() + this.getDurationReal().intValueExact());
            ((X_PP_Order_Node)object).setSetupTimeReal(((X_PP_Order_Node)object).getSetupTimeReal() + this.getSetupTimeReal().intValueExact());
            ((PO)object).saveEx();
            CostEngineFactory.getCostEngine(this.getAD_Client_ID()).createUsageVariances(this);
        }
        CostEngineFactory.getCostEngine(this.getAD_Client_ID()).createRateVariances(this);
        CostEngineFactory.getCostEngine(this.getAD_Client_ID()).createMethodVariances(this);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        this.setDocStatus("CO");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        return false;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        return false;
    }

    @Override
    public boolean reActivateIt() {
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getDescription());
        return stringBuffer.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine reportEngine = ReportEngine.get(this.getCtx(), 0, this.getPP_Order_ID());
        if (reportEngine == null) {
            return null;
        }
        return reportEngine.getPDF(file);
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        MWarehouse mWarehouse;
        MLocator mLocator;
        if (this.getM_Locator_ID() <= 0 && this.getM_Warehouse_ID() > 0 && (mLocator = (mWarehouse = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID())).getDefaultLocator()) != null) {
            this.setM_Locator_ID(mLocator.get_ID());
        }
        if (this.isIssue()) {
            if (this.getPP_Order_BOMLine_ID() <= 0) {
                throw new FillMandatoryException(new String[]{"PP_Order_BOMLine_ID"});
            }
            if (this.getC_UOM_ID() <= 0) {
                this.setC_UOM_ID(this.getPP_Order_BOMLine().getC_UOM_ID());
            }
            if (this.getC_UOM_ID() != this.getPP_Order_BOMLine().getC_UOM_ID()) {
                throw new AdempiereException("@PP_Cost_Collector_ID@ @C_UOM_ID@ <> @PP_Order_BOMLine_ID@ @C_UOM_ID@");
            }
        }
        if (this.isActivityControl() && this.getPP_Order_Node_ID() <= 0) {
            throw new FillMandatoryException(new String[]{"PP_Order_Node_ID"});
        }
        return true;
    }

    @Override
    public MPPOrderNode getPP_Order_Node() {
        int n = this.getPP_Order_Node_ID();
        if (n <= 0) {
            this.m_orderNode = null;
            return null;
        }
        if (this.m_orderNode == null || this.m_orderNode.get_ID() != n) {
            this.m_orderNode = new MPPOrderNode(this.getCtx(), n, this.get_TrxName());
        }
        return this.m_orderNode;
    }

    @Override
    public MPPOrderBOMLine getPP_Order_BOMLine() {
        int n = this.getPP_Order_BOMLine_ID();
        if (n <= 0) {
            this.m_bomLine = null;
            return null;
        }
        if (this.m_bomLine == null || this.m_bomLine.get_ID() != n) {
            this.m_bomLine = new MPPOrderBOMLine(this.getCtx(), n, this.get_TrxName());
        }
        this.m_bomLine.set_TrxName(this.get_TrxName());
        return this.m_bomLine;
    }

    @Override
    public MPPOrder getPP_Order() {
        int n = this.getPP_Order_ID();
        if (n <= 0) {
            this.m_order = null;
            return null;
        }
        if (this.m_order == null || this.m_order.get_ID() != n) {
            this.m_order = new MPPOrder(this.getCtx(), n, this.get_TrxName());
        }
        return this.m_order;
    }

    public long getDurationBaseSec() {
        return this.getPP_Order().getMPPOrderWorkflow().getDurationBaseSec();
    }

    public Timestamp getDateStart() {
        double d = this.getDurationReal().doubleValue();
        if (d != 0.0) {
            long l = (long)(this.getDurationReal().doubleValue() * (double)this.getDurationBaseSec() * 1000.0);
            return new Timestamp(this.getMovementDate().getTime() - l);
        }
        return this.getMovementDate();
    }

    public Timestamp getDateFinish() {
        return this.getMovementDate();
    }

    /*
     * WARNING - void declaration
     */
    private String createPO(MPPOrderNode mPPOrderNode) {
        String string = "";
        HashMap<Integer, MOrder> hashMap = new HashMap<Integer, MOrder>();
        String string2 = "PP_Order_Node_ID=? AND IsSubcontracting=?";
        List list = new Query(this.getCtx(), "PP_Order_Node_Product", string2, this.get_TrxName()).setParameters(mPPOrderNode.get_ID(), true).setOnlyActiveRecords(true).list();
        for (MPPOrderNodeProduct mPPOrderNodeProduct : list) {
            void var14_17;
            void var14_24;
            MProduct mProduct = MProduct.get(this.getCtx(), mPPOrderNodeProduct.getM_Product_ID());
            if (!mProduct.isPurchased() || !"S".equals(mProduct.getProductType())) {
                throw new AdempiereException("The Product: " + mProduct.getName() + " Do not is Purchase or Service Type");
            }
            int n = mPPOrderNode.getC_BPartner_ID();
            X_M_Product_PO x_M_Product_PO = null;
            for (MProductPO mProductPO : MProductPO.getOfProduct(this.getCtx(), mProduct.get_ID(), null)) {
                if (n == mProductPO.getC_BPartner_ID()) {
                    n = mProductPO.getC_BPartner_ID();
                    x_M_Product_PO = mProductPO;
                    break;
                }
                if (!mProductPO.isCurrentVendor() || mProductPO.getC_BPartner_ID() == 0) continue;
                n = mProductPO.getC_BPartner_ID();
                x_M_Product_PO = mProductPO;
                break;
            }
            if (n <= 0 || x_M_Product_PO == null) {
                throw new NoVendorForProductException(mProduct.getName());
            }
            Timestamp object = new Timestamp(System.currentTimeMillis());
            Timestamp timestamp = TimeUtil.addDays(object, x_M_Product_PO.getDeliveryTime_Promised());
            MOrder mOrder = (MOrder)hashMap.get(n);
            if (mOrder == null) {
                mOrder = new MOrder(this.getCtx(), 0, this.get_TrxName());
                MBPartner mBPartner = MBPartner.get(this.getCtx(), n);
                mOrder.setAD_Org_ID(this.getAD_Org_ID());
                mOrder.setBPartner(mBPartner);
                mOrder.setIsSOTrx(false);
                mOrder.setC_DocTypeTarget_ID();
                mOrder.setDatePromised(timestamp);
                mOrder.setDescription(Msg.translate(this.getCtx(), "PP_Order_ID") + ":" + this.getPP_Order().getDocumentNo());
                mOrder.setDocStatus("DR");
                mOrder.setDocAction("CO");
                mOrder.setAD_User_ID(this.getAD_User_ID());
                mOrder.setM_Warehouse_ID(this.getM_Warehouse_ID());
                mOrder.saveEx();
                this.addDescription(Msg.translate(this.getCtx(), "C_Order_ID") + ": " + mOrder.getDocumentNo());
                hashMap.put(n, mOrder);
                string = string + Msg.translate(this.getCtx(), "C_Order_ID") + " : " + mOrder.getDocumentNo() + " - " + Msg.translate(this.getCtx(), "C_BPartner_ID") + " : " + mBPartner.getName() + " , ";
            }
            BigDecimal bigDecimal = this.getMovementQty().multiply(mPPOrderNodeProduct.getQty());
            if (x_M_Product_PO.getOrder_Min().signum() > 0) {
                BigDecimal bigDecimal2 = bigDecimal.max(x_M_Product_PO.getOrder_Min());
            }
            if (x_M_Product_PO.getOrder_Pack().signum() > 0 && var14_24.signum() > 0) {
                BigDecimal bigDecimal3 = x_M_Product_PO.getOrder_Pack().multiply(var14_24.divide(x_M_Product_PO.getOrder_Pack(), 0, 0));
            }
            MOrderLine mOrderLine = new MOrderLine(mOrder);
            mOrderLine.setM_Product_ID(mProduct.getM_Product_ID());
            mOrderLine.setDescription(mPPOrderNode.getDescription());
            mOrderLine.setM_Warehouse_ID(this.getM_Warehouse_ID());
            mOrderLine.setQty((BigDecimal)var14_17);
            mOrderLine.setPP_Cost_Collector_ID(this.get_ID());
            mOrderLine.setDatePromised(timestamp);
            mOrderLine.saveEx();
            this.setProcessed(true);
        }
        return string;
    }

    @Override
    public MProduct getM_Product() {
        return MProduct.get(this.getCtx(), this.getM_Product_ID());
    }

    @Override
    public I_C_UOM getC_UOM() {
        return MUOM.get(this.getCtx(), this.getC_UOM_ID());
    }

    public boolean isIssue() {
        return this.isCostCollectorType("110") || this.isCostCollectorType("130") && this.getPP_Order_BOMLine_ID() > 0 || this.isCostCollectorType("150") && this.getPP_Order_BOMLine_ID() > 0;
    }

    public boolean isReceipt() {
        return this.isCostCollectorType("100");
    }

    public boolean isActivityControl() {
        return this.isCostCollectorType("160");
    }

    public boolean isVariance() {
        return this.isCostCollectorType("130", "120", "140", "150");
    }

    public String getMovementType() {
        if (this.isReceipt()) {
            return "W+";
        }
        if (this.isIssue()) {
            return "W-";
        }
        return null;
    }

    public boolean isCostCollectorType(String ... stringArray) {
        String string = this.getCostCollectorType();
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isFloorStock() {
        boolean bl = new Query(this.getCtx(), "PP_Order_BOMLine", "PP_Order_BOMLine_ID=? AND IssueMethod=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getPP_Order_BOMLine_ID(), "2").match();
        return bl;
    }

    public void setIsSubcontracting(int n) {
        this.setIsSubcontracting(MPPOrderNode.get(this.getCtx(), n, this.get_TrxName()).isSubcontracting());
    }
}

