/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_Employee;
import org.eevolution.model.X_HR_Period;

public class MHREmployee
extends X_HR_Employee {
    private static final long serialVersionUID = -7083160315471023587L;
    private static CCache<Integer, MHREmployee> s_cache = new CCache("HR_Employee", 1000);

    public static MHREmployee get(Properties ctx, int HR_Employee_ID) {
        if (HR_Employee_ID <= 0) {
            return null;
        }
        MHREmployee employee = s_cache.get(HR_Employee_ID);
        if (employee != null) {
            return employee;
        }
        employee = new MHREmployee(ctx, HR_Employee_ID, null);
        if (employee.get_ID() == HR_Employee_ID) {
            s_cache.put(HR_Employee_ID, employee);
        } else {
            employee = null;
        }
        return employee;
    }

    public static MBPartner[] getEmployees(MHRProcess p) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append(" C_BPartner.C_BPartner_ID IN (SELECT e.C_BPartner_ID FROM HR_Employee e WHERE e.IsActive=?");
        params.add(true);
        if (p.getHR_Payroll_ID() != 0 && p.getHR_Period_ID() != 0) {
            whereClause.append(" AND (e.HR_Payroll_ID IS NULL OR e.HR_Payroll_ID=?) ");
            params.add(p.getHR_Payroll_ID());
        }
        if (p.getHR_Period_ID() == 0) {
            whereClause.append(" AND e.StartDate <=? ");
            params.add(p.getDateAcct());
        } else {
            whereClause.append(" AND e.StartDate <=? ");
            params.add(new X_HR_Period(p.getCtx(), p.getHR_Period_ID(), null).getEndDate());
        }
        if (p.getHR_Department_ID() != 0) {
            whereClause.append(" AND e.HR_Department_ID =? ");
            params.add(p.getHR_Department_ID());
        }
        whereClause.append(" ) ");
        if (p.getC_BPartner_ID() != 0) {
            whereClause.append(" AND C_BPartner_ID =? ");
            params.add(p.getC_BPartner_ID());
        }
        whereClause.append(" AND AD_Client_ID =? ");
        params.add(p.getAD_Client_ID());
        List<MBPartner> list = new Query(p.getCtx(), "C_BPartner", whereClause.toString(), p.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy("Name").list();
        return list.toArray(new MBPartner[list.size()]);
    }

    public static MHREmployee getActiveEmployee(Properties ctx, int C_BPartner_ID, String trxName) {
        return (MHREmployee)new Query(ctx, "HR_Employee", "C_BPartner_ID=?", trxName).setOnlyActiveRecords(true).setParameters(C_BPartner_ID).setOrderBy("HR_Employee_ID DESC").first();
    }

    public MHREmployee(Properties ctx, int HR_Employee_ID, String trxName) {
        super(ctx, HR_Employee_ID, trxName);
        if (HR_Employee_ID == 0) {
            this.setClientOrg(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()));
        }
    }

    public MHREmployee(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

