/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MForecastLine;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMALine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_M_Forecast;
import org.compiere.model.X_M_InOutLine;
import org.compiere.process.DocAction;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderBOMLine;

public class LiberoValidator
implements ModelValidator {
    public static final String CTX_IsLiberoEnabled = "#IsLiberoEnabled";
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine modelValidationEngine, MClient mClient) {
        if (mClient != null) {
            this.m_AD_Client_ID = mClient.getAD_Client_ID();
        }
        modelValidationEngine.addModelChange("M_Product", this);
        for (String string : MPPMRP.getSourceTableNames()) {
            modelValidationEngine.addModelChange(string, this);
        }
        modelValidationEngine.addDocValidate("M_InOut", this);
        modelValidationEngine.addDocValidate("M_Movement", this);
    }

    @Override
    public String modelChange(PO pO, int n) throws Exception {
        Object object;
        this.log.info(pO.get_TableName() + " Type: " + n);
        boolean bl = 4 == n || 5 == n && MPPMRP.isChanged(pO);
        boolean bl2 = 3 == n;
        boolean bl3 = false;
        boolean bl4 = false;
        DocAction docAction = null;
        if (pO instanceof DocAction) {
            docAction = (DocAction)((Object)pO);
        } else if (pO instanceof MOrderLine) {
            docAction = ((MOrderLine)pO).getParent();
        }
        if (docAction != null) {
            object = docAction.getDocStatus();
            bl3 = "IP".equals(object) || "CO".equals(object);
            bl4 = "VO".equals(object);
        }
        if (pO instanceof MProduct && 2 == n && pO.is_ValueChanged("C_UOM_ID") && MPPMRP.hasProductRecords((MProduct)pO)) {
            throw new AdempiereException("@SaveUomError@");
        }
        if (bl2 || bl4 || !pO.isActive()) {
            MPPMRP.deleteMRP(pO);
        } else if (pO instanceof MOrder) {
            object = (MOrder)pO;
            if (bl && !((X_C_Order)object).isSOTrx()) {
                MPPMRP.C_Order((MOrder)object);
            } else if (n == 5 && ((X_C_Order)object).isSOTrx() && (bl3 || MPPMRP.isChanged((PO)object))) {
                MPPMRP.C_Order((MOrder)object);
            }
        } else if (pO instanceof MOrderLine && bl) {
            object = (MOrderLine)pO;
            MOrder mOrder = ((MOrderLine)object).getParent();
            if (!mOrder.isSOTrx()) {
                MPPMRP.C_OrderLine((MOrderLine)object);
            } else if (mOrder.isSOTrx() && bl3) {
                MPPMRP.C_OrderLine((MOrderLine)object);
            }
        } else if (pO instanceof MRequisition && bl) {
            object = (MRequisition)pO;
            MPPMRP.M_Requisition((MRequisition)object);
        } else if (pO instanceof MRequisitionLine && bl) {
            object = (MRequisitionLine)pO;
            MPPMRP.M_RequisitionLine((MRequisitionLine)object);
        } else if (pO instanceof X_M_Forecast && bl) {
            object = (X_M_Forecast)pO;
            MPPMRP.M_Forecast((X_M_Forecast)object);
        } else if (pO instanceof MForecastLine && bl) {
            object = (MForecastLine)pO;
            MPPMRP.M_ForecastLine((MForecastLine)object);
        } else if (pO instanceof MDDOrder && bl) {
            object = (MDDOrder)pO;
            MPPMRP.DD_Order((MDDOrder)object);
        } else if (pO instanceof MDDOrderLine && bl) {
            object = (MDDOrderLine)pO;
            MPPMRP.DD_OrderLine((MDDOrderLine)object);
        } else if (pO instanceof MPPOrder && bl) {
            object = (MPPOrder)pO;
            MPPMRP.PP_Order((MPPOrder)object);
        } else if (pO instanceof MPPOrderBOMLine && bl) {
            object = (MPPOrderBOMLine)pO;
            MPPMRP.PP_Order_BOMLine((MPPOrderBOMLine)object);
        }
        return null;
    }

    @Override
    public String docValidate(PO pO, int n) {
        this.log.info(pO.get_TableName() + " Timing: " + n);
        if (pO instanceof MInOut && n == 9) {
            MInOut mInOut = (MInOut)pO;
            if (mInOut.isSOTrx()) {
                for (MInOutLine mInOutLine : mInOut.getLines()) {
                    this.updateMPPOrder(mInOutLine);
                }
            } else {
                for (MInOutLine mInOutLine : mInOut.getLines()) {
                    List list = new Query(pO.getCtx(), "C_OrderLine", "C_OrderLine_ID=? AND PP_Cost_Collector_ID IS NOT NULL", pO.get_TrxName()).setParameters(mInOutLine.getC_OrderLine_ID()).list();
                    for (MOrderLine mOrderLine : list) {
                        if (mOrderLine.getQtyOrdered().compareTo(mOrderLine.getQtyDelivered()) < 0) continue;
                        MPPCostCollector mPPCostCollector = new MPPCostCollector(pO.getCtx(), mOrderLine.getPP_Cost_Collector_ID(), pO.get_TrxName());
                        String string = mPPCostCollector.completeIt();
                        mPPCostCollector.setDocStatus(string);
                        mPPCostCollector.setDocAction("CL");
                        mPPCostCollector.saveEx();
                        return null;
                    }
                }
            }
        } else if (pO instanceof MMovement && n == 9) {
            MMovement mMovement = (MMovement)pO;
            for (MMovementLine mMovementLine : mMovement.getLines(false)) {
                if (mMovementLine.getDD_OrderLine_ID() <= 0) continue;
                MDDOrderLine mDDOrderLine = new MDDOrderLine(mMovementLine.getCtx(), mMovementLine.getDD_OrderLine_ID(), pO.get_TrxName());
                MLocator mLocator = MLocator.get(mMovementLine.getCtx(), mMovementLine.getM_LocatorTo_ID());
                MWarehouse mWarehouse = MWarehouse.get(mMovementLine.getCtx(), mLocator.getM_Warehouse_ID());
                if (mWarehouse.isInTransit()) {
                    mDDOrderLine.setQtyInTransit(mDDOrderLine.getQtyInTransit().add(mMovementLine.getMovementQty()));
                    mDDOrderLine.setConfirmedQty(Env.ZERO);
                } else {
                    mDDOrderLine.setQtyInTransit(mDDOrderLine.getQtyInTransit().subtract(mMovementLine.getMovementQty()));
                    mDDOrderLine.setQtyDelivered(mDDOrderLine.getQtyDelivered().add(mMovementLine.getMovementQty()));
                }
                mDDOrderLine.saveEx();
            }
            if (mMovement.getDD_Order_ID() > 0) {
                MDDOrder mDDOrder = new MDDOrder(mMovement.getCtx(), mMovement.getDD_Order_ID(), mMovement.get_TrxName());
                mDDOrder.setIsInTransit(this.isInTransting(mDDOrder));
                mDDOrder.reserveStock(mDDOrder.getLines(true, null));
                mDDOrder.saveEx();
            }
        }
        return null;
    }

    private boolean isInTransting(MDDOrder mDDOrder) {
        for (MDDOrderLine mDDOrderLine : mDDOrder.getLines(true, null)) {
            if (mDDOrderLine.getQtyInTransit().signum() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String login(int n, int n2, int n3) {
        Env.setContext(Env.getCtx(), CTX_IsLiberoEnabled, true);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    private void updateMPPOrder(MInOutLine mInOutLine) {
        Object object;
        MPPOrder mPPOrder = null;
        BigDecimal bigDecimal = Env.ZERO;
        MInOut mInOut = mInOutLine.getParent();
        String string = mInOut.getMovementType();
        int n = 0;
        if ("C-".equals(string)) {
            n = mInOutLine.getC_OrderLine_ID();
            bigDecimal = mInOutLine.getMovementQty();
        } else if ("C+".equals(string)) {
            MRMALine mRMALine = new MRMALine(mInOutLine.getCtx(), mInOutLine.getM_RMALine_ID(), null);
            object = (MInOutLine)mRMALine.getM_InOutLine();
            n = ((X_M_InOutLine)object).getC_OrderLine_ID();
            bigDecimal = mInOutLine.getMovementQty().negate();
        }
        mPPOrder = (MPPOrder)new Query(mInOutLine.getCtx(), "PP_Order", " C_OrderLine_ID = ?  AND DocStatus IN  (?,?) AND EXISTS (SELECT 1 FROM  PP_Order_BOM  WHERE PP_Order_BOM.PP_Order_ID=PP_Order.PP_Order_ID AND PP_Order_BOM.BOMType =? )", mInOutLine.get_TrxName()).setParameters(n, "IP", "CO", "K").firstOnly();
        if (mPPOrder == null) {
            return;
        }
        if ("IP".equals(mPPOrder.getDocStatus())) {
            mPPOrder.completeIt();
            mPPOrder.setDocStatus("CO");
            mPPOrder.setDocAction("CL");
            mPPOrder.saveEx();
        }
        if ("CO".equals(mPPOrder.getDocStatus())) {
            object = mPPOrder.getDescription() != null ? mPPOrder.getDescription() : "" + Msg.translate(mInOut.getCtx(), "M_InOut_ID") + " : " + Msg.translate(mInOut.getCtx(), "DocumentNo");
            mPPOrder.setDescription((String)object);
            mPPOrder.updateMakeToKit(bigDecimal);
            mPPOrder.saveEx();
        }
        if (mPPOrder.getQtyToDeliver().compareTo(Env.ZERO) == 0) {
            mPPOrder.closeIt();
            mPPOrder.setDocStatus("CL");
            mPPOrder.setDocAction("--");
            mPPOrder.saveEx();
        }
    }
}

