/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.I_M_Movement;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocator;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_M_Product;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.I_DD_OrderLine;
import org.eevolution.model.MDDOrderLine;

public class CalloutDistributionOrder
extends CalloutEngine {
    private boolean steps = false;

    public String qty(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        MProduct mProduct;
        int n2;
        int n3;
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        int n4 = Env.getContextAsInt(properties, n, "M_Product_ID");
        if (this.steps) {
            this.log.warning("init - M_Product_ID=" + n4 + " - ");
        }
        BigDecimal bigDecimal = Env.ZERO;
        if (n4 == 0) {
            return "";
        }
        if (gridField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal bigDecimal2;
            n3 = (Integer)object;
            BigDecimal bigDecimal3 = (BigDecimal)gridTab.getValue("QtyEntered");
            if (bigDecimal3.compareTo(bigDecimal2 = bigDecimal3.setScale(MUOM.getPrecision(properties, n3), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + n3 + "; QtyEntered=" + bigDecimal3 + "->" + bigDecimal2);
                bigDecimal3 = bigDecimal2;
                gridTab.setValue("QtyEntered", (Object)bigDecimal3);
            }
            if ((bigDecimal = MUOMConversion.convertProductFrom(properties, n4, n3, bigDecimal3)) == null) {
                bigDecimal = bigDecimal3;
            }
            boolean bl = bigDecimal3.compareTo(bigDecimal) != 0;
            Env.setContext(properties, n, "UOMConversion", bl ? "Y" : "N");
            gridTab.setValue("QtyOrdered", (Object)bigDecimal);
        } else if (gridField.getColumnName().equals("QtyEntered")) {
            BigDecimal bigDecimal4 = (BigDecimal)object;
            n3 = Env.getContextAsInt(properties, n, "C_UOM_ID");
            BigDecimal bigDecimal5 = bigDecimal4.setScale(MUOM.getPrecision(properties, n3), 4);
            if (bigDecimal4.compareTo(bigDecimal5) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + n3 + "; QtyEntered=" + bigDecimal4 + "->" + bigDecimal5);
                bigDecimal4 = bigDecimal5;
                gridTab.setValue("QtyEntered", (Object)bigDecimal4);
            }
            if ((bigDecimal = MUOMConversion.convertProductFrom(properties, n4, n3, bigDecimal4)) == null) {
                bigDecimal = bigDecimal4;
            }
            boolean bl = bigDecimal4.compareTo(bigDecimal) != 0;
            this.log.fine("UOM=" + n3 + ", QtyEntered=" + bigDecimal4 + " -> " + bl + " QtyOrdered=" + bigDecimal);
            Env.setContext(properties, n, "UOMConversion", bl ? "Y" : "N");
            gridTab.setValue("QtyOrdered", (Object)bigDecimal);
        } else if (gridField.getColumnName().equals("QtyOrdered")) {
            BigDecimal bigDecimal6;
            n3 = Env.getContextAsInt(properties, n, "C_UOM_ID");
            bigDecimal = (BigDecimal)object;
            int n5 = MProduct.get(properties, n4).getUOMPrecision();
            BigDecimal bigDecimal7 = bigDecimal.setScale(n5, 4);
            if (bigDecimal.compareTo(bigDecimal7) != 0) {
                this.log.fine("Corrected QtyOrdered Scale " + bigDecimal + "->" + bigDecimal7);
                bigDecimal = bigDecimal7;
                gridTab.setValue("QtyOrdered", (Object)bigDecimal);
            }
            if ((bigDecimal6 = MUOMConversion.convertProductTo(properties, n4, n3, bigDecimal)) == null) {
                bigDecimal6 = bigDecimal;
            }
            n2 = bigDecimal.compareTo(bigDecimal6) != 0 ? 1 : 0;
            this.log.fine("UOM=" + n3 + ", QtyOrdered=" + bigDecimal + " -> " + (n2 != 0) + " QtyEntered=" + bigDecimal6);
            Env.setContext(properties, n, "UOMConversion", n2 != 0 ? "Y" : "N");
            gridTab.setValue("QtyEntered", (Object)bigDecimal6);
        } else {
            bigDecimal = (BigDecimal)gridTab.getValue("QtyOrdered");
        }
        if (n4 != 0 && Env.isSOTrx(properties, n) && bigDecimal.signum() > 0 && (mProduct = MProduct.get(properties, n4)).isStocked()) {
            int n6 = Env.getContextAsInt(properties, n, "M_Locator_ID");
            int n7 = Env.getContextAsInt(properties, n, "M_AttributeSetInstance_ID");
            n2 = MLocator.get(properties, n6).getM_Warehouse_ID();
            BigDecimal bigDecimal8 = MStorage.getQtyAvailable(n2, 0, n4, n7, null);
            if (bigDecimal8 == null) {
                bigDecimal8 = Env.ZERO;
            }
            if (bigDecimal8.signum() == 0) {
                gridTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (bigDecimal8.compareTo(bigDecimal) < 0) {
                gridTab.fireDataStatusEEvent("InsufficientQtyAvailable", bigDecimal8.toString(), false);
            } else {
                BigDecimal bigDecimal9;
                BigDecimal bigDecimal10;
                Integer n8 = (Integer)gridTab.getValue("DD_OrderLine_ID");
                if (n8 == null) {
                    n8 = new Integer(0);
                }
                if ((bigDecimal10 = MDDOrderLine.getNotReserved(properties, n6, n4, n7, n8)) == null) {
                    bigDecimal10 = Env.ZERO;
                }
                if ((bigDecimal9 = bigDecimal8.subtract(bigDecimal10)).compareTo(bigDecimal) < 0) {
                    String string = Msg.parseTranslation(properties, "@QtyAvailable@=" + bigDecimal8 + "  -  @QtyNotReserved@=" + bigDecimal10 + "  =  " + bigDecimal9);
                    gridTab.fireDataStatusEEvent("InsufficientQtyAvailable", string, false);
                }
            }
        }
        return "";
    }

    public String qtyConfirmed(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        I_DD_OrderLine i_DD_OrderLine = GridTabWrapper.create(gridTab, I_DD_OrderLine.class);
        MDDOrderLine mDDOrderLine = new MDDOrderLine(properties, i_DD_OrderLine.getDD_OrderLine_ID(), null);
        if (i_DD_OrderLine.getConfirmedQty().compareTo(mDDOrderLine.getQtyToDeliver()) > 0) {
            String string = Msg.parseTranslation(properties, "@ConfirmedQty@ : " + i_DD_OrderLine.getConfirmedQty() + " > @QtyInTransit@ " + i_DD_OrderLine.getQtyInTransit() + " @QtyToDeliver@ : " + mDDOrderLine.getQtyToDeliver());
            gridTab.fireDataStatusEEvent("", string, false);
            i_DD_OrderLine.setConfirmedQty(mDDOrderLine.getQtyToDeliver());
        }
        return "";
    }

    public String setLocatorTo(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        Object object2;
        I_DD_OrderLine i_DD_OrderLine = GridTabWrapper.create(gridTab, I_DD_OrderLine.class);
        if (object != null) {
            object2 = MProduct.get(properties, (Integer)object);
            if (i_DD_OrderLine.getC_UOM_ID() <= 0) {
                i_DD_OrderLine.setC_UOM_ID(((X_M_Product)object2).getC_UOM_ID());
            }
        }
        if ((object2 = MWarehouse.getForOrg(properties, i_DD_OrderLine.getAD_Org_ID())) == null && ((MWarehouse[])object2).length < 0) {
            return "";
        }
        MLocator mLocator = MLocator.getDefault(object2[0]);
        if (mLocator != null) {
            i_DD_OrderLine.setM_LocatorTo_ID(mLocator.getM_Locator_ID());
        }
        return "";
    }

    public String UOM(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        I_DD_OrderLine i_DD_OrderLine = GridTabWrapper.create(gridTab, I_DD_OrderLine.class);
        MProduct mProduct = MProduct.get(properties, i_DD_OrderLine.getM_Product_ID());
        if (mProduct != null) {
            i_DD_OrderLine.setC_UOM_ID(mProduct.getC_UOM_ID());
        }
        return "";
    }

    public String bPartner(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        I_M_Movement i_M_Movement = GridTabWrapper.create(gridTab, I_M_Movement.class);
        MOrg mOrg = MOrg.get(properties, i_M_Movement.getAD_Org_ID());
        int n2 = mOrg.getLinkedC_BPartner_ID(null);
        if (n2 > 0) {
            MBPartnerLocation[] mBPartnerLocationArray = MBPartnerLocation.getForBPartner(properties, n2, null);
            i_M_Movement.setC_BPartner_ID(n2);
            if (mBPartnerLocationArray.length > 0) {
                i_M_Movement.setC_BPartner_Location_ID(mBPartnerLocationArray[0].getC_BPartner_Location_ID());
            }
        }
        return "";
    }
}

