/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.crp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.model.MProduct;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.form.crp.CRPModel;
import org.eevolution.form.crp.DiagramTreeCellRenderer;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.model.MPPOrderWorkflow;
import org.eevolution.model.reasoner.CRPReasoner;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public abstract class CRPDatasetFactory
extends CRPReasoner
implements CRPModel {
    protected JTree tree;
    protected DefaultCategoryDataset dataset;

    protected abstract BigDecimal convert(BigDecimal var1);

    public static CRPModel get(Timestamp timestamp, Timestamp timestamp2, MResource mResource) {
        MResourceType mResourceType = MResourceType.get(Env.getCtx(), mResource.getS_ResourceType_ID());
        final MUOM mUOM = MUOM.get(Env.getCtx(), MUOM.getMinute_UOM_ID(Env.getCtx()));
        final MUOM mUOM2 = MUOM.get(Env.getCtx(), mResourceType.getC_UOM_ID());
        CRPDatasetFactory cRPDatasetFactory = new CRPDatasetFactory(){

            @Override
            protected BigDecimal convert(BigDecimal bigDecimal) {
                return MUOMConversion.convert(Env.getCtx(), mUOM.get_ID(), mUOM2.get_ID(), bigDecimal);
            }
        };
        super.generate(timestamp, timestamp2, mResource);
        return cRPDatasetFactory;
    }

    private void generate(Timestamp timestamp, Timestamp timestamp2, MResource mResource) {
        if (timestamp == null || timestamp2 == null || mResource == null) {
            return;
        }
        String string = Msg.translate(Env.getCtx(), "DailyCapacity");
        String string2 = Msg.translate(Env.getCtx(), "ActualLoad");
        SimpleDateFormat simpleDateFormat = DisplayType.getDateFormat(16, Env.getLanguage(Env.getCtx()));
        BigDecimal bigDecimal = this.getMaxRange(mResource);
        this.dataset = new DefaultCategoryDataset();
        HashMap<DefaultMutableTreeNode, String> hashMap = new HashMap<DefaultMutableTreeNode, String>();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(mResource);
        hashMap.put(defaultMutableTreeNode, this.getTreeNodeRepresentation(null, defaultMutableTreeNode, mResource));
        Timestamp timestamp3 = timestamp;
        while (timestamp2.after(timestamp3)) {
            String string3 = simpleDateFormat.format(timestamp3);
            hashMap.putAll(this.addTreeNodes(timestamp3, defaultMutableTreeNode, mResource));
            boolean bl = this.isAvailable(mResource, timestamp3);
            this.dataset.addValue((Number)(bl ? bigDecimal : BigDecimal.ZERO), (Comparable)((Object)string), (Comparable)((Object)string3));
            this.dataset.addValue((Number)(bl ? this.calculateLoad(timestamp3, mResource, null) : BigDecimal.ZERO), (Comparable)((Object)string2), (Comparable)((Object)string3));
            timestamp3 = TimeUtil.addDays(timestamp3, 1);
        }
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.setCellRenderer(new DiagramTreeCellRenderer(hashMap));
    }

    @Override
    public BigDecimal calculateLoad(Timestamp timestamp, MResource mResource, String string) {
        MResourceType mResourceType = MResourceType.get(Env.getCtx(), mResource.getS_ResourceType_ID());
        MUOM mUOM = MUOM.get(Env.getCtx(), mResourceType.getC_UOM_ID());
        long l = 0L;
        for (MPPOrderNode mPPOrderNode : this.getPPOrderNodes(timestamp, mResource)) {
            MPPOrder mPPOrder;
            if (string != null && !(mPPOrder = new MPPOrder(mPPOrderNode.getCtx(), mPPOrderNode.getPP_Order_ID(), mPPOrderNode.get_TrxName())).getDocStatus().equals(string)) continue;
            l += this.calculateMillisForDay(timestamp, mPPOrderNode, mResourceType);
        }
        BigDecimal bigDecimal = new BigDecimal(60000);
        BigDecimal bigDecimal2 = new BigDecimal(l).divide(bigDecimal, 2, 4);
        return this.convert(bigDecimal2);
    }

    private Timestamp[] getDayBorders(Timestamp timestamp, MPPOrderNode mPPOrderNode, MResourceType mResourceType) {
        Timestamp timestamp2 = mResourceType.getDayEnd(timestamp);
        timestamp2 = timestamp2.before(mPPOrderNode.getDateFinishSchedule()) ? timestamp2 : mPPOrderNode.getDateFinishSchedule();
        Timestamp timestamp3 = mResourceType.getDayStart(timestamp);
        timestamp3 = timestamp3.after(mPPOrderNode.getDateStartSchedule()) ? timestamp3 : mPPOrderNode.getDateStartSchedule();
        return new Timestamp[]{timestamp3, timestamp2};
    }

    private long calculateMillisForDay(Timestamp timestamp, MPPOrderNode mPPOrderNode, MResourceType mResourceType) {
        Timestamp[] timestampArray = this.getDayBorders(timestamp, mPPOrderNode, mResourceType);
        return timestampArray[1].getTime() - timestampArray[0].getTime();
    }

    private HashMap<DefaultMutableTreeNode, String> addTreeNodes(Timestamp timestamp, DefaultMutableTreeNode defaultMutableTreeNode, MResource mResource) {
        HashMap<DefaultMutableTreeNode, String> hashMap = new HashMap<DefaultMutableTreeNode, String>();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(timestamp);
        hashMap.put(defaultMutableTreeNode2, this.getTreeNodeRepresentation(null, defaultMutableTreeNode2, mResource));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (MPPOrder mPPOrder : this.getPPOrders(timestamp, mResource)) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(mPPOrder);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            hashMap.put(defaultMutableTreeNode3, this.getTreeNodeRepresentation(timestamp, defaultMutableTreeNode3, mResource));
            for (MPPOrderNode mPPOrderNode : this.getPPOrderNodes(timestamp, mResource)) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(mPPOrderNode);
                defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                hashMap.put(defaultMutableTreeNode4, this.getTreeNodeRepresentation(timestamp, defaultMutableTreeNode4, mResource));
            }
        }
        return hashMap;
    }

    private String getTreeNodeRepresentation(Timestamp timestamp, DefaultMutableTreeNode defaultMutableTreeNode, MResource mResource) {
        String string = null;
        if (defaultMutableTreeNode.getUserObject() instanceof MResource) {
            MResource mResource2 = (MResource)defaultMutableTreeNode.getUserObject();
            string = mResource2.getName();
        } else if (defaultMutableTreeNode.getUserObject() instanceof Timestamp) {
            Timestamp timestamp2 = (Timestamp)defaultMutableTreeNode.getUserObject();
            SimpleDateFormat simpleDateFormat = Env.getLanguage(Env.getCtx()).getDateFormat();
            string = simpleDateFormat.format(timestamp2);
            if (!this.isAvailable(mResource, timestamp2)) {
                string = "{" + string + "}";
            }
        } else if (defaultMutableTreeNode.getUserObject() instanceof MPPOrder) {
            MPPOrder mPPOrder = (MPPOrder)defaultMutableTreeNode.getUserObject();
            MProduct mProduct = MProduct.get(Env.getCtx(), mPPOrder.getM_Product_ID());
            string = mPPOrder.getDocumentNo() + " (" + mProduct.getName() + ")";
        } else if (defaultMutableTreeNode.getUserObject() instanceof MPPOrderNode) {
            MPPOrderNode mPPOrderNode = (MPPOrderNode)defaultMutableTreeNode.getUserObject();
            MPPOrderWorkflow mPPOrderWorkflow = mPPOrderNode.getMPPOrderWorkflow();
            MResourceType mResourceType = MResourceType.get(Env.getCtx(), mResource.getS_ResourceType_ID());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
            Timestamp[] timestampArray = this.getDayBorders(timestamp, mPPOrderNode, mResourceType);
            string = simpleDateFormat.format(timestampArray[0]) + " - " + simpleDateFormat.format(timestampArray[1]) + " " + mPPOrderNode.getName() + " (" + mPPOrderWorkflow.getName() + ")";
        }
        return string;
    }

    private BigDecimal getMaxRange(MResource mResource) {
        BigDecimal bigDecimal = mResource.getPercentUtilization().divide(Env.ONEHUNDRED, 2, RoundingMode.HALF_UP);
        int n = 2;
        return mResource.getDailyCapacity().multiply(bigDecimal).setScale(n, RoundingMode.HALF_UP);
    }

    @Override
    public CategoryDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }
}

