/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.bom.action;

import java.awt.event.ActionEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.util.Env;
import org.eevolution.form.action.PopupAction;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.wrapper.BOMLineWrapper;
import org.eevolution.model.wrapper.BOMWrapper;

public class MergeBOMAction
extends PopupAction {
    public static final String COMMAND = "mergeBOM";
    protected JTree tree;
    protected boolean actionResult;

    public MergeBOMAction(JTree jTree) {
        super(COMMAND);
        this.setActionCommand(COMMAND);
        this.tree = jTree;
    }

    @Override
    protected String getCommand() {
        return COMMAND;
    }

    @Override
    protected boolean successful() {
        return this.actionResult;
    }

    @Override
    protected String validateAction() {
        return null;
    }

    @Override
    protected void doAction(ActionEvent actionEvent) {
        if (this.tree != null) {
            this.mergeBOMFrom((DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent());
        }
    }

    private void mergeBOMFrom(DefaultMutableTreeNode defaultMutableTreeNode) {
        BOMWrapper bOMWrapper = (BOMWrapper)defaultMutableTreeNode.getUserObject();
        MPPProductBOM mPPProductBOM = new MPPProductBOM(Env.getCtx(), 0, null);
        mPPProductBOM.setBOMType(bOMWrapper.getBOMType());
        mPPProductBOM.setDescription(bOMWrapper.getDescription());
        mPPProductBOM.setM_AttributeSetInstance_ID(bOMWrapper.getM_AttributeSetInstance_ID());
        mPPProductBOM.setM_Product_ID(bOMWrapper.getM_Product_ID());
        mPPProductBOM.setName(bOMWrapper.getName());
        mPPProductBOM.setRevision(bOMWrapper.getRevision());
        mPPProductBOM.setValidFrom(bOMWrapper.getValidFrom());
        mPPProductBOM.setValidTo(bOMWrapper.getValidTo());
        mPPProductBOM.setValue(bOMWrapper.getValue());
        mPPProductBOM.setDocumentNo(bOMWrapper.getDocumentNo());
        mPPProductBOM.setC_UOM_ID(bOMWrapper.getC_UOM_ID());
        this.actionResult = mPPProductBOM.save();
        if (this.successful()) {
            this.mergeInDepth(mPPProductBOM.get_ID(), defaultMutableTreeNode);
        }
    }

    private void mergeInDepth(int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) {
                this.createBOMLine(n, defaultMutableTreeNode2);
            } else {
                this.mergeInDepth(n, defaultMutableTreeNode2);
            }
            if (!this.successful()) break;
        }
    }

    private void createBOMLine(int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        BOMLineWrapper bOMLineWrapper = (BOMLineWrapper)defaultMutableTreeNode.getUserObject();
        MPPProductBOMLine mPPProductBOMLine = new MPPProductBOMLine(Env.getCtx(), 0, null);
        mPPProductBOMLine.setPP_Product_BOM_ID(n);
        mPPProductBOMLine.setHelp(bOMLineWrapper.getHelp());
        mPPProductBOMLine.setM_ChangeNotice_ID(bOMLineWrapper.getM_ChangeNotice_ID());
        mPPProductBOMLine.setAssay(bOMLineWrapper.getAssay());
        mPPProductBOMLine.setQtyBatch(bOMLineWrapper.getQtyBatch());
        mPPProductBOMLine.setQtyBOM(bOMLineWrapper.getQtyBOM());
        mPPProductBOMLine.setIsQtyPercentage(bOMLineWrapper.isQtyPercentage());
        mPPProductBOMLine.setComponentType(bOMLineWrapper.getComponentType());
        mPPProductBOMLine.setC_UOM_ID(bOMLineWrapper.getC_UOM_ID());
        mPPProductBOMLine.setForecast(bOMLineWrapper.getForecast());
        mPPProductBOMLine.setIsCritical(bOMLineWrapper.isCritical());
        mPPProductBOMLine.setIssueMethod(bOMLineWrapper.getIssueMethod());
        mPPProductBOMLine.setLine(bOMLineWrapper.getLine());
        mPPProductBOMLine.setLeadTimeOffset(bOMLineWrapper.getLeadTimeOffset());
        mPPProductBOMLine.setM_AttributeSetInstance_ID(bOMLineWrapper.getM_AttributeSetInstance_ID());
        mPPProductBOMLine.setM_Product_ID(bOMLineWrapper.getM_Product_ID());
        mPPProductBOMLine.setScrap(bOMLineWrapper.getScrap());
        mPPProductBOMLine.setValidFrom(bOMLineWrapper.getValidFrom());
        mPPProductBOMLine.setValidTo(bOMLineWrapper.getValidTo());
        this.actionResult = mPPProductBOMLine.save();
    }
}

