/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.bom.action;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.model.MResource;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.action.ProcessPopupAction;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.reasoner.StorageReasoner;
import org.eevolution.model.wrapper.BOMLineWrapper;
import org.eevolution.model.wrapper.BOMWrapper;

public class CreateRfQAction
extends ProcessPopupAction {
    public static final String COMMAND = "createRfQ";
    public static final int PROCESS_ID = 1000100;
    protected JTree tree;
    protected StorageReasoner reasoner;

    public CreateRfQAction(JTree jTree, JFrame jFrame) {
        super(COMMAND, jFrame);
        this.setActionCommand(COMMAND);
        this.tree = jTree;
        this.reasoner = new StorageReasoner();
    }

    @Override
    protected String getCommand() {
        return COMMAND;
    }

    @Override
    protected int getProcessID() {
        return 1000100;
    }

    @Override
    protected String validateAction() {
        return null;
    }

    @Override
    protected void doProcess() {
        if (this.tree != null) {
            this.createRfQ((DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent());
        }
    }

    private void createRfQ(DefaultMutableTreeNode defaultMutableTreeNode) {
        BOMWrapper bOMWrapper = (BOMWrapper)defaultMutableTreeNode.getUserObject();
        MPPOrder mPPOrder = new MPPOrder(Env.getCtx(), bOMWrapper.getPP_Order_ID(), null);
        MResource mResource = MResource.get(Env.getCtx(), mPPOrder.getS_Resource_ID());
        Calendar calendar = Calendar.getInstance();
        MRfQ mRfQ = new MRfQ(Env.getCtx(), 0, null);
        mRfQ.setName(Msg.translate(Env.getCtx(), "C_RFQ_ID") + ": " + mPPOrder.getDocumentNo() + "_" + mResource.getName() + " (" + bOMWrapper.getName() + ")");
        mRfQ.setC_Currency_ID(Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID"));
        mRfQ.setQuoteType("S");
        mRfQ.setDateWorkStart(mPPOrder.getDateStartSchedule());
        mRfQ.setDateWorkComplete(mPPOrder.getDateFinishSchedule());
        mRfQ.setC_RfQ_Topic_ID(((BigDecimal)this.getParameterValue("C_RFQ_Topic_ID")).intValue());
        mRfQ.setSalesRep_ID(((BigDecimal)this.getParameterValue("SalesRep_ID")).intValue());
        this.savePO(mRfQ);
        if (this.successful()) {
            this.createRfQLines(mRfQ.get_ID(), defaultMutableTreeNode);
        }
    }

    private void createRfQLines(int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) {
                this.createRfQLine(n, defaultMutableTreeNode2);
            } else {
                this.createRfQLines(n, defaultMutableTreeNode2);
            }
            if (!this.successful()) break;
        }
    }

    private void createRfQLine(int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        BOMLineWrapper bOMLineWrapper = (BOMLineWrapper)defaultMutableTreeNode.getUserObject();
        BigDecimal bigDecimal = this.reasoner.getSumQtyRequired(bOMLineWrapper);
        if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        MRfQ mRfQ = new MRfQ(Env.getCtx(), n, null);
        MRfQLine mRfQLine = new MRfQLine(Env.getCtx(), 0, null);
        mRfQLine.setC_RfQ_ID(n);
        mRfQLine.setLine(this.lineCount(n) + 1);
        mRfQLine.setM_AttributeSetInstance_ID(bOMLineWrapper.getM_AttributeSetInstance_ID());
        mRfQLine.setM_Product_ID(bOMLineWrapper.getM_Product_ID());
        mRfQLine.setDateWorkStart(mRfQ.getDateWorkStart());
        mRfQLine.setDateWorkComplete(mRfQ.getDateWorkComplete());
        this.savePO(mRfQLine);
        if (!this.successful()) {
            return;
        }
        MRfQLineQty mRfQLineQty = new MRfQLineQty(Env.getCtx(), 0, null);
        mRfQLineQty.setQty(bigDecimal);
        mRfQLineQty.setC_UOM_ID(bOMLineWrapper.getC_UOM_ID());
        mRfQLineQty.setC_RfQLine_ID(mRfQLine.get_ID());
        mRfQLineQty.setIsRfQQty(true);
        mRfQLineQty.setIsPurchaseQty(true);
        this.savePO(mRfQLineQty);
    }

    private int lineCount(int n) {
        MRfQ mRfQ = new MRfQ(Env.getCtx(), n, null);
        return mRfQ.getLines().length;
    }
}

