/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.bom;

import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.model.MProduct;
import org.compiere.model.MResource;
import org.compiere.model.PO;
import org.compiere.model.X_M_Product;
import org.compiere.util.Env;
import org.eevolution.form.bom.BOMMessenger;
import org.eevolution.form.bom.BOMTreeCellRenderer;
import org.eevolution.form.bom.BOMTreeModel;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.X_PP_Order;
import org.eevolution.model.reasoner.StorageReasoner;
import org.eevolution.model.wrapper.BOMLineWrapper;
import org.eevolution.model.wrapper.BOMWrapper;

public abstract class BOMTreeFactory
implements BOMTreeModel {
    protected JTree tree;
    protected HashMap mapping;
    protected BOMMessenger msg;
    private StorageReasoner reasoner;

    protected abstract String type();

    public static BOMTreeModel get(String string, PO pO, StorageReasoner storageReasoner) {
        StorageReasoner storageReasoner2 = storageReasoner;
        final String string2 = string;
        BOMTreeFactory bOMTreeFactory = new BOMTreeFactory(){

            @Override
            protected String type() {
                return string2;
            }
        };
        bOMTreeFactory.buildTree(pO, storageReasoner);
        return bOMTreeFactory;
    }

    private StorageReasoner getStorageReasoner() {
        return this.reasoner;
    }

    protected void buildTree(PO pO, StorageReasoner storageReasoner) {
        this.reasoner = storageReasoner;
        this.tree = new JTree(this.buildStructure(pO, storageReasoner)){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                return BOMTreeFactory.this.msg.getToolTipText(mouseEvent);
            }
        };
        this.tree.setCellRenderer(new BOMTreeCellRenderer(this.getNodeMapping()));
        this.msg = new BOMMessenger(this.tree);
    }

    protected DefaultMutableTreeNode buildStructure(PO pO, StorageReasoner storageReasoner) {
        this.mapping = new HashMap();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(pO);
        this.mapping.put(defaultMutableTreeNode, this.getTreeNodeRepresentation(defaultMutableTreeNode));
        BOMWrapper bOMWrapper = null;
        String string = null;
        if (pO instanceof MProduct) {
            string = "M_Product_ID";
        } else if (pO instanceof MPPOrder) {
            string = "PP_Order_ID";
        }
        int[] nArray = storageReasoner.getPOIDs(BOMWrapper.tableName(this.type()), "IsActive = 'Y' AND " + string + " = " + pO.get_ID(), null);
        for (int i = 0; i < nArray.length; ++i) {
            bOMWrapper = new BOMWrapper(Env.getCtx(), nArray[i], null, this.type());
            defaultMutableTreeNode.add(this.getNode(bOMWrapper, null, this.mapping));
        }
        return defaultMutableTreeNode;
    }

    protected DefaultMutableTreeNode getNode(BOMWrapper bOMWrapper, BigDecimal bigDecimal, HashMap hashMap) {
        MProduct mProduct = new MProduct(Env.getCtx(), bOMWrapper.getM_Product_ID(), "M_Product");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(bOMWrapper);
        hashMap.put(defaultMutableTreeNode, this.getTreeNodeRepresentation(defaultMutableTreeNode));
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        int[] nArray = this.getStorageReasoner().getPOIDs(BOMLineWrapper.tableName(this.type()), BOMWrapper.idColumn(this.type()) + " = " + bOMWrapper.getID(), null);
        BOMLineWrapper bOMLineWrapper = null;
        MProduct mProduct2 = null;
        for (int i = 0; i < nArray.length; ++i) {
            bOMLineWrapper = new BOMLineWrapper(Env.getCtx(), nArray[i], null, this.type());
            bOMLineWrapper.setQtyBOM(bigDecimal != null ? bigDecimal.multiply(bOMLineWrapper.getQtyBOM()) : bOMLineWrapper.getQtyBOM());
            mProduct2 = new MProduct(Env.getCtx(), bOMLineWrapper.getM_Product_ID(), null);
            defaultMutableTreeNode2 = this.addLeafs(mProduct2, bigDecimal, hashMap);
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(bOMLineWrapper);
            hashMap.put(defaultMutableTreeNode3, this.getTreeNodeRepresentation(defaultMutableTreeNode3));
            defaultMutableTreeNode.add(defaultMutableTreeNode2 == null ? defaultMutableTreeNode3 : defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    protected DefaultMutableTreeNode addLeafs(MProduct mProduct, BigDecimal bigDecimal, HashMap hashMap) {
        int[] nArray = this.getStorageReasoner().getPOIDs(BOMWrapper.tableName(this.type()), "Value = '" + mProduct.getValue() + "'", null);
        BOMWrapper bOMWrapper = null;
        int n = 0;
        if (n < nArray.length) {
            bOMWrapper = new BOMWrapper(Env.getCtx(), nArray[n], null, this.type());
            return this.getNode(bOMWrapper, bigDecimal, hashMap);
        }
        return null;
    }

    protected String getTreeNodeRepresentation(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        String string = null;
        if (defaultMutableTreeNode.getUserObject() instanceof MProduct) {
            object = (MProduct)defaultMutableTreeNode.getUserObject();
            string = ((X_M_Product)object).getName() + " (" + ((X_M_Product)object).getValue() + ")";
        }
        if (defaultMutableTreeNode.getUserObject() instanceof MPPOrder) {
            object = (MPPOrder)defaultMutableTreeNode.getUserObject();
            MResource mResource = MResource.get(Env.getCtx(), ((X_PP_Order)object).getS_Resource_ID());
            string = ((X_PP_Order)object).getDocumentNo() + " (" + mResource.getName() + ")";
        } else if (defaultMutableTreeNode.getUserObject() instanceof BOMWrapper) {
            object = (BOMWrapper)defaultMutableTreeNode.getUserObject();
            MProduct mProduct = new MProduct(Env.getCtx(), ((BOMWrapper)object).getM_Product_ID(), null);
            string = ((BOMWrapper)object).getName();
        } else if (defaultMutableTreeNode.getUserObject() instanceof BOMLineWrapper) {
            object = (BOMLineWrapper)defaultMutableTreeNode.getUserObject();
            MProduct mProduct = new MProduct(Env.getCtx(), ((BOMLineWrapper)object).getM_Product_ID(), null);
            string = mProduct.getName();
        }
        return string;
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }

    @Override
    public HashMap getNodeMapping() {
        return this.mapping;
    }

    @Override
    public BOMMessenger getBOMMessenger() {
        return this.msg;
    }
}

