/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.bom;

import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.compiere.model.MProduct;
import org.eevolution.form.bom.BOMTreeCellRenderer;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.wrapper.BOMLineWrapper;
import org.eevolution.model.wrapper.BOMWrapper;
import org.eevolution.msg.HTMLMessenger;

public class BOMMessenger
extends HTMLMessenger {
    protected JTree bomTree;
    protected BOMTreeCellRenderer bomTreeCellRenderer;
    protected HashMap cache;

    public BOMMessenger(JTree jTree) {
        this.bomTree = jTree;
        this.cache = new HashMap();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        if (this.bomTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == -1) {
            return string;
        }
        return this.getToolTipText(this.bomTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()));
    }

    public String getToolTipText(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        String string = (String)this.cache.get(defaultMutableTreeNode);
        if (string != null) {
            return string;
        }
        if (defaultMutableTreeNode.getUserObject() instanceof MProduct) {
            string = this.getProductInfo((MProduct)defaultMutableTreeNode.getUserObject());
        }
        if (defaultMutableTreeNode.getUserObject() instanceof MPPOrder) {
            string = this.getMfcOrderInfo((MPPOrder)defaultMutableTreeNode.getUserObject());
        } else if (defaultMutableTreeNode.getUserObject() instanceof BOMWrapper) {
            string = this.getBOMInfo((BOMWrapper)defaultMutableTreeNode.getUserObject());
        } else if (defaultMutableTreeNode.getUserObject() instanceof BOMLineWrapper) {
            string = this.getBOMLineInfo((BOMLineWrapper)defaultMutableTreeNode.getUserObject());
        }
        this.cache.put(defaultMutableTreeNode, string);
        return string;
    }

    public static String getToolTipText(JTree jTree, MouseEvent mouseEvent) {
        BOMMessenger bOMMessenger = new BOMMessenger(jTree);
        return bOMMessenger.getToolTipText(mouseEvent);
    }
}

