/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.action;

import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.apps.AEnv;
import org.compiere.apps.AWindow;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.eevolution.form.action.PopupAction;
import org.eevolution.model.wrapper.AbstractPOWrapper;

public class ZoomMenuAction
extends PopupAction {
    public static final String COMMAND = "zoom";
    protected Object target;
    protected int tableID;
    protected String tableName;

    public ZoomMenuAction(int n, String string) {
        super(COMMAND);
        this.setActionCommand(COMMAND);
        this.tableID = n;
        this.tableName = string;
    }

    public ZoomMenuAction(Object object) throws Exception {
        super(COMMAND);
        this.setActionCommand(COMMAND);
        if (object != null && !(object instanceof JTree)) {
            throw new Exception("Unsupported target component: " + object.getClass().getName());
        }
        this.target = object;
    }

    @Override
    protected String getCommand() {
        return COMMAND;
    }

    @Override
    protected String validateAction() {
        return null;
    }

    @Override
    protected void doAction(ActionEvent actionEvent) {
        if (this.target != null) {
            this.zoom(this.target);
        } else {
            this.zoom();
        }
    }

    @Override
    protected boolean successful() {
        return true;
    }

    public Object getTarget() {
        return this.target;
    }

    private void zoom(Object object) {
        if (object instanceof JTree) {
            JTree jTree = (JTree)object;
            Object object2 = jTree.getSelectionPath().getLastPathComponent();
            int n = 0;
            int n2 = 0;
            try {
                n = this.getTableID((DefaultMutableTreeNode)object2);
                n2 = this.getRecordID((DefaultMutableTreeNode)object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            AEnv.zoom(n, n2);
        }
    }

    private int getTableID(DefaultMutableTreeNode defaultMutableTreeNode) throws Exception {
        PO pO = null;
        if (defaultMutableTreeNode.getUserObject() instanceof PO) {
            pO = (PO)defaultMutableTreeNode.getUserObject();
        } else if (defaultMutableTreeNode.getUserObject() instanceof AbstractPOWrapper) {
            pO = ((AbstractPOWrapper)defaultMutableTreeNode.getUserObject()).get();
        } else {
            return -1;
        }
        Field field = pO.getClass().getField("Table_ID");
        return field.getInt(null);
    }

    private int getRecordID(DefaultMutableTreeNode defaultMutableTreeNode) {
        PO pO = null;
        if (defaultMutableTreeNode.getUserObject() instanceof PO) {
            pO = (PO)defaultMutableTreeNode.getUserObject();
        } else if (defaultMutableTreeNode.getUserObject() instanceof AbstractPOWrapper) {
            pO = ((AbstractPOWrapper)defaultMutableTreeNode.getUserObject()).get();
        }
        return pO == null ? -1 : pO.get_ID();
    }

    private void zoom() {
        String string = this.tableName;
        int n = this.tableID;
        MQuery mQuery = new MQuery();
        mQuery.setTableName(string);
        AWindow aWindow = new AWindow();
        if (aWindow.initWindow(n, mQuery)) {
            AEnv.showCenterScreen(aWindow);
        }
        aWindow = null;
    }
}

