/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import org.compiere.model.PO;
import org.eevolution.tools.swing.SwingTool;
import org.eevolution.tools.worker.SingleWorker;

public abstract class PopupAction
extends JMenuItem
implements ActionListener {
    protected final ResourceBundle language = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".language");
    protected PropertyChangeSupport propertyChange;
    protected boolean success;
    protected boolean ignoreChange;
    protected SingleWorker worker;
    protected String errorMsg;

    protected abstract void doAction(ActionEvent var1);

    protected abstract String getCommand();

    protected abstract String validateAction();

    protected boolean successful() {
        return this.success;
    }

    public String getSuccessMsg() {
        return "OK";
    }

    protected void setError(String string) {
        this.errorMsg = string;
        this.success = false;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public PopupAction(String string) {
        this.setText(this.language.getString(string));
        this.setActionCommand(this.getCommand());
        this.init();
        this.addActionListener(this);
    }

    protected void init() {
        this.success = true;
        this.ignoreChange = false;
    }

    protected void beforeAction() {
        this.init();
        String string = this.validateAction();
        if (string != null) {
            this.setError(string);
            return;
        }
        SwingTool.setCursorsFromChild(this, true);
    }

    protected void afterAction() {
        if (!this.isIgnoreChange()) {
            this.propertyChange.firePropertyChange(this.getCommand(), false, this.successful());
        }
        SwingTool.setCursorsFromChild(this, false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final ActionEvent actionEvent2 = actionEvent;
        this.worker = new SingleWorker(){

            @Override
            protected Object doIt() {
                PopupAction.this.run(actionEvent2);
                return null;
            }
        };
        this.worker.start();
    }

    protected void run(ActionEvent actionEvent) {
        this.beforeAction();
        if (this.getActionCommand() != null && this.getActionCommand().equals(actionEvent.getActionCommand())) {
            this.doAction(actionEvent);
        }
        this.afterAction();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        this.propertyChange.addPropertyChangeListener(propertyChangeListener);
    }

    protected void setIgnoreChange(boolean bl) {
        this.ignoreChange = bl;
    }

    public boolean isIgnoreChange() {
        return this.ignoreChange;
    }

    protected void savePO(PO pO) {
        this.success = pO.save(null);
    }

    protected void deletePO(PO pO) {
        this.success = pO.delete(true, null);
    }
}

