/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.eevolution.form.TreeBOM;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class VTreeBOM
extends TreeBOM
implements FormPanel,
ActionListener,
ListSelectionListener,
PropertyChangeListener,
VetoableChangeListener,
TreeSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    CPanel panel = new CPanel();
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private JTree m_tree;
    private static CLogger log = CLogger.getCLogger(VTreeBOM.class);
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private FlowLayout northLayout = new FlowLayout();
    private CLabel labelProduct = new CLabel();
    private VLookup fieldProduct;
    private CCheckBox implosion = new CCheckBox();
    private CLabel treeInfo = new CLabel();
    private JSplitPane splitPane = new JSplitPane();
    private JScrollPane dataPane = new JScrollPane();
    private JScrollPane treePane = new JScrollPane();
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    protected StatusBar statusBar = new StatusBar();
    private MiniTable tableBOM = new MiniTable();
    private Vector<Vector<Object>> dataBOM = new Vector();
    private Vector<String> columnNames;
    private final int DIVIDER_LOCATION = 240;

    @Override
    public void init(int n, FormFrame formFrame) {
        this.m_WindowNo = n;
        this.m_frame = formFrame;
        log.info("VMerge.init - WinNo=" + this.m_WindowNo);
        try {
            this.preInit();
            this.jbInit();
            formFrame.getContentPane().add((Component)this.panel, "Center");
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "VTreeMaintenance.init", exception);
        }
    }

    private void preInit() throws Exception {
        Properties properties = this.getCtx();
        Language language = Language.getLoginLanguage();
        MLookup mLookup = MLookupFactory.get(properties, this.m_WindowNo, MColumn.getColumn_ID("M_Product", "M_Product_ID"), 30, language, "M_Product_ID", 0, false, " M_Product.IsSummary = 'N'");
        this.fieldProduct = new VLookup("M_Product_ID", false, false, true, mLookup){
            private static final long serialVersionUID = 1L;

            @Override
            public void setValue(Object object) {
                super.setValue(object);
                VTreeBOM.this.action_loadBOM();
            }
        };
        this.implosion.addActionListener(this);
        this.splitPane.add((Component)this.dataPane, "right");
        this.splitPane.add((Component)this.treePane, "left");
    }

    private void loadTableBOM() {
        this.columnNames = new Vector(18);
        this.columnNames.add(Msg.translate(this.getCtx(), "Select"));
        this.columnNames.add(Msg.translate(this.getCtx(), "IsActive"));
        this.columnNames.add(Msg.translate(this.getCtx(), "Line"));
        this.columnNames.add(Msg.translate(this.getCtx(), "ValidFrom"));
        this.columnNames.add(Msg.translate(this.getCtx(), "ValidTo"));
        this.columnNames.add(Msg.translate(this.getCtx(), "M_Product_ID"));
        this.columnNames.add(Msg.translate(this.getCtx(), "C_UOM_ID"));
        this.columnNames.add(Msg.translate(this.getCtx(), "IsQtyPercentage"));
        this.columnNames.add(Msg.translate(this.getCtx(), "QtyBatch"));
        this.columnNames.add(Msg.translate(this.getCtx(), "QtyBOM"));
        this.columnNames.add(Msg.translate(this.getCtx(), "IsCritical"));
        this.columnNames.add(Msg.translate(this.getCtx(), "LeadTimeOffset"));
        this.columnNames.add(Msg.translate(this.getCtx(), "Assay"));
        this.columnNames.add(Msg.translate(this.getCtx(), "Scrap"));
        this.columnNames.add(Msg.translate(this.getCtx(), "IssueMethod"));
        this.columnNames.add(Msg.translate(this.getCtx(), "BackflushGroup"));
        this.columnNames.add(Msg.translate(this.getCtx(), "Forecast"));
        this.tableBOM.getModel().removeTableModelListener(this);
        this.tableBOM.getModel().removeTableModelListener(this);
        DefaultTableModel defaultTableModel = new DefaultTableModel(this.dataBOM, this.columnNames);
        defaultTableModel.addTableModelListener(this);
        this.tableBOM.setModel(defaultTableModel);
        this.tableBOM.setColumnClass(0, Boolean.class, false);
        this.tableBOM.setColumnClass(1, Boolean.class, false);
        this.tableBOM.setColumnClass(2, Integer.class, false);
        this.tableBOM.setColumnClass(3, Timestamp.class, false);
        this.tableBOM.setColumnClass(4, Timestamp.class, false);
        this.tableBOM.setColumnClass(5, KeyNamePair.class, false);
        this.tableBOM.setColumnClass(6, KeyNamePair.class, false);
        this.tableBOM.setColumnClass(7, Boolean.class, false);
        this.tableBOM.setColumnClass(8, BigDecimal.class, false);
        this.tableBOM.setColumnClass(9, BigDecimal.class, false);
        this.tableBOM.setColumnClass(10, Boolean.class, false);
        this.tableBOM.setColumnClass(11, BigDecimal.class, false);
        this.tableBOM.setColumnClass(12, BigDecimal.class, false);
        this.tableBOM.setColumnClass(13, Integer.class, false);
        this.tableBOM.setColumnClass(14, String.class, false);
        this.tableBOM.setColumnClass(15, String.class, false);
        this.tableBOM.setColumnClass(16, BigDecimal.class, false);
        this.tableBOM.autoSize();
    }

    private void jbInit() {
        this.panel.setLayout(this.mainLayout);
        this.panel.setPreferredSize(new Dimension(640, 480));
        this.labelProduct.setText(Msg.getElement(this.getCtx(), "M_Product_ID"));
        this.implosion.setText(Msg.getElement(this.getCtx(), "Implosion"));
        this.northPanel.setLayout(this.northLayout);
        this.northLayout.setAlignment(0);
        this.panel.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.labelProduct, null);
        this.northPanel.add((Component)this.fieldProduct, null);
        this.northPanel.add((Component)this.implosion, null);
        this.northPanel.add((Component)this.treeInfo, null);
        this.panel.add((Component)this.southPanel, "South");
        this.southPanel.setLayout(this.southLayout);
        this.confirmPanel.addActionListener(this);
        this.southPanel.add((Component)this.confirmPanel, "South");
        this.panel.add((Component)this.splitPane, "Center");
        this.splitPane.setDividerLocation(240);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        log.info("VAllocation.vetoableChange - " + string + "=" + object);
        if (object == null) {
            return;
        }
        if (string.equals("M_Product_ID") && this.fieldProduct != null) {
            this.action_loadBOM();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.implosion) {
            this.action_loadBOM();
        }
        if (actionEvent.getActionCommand().equals("Ok")) {
            this.action_loadBOM();
        }
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    private void action_loadBOM() {
        int n = this.getM_Product_ID();
        if (n == 0) {
            return;
        }
        MProduct mProduct = MProduct.get(this.getCtx(), n);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.productSummary(mProduct, false));
        this.dataBOM.clear();
        if (this.isImplosion()) {
            for (MPPProductBOMLine mPPProductBOMLine : MPPProductBOMLine.getByProduct(mProduct)) {
                defaultMutableTreeNode.add(this.parent(mPPProductBOMLine));
            }
            this.m_tree = new JTree(defaultMutableTreeNode);
        } else {
            for (MPPProductBOM mPPProductBOM : MPPProductBOM.getProductBOMs(mProduct)) {
                defaultMutableTreeNode.add(this.parent(mPPProductBOM));
            }
            this.m_tree = new JTree(defaultMutableTreeNode);
        }
        this.m_tree.addTreeSelectionListener(this);
        this.treePane.getViewport().add((Component)this.m_tree, null);
        this.loadTableBOM();
        this.dataPane.getViewport().add((Component)this.tableBOM, null);
        this.splitPane.setDividerLocation(240);
    }

    public DefaultMutableTreeNode parent(MPPProductBOMLine mPPProductBOMLine) {
        MProduct mProduct = MProduct.get(this.getCtx(), mPPProductBOMLine.getM_Product_ID());
        MPPProductBOM mPPProductBOM = new MPPProductBOM(this.getCtx(), mPPProductBOMLine.getPP_Product_BOM_ID(), null);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.productSummary(mProduct, false));
        Vector<Object> vector = new Vector<Object>(17);
        vector.add(new Boolean(false));
        vector.add(new Boolean(true));
        vector.add(new Integer(mPPProductBOMLine.getLine()));
        vector.add(mPPProductBOMLine.getValidFrom());
        vector.add(mPPProductBOMLine.getValidTo());
        KeyNamePair keyNamePair = new KeyNamePair(mProduct.getM_Product_ID(), mProduct.getName());
        vector.add(keyNamePair);
        KeyNamePair keyNamePair2 = new KeyNamePair(mPPProductBOMLine.getC_UOM_ID(), mPPProductBOMLine.getC_UOM().getUOMSymbol());
        vector.add(keyNamePair2);
        vector.add(new Boolean(mPPProductBOMLine.isQtyPercentage()));
        vector.add(mPPProductBOMLine.getQtyBatch());
        vector.add(mPPProductBOMLine.getQtyBOM() != null ? mPPProductBOMLine.getQtyBOM() : new BigDecimal(0));
        vector.add(new Boolean(mPPProductBOMLine.isCritical()));
        vector.add(mPPProductBOMLine.getLeadTimeOffset());
        vector.add(mPPProductBOMLine.getAssay());
        vector.add(mPPProductBOMLine.getScrap());
        vector.add(mPPProductBOMLine.getIssueMethod());
        vector.add(mPPProductBOMLine.getBackflushGroup());
        vector.add(mPPProductBOMLine.getForecast());
        this.dataBOM.add(vector);
        Iterator<MPPProductBOM> iterator = MPPProductBOM.getProductBOMs((MProduct)mPPProductBOM.getM_Product()).iterator();
        if (iterator.hasNext()) {
            MPPProductBOM mPPProductBOM2 = iterator.next();
            MProduct mProduct2 = MProduct.get(this.getCtx(), mPPProductBOM2.getM_Product_ID());
            return this.component(mProduct2);
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode parent(MPPProductBOM mPPProductBOM) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.productSummary(mPPProductBOM));
        for (MPPProductBOMLine mPPProductBOMLine : mPPProductBOM.getLines()) {
            MProduct mProduct = MProduct.get(this.getCtx(), mPPProductBOMLine.getM_Product_ID());
            Vector<Object> vector = new Vector<Object>(17);
            vector.add(new Boolean(false));
            vector.add(new Boolean(true));
            vector.add(new Integer(mPPProductBOMLine.getLine()));
            vector.add(mPPProductBOMLine.getValidFrom());
            vector.add(mPPProductBOMLine.getValidTo());
            KeyNamePair keyNamePair = new KeyNamePair(mProduct.getM_Product_ID(), mProduct.getName());
            vector.add(keyNamePair);
            KeyNamePair keyNamePair2 = new KeyNamePair(mPPProductBOMLine.getC_UOM_ID(), mPPProductBOMLine.getC_UOM().getUOMSymbol());
            vector.add(keyNamePair2);
            vector.add(new Boolean(mPPProductBOMLine.isQtyPercentage()));
            vector.add(mPPProductBOMLine.getQtyBatch());
            vector.add(mPPProductBOMLine.getQtyBOM());
            vector.add(new Boolean(mPPProductBOMLine.isCritical()));
            vector.add(mPPProductBOMLine.getLeadTimeOffset());
            vector.add(mPPProductBOMLine.getAssay());
            vector.add(mPPProductBOMLine.getScrap());
            vector.add(mPPProductBOMLine.getIssueMethod());
            vector.add(mPPProductBOMLine.getBackflushGroup());
            vector.add(mPPProductBOMLine.getForecast());
            this.dataBOM.add(vector);
            defaultMutableTreeNode.add(this.component(mProduct));
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode component(MProduct mProduct) {
        if (this.isImplosion()) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.productSummary(mProduct, false));
            for (MPPProductBOMLine mPPProductBOMLine : MPPProductBOMLine.getByProduct(mProduct)) {
                defaultMutableTreeNode.add(this.parent(mPPProductBOMLine));
            }
            return defaultMutableTreeNode;
        }
        Iterator<MPPProductBOM> iterator = MPPProductBOM.getProductBOMs(mProduct).iterator();
        if (iterator.hasNext()) {
            MPPProductBOM mPPProductBOM = iterator.next();
            return this.parent(mPPProductBOM);
        }
        return new DefaultMutableTreeNode(this.productSummary(mProduct, true));
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void action_treeAdd(ListItem listItem) {
        log.info("VTreeMaintenance.action_treeAdd " + listItem);
        if (listItem != null) {
            // empty if block
        }
    }

    private void action_treeDelete(ListItem listItem) {
        log.info("VTreeMaintenance.action_treeDelete" + listItem);
        if (listItem != null) {
            // empty if block
        }
    }

    private void action_treeAddAll() {
        log.info("VTreeMaintenance.action_treeAddAll");
    }

    private void action_treeDeleteAll() {
        log.info("VTreeMaintenance.action_treeDeleteAll");
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    private boolean isImplosion() {
        return this.implosion.isSelected();
    }

    private int getM_Product_ID() {
        Integer n = (Integer)this.fieldProduct.getValue();
        if (n == null) {
            return 0;
        }
        return n;
    }

    class ListItem {
        public int id;
        public String name;
        public String description;
        public boolean isSummary;
        public String imageIndicator;

        public ListItem(int n, String string, String string2, boolean bl, String string3) {
            this.id = n;
            this.name = string;
            this.description = string2;
            this.isSummary = bl;
            this.imageIndicator = string3;
        }

        public String toString() {
            String string = this.name;
            if (this.description != null && this.description.length() > 0) {
                string = string + " (" + this.description + ")";
            }
            return string;
        }
    }
}

