/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.VBOMDrop;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.eevolution.form.bom.RadioButtonTreeCellRenderer;
import org.eevolution.form.bom.nodeUserObject;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.X_PP_Product_BOM;

public class VProductConfigurationBOM
extends CPanel
implements FormPanel,
ActionListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private CheckboxTree m_tree;
    private MProduct m_product = null;
    private BigDecimal m_qty = Env.ONE;
    private int m_bomLine = 0;
    private static CLogger log = CLogger.getCLogger(VBOMDrop.class);
    private ArrayList<JToggleButton> m_selectionList = new ArrayList();
    private ArrayList<VNumber> m_qtyList = new ArrayList();
    private ArrayList<Integer> m_productList = new ArrayList();
    private ArrayList<Integer> m_bomLineIDList = new ArrayList();
    private HashMap<String, ButtonGroup> m_buttonGroups = new HashMap();
    private static final int WINDOW_WIDTH = 600;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CPanel selectionPanel = new CPanel(new ALayout());
    private CComboBox productField;
    private VNumber productQty = new VNumber("Qty", true, false, true, 29, Msg.translate(Env.getCtx(), "Qty"));
    private CComboBox orderField;
    private CComboBox invoiceField;
    private CComboBox projectField;
    private RadioButtonTreeCellRenderer m_RadioButtonTreeCellRenderer = null;

    @Override
    public void init(int n, FormFrame formFrame) {
        log.info("");
        this.m_WindowNo = n;
        this.m_frame = formFrame;
        try {
            this.createSelectionPanel(true, true, true);
            this.m_frame.getContentPane().add((Component)this.selectionPanel, "North");
            this.createMainPanel();
            CScrollPane cScrollPane = new CScrollPane(this);
            this.m_frame.getContentPane().add((Component)cScrollPane, "Center");
            this.confirmPanel.addActionListener(this);
            this.m_frame.getContentPane().add((Component)this.confirmPanel, "South");
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Msg.translate(Env.getCtx(), "No Product Chosen"));
            this.m_RadioButtonTreeCellRenderer = new RadioButtonTreeCellRenderer();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "", exception);
        }
        this.sizeIt();
    }

    private void sizeIt() {
        this.m_frame.pack();
        Dimension dimension = this.m_frame.getPreferredSize();
        dimension.width = 600;
        this.m_frame.setSize(dimension);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
        this.removeAll();
        if (this.selectionPanel != null) {
            this.selectionPanel.removeAll();
        }
        this.selectionPanel = null;
        if (this.m_selectionList != null) {
            this.m_selectionList.clear();
        }
        this.m_selectionList = null;
        if (this.m_productList != null) {
            this.m_productList.clear();
        }
        this.m_productList = null;
        if (this.m_qtyList != null) {
            this.m_qtyList.clear();
        }
        this.m_qtyList = null;
        if (this.m_buttonGroups != null) {
            this.m_buttonGroups.clear();
        }
        this.m_buttonGroups = null;
    }

    private void createSelectionPanel(boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        this.selectionPanel.setBorder(new TitledBorder(Msg.translate(Env.getCtx(), "Selection")));
        this.productField = new CComboBox(this.getProducts());
        CLabel cLabel = new CLabel(Msg.translate(Env.getCtx(), "M_Product_ID"));
        cLabel.setLabelFor(this.productField);
        this.selectionPanel.add((Component)cLabel, new ALayoutConstraint(n++, 0));
        this.selectionPanel.add(this.productField);
        this.productField.addActionListener(this);
        cLabel = new CLabel(this.productQty.getTitle());
        cLabel.setLabelFor(this.productQty);
        this.selectionPanel.add(cLabel);
        this.selectionPanel.add(this.productQty);
        this.productQty.setValue(Env.ONE);
        this.productQty.addActionListener(this);
        if (bl) {
            this.orderField = new CComboBox(this.getOrders());
            cLabel = new CLabel(Msg.translate(Env.getCtx(), "C_Order_ID"));
            cLabel.setLabelFor(this.orderField);
            this.selectionPanel.add((Component)cLabel, new ALayoutConstraint(n++, 0));
            this.selectionPanel.add(this.orderField);
            this.orderField.addActionListener(this);
        }
        if (bl2) {
            this.invoiceField = new CComboBox(this.getInvoices());
            cLabel = new CLabel(Msg.translate(Env.getCtx(), "C_Invoice_ID"));
            cLabel.setLabelFor(this.invoiceField);
            this.selectionPanel.add((Component)cLabel, new ALayoutConstraint(n++, 0));
            this.selectionPanel.add(this.invoiceField);
            this.invoiceField.addActionListener(this);
        }
        if (bl3) {
            this.projectField = new CComboBox(this.getProjects());
            cLabel = new CLabel(Msg.translate(Env.getCtx(), "C_Project_ID"));
            cLabel.setLabelFor(this.projectField);
            this.selectionPanel.add((Component)cLabel, new ALayoutConstraint(n++, 0));
            this.selectionPanel.add(this.projectField);
            this.projectField.addActionListener(this);
        }
        this.confirmPanel.getOKButton().setEnabled(false);
        Dimension dimension = this.selectionPanel.getPreferredSize();
        dimension.width = 600;
        this.selectionPanel.setPreferredSize(dimension);
    }

    private KeyNamePair[] getProducts() {
        String string = "SELECT M_Product_ID, Name FROM M_Product WHERE IsBOM='Y' AND IsVerified='Y' AND IsActive='Y' and M_Product_ID in (SELECT M_Product_ID FROM PP_Product_bom WHERE bomtype = 'C' AND bomuse = 'A') ORDER BY Name";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(string, "M_Product", false, false), true);
    }

    private KeyNamePair[] getOrders() {
        String string = "SELECT C_Order_ID, DocumentNo || '_' || GrandTotal FROM C_Order WHERE Processed='N' AND DocStatus='DR' ORDER BY DocumentNo";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(string, "C_Order", false, false), true);
    }

    private KeyNamePair[] getProjects() {
        String string = "SELECT C_Project_ID, Name FROM C_Project WHERE Processed='N' AND IsSummary='N' AND IsActive='Y' AND ProjectCategory<>'S' ORDER BY Name";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(string, "C_Project", false, false), true);
    }

    private KeyNamePair[] getInvoices() {
        String string = "SELECT C_Invoice_ID, DocumentNo || '_' || GrandTotal FROM C_Invoice WHERE Processed='N' AND DocStatus='DR' ORDER BY DocumentNo";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(string, "C_Invoice", false, false), true);
    }

    private void createMainPanel() {
        log.config(": " + this.m_product);
        this.removeAll();
        this.setPreferredSize(null);
        this.invalidate();
        this.setBorder(null);
        this.m_selectionList.clear();
        this.m_productList.clear();
        this.m_bomLineIDList.clear();
        this.m_qtyList.clear();
        this.m_buttonGroups.clear();
        this.setLayout(new ALayout());
        String string = Msg.getMsg(Env.getCtx(), "SelectProduct");
        if (this.m_product != null && this.m_product.get_ID() > 0) {
            string = this.m_product.getName();
            if (this.m_product.getDescription() != null && this.m_product.getDescription().length() > 0) {
                this.setToolTipText(this.m_product.getDescription());
            }
            this.m_bomLine = 0;
            this.m_tree = new CheckboxTree(this.m_RadioButtonTreeCellRenderer.action_loadBOM(this.m_product, true));
            this.m_tree.getCheckingModel().setCheckingMode(TreeCheckingModel.CheckingMode.SIMPLE);
            this.m_tree.getCheckingModel().clearChecking();
            this.m_tree.setCellRenderer(this.m_RadioButtonTreeCellRenderer);
            this.m_tree.setScrollsOnExpand(true);
            JScrollPane jScrollPane = new JScrollPane(this.m_tree);
            this.add(jScrollPane);
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(Msg.translate(Env.getCtx(), "No Product Chosen"));
            this.m_tree = new CheckboxTree(defaultMutableTreeNode);
            JScrollPane jScrollPane = new JScrollPane(this.m_tree);
            this.add(jScrollPane);
        }
        this.setBorder(new TitledBorder(string));
    }

    private MProduct getProductFromMPPProductBOM(int n) {
        MProduct mProduct = null;
        try {
            StringBuffer stringBuffer = new StringBuffer("select m_product_id from pp_product_bom where pp_product_bom_id = ?");
            CPreparedStatement cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
            cPreparedStatement.setInt(1, n);
            ResultSet resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                mProduct = new MProduct(Env.getCtx(), n2, null);
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, "ERROR:", sQLException);
        }
        return mProduct;
    }

    private MProduct getProductFromMPPProductBOMLine(MPPProductBOMLine mPPProductBOMLine) {
        MProduct mProduct = null;
        try {
            StringBuffer stringBuffer = new StringBuffer("select m_product_id from pp_product_bomline where pp_product_bomline_id = ?");
            CPreparedStatement cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
            cPreparedStatement.setInt(1, mPPProductBOMLine.getPP_Product_BOMLine_ID());
            ResultSet resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                mProduct = new MProduct(Env.getCtx(), n, null);
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, "ERROR:", sQLException);
        }
        return mProduct;
    }

    private MPPProductBOMLine[] getBOMLines(MProduct mProduct) {
        ArrayList arrayList = new ArrayList();
        try {
            StringBuffer stringBuffer = new StringBuffer("select pp_product_bom_id from pp_product_bom where m_product_id = ?");
            CPreparedStatement cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
            cPreparedStatement.setInt(1, mProduct.get_ID());
            ResultSet resultSet = cPreparedStatement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                MPPProductBOM mPPProductBOM = new MPPProductBOM(Env.getCtx(), n, null);
                MPPProductBOMLine[] mPPProductBOMLineArray = mPPProductBOM.getLines();
                Collections.addAll(arrayList, mPPProductBOMLineArray);
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, "ERROR:", sQLException);
        }
        return arrayList.toArray(new MPPProductBOMLine[arrayList.size()]);
    }

    private void addBOMLines(MProduct mProduct, BigDecimal bigDecimal) {
        MPPProductBOMLine[] mPPProductBOMLineArray = this.getBOMLines(mProduct);
        for (int i = 0; i < mPPProductBOMLineArray.length; ++i) {
            this.addBOMLine(mPPProductBOMLineArray[i], bigDecimal);
        }
        log.fine("#" + mPPProductBOMLineArray.length);
    }

    private void addBOMLine(MPPProductBOMLine mPPProductBOMLine, BigDecimal bigDecimal) {
        log.fine("In addBOMLine");
        log.fine(mPPProductBOMLine.toString());
        String string = mPPProductBOMLine.getComponentType();
        if (string == null) {
            string = "P";
        }
        BigDecimal bigDecimal2 = new BigDecimal(0);
        MProduct mProduct = this.getProductFromMPPProductBOMLine(mPPProductBOMLine);
        if (mProduct == null) {
            return;
        }
        this.addDisplay(mPPProductBOMLine.getM_Product_ID(), mProduct.getM_Product_ID(), string, mProduct.getName(), bigDecimal2, mPPProductBOMLine.getPP_Product_BOM_ID(), mPPProductBOMLine.getFeature(), mPPProductBOMLine.get_ID());
    }

    private void addDisplay(int n, int n2, String string, String string2, BigDecimal bigDecimal, int n3, String string3, int n4) {
        Object object;
        log.fine("M_Product_ID=" + n2 + ",Type=" + string + ",Name=" + string2 + ",Qty=" + bigDecimal);
        boolean bl = true;
        if ("CO".equals(string)) {
            object = "";
            JCheckBox jCheckBox = new JCheckBox((String)object);
            jCheckBox.setSelected(true);
            jCheckBox.setEnabled(false);
            this.m_selectionList.add(jCheckBox);
            this.add((Component)jCheckBox, new ALayoutConstraint(this.m_bomLine++, 0));
        } else if ("VA".equals(string)) {
            object = Msg.getMsg(Env.getCtx(), "Optional");
            JCheckBox jCheckBox = new JCheckBox((String)object);
            jCheckBox.setSelected(false);
            bl = false;
            jCheckBox.addActionListener(this);
            this.m_selectionList.add(jCheckBox);
            this.add((Component)jCheckBox, new ALayoutConstraint(this.m_bomLine++, 0));
        } else {
            object = string3;
            JRadioButton jRadioButton = new JRadioButton((String)object);
            String string4 = String.valueOf(this.getProductFromMPPProductBOM(n3).get_ID()) + "_" + string;
            ButtonGroup buttonGroup = this.m_buttonGroups.get(string4);
            if (buttonGroup == null) {
                log.fine("ButtonGroup=" + string4);
                buttonGroup = new ButtonGroup();
                this.m_buttonGroups.put(string4, buttonGroup);
                buttonGroup.add(jRadioButton);
                jRadioButton.setSelected(true);
            } else {
                buttonGroup.add(jRadioButton);
                jRadioButton.setSelected(false);
                bl = false;
            }
            jRadioButton.addActionListener(this);
            this.m_selectionList.add(jRadioButton);
            this.add((Component)jRadioButton, new ALayoutConstraint(this.m_bomLine++, 0));
        }
        this.m_productList.add(new Integer(n2));
        this.m_bomLineIDList.add(new Integer(n4));
        object = new CLabel(string2);
        this.add((Component)object);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width > 600) {
            dimension.width = 570;
        }
        return dimension;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        Object object;
        log.config(actionEvent.getActionCommand());
        Object object2 = actionEvent.getSource();
        if (object2 instanceof JCheckBox || object2 instanceof JRadioButton) {
            this.cmd_selection(object2);
            if (object2 instanceof JRadioButton) {
                for (ButtonGroup buttonGroup : this.m_buttonGroups.values()) {
                    Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
                    while (enumeration.hasMoreElements()) {
                        if (object2 != enumeration.nextElement()) continue;
                        Enumeration<AbstractButton> enumeration2 = buttonGroup.getElements();
                        while (enumeration2.hasMoreElements()) {
                            AbstractButton abstractButton = enumeration2.nextElement();
                            if (object2 == abstractButton) continue;
                            this.cmd_selection(abstractButton);
                        }
                    }
                }
            }
        } else if (object2 == this.productField || object2 == this.productQty) {
            this.m_qty = (BigDecimal)this.productQty.getValue();
            object = (KeyNamePair)this.productField.getSelectedItem();
            this.m_product = MProduct.get(Env.getCtx(), ((KeyNamePair)object).getKey());
            this.createMainPanel();
            this.sizeIt();
        } else if (object2 == this.orderField) {
            boolean bl2;
            object = (KeyNamePair)this.orderField.getSelectedItem();
            boolean bl3 = bl2 = object != null && ((KeyNamePair)object).getKey() > 0;
            if (this.invoiceField != null) {
                this.invoiceField.setReadWrite(!bl2);
            }
            if (this.projectField != null) {
                this.projectField.setReadWrite(!bl2);
            }
        } else if (object2 == this.invoiceField) {
            boolean bl4;
            object = (KeyNamePair)this.invoiceField.getSelectedItem();
            boolean bl5 = bl4 = object != null && ((KeyNamePair)object).getKey() > 0;
            if (this.orderField != null) {
                this.orderField.setReadWrite(!bl4);
            }
            if (this.projectField != null) {
                this.projectField.setReadWrite(!bl4);
            }
        } else if (object2 == this.projectField) {
            boolean bl6;
            object = (KeyNamePair)this.projectField.getSelectedItem();
            boolean bl7 = bl6 = object != null && ((KeyNamePair)object).getKey() > 0;
            if (this.orderField != null) {
                this.orderField.setReadWrite(!bl6);
            }
            if (this.invoiceField != null) {
                this.invoiceField.setReadWrite(!bl6);
            }
        } else if (actionEvent.getActionCommand().equals("Ok")) {
            if (this.cmd_save()) {
                this.dispose();
            }
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
        boolean bl8 = bl = this.m_product != null;
        if (bl) {
            KeyNamePair keyNamePair = null;
            if (this.orderField != null) {
                keyNamePair = (KeyNamePair)this.orderField.getSelectedItem();
            }
            if ((keyNamePair == null || keyNamePair.getKey() <= 0) && this.invoiceField != null) {
                keyNamePair = (KeyNamePair)this.invoiceField.getSelectedItem();
            }
            if ((keyNamePair == null || keyNamePair.getKey() <= 0) && this.projectField != null) {
                keyNamePair = (KeyNamePair)this.projectField.getSelectedItem();
            }
            bl = keyNamePair != null && keyNamePair.getKey() > 0;
        }
        this.confirmPanel.getOKButton().setEnabled(bl);
    }

    private void cmd_selection(Object object) {
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            if (object != this.m_selectionList.get(i)) continue;
            boolean bl = this.isSelectionSelected(object);
            VNumber vNumber = this.m_qtyList.get(i);
            vNumber.setReadWrite(bl);
            return;
        }
        log.log(Level.SEVERE, "not found - " + object);
    }

    private boolean isSelectionSelected(Object object) {
        boolean bl = false;
        if (object instanceof JCheckBox) {
            bl = ((JCheckBox)object).isSelected();
        } else if (object instanceof JRadioButton) {
            bl = ((JRadioButton)object).isSelected();
        } else {
            log.log(Level.SEVERE, "Not valid - " + object);
        }
        return bl;
    }

    private boolean cmd_save() {
        KeyNamePair keyNamePair = (KeyNamePair)this.orderField.getSelectedItem();
        if (keyNamePair != null && keyNamePair.getKey() > 0) {
            return this.cmd_saveOrder(keyNamePair.getKey());
        }
        keyNamePair = (KeyNamePair)this.invoiceField.getSelectedItem();
        if (keyNamePair != null && keyNamePair.getKey() > 0) {
            return this.cmd_saveInvoice(keyNamePair.getKey());
        }
        keyNamePair = (KeyNamePair)this.projectField.getSelectedItem();
        if (keyNamePair != null && keyNamePair.getKey() > 0) {
            return this.cmd_saveProject(keyNamePair.getKey());
        }
        log.log(Level.SEVERE, "Nothing selected");
        return false;
    }

    private ArrayList<DefaultMutableTreeNode> getProductInstances(int n) {
        log.fine("In getProductInstances root_m_product_id: " + n);
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        try {
            StringBuffer stringBuffer = new StringBuffer("select a.m_product_id from pp_product_bom a, pp_product_bom b where a.name = b.name || ' Instance' and b.m_product_id = ? and a.bomtype = 'C' and a.bomuse = 'M'");
            log.fine("sql1: " + stringBuffer);
            CPreparedStatement cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
            log.fine("root_m_product_id: " + n);
            cPreparedStatement.setInt(1, n);
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                int n2 = resultSet.getInt(1);
                this.m_product = new MProduct(Env.getCtx(), n2, null);
                if (!this.m_product.isVerified()) continue;
                log.fine("Adding product: " + this.m_product.get_ID());
                arrayList.add(this.m_RadioButtonTreeCellRenderer.action_loadBOM(this.m_product, false));
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, "ERROR:", sQLException);
        }
        log.fine("# of product instances found: " + arrayList.size());
        return arrayList;
    }

    private ArrayList<DefaultMutableTreeNode> getProductInstances() {
        log.fine("In getProductInstances");
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        try {
            StringBuffer stringBuffer = new StringBuffer("select a.m_product_id from pp_product_bom a, pp_product_bom b where a.name = b.name || ' Instance' and b.m_product_id = ? and a.bomtype = 'C' and a.bomuse = 'M'");
            log.fine("sql1: " + stringBuffer);
            CPreparedStatement cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
            KeyNamePair keyNamePair = (KeyNamePair)this.productField.getSelectedItem();
            MProduct mProduct = MProduct.get(Env.getCtx(), keyNamePair.getKey());
            log.fine("m_productConfig.get_ID " + mProduct.get_ID());
            cPreparedStatement.setInt(1, mProduct.get_ID());
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                this.m_product = new MProduct(Env.getCtx(), n, null);
                if (!this.m_product.isVerified()) continue;
                log.fine("Adding product: " + this.m_product.get_ID());
                arrayList.add(this.m_RadioButtonTreeCellRenderer.action_loadBOM(this.m_product, false));
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, "ERROR:", sQLException);
        }
        log.fine("# of product instances found: " + arrayList.size());
        return arrayList;
    }

    private HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> buildConfigBOMIDToBOMLevelToLinesMap(MProduct mProduct) {
        log.fine("In buildConfigBOMIDToBOMLevelToLinesMap");
        HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> hashMap = new HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>();
        HashMap hashMap2 = new HashMap();
        MPPProductBOMLine[] mPPProductBOMLineArray = this.getBOMLines(mProduct);
        int n = 0;
        ArrayList<MPPProductBOMLine> arrayList = new ArrayList<MPPProductBOMLine>();
        for (int i = 0; i < mPPProductBOMLineArray.length; ++i) {
            log.fine("bom line from product with product_id: " + this.getProductFromMPPProductBOMLine(mPPProductBOMLineArray[i]).get_ID());
            arrayList.add(mPPProductBOMLineArray[i]);
        }
        hashMap2.put(new Integer(n), arrayList);
        MPPProductBOMLine mPPProductBOMLine = mPPProductBOMLineArray[0];
        int n2 = mPPProductBOMLine.getPP_Product_BOM_ID();
        hashMap.put(new Integer(n2), hashMap2);
        return hashMap;
    }

    private int getBomLevelBetweenPPProductBOMIDs(int n, int n2) {
        int n3 = 0;
        return n3;
    }

    private HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> buildConfigBOMIDToBOMLevelToLinesMapFromSelectionList() {
        log.fine("In buildConfigBOMIDToBOMLevelToLinesMapFromSelectionList");
        KeyNamePair keyNamePair = (KeyNamePair)this.productField.getSelectedItem();
        MProduct mProduct = MProduct.get(Env.getCtx(), keyNamePair.getKey());
        MPPProductBOMLine[] mPPProductBOMLineArray = this.getBOMLines(mProduct);
        int n = mPPProductBOMLineArray[0].getPP_Product_BOM_ID();
        HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> hashMap = new HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>();
        HashMap hashMap2 = new HashMap();
        HashMap<Integer, ArrayList<MPPProductBOMLine>> hashMap3 = null;
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            ArrayList<MPPProductBOMLine> arrayList;
            if (!this.isSelectionSelected(this.m_selectionList.get(i))) continue;
            int n2 = this.m_bomLineIDList.get(i);
            log.fine("PP_Product_BOMLine_ID: " + n2);
            MPPProductBOMLine mPPProductBOMLine = new MPPProductBOMLine(Env.getCtx(), n2, null);
            hashMap3 = hashMap.get(new Integer(mPPProductBOMLine.getPP_Product_BOM_ID()));
            if (hashMap3 == null) {
                hashMap3 = new HashMap();
                hashMap.put(new Integer(mPPProductBOMLine.getPP_Product_BOM_ID()), hashMap3);
                arrayList = new ArrayList();
                arrayList.add(mPPProductBOMLine);
                hashMap3.put(this.getBomLevelBetweenPPProductBOMIDs(n, mPPProductBOMLine.getPP_Product_BOM_ID()), arrayList);
                continue;
            }
            arrayList = hashMap3.get(this.getBomLevelBetweenPPProductBOMIDs(n, mPPProductBOMLine.getPP_Product_BOM_ID()));
            arrayList.add(mPPProductBOMLine);
        }
        return hashMap;
    }

    private void printBOMLevelToLinesMap(HashMap<Integer, ArrayList<MPPProductBOMLine>> hashMap) {
        Set<Map.Entry<Integer, ArrayList<MPPProductBOMLine>>> set = hashMap.entrySet();
        for (Map.Entry<Integer, ArrayList<MPPProductBOMLine>> entry : set) {
            log.fine("BOM level: " + ((Object)entry.getKey()).toString());
            ArrayList<MPPProductBOMLine> arrayList = entry.getValue();
            log.fine("Total BOM line's: " + arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                MPPProductBOMLine mPPProductBOMLine = arrayList.get(i);
                log.fine("bom line #: " + i + " product: " + mPPProductBOMLine.getDescription());
            }
        }
    }

    private void printConfigBOMIDToBOMLinesMapForProduct(MProduct mProduct, HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> hashMap) {
        log.fine("In printConfigBOMIDToBOMLinesMapForProduct");
        log.fine("Analyzing product bom id's and corresponding bomlines and levels for those product bom id's for a particular product");
        log.fine("Product: " + mProduct.getName() + " has:");
        log.fine("Total BOM's: " + hashMap.size());
        Set<Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>> set = hashMap.entrySet();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> entry : set) {
            HashMap<Object, Object> hashMap2 = new HashMap();
            log.fine("PP_Product_BOM_ID: " + ((Object)entry.getKey()).toString() + " has: ");
            hashMap2 = entry.getValue();
            Set<Map.Entry<Object, Object>> set2 = hashMap2.entrySet();
            for (Map.Entry<Object, Object> entry2 : set2) {
                ArrayList arrayList = (ArrayList)entry2.getValue();
                log.fine("Total bom lines: " + arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    MPPProductBOMLine mPPProductBOMLine = (MPPProductBOMLine)arrayList.get(i);
                    log.fine("bom line #: " + i + " product: " + mPPProductBOMLine.getDescription());
                }
            }
        }
    }

    private int getTotalBOMLines(HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> hashMap) {
        log.fine("In getTotalBOMLines");
        int n = 0;
        Set<Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>> set = hashMap.entrySet();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> entry : set) {
            HashMap<Object, Object> hashMap2 = new HashMap();
            hashMap2 = entry.getValue();
            Set<Map.Entry<Object, Object>> set2 = hashMap2.entrySet();
            for (Map.Entry<Object, Object> entry2 : set2) {
                ArrayList arrayList = (ArrayList)entry2.getValue();
                n += arrayList.size();
            }
        }
        log.fine("Total bom lines: " + n);
        return n;
    }

    private int getTotalBOMLevels(HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> hashMap) {
        log.fine("In getTotalBOMLevels");
        int n = 0;
        Set<Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>> set = hashMap.entrySet();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> entry : set) {
            HashMap<Object, Object> hashMap2 = new HashMap();
            log.fine("PP_Product_BOM_ID: " + ((Object)entry.getKey()).toString() + " has: ");
            hashMap2 = entry.getValue();
            Set<Map.Entry<Object, Object>> set2 = hashMap2.entrySet();
            for (Map.Entry<Object, Object> entry2 : set2) {
                if ((Integer)entry2.getKey() <= n) continue;
                n = (Integer)entry2.getKey();
            }
        }
        log.fine("maxBOMLevel found: " + n);
        return n;
    }

    private boolean isSameProductsInProductInstance(int n, ArrayList<MPPProductBOMLine> arrayList, HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> hashMap) {
        log.info("In isSameProductsInProductInstance");
        boolean bl = true;
        Set<Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>> set = hashMap.entrySet();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> entry : set) {
            HashMap<Object, Object> hashMap2 = new HashMap();
            log.fine("PP_Product_BOM_ID: " + ((Object)entry.getKey()).toString() + " has: ");
            hashMap2 = entry.getValue();
            Set<Map.Entry<Object, Object>> set2 = hashMap2.entrySet();
            for (Map.Entry<Object, Object> entry2 : set2) {
                if ((Integer)entry2.getKey() != n) continue;
                ArrayList arrayList2 = (ArrayList)entry2.getValue();
                log.fine("configBomLines.size: " + arrayList.size());
                log.fine("configInstanceBomLines.size: " + arrayList2.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    boolean bl2 = false;
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        int n2 = this.getProductFromMPPProductBOMLine(arrayList.get(i)).get_ID();
                        int n3 = this.getProductFromMPPProductBOMLine(arrayList.get(j)).get_ID();
                        log.fine("bomLevel: " + n);
                        log.fine("chosenProduct_ID: " + n2);
                        log.fine("instanceProduct_ID: " + n3);
                        if (n2 != n3) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    return false;
                }
            }
        }
        return bl;
    }

    private boolean isSameProductsAtBOMLevel(int n, HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> hashMap, HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> hashMap2) {
        log.fine("In isSameProductsAtBOMLevel");
        boolean bl = true;
        Set<Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>>> set = hashMap.entrySet();
        for (Map.Entry<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> entry : set) {
            HashMap<Object, Object> hashMap3 = new HashMap();
            log.fine("PP_Product_BOM_ID: " + ((Object)entry.getKey()).toString() + " has: ");
            hashMap3 = entry.getValue();
            Set<Map.Entry<Object, Object>> set2 = hashMap3.entrySet();
            for (Map.Entry<Object, Object> entry2 : set2) {
                ArrayList arrayList;
                if ((Integer)entry2.getKey() != n || this.isSameProductsInProductInstance(n, arrayList = (ArrayList)entry2.getValue(), hashMap2)) continue;
                bl = false;
            }
        }
        return bl;
    }

    private boolean isSameBOMStructure(HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> hashMap, HashMap<Integer, HashMap<Integer, ArrayList<MPPProductBOMLine>>> hashMap2) {
        log.fine("In isSameBOMStructure");
        boolean bl = true;
        int n = this.getTotalBOMLevels(hashMap);
        int n2 = this.getTotalBOMLevels(hashMap2);
        if (n == n2) {
            for (int i = 0; i < n + 1; ++i) {
                if (this.isSameProductsAtBOMLevel(i, hashMap, hashMap2)) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean pruneProductConfig() {
        log.fine("In pruneProductConfig");
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = this.m_RadioButtonTreeCellRenderer.root;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        log.fine("About to prune");
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                log.fine("Analyzing: " + defaultMutableTreeNode2);
                log.fine("level: " + defaultMutableTreeNode2.getLevel());
                nodeUserObject nodeUserObject2 = (nodeUserObject)defaultMutableTreeNode2.getUserObject();
                log.fine("isMandatory: " + nodeUserObject2.isMandatory);
                log.fine("isChosen: " + nodeUserObject2.isChosen);
                if (defaultMutableTreeNode2.isRoot() || nodeUserObject2.isChosen || nodeUserObject2.isMandatory) continue;
                log.fine("Removing: " + defaultMutableTreeNode2);
                defaultMutableTreeNode2.removeFromParent();
                bl = true;
            }
        }
        log.fine("Exiting pruneConfig");
        return bl;
    }

    private int getNumNodesFromRoot(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        ArrayList<TreeNode> arrayList = Collections.list(enumeration);
        return arrayList.size();
    }

    private boolean isProductContainedAtLevelInProductInstance(int n, int n2, DefaultMutableTreeNode defaultMutableTreeNode) {
        log.fine("In isProductContainedAtLevelInProductInstance");
        log.fine("looking for m_product_id: " + n + " at level: " + n2);
        log.fine("rootProductInstance.getDepth: " + defaultMutableTreeNode.getDepth());
        log.fine("rootProductInstance.getNumNodesFromRoot: " + this.getNumNodesFromRoot(defaultMutableTreeNode));
        boolean bl = false;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                nodeUserObject nodeUserObject2 = (nodeUserObject)defaultMutableTreeNode2.getUserObject();
                log.fine("node: " + defaultMutableTreeNode2 + " product instance m_product_id: " + nodeUserObject2.M_Product.get_ID() + " at level: " + defaultMutableTreeNode2.getLevel());
                if (defaultMutableTreeNode2.getLevel() != n2 || nodeUserObject2.M_Product.get_ID() != n) continue;
                bl = true;
                return bl;
            }
        }
        return bl;
    }

    private void printTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        log.fine("In printTree");
        log.fine("root.getDepth: " + defaultMutableTreeNode.getDepth());
        log.fine("root.getNumNodesFromRoot: " + this.getNumNodesFromRoot(defaultMutableTreeNode));
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                nodeUserObject nodeUserObject2 = (nodeUserObject)defaultMutableTreeNode2.getUserObject();
                log.fine("node: " + defaultMutableTreeNode2 + " product instance m_product_id: " + nodeUserObject2.M_Product.get_ID() + " at level: " + defaultMutableTreeNode2.getLevel());
                log.fine("bom id: " + nodeUserObject2.bom.get_ID());
                log.fine("isMandatory: " + nodeUserObject2.isMandatory);
                log.fine("isChosen: " + nodeUserObject2.isChosen);
            }
        }
    }

    private boolean isConfigEqualToProductInstance(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        Enumeration<TreeNode> enumeration;
        log.fine("In isConfigEqualToProductInstance");
        boolean bl = false;
        boolean bl2 = false;
        log.fine("rootProductConfig.getDepth: " + defaultMutableTreeNode2.getDepth());
        log.fine("rootProductInstance.getDepth: " + defaultMutableTreeNode.getDepth());
        log.fine("rootProductConfig.getNumNodesFromRoot: " + this.getNumNodesFromRoot(defaultMutableTreeNode2));
        log.fine("rootProductInstance.getNumNodesFromRoot: " + this.getNumNodesFromRoot(defaultMutableTreeNode));
        if (this.getNumNodesFromRoot(defaultMutableTreeNode2) == this.getNumNodesFromRoot(defaultMutableTreeNode) && defaultMutableTreeNode2.getDepth() == defaultMutableTreeNode.getDepth() && (enumeration = defaultMutableTreeNode2.breadthFirstEnumeration()) != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                nodeUserObject nodeUserObject2 = (nodeUserObject)defaultMutableTreeNode3.getUserObject();
                if (!nodeUserObject2.isChosen && !nodeUserObject2.isMandatory || defaultMutableTreeNode2.getLevel() - defaultMutableTreeNode3.getLevel() + 1 <= 1 || nodeUserObject2.bomLine == null || this.isProductContainedAtLevelInProductInstance(nodeUserObject2.M_Product.get_ID(), defaultMutableTreeNode2.getLevel() - defaultMutableTreeNode3.getLevel() + 1, defaultMutableTreeNode)) continue;
                return bl;
            }
            bl = true;
            return bl;
        }
        return bl;
    }

    private boolean isConfigEqualToProductInstance(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration;
        log.fine("In isConfigEqualToProductInstance");
        boolean bl = false;
        boolean bl2 = false;
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.m_RadioButtonTreeCellRenderer.root;
        log.fine("rootProductConfig.getDepth: " + defaultMutableTreeNode2.getDepth());
        log.fine("rootProductInstance.getDepth: " + defaultMutableTreeNode.getDepth());
        log.fine("rootProductConfig.getNumNodesFromRoot: " + this.getNumNodesFromRoot(defaultMutableTreeNode2));
        log.fine("rootProductInstance.getNumNodesFromRoot: " + this.getNumNodesFromRoot(defaultMutableTreeNode));
        if (this.getNumNodesFromRoot(defaultMutableTreeNode2) == this.getNumNodesFromRoot(defaultMutableTreeNode) && defaultMutableTreeNode2.getDepth() == defaultMutableTreeNode.getDepth() && (enumeration = defaultMutableTreeNode2.breadthFirstEnumeration()) != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                nodeUserObject nodeUserObject2 = (nodeUserObject)defaultMutableTreeNode3.getUserObject();
                if (!nodeUserObject2.isChosen && !nodeUserObject2.isMandatory || defaultMutableTreeNode3.getLevel() <= 1 || this.isProductContainedAtLevelInProductInstance(nodeUserObject2.M_Product.get_ID(), defaultMutableTreeNode3.getLevel(), defaultMutableTreeNode)) continue;
                return bl;
            }
            bl = true;
            return bl;
        }
        return bl;
    }

    private DefaultMutableTreeNode findProductInstance(DefaultMutableTreeNode defaultMutableTreeNode) {
        log.fine("In findProductInstance");
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        nodeUserObject nodeUserObject2 = (nodeUserObject)defaultMutableTreeNode.getUserObject();
        ArrayList<DefaultMutableTreeNode> arrayList = this.getProductInstances(nodeUserObject2.M_Product.get_ID());
        if (arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!this.isConfigEqualToProductInstance(arrayList.get(i), defaultMutableTreeNode)) continue;
                defaultMutableTreeNode2 = arrayList.get(i);
            }
        }
        return defaultMutableTreeNode2;
    }

    private int findProductInstance() {
        log.fine("In findProductInstance");
        int n = -1;
        DefaultMutableTreeNode defaultMutableTreeNode = this.m_RadioButtonTreeCellRenderer.root;
        ArrayList<DefaultMutableTreeNode> arrayList = this.getProductInstances();
        if (arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!this.isConfigEqualToProductInstance(arrayList.get(i))) continue;
                nodeUserObject nodeUserObject2 = (nodeUserObject)arrayList.get(i).getUserObject();
                n = nodeUserObject2.M_Product.get_ID();
            }
        }
        return n;
    }

    private DefaultMutableTreeNode getLowestConfigurableBOMTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        log.fine("In getLowestConfigurableBOMTreeNode");
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.m_RadioButtonTreeCellRenderer.root;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.breadthFirstEnumeration();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                nodeUserObject nodeUserObject2 = (nodeUserObject)defaultMutableTreeNode3.getUserObject();
                log.fine("child level: " + defaultMutableTreeNode3.getLevel());
                log.fine("child: " + defaultMutableTreeNode3);
                if (defaultMutableTreeNode3.getLevel() <= 1) continue;
                X_PP_Product_BOM cfr_ignored_0 = nodeUserObject2.bom;
                if (!nodeUserObject2.bom.getBOMType().equals("C")) continue;
                X_PP_Product_BOM cfr_ignored_1 = nodeUserObject2.bom;
                if (!nodeUserObject2.bom.getBOMUse().equals("A") || nodeUserObject2.bomLine != null) continue;
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = defaultMutableTreeNode3;
                    continue;
                }
                if (defaultMutableTreeNode.getLevel() <= defaultMutableTreeNode3.getLevel()) continue;
                defaultMutableTreeNode = defaultMutableTreeNode3;
            }
        }
        return defaultMutableTreeNode;
    }

    private boolean replaceProductConfigBOMwithProductFromChoices() {
        boolean bl = true;
        boolean bl2 = false;
        log.fine("In replaceProductConfigBOMwithProductFromChoices");
        while (!bl2) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getLowestConfigurableBOMTreeNode();
            log.fine("lowestProductConfigBOMNode: " + defaultMutableTreeNode);
            if (defaultMutableTreeNode == null) {
                bl2 = true;
                continue;
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.findProductInstance(defaultMutableTreeNode);
            log.fine("foundProductInstanceNode: " + defaultMutableTreeNode2);
            if (defaultMutableTreeNode2 == null) {
                bl2 = true;
                bl = false;
                continue;
            }
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            nodeUserObject nodeUserObject2 = (nodeUserObject)defaultMutableTreeNode2.getUserObject();
            nodeUserObject2.isChosen = true;
            nodeUserObject2.isMandatory = true;
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.removeFromParent();
        }
        return bl;
    }

    private boolean cmd_saveOrder(int n) {
        Object object;
        log.config("C_Order_ID=" + n);
        MOrder mOrder = new MOrder(Env.getCtx(), n, null);
        if (mOrder.get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Order_ID=" + n);
            return false;
        }
        this.m_qty = (BigDecimal)this.productQty.getValue();
        log.fine("printing product config tree");
        this.printTree(this.m_RadioButtonTreeCellRenderer.root);
        while (this.pruneProductConfig()) {
        }
        int n2 = -1;
        boolean bl = this.replaceProductConfigBOMwithProductFromChoices();
        log.fine("replaceResult: " + bl);
        if (bl) {
            log.fine("After replacement product config tree");
            this.printTree(this.m_RadioButtonTreeCellRenderer.root);
            n2 = this.findProductInstance();
        }
        log.fine("M_Product_ID: " + n2);
        if (n2 < 0 || !bl) {
            log.fine("No product instance found for the configuration chosen");
            object = "No product instance found for the configuration chosen, create one?";
            String string = "Warning";
            int n3 = JOptionPane.showConfirmDialog(null, object, string, 0);
            if (n3 == 0) {
                log.fine("create product instance");
            }
        }
        object = new MOrderLine(mOrder);
        ((MOrderLine)object).setM_Product_ID(this.m_product.get_ID(), true);
        ((MOrderLine)object).setQty(this.m_qty);
        ((MOrderLine)object).setPrice();
        ((MOrderLine)object).setTax();
        if (((PO)object).save()) {
            log.fine("order line saved");
        } else {
            log.log(Level.SEVERE, "Line not saved");
        }
        int n4 = 0;
        log.config("#" + n4);
        return true;
    }

    private boolean cmd_saveInvoice(int n) {
        log.config("C_Invoice_ID=" + n);
        MInvoice mInvoice = new MInvoice(Env.getCtx(), n, null);
        if (mInvoice.get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Invoice_ID=" + n);
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            if (!this.isSelectionSelected(this.m_selectionList.get(i))) continue;
            BigDecimal bigDecimal = (BigDecimal)this.m_qtyList.get(i).getValue();
            int n3 = this.m_productList.get(i);
            MInvoiceLine mInvoiceLine = new MInvoiceLine(mInvoice);
            mInvoiceLine.setM_Product_ID(n3, true);
            mInvoiceLine.setQty(bigDecimal);
            mInvoiceLine.setPrice();
            mInvoiceLine.setTax();
            if (mInvoiceLine.save()) {
                ++n2;
                continue;
            }
            log.log(Level.SEVERE, "Line not saved");
        }
        log.config("#" + n2);
        return true;
    }

    private boolean cmd_saveProject(int n) {
        log.config("C_Project_ID=" + n);
        MProject mProject = new MProject(Env.getCtx(), n, null);
        if (mProject.get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Project_ID=" + n);
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            if (!this.isSelectionSelected(this.m_selectionList.get(i))) continue;
            BigDecimal bigDecimal = (BigDecimal)this.m_qtyList.get(i).getValue();
            int n3 = this.m_productList.get(i);
            MProjectLine mProjectLine = new MProjectLine(mProject);
            mProjectLine.setM_Product_ID(n3);
            mProjectLine.setPlannedQty(bigDecimal);
            if (mProjectLine.save()) {
                ++n2;
                continue;
            }
            log.log(Level.SEVERE, "Line not saved");
        }
        log.config("#" + n2);
        return true;
    }
}

