/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLocator;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VPAttribute;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MColumn;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MTab;
import org.compiere.model.MWindow;
import org.compiere.plaf.CompiereColor;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.swing.CTextPane;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderBOMLine;

public class VOrderReceiptIssue
extends CPanel
implements FormPanel,
ActionListener,
VetoableChangeListener,
ChangeListener,
ListSelectionListener,
TableModelListener,
ASyncProcess {
    private static final long serialVersionUID = 1L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private StatusBar statusBar = new StatusBar();
    private static CLogger log = CLogger.getCLogger(VOrderReceiptIssue.class);
    private CPanel mainPanel = new CPanel();
    private CPanel Generate = new CPanel();
    private CPanel PanelBottom = new CPanel();
    private CPanel PanelCenter = new CPanel();
    private CPanel northPanel = new CPanel();
    private CButton Process = new CButton();
    private CPanel ReceiptIssueOrder = new CPanel();
    private JTabbedPane TabsReceiptsIssue = new JTabbedPane();
    private VPAttribute attribute = null;
    private CLabel attributeLabel = new CLabel();
    private VNumber orderedQtyField = new VNumber("QtyOrdered", false, false, false, 29, "QtyOrdered");
    private CLabel orderedQtyLabel = new CLabel();
    private VNumber deliveredQtyField = new VNumber("QtyDelivered", false, false, false, 29, "QtyDelivered");
    private CLabel deliveredQtyLabel = new CLabel();
    private VNumber openQtyField = new VNumber("QtyOpen", false, false, false, 29, "QtyOpen");
    private CLabel openQtyLabel = new CLabel();
    private VNumber toDeliverQty = new VNumber("QtyToDeliver", true, false, true, 29, "QtyToDeliver");
    private CLabel toDeliverQtyLabel = new CLabel();
    private JScrollPane issueScrollPane = new JScrollPane();
    private MiniTable issue = new MiniTable();
    private VDate movementDateField = new VDate("MovementDate", true, false, true, 15, "MovementDate");
    private CLabel movementDateLabel = new CLabel();
    private VLookup orderField = null;
    private CLabel orderLabel = new CLabel();
    private VNumber rejectQty = new VNumber("Qtyreject", false, false, true, 29, "QtyReject");
    private CLabel rejectQtyLabel = new CLabel();
    private VLookup resourceField = null;
    private CLabel resourceLabel = new CLabel();
    private VLookup warehouseField = null;
    private CLabel warehouseLabel = new CLabel();
    private VNumber scrapQtyField = new VNumber("Qtyscrap", false, false, true, 29, "Qtyscrap");
    private CLabel scrapQtyLabel = new CLabel();
    private CLabel backflushGroupLabel = new CLabel(Msg.translate(Env.getCtx(), "BackflushGroup"));
    private CTextField backflushGroup = new CTextField(10);
    private CLabel productLabel = new CLabel(Msg.translate(Env.getCtx(), "M_Product_ID"));
    private VLookup productField = null;
    private CLabel uomLabel = new CLabel(Msg.translate(Env.getCtx(), "C_UOM_ID"));
    private VLookup uomField = null;
    private CLabel uomorderLabel = new CLabel(Msg.translate(Env.getCtx(), "Altert UOM"));
    private VLookup uomorderField = null;
    private CLabel locatorLabel = new CLabel(Msg.translate(Env.getCtx(), "M_Locator_ID"));
    private VLocator locatorField = null;
    private CLabel labelcombo = new CLabel(Msg.translate(Env.getCtx(), "DeliveryRule"));
    private VComboBox pickcombo = new VComboBox();
    private CLabel QtyBatchsLabel = new CLabel();
    private VNumber qtyBatchsField = new VNumber("QtyBatchs", false, false, false, 29, "QtyBatchs");
    private CLabel QtyBatchSizeLabel = new CLabel();
    private VNumber qtyBatchSizeField = new VNumber("QtyBatchSize", false, false, false, 29, "QtyBatchSize");
    private CTextPane info = new CTextPane();
    private MPPOrder m_PP_order = null;

    @Override
    public void init(int n, FormFrame formFrame) {
        this.m_WindowNo = n;
        this.m_frame = formFrame;
        log.info("VOrderReceipIssue.init - WinNo=" + this.m_WindowNo);
        try {
            this.fillPicks();
            this.jbInit();
            this.dynInit();
            this.pickcombo.addActionListener(this);
            formFrame.getContentPane().add((Component)this.mainPanel, "Center");
            formFrame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "VOrderReceipIssue.init", exception);
        }
    }

    private void fillPicks() throws Exception {
        Properties properties = Env.getCtx();
        Language language = Language.getLoginLanguage();
        MLookup mLookup = MLookupFactory.get(properties, this.m_WindowNo, MColumn.getColumn_ID("PP_Order", "PP_Order_ID"), 30, language, "PP_Order_ID", 0, false, "PP_Order.DocStatus = 'CO'");
        this.orderField = new VLookup("PP_Order_ID", false, false, true, mLookup);
        this.orderField.setBackground(AdempierePLAF.getInfoBackground());
        this.orderField.addVetoableChangeListener(this);
        MLookup mLookup2 = MLookupFactory.get(properties, this.m_WindowNo, 0, MColumn.getColumn_ID("PP_Order", "S_Resource_ID"), 19);
        this.resourceField = new VLookup("S_Resource_ID", false, false, false, mLookup2);
        MLookup mLookup3 = MLookupFactory.get(properties, this.m_WindowNo, 0, MColumn.getColumn_ID("PP_Order", "M_Warehouse_ID"), 19);
        this.warehouseField = new VLookup("M_Warehouse_ID", false, false, false, mLookup3);
        MLookup mLookup4 = MLookupFactory.get(properties, this.m_WindowNo, 0, MColumn.getColumn_ID("PP_Order", "M_Product_ID"), 19);
        this.productField = new VLookup("M_Product_ID", false, false, false, mLookup4);
        MLookup mLookup5 = MLookupFactory.get(properties, this.m_WindowNo, 0, MColumn.getColumn_ID("PP_Order", "C_UOM_ID"), 19);
        this.uomField = new VLookup("C_UOM_ID", false, false, false, mLookup5);
        MLookup mLookup6 = MLookupFactory.get(properties, this.m_WindowNo, 0, MColumn.getColumn_ID("PP_Order", "C_UOM_ID"), 19);
        this.uomorderField = new VLookup("C_UOM_ID", false, false, false, mLookup6);
        MLocatorLookup mLocatorLookup = new MLocatorLookup(properties, this.m_WindowNo);
        this.locatorField = new VLocator("M_Locator_ID", true, false, true, mLocatorLookup, this.m_WindowNo);
        MPAttributeLookup mPAttributeLookup = new MPAttributeLookup(properties, this.m_WindowNo);
        this.attribute = new VPAttribute(false, false, true, this.m_WindowNo, mPAttributeLookup);
        this.attribute.setValue(0);
        int n = MWindow.getWindow_ID("Manufacturing Order");
        GridFieldVO gridFieldVO = GridFieldVO.createStdField(properties, this.m_WindowNo, 0, n, MTab.getTab_ID(n, "Order"), false, false, false);
        gridFieldVO.AD_Column_ID = MColumn.getColumn_ID("PP_Order", "M_AttributeSetInstance_ID");
        GridField gridField = new GridField(gridFieldVO);
        this.attribute.setField(gridField);
        this.scrapQtyField.setValue(Env.ZERO);
        this.rejectQty.setValue(Env.ZERO);
        this.pickcombo.addItem(new KeyNamePair(1, Msg.translate(Env.getCtx(), "IsBackflush")));
        this.pickcombo.addItem(new KeyNamePair(2, Msg.translate(Env.getCtx(), "OnlyIssue")));
        this.pickcombo.addItem(new KeyNamePair(3, Msg.translate(Env.getCtx(), "OnlyReceipt")));
        this.pickcombo.addActionListener(this);
        this.Process.addActionListener(this);
        this.toDeliverQty.addActionListener(this);
        this.scrapQtyField.addActionListener(this);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.ReceiptIssueOrder.setLayout(new BorderLayout());
        this.PanelCenter.setLayout(new BorderLayout());
        this.issueScrollPane.setBorder(new TitledBorder(""));
        this.issueScrollPane.setViewportView(this.issue);
        this.PanelCenter.add((Component)this.issueScrollPane, "Center");
        this.ReceiptIssueOrder.add((Component)this.PanelCenter, "Center");
        this.Process.setText(Msg.translate(Env.getCtx(), "OK"));
        this.PanelBottom.add(this.Process);
        this.ReceiptIssueOrder.add((Component)this.PanelBottom, "South");
        this.northPanel.setLayout(new GridBagLayout());
        this.orderLabel.setText(Msg.translate(Env.getCtx(), "PP_Order_ID"));
        this.northPanel.add((Component)this.orderLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.orderField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.resourceLabel.setText(Msg.translate(Env.getCtx(), "S_Resource_ID"));
        this.northPanel.add((Component)this.resourceLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.resourceField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.warehouseLabel.setText(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        this.northPanel.add((Component)this.warehouseLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.warehouseField, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.warehouseLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.productLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.productField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.uomLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.uomField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.uomorderLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.uomorderField, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.orderedQtyLabel.setText(Msg.translate(Env.getCtx(), "QtyOrdered"));
        this.northPanel.add((Component)this.orderedQtyLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.orderedQtyField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.deliveredQtyLabel.setText(Msg.translate(Env.getCtx(), "QtyDelivered"));
        this.northPanel.add((Component)this.deliveredQtyLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.deliveredQtyField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.openQtyLabel.setText(Msg.translate(Env.getCtx(), "QtyOpen"));
        this.northPanel.add((Component)this.openQtyLabel, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.openQtyField, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.QtyBatchsLabel.setText(Msg.translate(Env.getCtx(), "QtyBatchs"));
        this.northPanel.add((Component)this.QtyBatchsLabel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.qtyBatchsField, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.QtyBatchSizeLabel.setText(Msg.translate(Env.getCtx(), "QtyBatchSize"));
        this.northPanel.add((Component)this.QtyBatchSizeLabel, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.qtyBatchSizeField, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.labelcombo, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.pickcombo, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.toDeliverQtyLabel.setText(Msg.translate(Env.getCtx(), "QtyToDeliver"));
        this.northPanel.add((Component)this.toDeliverQtyLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.toDeliverQty, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.scrapQtyLabel.setText(Msg.translate(Env.getCtx(), "QtyScrap"));
        this.northPanel.add((Component)this.scrapQtyLabel, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.scrapQtyField, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.rejectQtyLabel.setText(Msg.translate(Env.getCtx(), "QtyReject"));
        this.northPanel.add((Component)this.rejectQtyLabel, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.rejectQty, new GridBagConstraints(5, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.movementDateLabel.setText(Msg.translate(Env.getCtx(), "MovementDate"));
        this.northPanel.add((Component)this.movementDateLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.movementDateField, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.locatorLabel.setText(Msg.translate(Env.getCtx(), "M_Locator_ID"));
        this.northPanel.add((Component)this.locatorLabel, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.locatorField, new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.attributeLabel.setText(Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"));
        this.northPanel.add((Component)this.attributeLabel, new GridBagConstraints(4, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.attribute, new GridBagConstraints(5, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.backflushGroupLabel, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.backflushGroup, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.ReceiptIssueOrder.add((Component)this.northPanel, "North");
        this.TabsReceiptsIssue.add((Component)this.ReceiptIssueOrder, Msg.translate(Env.getCtx(), "IsShipConfirm"));
        this.TabsReceiptsIssue.add((Component)this.Generate, Msg.translate(Env.getCtx(), "Generate"));
        this.Generate.setLayout(new BorderLayout());
        this.Generate.add((Component)this.info, "Center");
        this.Generate.setEnabled(false);
        this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.info.setEditable(false);
        this.TabsReceiptsIssue.addChangeListener(this);
        this.add((Component)this.TabsReceiptsIssue, "Center");
        this.mainPanel.add((Component)this.TabsReceiptsIssue, "Center");
        this.add((Component)this.mainPanel, "North");
    }

    private void dynInit() {
        this.disableToDeliver();
        this.issue.addColumn("PP_Order_BOMLine_ID");
        this.issue.addColumn("IsCritical");
        this.issue.addColumn("Value");
        this.issue.addColumn("M_Product_ID");
        this.issue.addColumn("C_UOM_ID");
        this.issue.addColumn("M_AttributeSetInstance_ID");
        this.issue.addColumn("QtyRequiered");
        this.issue.addColumn("QtyDelivered");
        this.issue.addColumn("QtyToDeliver");
        this.issue.addColumn("QtyScrap");
        this.issue.addColumn("QtyOnHand");
        this.issue.addColumn("QtyReserved");
        this.issue.addColumn("QtyAvailable");
        this.issue.addColumn("M_Locator_ID");
        this.issue.addColumn("M_Warehouse_ID");
        this.issue.addColumn("QtyBOM");
        this.issue.addColumn("IsQtyPercentage");
        this.issue.addColumn("QtyBatch");
        this.issue.setMultiSelection(true);
        this.issue.setRowSelectionAllowed(true);
        this.issue.setColumnClass(0, IDColumn.class, false, " ");
        this.issue.setColumnClass(1, Boolean.class, true, Msg.translate(Env.getCtx(), "IsCritical"));
        this.issue.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "Value"));
        this.issue.setColumnClass(3, KeyNamePair.class, true, Msg.translate(Env.getCtx(), "M_Product_ID"));
        this.issue.setColumnClass(4, KeyNamePair.class, true, Msg.translate(Env.getCtx(), "C_UOM_ID"));
        this.issue.setColumnClass(5, String.class, true, Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"));
        this.issue.setColumnClass(6, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyRequired"));
        this.issue.setColumnClass(7, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyDelivered"));
        this.issue.setColumnClass(8, BigDecimal.class, false, Msg.translate(Env.getCtx(), "QtyToDeliver"));
        this.issue.setColumnClass(9, BigDecimal.class, false, Msg.translate(Env.getCtx(), "QtyScrap"));
        this.issue.setColumnClass(10, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyOnHand"));
        this.issue.setColumnClass(11, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyReserved"));
        this.issue.setColumnClass(12, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyAvailable"));
        this.issue.setColumnClass(13, String.class, true, Msg.translate(Env.getCtx(), "M_Locator_ID"));
        this.issue.setColumnClass(14, KeyNamePair.class, true, Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        this.issue.setColumnClass(15, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyBom"));
        this.issue.setColumnClass(16, Boolean.class, true, Msg.translate(Env.getCtx(), "IsQtyPercentage"));
        this.issue.setColumnClass(17, BigDecimal.class, true, Msg.translate(Env.getCtx(), "QtyBatch"));
        this.issue.autoSize();
        this.issue.getModel().addTableModelListener(this);
        CompiereColor.setBackground(this);
        this.issue.setCellSelectionEnabled(true);
        this.issue.getSelectionModel().addListSelectionListener(this);
        this.issue.setRowCount(0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        log.fine("Event:" + actionEvent.getSource());
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        if (actionEvent.getSource().equals(this.Process)) {
            if (this.getMovementDate() == null) {
                JOptionPane.showMessageDialog(null, Msg.getMsg(Env.getCtx(), "NoDate"), "Info", 1);
                return;
            }
            if ((this.isOnlyReceipt() || this.isBackflush()) && this.getM_Locator_ID() <= 0) {
                JOptionPane.showMessageDialog(null, Msg.getMsg(Env.getCtx(), "NoLocator"), "Info", 1);
                return;
            }
            this.TabsReceiptsIssue.setSelectedIndex(1);
            this.generateSummaryTable();
            if (ADialog.ask(this.m_WindowNo, this, "Update")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (this.cmd_process()) {
                    this.dispose();
                    return;
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.TabsReceiptsIssue.setSelectedIndex(0);
        }
        if ((actionEvent.getSource().equals(this.toDeliverQty) || actionEvent.getSource().equals(this.scrapQtyField)) && this.getPP_Order_ID() > 0 && this.isBackflush()) {
            this.executeQuery();
        }
        if (actionEvent.getSource().equals(this.pickcombo)) {
            if (this.isOnlyReceipt()) {
                this.enableToDeliver();
                this.locatorLabel.setVisible(true);
                this.locatorField.setVisible(true);
                this.attribute.setVisible(true);
                this.attributeLabel.setVisible(true);
                this.issue.setVisible(false);
            } else if (this.isOnlyIssue()) {
                this.disableToDeliver();
                this.locatorLabel.setVisible(false);
                this.locatorField.setVisible(false);
                this.attribute.setVisible(false);
                this.attributeLabel.setVisible(false);
                this.issue.setVisible(true);
                this.executeQuery();
            } else if (this.isBackflush()) {
                this.enableToDeliver();
                this.locatorLabel.setVisible(true);
                this.locatorField.setVisible(true);
                this.attribute.setVisible(true);
                this.attributeLabel.setVisible(true);
                this.issue.setVisible(true);
                this.executeQuery();
            }
            this.setToDeliverQty(this.getOpenQty());
        }
    }

    public void enableToDeliver() {
        this.setToDeliver(true);
    }

    public void disableToDeliver() {
        this.setToDeliver(false);
    }

    private void setToDeliver(Boolean bl) {
        this.toDeliverQty.getComponent(0).setEnabled(bl);
        this.toDeliverQty.getComponent(1).setEnabled(bl);
        this.scrapQtyLabel.setVisible(bl);
        this.scrapQtyField.setVisible(bl);
        this.rejectQtyLabel.setVisible(bl);
        this.rejectQty.setVisible(bl);
    }

    private void executeQuery() {
        this.issue.removeAll();
        int n = 0;
        this.issue.setRowCount(n);
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement("SELECT obl.PP_Order_BOMLine_ID,obl.IsCritical,p.Value,obl.M_Product_ID,p.Name,p.C_UOM_ID,u.Name,obl.QtyRequiered,obl.QtyReserved,bomQtyAvailable(obl.M_Product_ID,obl.M_Warehouse_ID,0 ) AS QtyAvailable,bomQtyOnHand(obl.M_Product_ID,obl.M_Warehouse_ID,0) AS QtyOnHand,p.M_Locator_ID,obl.M_Warehouse_ID,w.Name,obl.QtyBom,obl.isQtyPercentage,obl.QtyBatch,obl.ComponentType,obl.QtyRequiered - QtyDelivered AS QtyOpen,obl.QtyDelivered FROM PP_Order_BOMLine obl INNER JOIN M_Product p ON (obl.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (p.C_UOM_ID = u.C_UOM_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = obl.M_Warehouse_ID)  WHERE obl.PP_Order_ID = ? ORDER BY obl.Line", null);
            cPreparedStatement.setInt(1, this.getPP_Order_ID());
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                this.issue.setRowCount(n + 1);
                IDColumn iDColumn = new IDColumn(resultSet.getInt(1));
                BigDecimal bigDecimal = resultSet.getBigDecimal(15);
                Boolean bl = resultSet.getString(16).equals("Y");
                Boolean bl2 = resultSet.getString(2).equals("Y");
                BigDecimal bigDecimal2 = resultSet.getBigDecimal(17);
                BigDecimal bigDecimal3 = resultSet.getBigDecimal(8);
                BigDecimal bigDecimal4 = resultSet.getBigDecimal(11);
                BigDecimal bigDecimal5 = resultSet.getBigDecimal(19);
                BigDecimal bigDecimal6 = resultSet.getBigDecimal(20);
                String string = resultSet.getString(18);
                BigDecimal bigDecimal7 = this.getToDeliverQty();
                BigDecimal bigDecimal8 = this.getOpenQty();
                BigDecimal bigDecimal9 = this.getScrapQty();
                BigDecimal bigDecimal10 = Env.ZERO;
                BigDecimal bigDecimal11 = Env.ZERO;
                BigDecimal bigDecimal12 = Env.ZERO;
                BigDecimal bigDecimal13 = Env.ZERO;
                iDColumn.setSelected(this.isOnlyReceipt());
                this.issue.setValueAt(iDColumn, n, 0);
                this.issue.setValueAt(bl2, n, 1);
                this.issue.setValueAt(resultSet.getString(3), n, 2);
                this.issue.setValueAt(new KeyNamePair(resultSet.getInt(4), resultSet.getString(5)), n, 3);
                this.issue.setValueAt(new KeyNamePair(resultSet.getInt(6), resultSet.getString(7)), n, 4);
                this.issue.setValueAt(bigDecimal3, n, 6);
                this.issue.setValueAt(bigDecimal6, n, 7);
                this.issue.setValueAt(bigDecimal4, n, 10);
                this.issue.setValueAt(resultSet.getBigDecimal(9), n, 11);
                this.issue.setValueAt(resultSet.getBigDecimal(10), n, 12);
                this.issue.setValueAt(new KeyNamePair(resultSet.getInt(13), resultSet.getString(14)), n, 14);
                this.issue.setValueAt(bigDecimal, n, 15);
                this.issue.setValueAt(bl, n, 16);
                this.issue.setValueAt(bigDecimal2, n, 17);
                if (string.equals("CO") || string.equals("PK")) {
                    iDColumn.setSelected(bigDecimal4.signum() > 0 && bigDecimal3.signum() > 0);
                    if (bl.booleanValue()) {
                        BigDecimal bigDecimal14 = bigDecimal2.divide(Env.ONEHUNDRED, 8, RoundingMode.HALF_UP);
                        if (this.isBackflush()) {
                            if (bigDecimal3.signum() == 0 || bigDecimal5.signum() == 0) {
                                bigDecimal10 = Env.ZERO;
                            } else {
                                bigDecimal10 = bigDecimal7.multiply(bigDecimal14);
                                if (bigDecimal3.subtract(bigDecimal6).signum() < 0 | bigDecimal10.signum() == 0) {
                                    bigDecimal10 = bigDecimal3.subtract(bigDecimal6);
                                }
                            }
                            if (bigDecimal10.signum() != 0) {
                                bigDecimal13 = bigDecimal10.setScale(4, 4);
                                this.issue.setValueAt(bigDecimal10, n, 8);
                            }
                        } else {
                            bigDecimal10 = bigDecimal5;
                            if (bigDecimal10.signum() != 0) {
                                bigDecimal12 = bigDecimal8.multiply(bigDecimal14);
                                bigDecimal13 = bigDecimal10.setScale(4, 4);
                                this.issue.setValueAt(bigDecimal10.setScale(8, 4), n, 8);
                                this.issue.setValueAt(bigDecimal8.multiply(bigDecimal14), n, 6);
                            }
                        }
                        if (bigDecimal9.signum() != 0 && (bigDecimal11 = bigDecimal9.multiply(bigDecimal14)).signum() != 0) {
                            this.issue.setValueAt(bigDecimal11, n, 9);
                        }
                    } else {
                        if (this.isBackflush()) {
                            bigDecimal10 = bigDecimal7.multiply(bigDecimal);
                            if (bigDecimal10.signum() != 0) {
                                bigDecimal12 = bigDecimal7.multiply(bigDecimal);
                                bigDecimal13 = bigDecimal10;
                                this.issue.setValueAt(bigDecimal12, n, 6);
                                this.issue.setValueAt(bigDecimal10, n, 8);
                            }
                        } else {
                            bigDecimal10 = bigDecimal5;
                            if (bigDecimal10.signum() != 0) {
                                bigDecimal12 = bigDecimal8.multiply(bigDecimal);
                                bigDecimal13 = bigDecimal10;
                                this.issue.setValueAt(bigDecimal12, n, 6);
                                this.issue.setValueAt(bigDecimal10, n, 8);
                            }
                        }
                        if (bigDecimal9.signum() != 0 && (bigDecimal11 = bigDecimal9.multiply(bigDecimal)).signum() != 0) {
                            this.issue.setValueAt(bigDecimal11, n, 9);
                        }
                    }
                } else if (string.equals("TL")) {
                    bigDecimal10 = bigDecimal;
                    if (bigDecimal10.signum() != 0) {
                        bigDecimal12 = bigDecimal;
                        bigDecimal13 = bigDecimal10;
                        this.issue.setValueAt(bigDecimal, n, 6);
                        this.issue.setValueAt(bigDecimal10, n, 8);
                    }
                } else {
                    this.issue.setValueAt(Env.ZERO, n, 6);
                    this.issue.setValueAt(Env.ZERO, n, 8);
                }
                ++n;
                if (!this.isOnlyIssue() && !this.isBackflush()) continue;
                int n2 = resultSet.getInt(13);
                int n3 = resultSet.getInt(4);
                n += this.lotes(n, iDColumn, n2, n3, bigDecimal12, bigDecimal13);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException(sQLException);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        this.issue.autoSize();
    }

    private int lotes(int n, IDColumn iDColumn, int n2, int n3, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        int n4 = 0;
        BigDecimal bigDecimal3 = bigDecimal;
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement("SELECT s.M_Product_ID , s.QtyOnHand, s.M_AttributeSetInstance_ID, p.Name, masi.Description, l.Value, w.Value, w.M_warehouse_ID,p.Value  FROM M_Storage s  INNER JOIN M_Product p ON (s.M_Product_ID = p.M_Product_ID)  INNER JOIN C_UOM u ON (u.C_UOM_ID = p.C_UOM_ID)  INNER JOIN M_AttributeSetInstance masi ON (masi.M_AttributeSetInstance_ID = s.M_AttributeSetInstance_ID)  INNER JOIN M_Warehouse w ON (w.M_Warehouse_ID = ?)  INNER JOIN M_Locator l ON(l.M_Warehouse_ID=w.M_Warehouse_ID and s.M_Locator_ID=l.M_Locator_ID)  WHERE s.M_Product_ID = ? and s.QtyOnHand > 0  and s.M_AttributeSetInstance_ID <> 0  ORDER BY s.Created ", null);
            cPreparedStatement.setInt(1, n2);
            cPreparedStatement.setInt(2, n3);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                this.issue.setRowCount(n + 1);
                BigDecimal bigDecimal4 = resultSet.getBigDecimal(2);
                IDColumn iDColumn2 = new IDColumn(resultSet.getInt(3));
                iDColumn2.setSelected(false);
                this.issue.setRowSelectionAllowed(true);
                this.issue.setValueAt(iDColumn2, n, 0);
                KeyNamePair keyNamePair = new KeyNamePair(resultSet.getInt(1), resultSet.getString(4));
                this.issue.setValueAt(keyNamePair, n, 3);
                this.issue.setValueAt(bigDecimal4, n, 10);
                this.issue.setValueAt(resultSet.getString(5), n, 5);
                this.issue.setValueAt(resultSet.getString(6), n, 13);
                KeyNamePair keyNamePair2 = new KeyNamePair(resultSet.getInt(8), resultSet.getString(7));
                this.issue.setValueAt(keyNamePair2, n, 14);
                if (bigDecimal3.compareTo(bigDecimal4) < 0) {
                    this.issue.setValueAt(bigDecimal3.signum() > 0 ? bigDecimal3 : Env.ZERO, n, 6);
                } else {
                    this.issue.setValueAt(bigDecimal4, n, 6);
                }
                bigDecimal3 = bigDecimal3.subtract(bigDecimal4);
                ++n4;
                ++n;
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException(sQLException);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
        return n4;
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        log.fine("VOrderReceip.vetoableChange - " + string + "=" + object);
        if (object == null) {
            return;
        }
        if (string.equals("PP_Order_ID")) {
            this.orderField.setValue(object);
            MPPOrder mPPOrder = this.getPP_Order();
            if (mPPOrder != null) {
                this.setS_Resource_ID(mPPOrder.getS_Resource_ID());
                this.setM_Warehouse_ID(mPPOrder.getM_Warehouse_ID());
                this.setDeliveredQty(mPPOrder.getQtyDelivered());
                this.setOrderedQty(mPPOrder.getQtyOrdered());
                this.setQtyBatchs(mPPOrder.getQtyBatchs());
                this.setQtyBatchSize(mPPOrder.getQtyBatchSize());
                this.setOpenQty(mPPOrder.getQtyOrdered().subtract(mPPOrder.getQtyDelivered()));
                this.setToDeliverQty(this.getOpenQty());
                this.setM_Product_ID(mPPOrder.getM_Product_ID());
                MProduct mProduct = MProduct.get(Env.getCtx(), mPPOrder.getM_Product_ID());
                this.setC_UOM_ID(mProduct.getC_UOM_ID());
                this.setOrder_UOM_ID(mPPOrder.getC_UOM_ID());
                this.setM_AttributeSetInstance_ID(mPPOrder.getMPPOrderBOM().getM_AttributeSetInstance_ID());
                this.pickcombo.setSelectedIndex(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cmd_process() {
        if ((this.isOnlyReceipt() || this.isBackflush()) && this.getM_Locator_ID() <= 0) {
            JOptionPane.showMessageDialog(null, Msg.getMsg(Env.getCtx(), "NoLocator"), "Info", 1);
        }
        if (this.getPP_Order() == null || this.getMovementDate() == null) {
            return false;
        }
        final boolean bl = ADialog.ask(this.m_WindowNo, this, Msg.parseTranslation(Env.getCtx(), "@IsCloseDocument@ : " + this.getPP_Order().getDocumentNo()));
        try {
            Trx.run(new TrxRunnable(){

                @Override
                public void run(String string) {
                    MPPOrder mPPOrder = new MPPOrder(Env.getCtx(), VOrderReceiptIssue.this.getPP_Order_ID(), string);
                    if (VOrderReceiptIssue.this.isBackflush() || VOrderReceiptIssue.this.isOnlyIssue()) {
                        VOrderReceiptIssue.this.createIssue(mPPOrder);
                    }
                    if (VOrderReceiptIssue.this.isOnlyReceipt() || VOrderReceiptIssue.this.isBackflush()) {
                        MPPOrder.createReceipt(mPPOrder, VOrderReceiptIssue.this.getMovementDate(), VOrderReceiptIssue.this.getDeliveredQty(), VOrderReceiptIssue.this.getToDeliverQty(), VOrderReceiptIssue.this.getScrapQty(), VOrderReceiptIssue.this.getRejectQty(), VOrderReceiptIssue.this.getM_Locator_ID(), VOrderReceiptIssue.this.getM_AttributeSetInstance_ID());
                        if (bl) {
                            mPPOrder.setDateFinish(VOrderReceiptIssue.this.getMovementDate());
                            mPPOrder.closeIt();
                            mPPOrder.saveEx();
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            ADialog.error(this.m_WindowNo, this, "Error", exception.getLocalizedMessage());
            boolean bl2 = false;
            return bl2;
        }
        finally {
            this.m_PP_order = null;
        }
        return true;
    }

    private void createIssue(MPPOrder mPPOrder) {
        Comparable comparable;
        Serializable serializable;
        int n;
        Timestamp timestamp;
        Timestamp timestamp2 = timestamp = this.getMovementDate();
        boolean bl = false;
        ArrayList[][] arrayListArray = new ArrayList[this.issue.getRowCount()][1];
        int n2 = 0;
        for (n = 0; n < this.issue.getRowCount(); ++n) {
            serializable = new ArrayList();
            IDColumn iDColumn = (IDColumn)this.issue.getValueAt(n, 0);
            comparable = new KeyNamePair(iDColumn.getRecord_ID(), iDColumn.isSelected() ? "Y" : "N");
            ((ArrayList)serializable).add(comparable);
            ((ArrayList)serializable).add(this.issue.getValueAt(n, 1));
            ((ArrayList)serializable).add(this.issue.getValueAt(n, 2));
            ((ArrayList)serializable).add(this.issue.getValueAt(n, 3));
            ((ArrayList)serializable).add(this.getValueBigDecimal(n, 8));
            ((ArrayList)serializable).add(this.getValueBigDecimal(n, 9));
            arrayListArray[n2][0] = serializable;
            ++n2;
        }
        bl = MPPOrder.isQtyAvailable(mPPOrder, arrayListArray, timestamp2);
        if (!bl) {
            ADialog.error(this.m_WindowNo, this, "NoQtyAvailable");
            throw new AdempiereException("@NoQtyAvailable@");
        }
        for (n = 0; n < arrayListArray.length; ++n) {
            serializable = (KeyNamePair)arrayListArray[n][0].get(0);
            boolean bl2 = ((NamePair)serializable).getName().equals("Y");
            if (serializable == null || !bl2) continue;
            comparable = (Boolean)arrayListArray[n][0].get(1);
            String string = (String)arrayListArray[n][0].get(2);
            KeyNamePair keyNamePair = (KeyNamePair)arrayListArray[n][0].get(3);
            int n3 = keyNamePair.getKey();
            MPPOrderBOMLine mPPOrderBOMLine = null;
            int n4 = 0;
            int n5 = 0;
            BigDecimal bigDecimal = (BigDecimal)arrayListArray[n][0].get(4);
            BigDecimal bigDecimal2 = (BigDecimal)arrayListArray[n][0].get(5);
            MProduct mProduct = MProduct.get(mPPOrder.getCtx(), n3);
            if (mProduct == null || mProduct.get_ID() == 0 || !mProduct.isStocked()) continue;
            if (string == null && bl2) {
                n5 = ((KeyNamePair)serializable).getKey();
                mPPOrderBOMLine = MPPOrderBOMLine.forM_Product_ID(Env.getCtx(), mPPOrder.get_ID(), n3, mPPOrder.get_TrxName());
                if (mPPOrderBOMLine != null) {
                    n4 = mPPOrderBOMLine.get_ID();
                }
            } else if (string != null && bl2 && (n4 = Integer.valueOf(((KeyNamePair)serializable).getKey()).intValue()) > 0) {
                mPPOrderBOMLine = new MPPOrderBOMLine(mPPOrder.getCtx(), n4, mPPOrder.get_TrxName());
                n5 = mPPOrderBOMLine.getM_AttributeSetInstance_ID();
            }
            MStorage[] mStorageArray = MPPOrder.getStorages(Env.getCtx(), n3, mPPOrder.getM_Warehouse_ID(), n5, timestamp2, mPPOrder.get_TrxName());
            MPPOrder.createIssue(mPPOrder, n4, timestamp, bigDecimal, bigDecimal2, Env.ZERO, mStorageArray, false);
        }
    }

    private void generateSummaryTable() {
        String[][] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>");
        stringBuffer.append(Msg.translate(Env.getCtx(), "IsShipConfirm"));
        stringBuffer.append("</b>");
        stringBuffer.append("<br />");
        if (this.isOnlyReceipt() || this.isBackflush()) {
            stringArray = new String[][]{{Msg.translate(Env.getCtx(), "Name"), Msg.translate(Env.getCtx(), "C_UOM_ID"), Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"), Msg.translate(Env.getCtx(), "QtyToDeliver"), Msg.translate(Env.getCtx(), "QtyDelivered"), Msg.translate(Env.getCtx(), "QtyScrap")}, {this.productField.getDisplay(), this.uomField.getDisplay(), this.attribute.getDisplay(), this.toDeliverQty.getDisplay(), this.deliveredQtyField.getDisplay(), this.scrapQtyField.getDisplay()}};
            stringBuffer.append(this.createHTMLTable(stringArray));
        }
        if (this.isBackflush() || this.isOnlyIssue()) {
            stringBuffer.append("<br /><br />");
            stringArray = new ArrayList();
            stringArray.add(new String[]{Msg.translate(Env.getCtx(), "Value"), Msg.translate(Env.getCtx(), "Name"), Msg.translate(Env.getCtx(), "C_UOM_ID"), Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"), Msg.translate(Env.getCtx(), "QtyToDeliver"), Msg.translate(Env.getCtx(), "QtyDelivered"), Msg.translate(Env.getCtx(), "QtyScrap")});
            block0: for (int i = 0; i < this.issue.getRowCount(); ++i) {
                String[] stringArray2;
                IDColumn iDColumn = (IDColumn)this.issue.getValueAt(i, 0);
                if (iDColumn == null || !iDColumn.isSelected()) continue;
                KeyNamePair keyNamePair = (KeyNamePair)this.issue.getValueAt(i, 3);
                int n = keyNamePair.getKey();
                KeyNamePair keyNamePair2 = (KeyNamePair)this.issue.getValueAt(i, 4);
                if (this.issue.getValueAt(i, 5) == null) {
                    String[] stringArray3 = stringArray2 = this.getMovementDate();
                    MStorage[] mStorageArray = MPPOrder.getStorages(Env.getCtx(), n, this.getPP_Order().getM_Warehouse_ID(), 0, (Timestamp)stringArray3, null);
                    BigDecimal bigDecimal = this.getValueBigDecimal(i, 8);
                    BigDecimal bigDecimal2 = this.getValueBigDecimal(i, 9);
                    BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2);
                    for (MStorage mStorage : mStorageArray) {
                        if (mStorage.getQtyOnHand().signum() == 0) continue;
                        BigDecimal bigDecimal4 = bigDecimal3;
                        if (bigDecimal4.compareTo(mStorage.getQtyOnHand()) > 0) {
                            bigDecimal4 = mStorage.getQtyOnHand();
                        }
                        bigDecimal3 = bigDecimal3.subtract(bigDecimal4);
                        String string = new MAttributeSetInstance(Env.getCtx(), mStorage.getM_AttributeSetInstance_ID(), null).getDescription();
                        String[] stringArray4 = new String[]{"", "", "", "", "0.00", "0.00", "0.00"};
                        stringArray4[0] = this.issue.getValueAt(i, 2) != null ? this.issue.getValueAt(i, 2).toString() : "";
                        stringArray4[1] = keyNamePair.toString();
                        stringArray4[2] = keyNamePair2 != null ? keyNamePair2.toString() : "";
                        stringArray4[3] = string != null ? string : "";
                        stringArray4[4] = bigDecimal4.setScale(2, 4).toString();
                        stringArray4[5] = this.getValueBigDecimal(i, 7).setScale(2, 4).toString();
                        stringArray4[6] = this.getValueBigDecimal(i, 9).toString();
                        stringArray.add(stringArray4);
                        if (bigDecimal3.signum() <= 0) continue block0;
                    }
                    continue;
                }
                stringArray2 = new String[]{"", "", "", "", "0.00", "0.00", "0.00"};
                stringArray2[0] = this.issue.getValueAt(i, 2) != null ? this.issue.getValueAt(i, 2).toString() : "";
                stringArray2[1] = keyNamePair.toString();
                stringArray2[2] = keyNamePair2 != null ? keyNamePair2.toString() : "";
                stringArray2[3] = this.issue.getValueAt(i, 5) != null ? this.issue.getValueAt(i, 5).toString() : "";
                stringArray2[4] = this.getValueBigDecimal(i, 8).toString();
                stringArray2[5] = this.getValueBigDecimal(i, 7).toString();
                stringArray2[6] = this.getValueBigDecimal(i, 9).toString();
                stringArray.add(stringArray2);
            }
            String[][] stringArray5 = (String[][])stringArray.toArray((T[])new String[stringArray.size()][]);
            stringBuffer.append(this.createHTMLTable(stringArray5));
        }
        this.info.setText(stringBuffer.toString());
    }

    private boolean isOnlyReceipt() {
        return this.pickcombo.getDisplay().equals("OnlyReceipt");
    }

    private boolean isOnlyIssue() {
        return this.pickcombo.getDisplay().equals("OnlyIssue");
    }

    protected boolean isBackflush() {
        return this.pickcombo.getDisplay().equals("IsBackflush");
    }

    protected Timestamp getMovementDate() {
        return (Timestamp)this.movementDateField.getValue();
    }

    protected BigDecimal getOrderedQty() {
        BigDecimal bigDecimal = (BigDecimal)this.orderedQtyField.getValue();
        return bigDecimal != null ? bigDecimal : Env.ZERO;
    }

    protected void setOrderedQty(BigDecimal bigDecimal) {
        this.orderedQtyField.setValue(bigDecimal);
    }

    protected BigDecimal getDeliveredQty() {
        BigDecimal bigDecimal = (BigDecimal)this.deliveredQtyField.getValue();
        return bigDecimal != null ? bigDecimal : Env.ZERO;
    }

    protected void setDeliveredQty(BigDecimal bigDecimal) {
        this.deliveredQtyField.setValue(bigDecimal);
    }

    protected BigDecimal getToDeliverQty() {
        BigDecimal bigDecimal = (BigDecimal)this.toDeliverQty.getValue();
        return bigDecimal != null ? bigDecimal : Env.ZERO;
    }

    protected void setToDeliverQty(BigDecimal bigDecimal) {
        this.toDeliverQty.setValue(bigDecimal);
    }

    protected BigDecimal getScrapQty() {
        BigDecimal bigDecimal = (BigDecimal)this.scrapQtyField.getValue();
        return bigDecimal != null ? bigDecimal : Env.ZERO;
    }

    protected BigDecimal getRejectQty() {
        BigDecimal bigDecimal = (BigDecimal)this.rejectQty.getValue();
        return bigDecimal != null ? bigDecimal : Env.ZERO;
    }

    protected BigDecimal getOpenQty() {
        BigDecimal bigDecimal = (BigDecimal)this.openQtyField.getValue();
        return bigDecimal != null ? bigDecimal : Env.ZERO;
    }

    protected void setOpenQty(BigDecimal bigDecimal) {
        this.openQtyField.setValue(bigDecimal);
    }

    protected BigDecimal getQtyBatchs() {
        BigDecimal bigDecimal = (BigDecimal)this.qtyBatchsField.getValue();
        return bigDecimal != null ? bigDecimal : Env.ZERO;
    }

    protected void setQtyBatchs(BigDecimal bigDecimal) {
        this.qtyBatchsField.setValue(bigDecimal);
    }

    protected BigDecimal getQtyBatchSize() {
        BigDecimal bigDecimal = (BigDecimal)this.qtyBatchSizeField.getValue();
        return bigDecimal != null ? bigDecimal : Env.ZERO;
    }

    protected void setQtyBatchSize(BigDecimal bigDecimal) {
        this.qtyBatchSizeField.setValue(bigDecimal);
    }

    protected int getM_AttributeSetInstance_ID() {
        Integer n = (Integer)this.attribute.getValue();
        return n != null ? n : 0;
    }

    protected void setM_AttributeSetInstance_ID(int n) {
        this.attribute.setValue(n);
    }

    protected int getM_Locator_ID() {
        Integer n = (Integer)this.locatorField.getValue();
        return n != null ? n : 0;
    }

    protected void setM_Locator_ID(int n) {
        this.locatorField.setValue(n);
    }

    protected int getPP_Order_ID() {
        Integer n = (Integer)this.orderField.getValue();
        return n != null ? n : 0;
    }

    protected MPPOrder getPP_Order() {
        int n = this.getPP_Order_ID();
        if (n <= 0) {
            this.m_PP_order = null;
            return null;
        }
        if (this.m_PP_order == null || this.m_PP_order.get_ID() != n) {
            this.m_PP_order = new MPPOrder(Env.getCtx(), n, null);
        }
        return this.m_PP_order;
    }

    protected int getS_Resource_ID() {
        Integer n = (Integer)this.resourceField.getValue();
        return n != null ? n : 0;
    }

    protected void setS_Resource_ID(int n) {
        this.resourceField.setValue(n);
    }

    protected int getM_Warehouse_ID() {
        Integer n = (Integer)this.warehouseField.getValue();
        return n != null ? n : 0;
    }

    protected void setM_Warehouse_ID(int n) {
        this.warehouseField.setValue(n);
    }

    protected int getM_Product_ID() {
        Integer n = (Integer)this.productField.getValue();
        return n != null ? n : 0;
    }

    protected void setM_Product_ID(int n) {
        this.productField.setValue(n);
        Env.setContext(Env.getCtx(), this.m_WindowNo, "M_Product_ID", n);
    }

    protected int getC_UOM_ID() {
        Integer n = (Integer)this.uomField.getValue();
        return n != null ? n : 0;
    }

    protected void setC_UOM_ID(int n) {
        this.uomField.setValue(n);
    }

    protected int getOrder_UOM_ID() {
        Integer n = (Integer)this.uomorderField.getValue();
        return n != null ? n : 0;
    }

    protected void setOrder_UOM_ID(int n) {
        this.uomorderField.setValue(n);
    }

    private String createHTMLTable(String[][] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("<table width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringBuffer.append("<tr>");
            for (int j = 0; j < stringArray[i].length; ++j) {
                stringBuffer.append("<td>");
                if (stringArray[i][j] != null) {
                    stringBuffer.append(stringArray[i][j]);
                }
                stringBuffer.append("</td>");
            }
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void executeASync(ProcessInfo processInfo) {
    }

    @Override
    public boolean isUILocked() {
        return true;
    }

    @Override
    public void lockUI(ProcessInfo processInfo) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    @Override
    public void unlockUI(ProcessInfo processInfo) {
    }

    private BigDecimal getValueBigDecimal(int n, int n2) {
        BigDecimal bigDecimal = (BigDecimal)this.issue.getValueAt(n, n2);
        return bigDecimal == null ? Env.ZERO : bigDecimal;
    }
}

