/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ADialogDialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.Viewer;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextPane;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;

public class VOrderDistributionReceipt
extends CPanel
implements FormPanel,
ActionListener,
VetoableChangeListener,
ChangeListener,
TableModelListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private boolean m_selectionActive = true;
    private Object m_DD_Order_ID = null;
    private Object m_MovementDate = null;
    private static CLogger log = CLogger.getCLogger(VOrderDistributionReceipt.class);
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel selPanel = new CPanel();
    private CPanel selNorthPanel = new CPanel();
    private BorderLayout selPanelLayout = new BorderLayout();
    private CLabel lOrder = new CLabel();
    private VLookup fOrder;
    private VDate fMovementDate = new VDate("MovementDate", true, false, true, 15, "MovementDate");
    private CLabel lMovementDate = new CLabel(Msg.translate(Env.getCtx(), "MovementDate"));
    private FlowLayout northPanelLayout = new FlowLayout();
    private ConfirmPanel confirmPanelSel = new ConfirmPanel(true);
    private ConfirmPanel confirmPanelGen = new ConfirmPanel(false, true, false, false, false, false, true);
    private StatusBar statusBar = new StatusBar();
    private CPanel genPanel = new CPanel();
    private BorderLayout genLayout = new BorderLayout();
    private CTextPane info = new CTextPane();
    private JScrollPane scrollPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private ArrayList<Integer> selection = null;

    @Override
    public void init(int n, FormFrame formFrame) {
        log.info("");
        this.m_WindowNo = n;
        this.m_frame = formFrame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            this.fillPicks();
            this.jbInit();
            this.dynInit();
            formFrame.getContentPane().add((Component)this.tabbedPane, "Center");
            formFrame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "init", exception);
        }
    }

    void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.selPanel.setLayout(this.selPanelLayout);
        this.lOrder.setLabelFor(this.fOrder);
        this.selNorthPanel.setLayout(this.northPanelLayout);
        this.northPanelLayout.setAlignment(0);
        this.tabbedPane.add((Component)this.selPanel, Msg.getMsg(Env.getCtx(), "Select"));
        this.selPanel.add((Component)this.selNorthPanel, "North");
        this.selNorthPanel.add((Component)this.lOrder, null);
        this.selNorthPanel.add((Component)this.fOrder, null);
        this.selNorthPanel.add((Component)this.lMovementDate, null);
        this.selNorthPanel.add((Component)this.fMovementDate, null);
        this.selPanel.setName("selPanel");
        this.selPanel.add((Component)this.confirmPanelSel, "South");
        this.selPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.miniTable, null);
        this.confirmPanelSel.addActionListener(this);
        this.tabbedPane.add((Component)this.genPanel, Msg.getMsg(Env.getCtx(), "Generate"));
        this.genPanel.setLayout(this.genLayout);
        this.genPanel.add((Component)this.info, "Center");
        this.genPanel.setEnabled(false);
        this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.info.setEditable(false);
        this.genPanel.add((Component)this.confirmPanelGen, "South");
        this.confirmPanelGen.addActionListener(this);
    }

    private void fillPicks() throws Exception {
        Language language = Language.getLoginLanguage();
        MLookup mLookup = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, MColumn.getColumn_ID("DD_Order", "DD_Order_ID"), 30, language, "DD_Order_ID", 0, false, "DocStatus='CO' AND IsInTransit='Y'");
        this.fOrder = new VLookup("DD_Order_ID", true, false, true, mLookup);
        this.lOrder.setText(Msg.translate(Env.getCtx(), "DD_Order_ID"));
        this.fOrder.addVetoableChangeListener(this);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        this.m_MovementDate = timestamp;
        this.fMovementDate.setValue(timestamp);
        this.fMovementDate.addVetoableChangeListener(this);
    }

    private void dynInit() {
        this.miniTable.addColumn("DD_Order_ID");
        this.miniTable.addColumn("QtyInTransit");
        this.miniTable.addColumn("C_UOM_ID");
        this.miniTable.addColumn("Value");
        this.miniTable.addColumn("M_Product_ID");
        this.miniTable.addColumn("M_WarehouseSource_ID");
        this.miniTable.setMultiSelection(true);
        this.miniTable.setRowSelectionAllowed(true);
        this.miniTable.setColumnClass(0, IDColumn.class, false, " ");
        this.miniTable.setColumnClass(1, BigDecimal.class, false, Msg.translate(Env.getCtx(), "QtyInTransit"));
        this.miniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "C_UOM_ID"));
        this.miniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "M_Product_ID"));
        this.miniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "Value"));
        this.miniTable.setColumnClass(5, String.class, true, Msg.translate(Env.getCtx(), "WarehouseSource"));
        this.miniTable.autoSize();
        this.miniTable.getModel().addTableModelListener(this);
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "InOutGenerateSel"));
        this.statusBar.setStatusDB(" ");
        this.tabbedPane.addChangeListener(this);
    }

    private String getOrderSQL() {
        StringBuffer stringBuffer = new StringBuffer("SELECT ol.DD_OrderLine_ID, ol.QtyInTransit , uom.Name , p.Value ,p.Name  , w.Name FROM DD_OrderLine ol INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID) INNER JOIN M_Product p ON (p.M_Product_ID=ol.M_Product_ID)  INNER JOIN C_UOM uom  ON (uom.C_UOM_ID=ol.C_UOM_ID) INNER JOIN M_Locator  l ON (l.M_Locator_ID = ol.M_Locator_ID) INNER JOIN M_Warehouse  w ON (w.M_Warehouse_ID = l.M_Warehouse_ID) WHERE o.DocStatus= 'CO' AND  ol.QtyInTransit > 0  AND  o.DD_Order_ID = ? ");
        return stringBuffer.toString();
    }

    private void executeQuery() {
        log.info("");
        String string = "";
        if (this.m_DD_Order_ID == null) {
            return;
        }
        string = this.getOrderSQL();
        log.fine(string);
        int n = 0;
        this.miniTable.setRowCount(n);
        try {
            CPreparedStatement cPreparedStatement = DB.prepareStatement(string.toString(), null);
            cPreparedStatement.setInt(1, Integer.parseInt(this.m_DD_Order_ID.toString()));
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                this.miniTable.setRowCount(n + 1);
                this.miniTable.setValueAt(new IDColumn(resultSet.getInt(1)), n, 0);
                this.miniTable.setValueAt(resultSet.getBigDecimal(2), n, 1);
                this.miniTable.setValueAt(resultSet.getString(3), n, 2);
                this.miniTable.setValueAt(resultSet.getString(4), n, 4);
                this.miniTable.setValueAt(resultSet.getString(5), n, 3);
                this.miniTable.setValueAt(resultSet.getString(6), n, 5);
                ++n;
            }
            resultSet.close();
            cPreparedStatement.close();
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, string.toString(), sQLException);
        }
        this.miniTable.autoSize();
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        log.info("Cmd=" + actionEvent.getActionCommand());
        if (actionEvent.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        this.saveSelection();
        if (this.selection != null && this.selection.size() > 0 && this.m_selectionActive && this.m_DD_Order_ID != null && this.m_MovementDate != null) {
            this.generateMovements();
        } else {
            this.dispose();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        log.info(propertyChangeEvent.getPropertyName() + "=" + propertyChangeEvent.getNewValue());
        if (propertyChangeEvent.getPropertyName().equals("DD_Order_ID")) {
            this.m_DD_Order_ID = propertyChangeEvent.getNewValue();
        }
        if (propertyChangeEvent.getPropertyName().equals("MovementDate")) {
            this.m_MovementDate = propertyChangeEvent.getNewValue();
        }
        this.executeQuery();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.tabbedPane.getSelectedIndex();
        this.m_selectionActive = n == 0;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = 0;
        int n2 = this.miniTable.getRowCount();
        for (int i = 0; i < n2; ++i) {
            IDColumn iDColumn = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (iDColumn == null || !iDColumn.isSelected()) continue;
            ++n;
        }
        this.statusBar.setStatusDB(" " + n + " ");
    }

    private void saveSelection() {
        log.info("");
        this.miniTable.editingStopped(new ChangeEvent(this));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.selection = null;
        int n = this.miniTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            IDColumn iDColumn = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (iDColumn == null || !iDColumn.isSelected()) continue;
            arrayList.add(iDColumn.getRecord_ID());
        }
        if (arrayList.size() == 0) {
            return;
        }
        log.config("Selected #" + arrayList.size());
        this.selection = arrayList;
    }

    private void generateMovements() {
        log.info("DD_Order_ID=" + this.m_DD_Order_ID);
        log.info("MovementDate" + this.m_MovementDate);
        String string = Trx.createTrxName("IOG");
        Trx trx = Trx.get(string, true);
        this.m_selectionActive = false;
        this.statusBar.setStatusLine(Msg.translate(Env.getCtx(), "M_Movement_ID"));
        this.statusBar.setStatusDB(String.valueOf(this.selection.size()));
        if (this.selection.size() <= 0) {
            return;
        }
        Properties properties = Env.getCtx();
        Timestamp timestamp = (Timestamp)this.m_MovementDate;
        MDDOrder mDDOrder = new MDDOrder(properties, Integer.parseInt(this.m_DD_Order_ID.toString()), string);
        MMovement mMovement = new MMovement(properties, 0, string);
        mMovement.setDD_Order_ID(mDDOrder.getDD_Order_ID());
        mMovement.setAD_User_ID(mDDOrder.getAD_User_ID());
        mMovement.setPOReference(mDDOrder.getPOReference());
        mMovement.setReversal_ID(0);
        mMovement.setM_Shipper_ID(mDDOrder.getM_Shipper_ID());
        mMovement.setDescription(mDDOrder.getDescription());
        mMovement.setC_BPartner_ID(mDDOrder.getC_BPartner_ID());
        mMovement.setC_BPartner_Location_ID(mDDOrder.getC_BPartner_Location_ID());
        mMovement.setAD_Org_ID(mDDOrder.getAD_Org_ID());
        mMovement.setAD_OrgTrx_ID(mDDOrder.getAD_OrgTrx_ID());
        mMovement.setAD_User_ID(mDDOrder.getAD_User_ID());
        mMovement.setC_Activity_ID(mDDOrder.getC_Activity_ID());
        mMovement.setC_Campaign_ID(mDDOrder.getC_Campaign_ID());
        mMovement.setC_Project_ID(mDDOrder.getC_Project_ID());
        mMovement.setMovementDate(timestamp);
        mMovement.setDeliveryRule(mDDOrder.getDeliveryRule());
        mMovement.setDeliveryViaRule(mDDOrder.getDeliveryViaRule());
        mMovement.setDocAction("PR");
        mMovement.setDocStatus("DR");
        int n = this.getDocType("MMM", mDDOrder.getAD_Org_ID());
        if (n > 0) {
            mMovement.setC_DocType_ID(n);
        }
        mMovement.saveEx();
        for (int i = 0; i < this.selection.size(); ++i) {
            int n2 = this.selection.get(i);
            MDDOrderLine mDDOrderLine = new MDDOrderLine(properties, n2, string);
            MMovementLine mMovementLine = new MMovementLine(mMovement);
            mMovementLine.setM_Product_ID(mDDOrderLine.getM_Product_ID());
            BigDecimal bigDecimal = (BigDecimal)this.miniTable.getValueAt(i, 1);
            if (bigDecimal == null | bigDecimal.compareTo(mDDOrderLine.getQtyInTransit()) > 0) {
                throw new AdempiereException("Error in Qty");
            }
            mMovementLine.setOrderLine(mDDOrderLine, bigDecimal, true);
            mMovementLine.saveEx();
        }
        mMovement.setDocAction("CL");
        mMovement.setDocStatus(mMovement.completeIt());
        mMovement.saveEx();
        trx.commit();
        this.generateMovements_complete(mMovement);
    }

    private int getDocType(String string, int n) {
        MDocType[] mDocTypeArray = MDocType.getOfDocBaseType(Env.getCtx(), string);
        if (mDocTypeArray == null || mDocTypeArray.length == 0) {
            String string2 = "Not found default document type for docbasetype " + string;
            throw new AdempiereException(string2);
        }
        for (MDocType mDocType : mDocTypeArray) {
            if (mDocType.getAD_Org_ID() != n) continue;
            return mDocType.getC_DocType_ID();
        }
        log.info("Doc Type for " + string + ": " + mDocTypeArray[0].getC_DocType_ID());
        return mDocTypeArray[0].getC_DocType_ID();
    }

    private void generateMovements_complete(MMovement mMovement) {
        this.tabbedPane.setSelectedIndex(1);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>").append("").append("</b><br>").append(Msg.translate(Env.getCtx(), "DocumentNo") + " : " + mMovement.getDocumentNo()).append("<br>").append("");
        this.info.setText(stringBuffer.toString());
        this.confirmPanelGen.getOKButton().setEnabled(false);
        if (ADialog.ask(this.m_WindowNo, this, "PrintShipments")) {
            ADialogDialog aDialogDialog;
            this.setCursor(Cursor.getPredefinedCursor(3));
            int n = ADialogDialog.A_CANCEL;
            do {
                MPrintFormat mPrintFormat = MPrintFormat.get(Env.getCtx(), MPrintFormat.getPrintFormat_ID("Inventory Move Hdr (Example)", MMovement.Table_ID, 0), false);
                MQuery mQuery = new MQuery("M_Movement");
                mQuery.addRestriction("M_Movement_ID", "=", mMovement.getM_Movement_ID());
                PrintInfo printInfo = new PrintInfo("M_Movement", MMovement.Table_ID, mMovement.getM_Movement_ID());
                ReportEngine reportEngine = new ReportEngine(Env.getCtx(), mPrintFormat, mQuery, printInfo);
                reportEngine.print();
                new Viewer(reportEngine);
            } while ((n = (aDialogDialog = new ADialogDialog((Frame)this.m_frame, Env.getHeader(Env.getCtx(), this.m_WindowNo), Msg.getMsg(Env.getCtx(), "PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.confirmPanelGen.getOKButton().setEnabled(true);
    }
}

